/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.introspector;

import com.google.common.collect.ImmutableSet;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelperKt;
import com.intellij.database.dialects.base.introspector.IntrospectionQueryContext;
import com.intellij.database.dialects.mssql.generator.MsNamingService;
import com.intellij.database.dialects.mssql.introspector.MsIntroQueries;
import com.intellij.database.dialects.mssql.introspector.MsIntrospectorKt;
import com.intellij.database.dialects.mssql.model.MsCustomType;
import com.intellij.database.dialects.mssql.model.MsDatabase;
import com.intellij.database.dialects.mssql.model.MsExtendedPropertiesHolder;
import com.intellij.database.dialects.mssql.model.MsGrantsHolder;
import com.intellij.database.dialects.mssql.model.MsKey;
import com.intellij.database.dialects.mssql.model.MsSchemaObject;
import com.intellij.database.dialects.mssql.model.MsTable;
import com.intellij.database.dialects.mssql.model.MsTableType;
import com.intellij.database.dialects.mssql.model.properties.MsObjectPermission;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.NameValueType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.basic.BasicColumniation;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMixinColumniation;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.remote.jdba.sql.SqlQuery;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u00c6\u0001\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u001a\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0012\u0010\u0012\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\nH\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0001H\u0002\u001a*\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0001H\u0002\u001a7\u0010\u001e\u001a\u0002H\u001f\"\b\b\u0000\u0010\u001f*\u00020 2\u000e\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u001f0\"2\u0006\u0010#\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010$\u001a\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010\r\u001a\u00020\u0001H\u0002\u001a\f\u0010(\u001a\u00020\n*\u00020)H\u0002\u001a\u0016\u0010*\u001a\u00020\n*\u00020\n2\b\u0010+\u001a\u0004\u0018\u00010\nH\u0002\u001a\u0014\u0010,\u001a\u0004\u0018\u00010\n*\b\u0012\u0004\u0012\u00020)0-H\u0002\u001a\u001c\u0010.\u001a\u0004\u0018\u00010/*\u0002002\f\u00101\u001a\b\u0012\u0004\u0012\u00020\n0-H\u0002\u001a\u0018\u00102\u001a\b\u0012\u0004\u0012\u0002030-*\b\u0012\u0004\u0012\u00020)0-H\u0002\u001a@\u00104\u001a\u000205*\u0002062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u000e\u0010;\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010=0<2\u0012\u0010>\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020@0?0<H\u0002\u001a \u0010A\u001a\u000205*\u00020B2\b\u0010C\u001a\u0004\u0018\u00010D2\b\u0010E\u001a\u0004\u0018\u00010DH\u0002\u001a\u001c\u0010F\u001a\u000205*\u00020G2\u000e\u0010H\u001a\n\u0012\u0004\u0012\u00020)\u0018\u00010-H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"2\u0010\b\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\n0\n \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\n0\n\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"ALIAS_TYPE_KIND", "", "FULLTEXT_INDEX_POSITION", "", "SURROGATE_NAME_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "TABLE_TYPE_KIND", "VARIABLE_TYPES", "Lcom/google/common/collect/ImmutableSet;", "", "canCheckOutdated", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "catalogPrefix", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "detectSurrogateName", "name", "makeCascadeRule", "Lcom/intellij/database/model/properties/CascadeRule;", "code", "makeDataType", "Lcom/intellij/database/model/DataType;", "type_name", "max_length", "", "precision", "scale", "renewType", "T", "Lcom/intellij/database/dialects/mssql/model/MsCustomType;", "family", "Lcom/intellij/database/model/families/ModNamingFamily;", "typeId", "(Lcom/intellij/database/model/families/ModNamingFamily;ILjava/lang/String;)Lcom/intellij/database/dialects/mssql/model/MsCustomType;", "unpackEvents", "", "Lcom/intellij/database/model/TrigEvent;", "asLiteral", "Lcom/intellij/database/dialects/mssql/introspector/MsIntroQueries$OneProperty;", "cast", "type", "comment", "", "findKeyByColumns", "Lcom/intellij/database/dialects/mssql/model/MsKey;", "Lcom/intellij/database/dialects/mssql/model/MsTable;", "names", "properties", "Lcom/intellij/database/model/NameValueType;", "retrievePermissions", "", "Lcom/intellij/database/dialects/base/introspector/IntrospectionQueryContext;", "obj", "Lcom/intellij/database/dialects/mssql/model/MsGrantsHolder;", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "checkSumQuery", "Lcom/intellij/database/remote/jdba/sql/SqlQuery;", "", "grantsQuery", "", "Lcom/intellij/database/dialects/mssql/introspector/MsIntroQueries$OnePermission;", "setCreatedAndModifiedTimestamps", "Lcom/intellij/database/dialects/mssql/model/MsSchemaObject;", "createdTimestamp", "Ljava/util/Date;", "modifiedTimestamp", "setExtProps", "Lcom/intellij/database/dialects/mssql/model/MsExtendedPropertiesHolder;", "props", "intellij.database.dialects.mssql"})
public final class MsIntrospectorKt {
    private static final byte ALIAS_TYPE_KIND = 1;
    private static final byte TABLE_TYPE_KIND = 2;
    private static final Pattern SURROGATE_NAME_PATTERN = Pattern.compile("^\\s*\\w{2}\\S{2,18}__[\\dA-F]{8,16}\\s*$", 2);
    private static final ImmutableSet<String> VARIABLE_TYPES = ImmutableSet.of((Object)"decimal", (Object)"numeric", (Object)"varbinary", (Object)"varchar", (Object)"binary", (Object)"char", (Object[])new String[]{"nvarchar", "nchar", "time", "datetime2", "datetimeoffset"});
    private static final short FULLTEXT_INDEX_POSITION = Short.MAX_VALUE;

    private static final void setExtProps(MsExtendedPropertiesHolder $this$setExtProps, List<MsIntroQueries.OneProperty> props) {
        List list = props;
        $this$setExtProps.setComment(list != null ? MsIntrospectorKt.comment(list) : null);
        List list2 = props;
        if (list2 == null || (list2 = MsIntrospectorKt.properties(list2)) == null) {
            list2 = CollectionsKt.emptyList();
        }
        $this$setExtProps.setExtendedProperties(list2);
    }

    private static final String comment(List<MsIntroQueries.OneProperty> $this$comment) {
        Object v0;
        block1: {
            Iterable iterable = $this$comment;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                MsIntroQueries.OneProperty it = (MsIntroQueries.OneProperty)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.name, (Object)"MS_Description")) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        MsIntroQueries.OneProperty oneProperty = v0;
        return oneProperty != null ? oneProperty.value : null;
    }

    private static final List<NameValueType> properties(List<MsIntroQueries.OneProperty> $this$properties) {
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)$this$properties), (Function1)properties.1.INSTANCE), (Function1)properties.2.INSTANCE));
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final String asLiteral(MsIntroQueries.OneProperty $this$asLiteral) {
        String string;
        String string2 = $this$asLiteral.type;
        if (string2 != null) {
            switch (string2) {
                case "varbinary": 
                case "binary": {
                    String string3 = $this$asLiteral.value;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"value");
                    string = ScriptGeneratorHelperKt.getSqlString(string3);
                    return string;
                }
                case "nvarchar": 
                case "nchar": {
                    StringBuilder stringBuilder = new StringBuilder().append("N");
                    String string4 = $this$asLiteral.value;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"value");
                    string = stringBuilder.append(ScriptGeneratorHelperKt.getSqlString(string4)).toString();
                    return string;
                }
                case "numeric": 
                case "tinyint": 
                case "smallmoney": 
                case "real": 
                case "float": 
                case "int": 
                case "smallint": 
                case "money": 
                case "decimal": 
                case "bigint": {
                    String string5 = $this$asLiteral.value;
                    string = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"value");
                    return string;
                }
            }
        }
        String string6 = $this$asLiteral.value;
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"value");
        string = ScriptGeneratorHelperKt.getSqlString(string6);
        return string;
    }

    private static final String cast(String $this$cast, String type) {
        return "cast(" + $this$cast + " as " + type + ')';
    }

    private static final <T extends MsCustomType> T renewType(ModNamingFamily<? extends T> family, int typeId, String name2) {
        MsCustomType type = null;
        type = (MsCustomType)family.find(new Predicate<T>(typeId){
            final /* synthetic */ int $typeId;

            public final boolean test(T it) {
                T t = it;
                Intrinsics.checkNotNullExpressionValue(t, (String)"it");
                return t.getTypeId() == this.$typeId;
            }
            {
                this.$typeId = n;
            }
        });
        if (type != null) {
            type.setName(name2);
            type.resetSyncPending();
            return (T)type;
        }
        type = (MsCustomType)family.get(name2);
        if (type != null && type.getTypeId() == 0) {
            type.setTypeId(typeId);
            type.resetSyncPending();
            return (T)type;
        }
        type = (MsCustomType)family.createNewOne();
        type.setTypeId(typeId);
        type.setName(name2);
        return (T)type;
    }

    private static final MsKey findKeyByColumns(MsTable $this$findKeyByColumns, List<String> names2) {
        Object v1;
        block1: {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)$this$findKeyByColumns.getKeys();
            Intrinsics.checkNotNullExpressionValue((Object)modNamingIdentifyingFamily, (String)"this.keys");
            Iterable $this$firstOrNull$iv = (Iterable)modNamingIdentifyingFamily;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                MsKey it = (MsKey)element$iv;
                boolean bl = false;
                if (!BasicMixinColumniation.areColNames((BasicColumniation)((BasicColumniation)it), names2)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private static final Set<TrigEvent> unpackEvents(byte e2) {
        byte $this$and$iv;
        EnumSet<TrigEvent> events = EnumSet.noneOf(TrigEvent.class);
        byte by = e2;
        byte that$iv = 1;
        boolean $i$f$and = false;
        byte $this$toUnsignedInt$iv$iv = $this$and$iv;
        boolean $i$f$toUnsignedInt = false;
        int n = Byte.toUnsignedInt($this$toUnsignedInt$iv$iv);
        $this$toUnsignedInt$iv$iv = that$iv;
        $i$f$toUnsignedInt = false;
        if ((byte)(n & Byte.toUnsignedInt($this$toUnsignedInt$iv$iv)) != 0) {
            events.add(TrigEvent.INSERT);
        }
        $this$and$iv = e2;
        that$iv = 2;
        $i$f$and = false;
        $this$toUnsignedInt$iv$iv = $this$and$iv;
        $i$f$toUnsignedInt = false;
        int n2 = Byte.toUnsignedInt($this$toUnsignedInt$iv$iv);
        $this$toUnsignedInt$iv$iv = that$iv;
        $i$f$toUnsignedInt = false;
        if ((byte)(n2 & Byte.toUnsignedInt($this$toUnsignedInt$iv$iv)) != 0) {
            events.add(TrigEvent.UPDATE);
        }
        $this$and$iv = e2;
        that$iv = 4;
        $i$f$and = false;
        $this$toUnsignedInt$iv$iv = $this$and$iv;
        $i$f$toUnsignedInt = false;
        int n3 = Byte.toUnsignedInt($this$toUnsignedInt$iv$iv);
        $this$toUnsignedInt$iv$iv = that$iv;
        $i$f$toUnsignedInt = false;
        if ((byte)(n3 & Byte.toUnsignedInt($this$toUnsignedInt$iv$iv)) != 0) {
            events.add(TrigEvent.DELETE);
        }
        EnumSet<TrigEvent> enumSet = events;
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"events");
        return enumSet;
    }

    private static final void setCreatedAndModifiedTimestamps(MsSchemaObject $this$setCreatedAndModifiedTimestamps, Date createdTimestamp, Date modifiedTimestamp) {
        $this$setCreatedAndModifiedTimestamps.setCreatedTimestamp(createdTimestamp);
        $this$setCreatedAndModifiedTimestamps.setModifiedTimestamp(modifiedTimestamp);
    }

    private static final String catalogPrefix(BasicDatabase database) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = database.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"database.name");
        return stringBuilder.append(MsNamingService.INSTANCE.nameToScript(string, database.getKind(), false)).append(".sys").toString();
    }

    private static final boolean detectSurrogateName(String name2) {
        if (name2 == null) {
            return false;
        }
        return SURROGATE_NAME_PATTERN.matcher(name2).matches();
    }

    private static final DataType makeDataType(String type_name, int max_length, int precision, byte scale) {
        DataType dt = null;
        if (type_name != null) {
            if (VARIABLE_TYPES.contains((Object)type_name)) {
                if (Intrinsics.areEqual((Object)type_name, (Object)"time") || Intrinsics.areEqual((Object)type_name, (Object)"datetime2") || Intrinsics.areEqual((Object)type_name, (Object)"datetimeoffset")) {
                    int size = scale >= 0 && scale <= 6 ? (int)scale : -1;
                    LengthUnit units = size >= 0 ? LengthUnit.DIGIT : null;
                    DataType dataType = DataTypeFactory.of(null, (String)type_name, (int)size, (int)0, (LengthUnit)units, null, (boolean)false, (boolean)false);
                    Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"DataTypeFactory.of(null,\u2026nits, null, false, false)");
                    dt = dataType;
                } else if (precision > 0) {
                    DataType dataType = DataTypeFactory.of(null, (String)type_name, (int)precision, (int)scale, null, null, (boolean)false, (boolean)false);
                    Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"DataTypeFactory.of(null,\u2026null, null, false, false)");
                    dt = dataType;
                } else if (Intrinsics.areEqual((Object)type_name, (Object)"char") || Intrinsics.areEqual((Object)type_name, (Object)"nchar") || Intrinsics.areEqual((Object)type_name, (Object)"varchar") || Intrinsics.areEqual((Object)type_name, (Object)"nvarchar") || Intrinsics.areEqual((Object)type_name, (Object)"varbinary")) {
                    boolean national;
                    boolean bl = national = type_name.charAt(0) == 'n';
                    int length = max_length == -1 ? Integer.MAX_VALUE : (national ? max_length >> 1 : max_length);
                    DataType dataType = DataTypeFactory.of(null, (String)type_name, (int)length, (int)0, (LengthUnit)LengthUnit.CHAR, null, (boolean)false, (boolean)false);
                    Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"DataTypeFactory.of(null,\u2026CHAR, null, false, false)");
                    dt = dataType;
                } else if (max_length > 0) {
                    DataType dataType = DataTypeFactory.of(null, (String)type_name, (int)max_length, (int)scale, null, null, (boolean)false, (boolean)false);
                    Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"DataTypeFactory.of(null,\u2026null, null, false, false)");
                    dt = dataType;
                } else {
                    DataType dataType = DataTypeFactory.of((String)type_name);
                    Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"DataTypeFactory.of(type_name)");
                    dt = dataType;
                }
            } else {
                DataType dataType = DataTypeFactory.of((String)type_name);
                Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"DataTypeFactory.of(type_name)");
                dt = dataType;
            }
        } else {
            DataType dataType = DataType.UNKNOWN;
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"DataType.UNKNOWN");
            dt = dataType;
        }
        return dt;
    }

    private static final CascadeRule makeCascadeRule(byte code) {
        CascadeRule cascadeRule;
        switch (code) {
            case 1: {
                cascadeRule = CascadeRule.cascade;
                break;
            }
            case 2: {
                cascadeRule = CascadeRule.set_null;
                break;
            }
            case 3: {
                cascadeRule = CascadeRule.set_default;
                break;
            }
            default: {
                cascadeRule = CascadeRule.no_action;
            }
        }
        return cascadeRule;
    }

    private static final boolean canCheckOutdated(BasicElement e2) {
        return e2 == null || e2 instanceof MsSchemaObject && !(e2 instanceof MsTableType) && ((MsSchemaObject)e2).getModifiedTimestamp() != null;
    }

    private static final void retrievePermissions(IntrospectionQueryContext $this$retrievePermissions, MsGrantsHolder obj2, DBTransaction tran, SqlQuery<Long> checkSumQuery, SqlQuery<List<MsIntroQueries.OnePermission>> grantsQuery) {
        long checksum = 0L;
        try {
            Long checksumOrNull;
            Long l = checksumOrNull = $this$retrievePermissions.performQuery(tran, checkSumQuery);
            checksum = l != null ? l : 0L;
        }
        catch (Exception e2) {
            String message2 = "Failed to calculate checksum of permissions in " + obj2.getKind().code() + ' ' + obj2.getName() + ": exception " + e2.getClass().getSimpleName() + ": " + e2.getMessage();
            if ($this$retrievePermissions.log.isDebugEnabled()) {
                $this$retrievePermissions.log.warn(message2, (Throwable)e2);
            } else {
                $this$retrievePermissions.log.warn(message2);
            }
            return;
        }
        if (checksum == obj2.getPermissionsCheckSum()) {
            return;
        }
        ArrayList permissions = new ArrayList();
        IntrospectionQueryContext.performQueryHandleEachRow$default($this$retrievePermissions, tran, grantsQuery, 0, (Function1)new Function1<MsIntroQueries.OnePermission, Unit>(permissions, obj2){
            final /* synthetic */ ArrayList $permissions;
            final /* synthetic */ MsGrantsHolder $obj;

            public final void invoke(@NotNull MsIntroQueries.OnePermission p) {
                MsObjectPermission.State state2;
                MsObjectPermission.State state3;
                Object object;
                long l;
                String string;
                short s;
                long l2;
                ObjectKind objectKind;
                boolean bl;
                Object object2;
                Collection collection;
                block12: {
                    ObjectKind objectKind2;
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    collection = this.$permissions;
                    object2 = p.object_id;
                    bl = false;
                    boolean bl2 = false;
                    long it22 = ((Number)object2).longValue();
                    boolean bl3 = false;
                    boolean bl4 = p.kind != (short)0;
                    Object object3 = bl4 ? object2 : null;
                    if (object3 == null) {
                        MsGrantsHolder $this$castSafelyTo$iv = this.$obj;
                        boolean $i$f$castSafelyTo = false;
                        MsGrantsHolder msGrantsHolder = $this$castSafelyTo$iv;
                        if (!(msGrantsHolder instanceof MsDatabase)) {
                            msGrantsHolder = null;
                        }
                        MsDatabase msDatabase = (MsDatabase)msGrantsHolder;
                        object3 = msDatabase != null ? Long.valueOf(msDatabase.getObjectId()) : null;
                    }
                    long l3 = object3 != null ? (Long)object3 : 0L;
                    switch (p.kind) {
                        case 0: {
                            objectKind2 = ObjectKind.DATABASE;
                            break;
                        }
                        case 3: {
                            objectKind2 = ObjectKind.SCHEMA;
                            break;
                        }
                        case 4: {
                            objectKind2 = ObjectKind.ROLE;
                            break;
                        }
                        case 6: {
                            objectKind2 = ObjectKind.ALIAS_TYPE;
                            break;
                        }
                        case 100: {
                            objectKind2 = ObjectKind.ROOT;
                            break;
                        }
                        case 101: {
                            objectKind2 = ObjectKind.LOGIN;
                            break;
                        }
                        default: {
                            objectKind2 = ObjectKind.NONE;
                        }
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)objectKind2, (String)"when (p.kind) {\n        \u2026> ObjectKind.NONE\n      }");
                    object2 = p.position;
                    bl = false;
                    bl2 = false;
                    short it22 = ((Number)object2).shortValue();
                    objectKind = objectKind2;
                    l2 = l3;
                    boolean bl5 = false;
                    s = it22 != -1 ? (short)1 : 0;
                    Object object4 = s != 0 ? object2 : null;
                    short s2 = object4 != null ? (Short)object4 : (short)0;
                    long l4 = p.grantee_principal_id;
                    String string2 = StringUtil.toLowerCase((String)p.permission_name);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringUtil.toLowerCase(p.permission_name)");
                    object2 = MsObjectPermission.State.values();
                    string = string2;
                    l = l4;
                    s = s2;
                    bl = false;
                    Number number = object2;
                    boolean bl6 = false;
                    Number number2 = number;
                    int n = ((Number)number2).length;
                    for (int j = 0; j < n; ++j) {
                        Number number3;
                        Number it = number3 = number2[j];
                        boolean bl7 = false;
                        Character c = p.state;
                        if (!(c != null && ((MsObjectPermission.State)((Object)it)).getCode() == c.charValue())) continue;
                        object = number3;
                        break block12;
                    }
                    object = null;
                }
                if ((state3 = (state2 = object)) == null) {
                    state3 = MsObjectPermission.State.REVOKE;
                }
                MsObjectPermission.State state4 = state3;
                String string3 = string;
                long l5 = l;
                short s3 = s;
                ObjectKind objectKind3 = objectKind;
                long l6 = l2;
                object2 = new MsObjectPermission(l6, objectKind3, s3, l5, string3, state4);
                bl = false;
                collection.add(object2);
            }
            {
                this.$permissions = arrayList;
                this.$obj = msGrantsHolder;
                super(1);
            }
        }, 2, null);
        boolean bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                MsObjectPermission it = (MsObjectPermission)a;
                boolean bl2 = false;
                Comparable comparable = Long.valueOf(it.getId());
                it = (MsObjectPermission)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Comparable comparable3 = Long.valueOf(it.getId());
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
            }
        };
        boolean bl2 = false;
        comparator = new Comparator<T>(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = comparator;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    boolean bl = false;
                    MsObjectPermission it = (MsObjectPermission)a;
                    boolean bl2 = false;
                    Comparable comparable = Integer.valueOf(it.getKind().getOrder());
                    it = (MsObjectPermission)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Comparable comparable3 = Integer.valueOf(it.getKind().getOrder());
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
                }
                return n;
            }
        };
        bl2 = false;
        CollectionsKt.sortWith((List)permissions, (Comparator)new Comparator<T>(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = comparator;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    boolean bl = false;
                    MsObjectPermission it = (MsObjectPermission)a;
                    boolean bl2 = false;
                    Comparable comparable = Short.valueOf(it.getPosition());
                    it = (MsObjectPermission)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Comparable comparable3 = Short.valueOf(it.getPosition());
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
                }
                return n;
            }
        });
        ((BasicModModel)obj2.getModel()).modify((BasicElement)obj2, MsGrantsHolder.class, (ModelModifier)new ModelModifier<MsGrantsHolder>(permissions, checksum){
            final /* synthetic */ ArrayList $permissions;
            final /* synthetic */ long $checksum;

            public final void perform(MsGrantsHolder g) {
                MsGrantsHolder msGrantsHolder = g;
                Intrinsics.checkNotNullExpressionValue((Object)msGrantsHolder, (String)"g");
                msGrantsHolder.setGrants(this.$permissions);
                g.setPermissionsCheckSum(this.$checksum);
            }
            {
                this.$permissions = arrayList;
                this.$checksum = l;
            }
        });
    }

    public static final /* synthetic */ boolean access$canCheckOutdated(BasicElement e2) {
        return MsIntrospectorKt.canCheckOutdated(e2);
    }

    public static final /* synthetic */ void access$retrievePermissions(IntrospectionQueryContext $this$access_u24retrievePermissions, MsGrantsHolder obj2, DBTransaction tran, SqlQuery checkSumQuery, SqlQuery grantsQuery) {
        MsIntrospectorKt.retrievePermissions($this$access_u24retrievePermissions, obj2, tran, (SqlQuery<Long>)checkSumQuery, (SqlQuery<List<MsIntroQueries.OnePermission>>)grantsQuery);
    }

    public static final /* synthetic */ void access$setExtProps(MsExtendedPropertiesHolder $this$access_u24setExtProps, List props) {
        MsIntrospectorKt.setExtProps($this$access_u24setExtProps, props);
    }

    public static final /* synthetic */ void access$setCreatedAndModifiedTimestamps(MsSchemaObject $this$access_u24setCreatedAndModifiedTimestamps, Date createdTimestamp, Date modifiedTimestamp) {
        MsIntrospectorKt.setCreatedAndModifiedTimestamps($this$access_u24setCreatedAndModifiedTimestamps, createdTimestamp, modifiedTimestamp);
    }

    public static final /* synthetic */ MsCustomType access$renewType(ModNamingFamily family, int typeId, String name2) {
        return MsIntrospectorKt.renewType(family, typeId, name2);
    }

    public static final /* synthetic */ DataType access$makeDataType(String type_name, int max_length, int precision, byte scale) {
        return MsIntrospectorKt.makeDataType(type_name, max_length, precision, scale);
    }

    public static final /* synthetic */ boolean access$detectSurrogateName(String name2) {
        return MsIntrospectorKt.detectSurrogateName(name2);
    }

    public static final /* synthetic */ CascadeRule access$makeCascadeRule(byte code) {
        return MsIntrospectorKt.makeCascadeRule(code);
    }

    public static final /* synthetic */ MsKey access$findKeyByColumns(MsTable $this$access_u24findKeyByColumns, List names2) {
        return MsIntrospectorKt.findKeyByColumns($this$access_u24findKeyByColumns, names2);
    }

    public static final /* synthetic */ Set access$unpackEvents(byte e2) {
        return MsIntrospectorKt.unpackEvents(e2);
    }

    public static final /* synthetic */ String access$catalogPrefix(BasicDatabase database) {
        return MsIntrospectorKt.catalogPrefix(database);
    }

    public static final /* synthetic */ String access$asLiteral(MsIntroQueries.OneProperty $this$access_u24asLiteral) {
        return MsIntrospectorKt.asLiteral($this$access_u24asLiteral);
    }
}

