/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.inspections;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.dataSource.validation.NamedProgressive;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MsDomainInUserNameValidator
extends DatabaseConfigValidator<LocalDataSource> {
    public Class<LocalDataSource> getTargetClass() {
        return LocalDataSource.class;
    }

    public void collectProblems(@NotNull Project project, final @NotNull LocalDataSource target2, @NotNull Consumer<? super DataSourceProblem> problems, final @Nullable DatabaseConfigEditor editor) {
        if (project == null) {
            MsDomainInUserNameValidator.$$$reportNull$$$0(0);
        }
        if (target2 == null) {
            MsDomainInUserNameValidator.$$$reportNull$$$0(1);
        }
        if (problems == null) {
            MsDomainInUserNameValidator.$$$reportNull$$$0(2);
        }
        if (!target2.getDbms().isMicrosoft()) {
            return;
        }
        final String username = target2.getUsername();
        final int slash = username.indexOf(92);
        if (slash == -1) {
            return;
        }
        final boolean driverIsOk = JdbcEngine.isJTds((LocalDataSource)target2);
        NamedProgressive fix = editor == null ? null : new NamedProgressive(AnalysisBundle.message((String)"MsDomainInUserNameValidator.progress.title.set.up.domain.authentication", (Object[])new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                DataSourceConfigurable configurable;
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((configurable = (DataSourceConfigurable)editor.getConfigurable((Object)target2, true, DataSourceConfigurable.class)) == null) {
                    return;
                }
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    if (!driverIsOk) {
                        DatabaseDriver jtdsDriver = (DatabaseDriver)ContainerUtil.find((Iterable)DatabaseDriverManager.getInstance().getDrivers(), JdbcEngine::isJtds);
                        if (jtdsDriver == null) {
                            return;
                        }
                        configurable.setDriver(jtdsDriver);
                    }
                    LocalDataSource tmp = configurable.getTempDataSource();
                    tmp.setAuthProviderId("ms-domain");
                    tmp.setUsername(username.substring(slash + 1));
                    tmp.getAdditionalJdbcProperties().put("DOMAIN", username.substring(0, slash));
                    configurable.resetFromTemp();
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dialects/mssql/inspections/MsDomainInUserNameValidator$1", "run"));
            }
        };
        DataSourceProblem hint = new DataSourceProblem((Object)this, null, DataSourceProblem.Level.HINT, new DataSourceProblem.HyperText(AnalysisBundle.message((String)"MsDomainInUserNameValidator.notification.title.not.allowed.in.user.name", (Object[])new Object[0]), AnalysisBundle.message((String)"MsDomainInUserNameValidator.notification.content.do.you.want.to.set.up.href.action0.domain.authentication", (Object[])new Object[0]), AnalysisBundle.message((String)"MsDomainInUserNameValidator.notification.content.not.allowed.in.user.name.looks.like.you.want.domain.authentication", (Object[])new Object[0]), new Object[]{fix}), fix);
        problems.consume((Object)hint);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "target";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "problems";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/dialects/mssql/inspections/MsDomainInUserNameValidator";
        objectArray[2] = "collectProblems";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

