/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseCredentialsAuthProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.template.MutableParametersHolder;
import com.intellij.database.dataSource.url.template.ParametersHolder;
import com.intellij.database.dataSource.url.ui.UrlPropertiesPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MsJtdsDomainAuthProvider
implements DatabaseAuthProvider {
    public static final String ID = "ms-domain";
    public static final String DOMAIN = "DOMAIN";

    public @Nullable CompletionStage<// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull DatabaseConnectionInterceptor.ProtoConnection> intercept(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, boolean silent) {
        if (proto2 == null) {
            MsJtdsDomainAuthProvider.$$$reportNull$$$0(0);
        }
        return DatabaseCredentialsAuthProvider.applyInitialCredentials((DatabaseConnectionInterceptor.ProtoConnection)proto2, (boolean)silent).apply(null, p -> {
            DataSourceUiUtil.putOrRemove((Map)p.getConnectionProperties(), (Object)DOMAIN, (Object)((String)p.getConnectionPoint().getAdditionalJdbcProperties().get(DOMAIN)));
            return p;
        }).unwrap();
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public String getDisplayName() {
        String string = DatabaseBundle.message((String)"domain.credentials", (Object[])new Object[0]);
        if (string == null) {
            MsJtdsDomainAuthProvider.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isApplicable(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            MsJtdsDomainAuthProvider.$$$reportNull$$$0(2);
        }
        return JdbcEngine.isJTds((LocalDataSource)dataSource);
    }

    public void setNewPassword(DatabaseConnectionInterceptor.ProtoConnection proto2, String newPass) {
        DatabaseCredentialsAuthProvider.applyNewPassword((DatabaseConnectionInterceptor.ProtoConnection)proto2, (String)newPass);
    }

    @Nullable
    public DatabaseAuthProvider.AuthWidget createWidget(@Nullable Project project, @NotNull DatabaseCredentials credentials, @NotNull LocalDataSource dataSource) {
        if (credentials == null) {
            MsJtdsDomainAuthProvider.$$$reportNull$$$0(3);
        }
        if (dataSource == null) {
            MsJtdsDomainAuthProvider.$$$reportNull$$$0(4);
        }
        return new DomainUserPassWidget(credentials, dataSource);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proto";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mssql/MsJtdsDomainAuthProvider";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mssql/MsJtdsDomainAuthProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "intercept";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createWidget";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DomainUserPassWidget
    extends DatabaseCredentialsAuthProvider.UserPassWidget {
        protected JBTextField myDomainField;

        public DomainUserPassWidget(@NotNull DatabaseCredentials credentials, @NotNull LocalDataSource dataSource) {
            if (credentials == null) {
                DomainUserPassWidget.$$$reportNull$$$0(0);
            }
            if (dataSource == null) {
                DomainUserPassWidget.$$$reportNull$$$0(1);
            }
            super(credentials, dataSource);
        }

        protected JPanel createPanel() {
            JPanel panel2 = new JPanel((LayoutManager)new GridLayoutManager(3, 6));
            this.addDomainField(panel2, 0);
            this.addUserField(panel2, 1);
            this.addPasswordField(panel2, 2);
            return panel2;
        }

        protected void addDomainField(JComponent panel2, int row) {
            JBLabel domainLabel = new JBLabel(DatabaseBundle.message((String)"database.auth.domain.label", (Object[])new Object[0]));
            this.myDomainField = new JBTextField();
            panel2.add((Component)domainLabel, UrlPropertiesPanel.createLabelConstraints((int)row, (int)0, (double)domainLabel.getPreferredSize().getWidth()));
            panel2.add((Component)this.myDomainField, UrlPropertiesPanel.createSimpleConstraints((int)row, (int)1, (int)3));
        }

        public void save(@NotNull LocalDataSource dataSource, boolean copyCredentials) {
            if (dataSource == null) {
                DomainUserPassWidget.$$$reportNull$$$0(2);
            }
            super.save(dataSource, copyCredentials);
            String domain = this.myDomainField.getText();
            DataSourceUiUtil.putOrRemove((Map)dataSource.getAdditionalJdbcProperties(), (Object)MsJtdsDomainAuthProvider.DOMAIN, (Object)domain);
        }

        public void reset(@NotNull LocalDataSource dataSource, boolean resetCredentials) {
            if (dataSource == null) {
                DomainUserPassWidget.$$$reportNull$$$0(3);
            }
            super.reset(dataSource, resetCredentials);
            String domain = (String)dataSource.getAdditionalJdbcProperties().get(MsJtdsDomainAuthProvider.DOMAIN);
            this.myDomainField.setText(StringUtil.notNullize((String)domain));
        }

        public void onChanged(final @NotNull Runnable r) {
            if (r == null) {
                DomainUserPassWidget.$$$reportNull$$$0(4);
            }
            super.onChanged(r);
            this.myDomainField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e2) {
                    if (e2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    r.run();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dialects/mssql/MsJtdsDomainAuthProvider$DomainUserPassWidget$1", "textChanged"));
                }
            });
        }

        public void updateFromUrl(@NotNull ParametersHolder holder) {
            if (holder == null) {
                DomainUserPassWidget.$$$reportNull$$$0(5);
            }
            String domainFromParser = holder.getParameter(MsJtdsDomainAuthProvider.DOMAIN);
            super.updateFromUrl(holder);
            if (StringUtil.isNotEmpty((String)domainFromParser)) {
                this.myDomainField.setText(domainFromParser);
            }
        }

        public void updateUrl(@NotNull MutableParametersHolder model) {
            if (model == null) {
                DomainUserPassWidget.$$$reportNull$$$0(6);
            }
            super.updateUrl(model);
            model.setParameter(MsJtdsDomainAuthProvider.DOMAIN, "");
        }

        @NotNull
        public JComponent getPreferredFocusedComponent() {
            JBTextField jBTextField = this.myDomainField;
            if (jBTextField == null) {
                DomainUserPassWidget.$$$reportNull$$$0(7);
            }
            return jBTextField;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "credentials";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/mssql/MsJtdsDomainAuthProvider$DomainUserPassWidget";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/mssql/MsJtdsDomainAuthProvider$DomainUserPassWidget";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPreferredFocusedComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "save";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "onChanged";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "updateFromUrl";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "updateUrl";
                    break;
                }
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

