/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseArtifactList;
import com.intellij.database.dataSource.DatabaseArtifactManager;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseCredentialsAuthProvider;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.dataSource.validation.DatabaseDriverValidator;
import com.intellij.database.dataSource.validation.NamedProgressive;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.database.dialects.base.BaseDatabaseErrorHandler;
import com.intellij.database.util.Version;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.database.view.ui.DatabaseDriverConfigurable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MsAzureADAuthProvider
extends DatabaseConfigValidator<LocalDataSource>
implements DatabaseAuthProvider {
    public static final String ID = "ms-azure-active-directory-pw";
    private static final Logger LOG = Logger.getInstance(MsAzureADAuthProvider.class);

    public @Nullable CompletionStage<// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull DatabaseConnectionInterceptor.ProtoConnection> intercept(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, boolean silent) {
        if (proto2 == null) {
            MsAzureADAuthProvider.$$$reportNull$$$0(0);
        }
        return DatabaseCredentialsAuthProvider.applyInitialCredentials((DatabaseConnectionInterceptor.ProtoConnection)proto2, (boolean)silent).apply(null, p -> {
            DataSourceUiUtil.putOrRemove((Map)p.getConnectionProperties(), (Object)"authentication", (Object)"ActiveDirectoryPassword");
            return p;
        }).unwrap();
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public String getDisplayName() {
        String string = DatabaseBundle.message((String)"azure.active.directory.password", (Object[])new Object[0]);
        if (string == null) {
            MsAzureADAuthProvider.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isApplicable(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            MsAzureADAuthProvider.$$$reportNull$$$0(2);
        }
        return JdbcEngine.isMs((DatabaseDriver)dataSource.getDatabaseDriver());
    }

    public void setNewPassword(DatabaseConnectionInterceptor.ProtoConnection proto2, String newPass) {
        DatabaseCredentialsAuthProvider.applyNewPassword((DatabaseConnectionInterceptor.ProtoConnection)proto2, (String)newPass);
    }

    @Nullable
    public DatabaseAuthProvider.AuthWidget createWidget(@Nullable Project project, @NotNull DatabaseCredentials credentials, @NotNull LocalDataSource dataSource) {
        if (credentials == null) {
            MsAzureADAuthProvider.$$$reportNull$$$0(3);
        }
        if (dataSource == null) {
            MsAzureADAuthProvider.$$$reportNull$$$0(4);
        }
        return new DatabaseCredentialsAuthProvider.UserPassWidget(credentials, dataSource);
    }

    public Class<? extends LocalDataSource> getTargetClass() {
        return LocalDataSource.class;
    }

    @Nullable
    public CompletionStage<DatabaseConnectionInterceptor.ProtoConnection> handleConnectionFailure(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, @NotNull SQLException e2, boolean silent, int attempt) {
        if (proto2 == null) {
            MsAzureADAuthProvider.$$$reportNull$$$0(5);
        }
        if (e2 == null) {
            MsAzureADAuthProvider.$$$reportNull$$$0(6);
        }
        String message2 = e2.getMessage();
        DatabaseDriver driver = proto2.getConnectionPoint().getDatabaseDriver();
        if (driver != null && message2 != null && message2.contains("Failed to load ADAL4J")) {
            return AsyncUtil.exceptional((Throwable)new DatabaseErrorHandler.KnownException(e2.getMessage(), Collections.singletonList(MsAzureADAuthProvider.createSetUpFix(driver, true)), (Throwable)e2));
        }
        return super.handleConnectionFailure(proto2, e2, silent, attempt);
    }

    public void collectProblems(final @NotNull Project project, @NotNull LocalDataSource target2, @NotNull Consumer<? super DataSourceProblem> problems, final @Nullable DatabaseConfigEditor editor) {
        DatabaseDriver driver;
        if (project == null) {
            MsAzureADAuthProvider.$$$reportNull$$$0(7);
        }
        if (target2 == null) {
            MsAzureADAuthProvider.$$$reportNull$$$0(8);
        }
        if (problems == null) {
            MsAzureADAuthProvider.$$$reportNull$$$0(9);
        }
        if ((driver = target2.getDatabaseDriver()) != null && !MsAzureADAuthProvider.hasAdal(target2)) {
            final DatabaseErrorHandler.Fix setUpFix = MsAzureADAuthProvider.createSetUpFix(driver, false);
            NamedProgressive fix = new NamedProgressive(setUpFix.getName()){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ApplicationManager.getApplication().invokeAndWait(() -> DataSourceUiUtil.applyFix((Project)project, (DatabaseErrorHandler.Fix)setUpFix, (DatabaseConfigEditor)editor));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dialects/mssql/MsAzureADAuthProvider$1", "run"));
                }
            };
            problems.consume((Object)new DataSourceProblem((Object)target2, (Object)this, DataSourceProblem.Level.WARNING, new DataSourceProblem.HyperText(DatabaseBundle.message((String)"notification.title.azure.active.directory.authentication", (Object[])new Object[0]), DatabaseBundle.message((String)"notification.content.extra.libraries.required.href.action0.download", (Object[])new Object[0]), DatabaseBundle.message((String)"notification.content.extra.libraries.required", (Object[])new Object[0]), new Object[]{fix}), fix));
        }
    }

    @NotNull
    private static DatabaseErrorHandler.Fix createSetUpFix(DatabaseDriver driver, boolean navigate) {
        DatabaseErrorHandler.Fix fix = BaseDatabaseErrorHandler.settingsFix(DatabaseBundle.message((String)"set.up.required.libraries", (Object[])new Object[0]), driver, navigate, (Consumer<? super DatabaseDriverConfigurable>)((Consumer)configurable -> {
            DatabaseArtifactList.ArtifactVersion adal = MsAzureADAuthProvider.findAdal();
            if (adal == null) {
                LOG.error("ADAL4J artifact not found");
                return;
            }
            DataSourceUiUtil.modify(d -> d.getArtifacts().add(DatabaseDriverImpl.createArtifactRef((String)adal.artifact.id, (Version)adal.version, (String)"stable")), (DatabaseDriverConfigurable)configurable);
            MsAzureADAuthProvider.download(driver, configurable, adal);
        }));
        if (fix == null) {
            MsAzureADAuthProvider.$$$reportNull$$$0(10);
        }
        return fix;
    }

    private static void download(DatabaseDriver driver, DatabaseDriverConfigurable configurable, DatabaseArtifactList.ArtifactVersion adal) {
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        final NamedProgressive downloader = DatabaseDriverValidator.createDownloadTask((DatabaseArtifactList.ArtifactVersion)adal, (DatabaseDriver)driver, (DatabaseConfigEditor)configurable.getController());
        if (indicator != null) {
            downloader.run(indicator);
        } else {
            new Task.Modal(configurable.getProject(), downloader.getName(), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    downloader.run(indicator);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dialects/mssql/MsAzureADAuthProvider$2", "run"));
                }
            }.queue();
        }
    }

    @Nullable
    private static DatabaseArtifactList.ArtifactVersion findAdal() {
        return DatabaseArtifactManager.getArtifacts().resolve("Active Directory", null, "stable", null);
    }

    private static boolean hasAdal(@NotNull LocalDataSource target2) {
        if (target2 == null) {
            MsAzureADAuthProvider.$$$reportNull$$$0(11);
        }
        return JBIterable.from((Iterable)target2.getClasspathElements()).flatten(SimpleClasspathElement::getClassesRootUrls).find(u -> u.contains("adal4j")) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proto";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mssql/MsAzureADAuthProvider";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mssql/MsAzureADAuthProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createSetUpFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "intercept";
                break;
            }
            case 1: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createWidget";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleConnectionFailure";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collectProblems";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasAdal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

