/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.BinaryMaxDomain;
import com.intellij.database.data.types.domain.BooleanDomain;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.Float1Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IdentityDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.Number2Domain;
import com.intellij.database.data.types.domain.OperationSupport;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.ReadOnlyDomain;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.data.types.domain.TextMaxDomain;
import com.intellij.database.data.types.domain.UnknownDomain;
import com.intellij.database.dialects.mssql.MsDialect;
import com.intellij.database.util.Version;
import org.jetbrains.annotations.Nullable;

public class Ms05Domains
extends DomainRegistry {
    static final int TS_FRACTION = 3;
    private static final int MAX_BINARY = 8000;
    private static final int MAX_PRECISION = 38;
    private static final int MAX_CHAR = 4000;
    private static final long MAX_TEXT = 0x3FFFFFFFL;
    private static final int MONEY_PRECISION = 19;
    private static final int SMALLMONEY_PRECISION = 10;
    private static final int MONEY_SCALE = 4;

    public Ms05Domains() {
        this.add((Domain)new Float1Domain("float", ConversionPoint.SINGLE_PRECISION, new DomainRegistry.Limits(new DomainRegistry.Limit[]{new DomainRegistry.Limit((Number)24, (Number)Float.valueOf(-3.4028235E38f), (Number)Float.valueOf(Float.MAX_VALUE)), new DomainRegistry.Limit((Number)53, (Number)-1.7976931348623157E308, (Number)Double.MAX_VALUE)})));
        this.add((Domain)new ReadOnlyDomain((Domain)new BinaryDomain("timestamp", ConversionPoint.BINARY, 8L, OperationSupport.SUPPORTS_NOTHING)));
        this.add((Domain)new BinaryMaxDomain("binary", ConversionPoint.BINARY, Integer.MAX_VALUE, 8000L, 1L, false, OperationSupport.SUPPORTS_LIKE));
        this.add((Domain)new BinaryMaxDomain("varbinary", ConversionPoint.VARBINARY, Integer.MAX_VALUE, 8000L, 1L, true, OperationSupport.SUPPORTS_LIKE));
        this.add((Domain)new BinaryDomain("image", ConversionPoint.GRAPHIC, Integer.MAX_VALUE, OperationSupport.SUPPORTS_NOTHING));
        this.add((Domain)new BooleanDomain("bit", ConversionPoint.BOOLEAN, OperationSupport.SUPPORTS_NOTHING));
        this.add((Domain)new IdentityDomain((Domain)new IntegerDomain("int", ConversionPoint.SERIAL_NUMBER, -2.147483648E9, 2.147483647E9)));
        this.add((Domain)new IdentityDomain((Domain)new IntegerDomain("smallint", ConversionPoint.SERIAL_NUMBER, -32768.0, 32767.0)));
        this.add((Domain)new IdentityDomain((Domain)new IntegerDomain("tinyint", ConversionPoint.SERIAL_NUMBER, -128.0, 127.0)));
        this.add((Domain)new IdentityDomain((Domain)new IntegerDomain("bigint", ConversionPoint.SERIAL_NUMBER, -9.223372036854776E18, 9.223372036854776E18)));
        this.add((Domain)new IntegerDomain("int", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add((Domain)new IntegerDomain("smallint", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add((Domain)new IntegerDomain("tinyint", ConversionPoint.NUMBER, -128.0, 127.0));
        this.add((Domain)new IntegerDomain("bigint", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add((Domain)new FloatDomain("real", ConversionPoint.SINGLE_PRECISION, -3.4028234663852886E38, 3.4028234663852886E38));
        this.add((Domain)new Number2Domain("decimal", ConversionPoint.BIG_DECIMAL, 38, 38, true));
        this.add((Domain)new Number2Domain("dec", ConversionPoint.BIG_DECIMAL, 38, 38, true));
        this.add((Domain)new Number2Domain("numeric", ConversionPoint.BIG_DECIMAL, 38, 38, true));
        this.add((Domain)new IdentityDomain((Domain)new Number2Domain("decimal", ConversionPoint.SERIAL_NUMBER, 38, 0, true)));
        this.add((Domain)new IdentityDomain((Domain)new Number2Domain("dec", ConversionPoint.SERIAL_NUMBER, 38, 0, true)));
        this.add((Domain)new IdentityDomain((Domain)new Number2Domain("numeric", ConversionPoint.SERIAL_NUMBER, 38, 0, true)));
        this.add((Domain)new Number2Domain("smallmoney", ConversionPoint.MONEY, 10, 4, false, OperationSupport.SUPPORTS_NUMERIC_EQUALS));
        this.add((Domain)new Number2Domain("money", ConversionPoint.MONEY, 19, 4, false, OperationSupport.SUPPORTS_NUMERIC_EQUALS));
        this.add((Domain)new TextDomain("text", ConversionPoint.TEXT, Integer.MAX_VALUE, OperationSupport.SUPPORTS_LIKE_ONLY));
        this.add((Domain)new TextDomain("ntext", ConversionPoint.NTEXT, 0x3FFFFFFFL, OperationSupport.SUPPORTS_LIKE_ONLY));
        this.add((Domain)new TextDomain("sysname", ConversionPoint.TEXT, Integer.MAX_VALUE));
        this.add((Domain)new SimpleDomain("uniqueidentifier", ConversionPoint.UUID, PhysicalDomainType.TEXT, OperationSupport.SUPPORTS_LIKE));
        this.add((Domain)new TextDomain("nchar", ConversionPoint.NCHAR, 4000L, 1L, true, false));
        this.add((Domain)new TextDomain("char", ConversionPoint.CHAR, 4000L, 1L, true, false));
        this.add((Domain)new TextMaxDomain("varchar", ConversionPoint.VARCHAR, Integer.MAX_VALUE, 8000L, 1L));
        this.add((Domain)new TextMaxDomain("nvarchar", ConversionPoint.NVARCHAR, Integer.MAX_VALUE, 8000L, 1L));
        this.add((Domain)new TextDomain("xml", ConversionPoint.XML, Integer.MAX_VALUE, OperationSupport.SUPPORTS_NOTHING));
        this.add((Domain)new FractionDomain("datetime", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, 3, -1, false, OperationSupport.SUPPORTS_LIKE));
        this.add((Domain)new UnknownDomain("hierarchyid"));
        this.add((Domain)new UnknownDomain("smalldatetime"));
        this.add((Domain)new UnknownDomain("datetimeoffset"));
        this.add((Domain)new UnknownDomain("geometry"));
        this.add((Domain)new UnknownDomain("geography"));
    }

    public boolean isSuitable(@Nullable Version productVersion) {
        return productVersion == null || !MsDialect.isMsSql2008(productVersion);
    }
}

