/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import java.sql.SQLException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractTsqlDialect
extends AbstractDatabaseDialect
implements DatabaseDialect {
    protected AbstractTsqlDialect(TypeHelper typeHelper) {
        super(typeHelper);
    }

    @Override
    protected void sqlParameter(@NotNull DdlBuilder builder, DasArgument parameter, boolean longMode) {
        if (builder == null) {
            AbstractTsqlDialect.$$$reportNull$$$0(0);
        }
        DialectUtils.sqlParameter((DdlBuilder)builder, (DasArgument)parameter, (boolean)longMode, (int)2, (boolean)false);
    }

    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            AbstractTsqlDialect.$$$reportNull$$$0(1);
        }
        if (sequence == null) {
            AbstractTsqlDialect.$$$reportNull$$$0(2);
        }
        throw new UnsupportedOperationException(DatabaseBundle.message((String)"ddl.error.drop.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    public boolean supportsTableInfo() {
        return true;
    }

    @Override
    public ObjectKind getSearchPathObjectKind() {
        return ObjectKind.DATABASE;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnection connection) throws SQLException {
        Map map2;
        Object db;
        if (system == null) {
            AbstractTsqlDialect.$$$reportNull$$$0(3);
        }
        if (connection == null) {
            AbstractTsqlDialect.$$$reportNull$$$0(4);
        }
        return (db = (map2 = DbImplUtil.resultRowAsMap((DatabaseConnection)connection, (String)"select db_name() as a", (String[])new String[0])).get("a")) == null ? null : SearchPath.of((ObjectPath)ObjectPath.create((String)db.toString(), (ObjectKind)ObjectKind.DATABASE));
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            AbstractTsqlDialect.$$$reportNull$$$0(5);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.DATABASE) {
            return null;
        }
        String database = this.getNamingService().nameToScript(current.getName(), current.kind, false, this.getCodeStyle().getQuotesPriority());
        return String.format("use %s", database);
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    public boolean supportsProcedureDefinition() {
        return true;
    }

    @Override
    @NotNull
    public String getBinaryLiteralString(byte @NotNull [] binaryData) {
        if (binaryData == null) {
            AbstractTsqlDialect.$$$reportNull$$$0(6);
        }
        String string = "0x" + DialectUtils.toHexString((byte[])binaryData);
        if (string == null) {
            AbstractTsqlDialect.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    public boolean supportsLoadDatabaseList() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryData";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mssql/AbstractTsqlDialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mssql/AbstractTsqlDialect";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryLiteralString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "sqlParameter";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryLiteralString";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

