/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mongo.translator;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dialects.mongo.translator.IMongoFromExpr;
import com.intellij.database.dialects.mongo.translator.IMongoJoinBuilder;
import com.intellij.database.dialects.mongo.translator.IMongoTableFromExpr;
import com.intellij.database.dialects.mongo.translator.MongoIdentifier;
import com.intellij.database.dialects.mongo.translator.MongoJoin;
import com.intellij.database.dialects.mongo.translator.MongoJoinBuilder;
import com.intellij.database.dialects.mongo.translator.MongoJoinCondition;
import com.intellij.database.dialects.mongo.translator.MongoToDatabaseScriptTranslator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlJoinConditionClause;
import com.intellij.sql.psi.SqlJoinExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0012\u001a\u00020\u000bH\u0016J\u0010\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\bH\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J\u0010\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J \u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u000fH\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/dialects/mongo/translator/MongoJoinBuilder;", "Lcom/intellij/database/dialects/mongo/translator/IMongoJoinBuilder;", "o", "Lcom/intellij/sql/psi/SqlJoinExpression;", "root", "Lcom/intellij/sql/psi/SqlElement;", "(Lcom/intellij/sql/psi/SqlJoinExpression;Lcom/intellij/sql/psi/SqlElement;)V", "condition", "Lcom/intellij/database/dialects/mongo/translator/MongoJoinCondition;", "fromExprs", "", "Lcom/intellij/database/dialects/mongo/translator/IMongoFromExpr;", "getO", "()Lcom/intellij/sql/psi/SqlJoinExpression;", "opTokens", "", "getRoot", "()Lcom/intellij/sql/psi/SqlElement;", "build", "v", "convertOpCompositeToken", "", "compositeOpToken", "fromExpr", "handleJoinCondition", "leftFromExpr", "rightTableFromExpr", "Lcom/intellij/database/dialects/mongo/translator/IMongoTableFromExpr;", "opToken", "intellij.database.dialects.mongo"})
public final class MongoJoinBuilder
implements IMongoJoinBuilder {
    private List<IMongoFromExpr> fromExprs;
    private MongoJoinCondition condition;
    private final List<String> opTokens;
    @NotNull
    private final SqlJoinExpression o;
    @NotNull
    private final SqlElement root;

    @Override
    @NotNull
    public IMongoFromExpr build() {
        if (this.opTokens.isEmpty()) {
            if (this.fromExprs.size() == 1) {
                throw (Throwable)MongoToDatabaseScriptTranslator.Companion.createTranslationPSIStructureException((PsiElement)this.o, (PsiElement)this.root);
            }
            String string = DatabaseBundle.message((String)"MongoTranslator.errors.0.is.unsupported.please.use.inner.join.or.left.join", (Object[])new Object[]{"CROSS JOIN"});
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DatabaseBundle.message(\"\u2026left.join\", \"CROSS JOIN\")");
            throw (Throwable)MongoToDatabaseScriptTranslator.Companion.createTranslationException(string, (PsiElement)this.o, (PsiElement)this.root);
        }
        boolean operatorIsInnerInsteadOfLeft = this.convertOpCompositeToken(CollectionsKt.joinToString$default((Iterable)this.opTokens, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        if (this.fromExprs.size() != 2) {
            throw (Throwable)MongoToDatabaseScriptTranslator.Companion.createTranslationPSIStructureException((PsiElement)this.o, (PsiElement)this.root);
        }
        IMongoFromExpr leftFromExpr = this.fromExprs.get(0);
        IMongoFromExpr rightFromExpr = this.fromExprs.get(1);
        if (!(rightFromExpr instanceof IMongoTableFromExpr)) {
            String string = DatabaseBundle.message((String)"MongoTranslator.errors.only.join.with.table.second.argument.is.supported", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DatabaseBundle.message(\"\u2026d.argument.is.supported\")");
            throw (Throwable)MongoToDatabaseScriptTranslator.Companion.createTranslationException(string, (PsiElement)this.o, (PsiElement)this.root);
        }
        MongoJoinCondition mongoJoinCondition = this.condition;
        if (mongoJoinCondition == null) {
            throw (Throwable)MongoToDatabaseScriptTranslator.Companion.createTranslationPSIStructureException((PsiElement)this.o, (PsiElement)this.root);
        }
        MongoJoinCondition condition = mongoJoinCondition;
        return new MongoJoin(leftFromExpr, (IMongoTableFromExpr)rightFromExpr, this.handleJoinCondition(leftFromExpr, (IMongoTableFromExpr)rightFromExpr, condition), operatorIsInnerInsteadOfLeft);
    }

    @Override
    @NotNull
    public MongoJoinBuilder fromExpr(@NotNull IMongoFromExpr v2) {
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v");
        MongoJoinBuilder mongoJoinBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        MongoJoinBuilder $this$apply = mongoJoinBuilder;
        boolean bl3 = false;
        $this$apply.fromExprs.add(v2);
        return mongoJoinBuilder;
    }

    @Override
    @NotNull
    public MongoJoinBuilder condition(@NotNull MongoJoinCondition v2) {
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v");
        MongoJoinBuilder mongoJoinBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        MongoJoinBuilder $this$apply = mongoJoinBuilder;
        boolean bl3 = false;
        $this$apply.condition = v2;
        return mongoJoinBuilder;
    }

    @Override
    @NotNull
    public MongoJoinBuilder opToken(@NotNull String v2) {
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v");
        MongoJoinBuilder mongoJoinBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        MongoJoinBuilder $this$apply = mongoJoinBuilder;
        boolean bl3 = false;
        $this$apply.opTokens.add(v2);
        return mongoJoinBuilder;
    }

    private final boolean convertOpCompositeToken(String compositeOpToken) {
        boolean bl;
        switch (compositeOpToken) {
            case "INNER JOIN": 
            case "JOIN": {
                bl = true;
                break;
            }
            case "LEFT JOIN": 
            case "LEFT OUTER JOIN": {
                bl = false;
                break;
            }
            default: {
                PsiElement psiElement;
                try {
                    psiElement = this.o.getOpSignElement();
                }
                catch (AssertionError e2) {
                    psiElement = null;
                }
                PsiElement op = psiElement;
                String string = DatabaseBundle.message((String)"MongoTranslator.errors.0.is.unsupported.please.use.inner.join.or.left.join", (Object[])new Object[]{compositeOpToken});
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DatabaseBundle.message(\"\u2026.join\", compositeOpToken)");
                throw (Throwable)MongoToDatabaseScriptTranslator.Companion.createTranslationException(string, op, (PsiElement)this.root);
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final MongoJoinCondition handleJoinCondition(IMongoFromExpr leftFromExpr, IMongoTableFromExpr rightTableFromExpr, MongoJoinCondition condition) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = leftFromExpr.nameIdentifiers();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MongoIdentifier mongoIdentifier = (MongoIdentifier)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            collection.add(string);
        }
        List leftNames = (List)destination$iv$iv;
        String rightTableName = rightTableFromExpr.nameIdentifier().getName();
        if (leftNames.contains(rightTableName)) {
            String string = DatabaseBundle.message((String)"MongoTranslator.errors.not.unique.table.alias", (Object[])new Object[]{rightTableName});
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DatabaseBundle.message(\"\u2026e.alias\", rightTableName)");
            throw (Throwable)MongoToDatabaseScriptTranslator.Companion.createTranslationException(string, (PsiElement)this.o, (PsiElement)this.root);
        }
        MongoIdentifier mongoIdentifier = condition.getLocalColumn().getTableIdentifier();
        if (CollectionsKt.contains((Iterable)leftNames, (Object)(mongoIdentifier != null ? mongoIdentifier.getName() : null))) {
            MongoIdentifier mongoIdentifier2 = condition.getForeignColumn().getTableIdentifier();
            if (Intrinsics.areEqual((Object)rightTableName, (Object)(mongoIdentifier2 != null ? mongoIdentifier2.getName() : null))) {
                return condition;
            }
        }
        MongoIdentifier mongoIdentifier3 = condition.getLocalColumn().getTableIdentifier();
        if (Intrinsics.areEqual((Object)rightTableName, (Object)(mongoIdentifier3 != null ? mongoIdentifier3.getName() : null))) {
            MongoIdentifier mongoIdentifier4 = condition.getForeignColumn().getTableIdentifier();
            if (CollectionsKt.contains((Iterable)leftNames, (Object)(mongoIdentifier4 != null ? mongoIdentifier4.getName() : null))) {
                return new MongoJoinCondition(condition.getForeignColumn(), condition.getLocalColumn());
            }
        }
        String quotedLeftNamesArg2 = CollectionsKt.joinToString$default((Iterable)leftNames, (CharSequence)", ", null, null, (int)0, null, (Function1)handleJoinCondition.quotedLeftNamesArg.1.INSTANCE, (int)30, null);
        String quotedRightTableName = '\'' + rightTableName + '\'';
        String string = DatabaseBundle.message((String)"MongoTranslator.errors.incorrect.columns.in.join.condition", (Object[])new Object[]{quotedLeftNamesArg2, quotedRightTableName});
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DatabaseBundle.message(\"\u2026rg, quotedRightTableName)");
        throw (Throwable)MongoToDatabaseScriptTranslator.Companion.createTranslationException(string, PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)this.o), SqlJoinConditionClause.class), (PsiElement)this.root);
    }

    @NotNull
    public final SqlJoinExpression getO() {
        return this.o;
    }

    @NotNull
    public final SqlElement getRoot() {
        return this.root;
    }

    public MongoJoinBuilder(@NotNull SqlJoinExpression o2, @NotNull SqlElement root2) {
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        this.o = o2;
        this.root = root2;
        this.fromExprs = new ArrayList();
        this.opTokens = new ArrayList();
    }
}

