/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mongo;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.ComparePredicateOperation;
import com.intellij.database.data.types.CustomPlaceholder;
import com.intellij.database.data.types.EqualsPredicateOperation;
import com.intellij.database.data.types.FormatTestResult;
import com.intellij.database.data.types.FormatTester;
import com.intellij.database.data.types.GreaterPredicateOperation;
import com.intellij.database.data.types.JdbcPlaceholder;
import com.intellij.database.data.types.LessPredicateOperation;
import com.intellij.database.data.types.LikePredicateOperation;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.NotEqualsPredicateOperation;
import com.intellij.database.data.types.NullPredicateValue;
import com.intellij.database.data.types.Placeholder;
import com.intellij.database.data.types.PredicateOperation;
import com.intellij.database.data.types.PredicateValue;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.data.types.PredicatesUtilKt;
import com.intellij.database.data.types.StringPredicateValue;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.LikeOpType;
import com.intellij.database.data.types.domain.OperationKt;
import com.intellij.database.dialects.base.BasePredicatesHelper;
import com.intellij.database.dialects.mongo.MongoPredicatesHelper;
import com.intellij.database.dialects.mongo.MongoScriptUtilKt;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J>\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0014J&\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014JP\u0010\u001c\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u000f\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001f\u001a\u00020\u0012H\u0014J\"\u0010 \u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J2\u0010!\u001a\u00020\u00182\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160#2\u0006\u0010$\u001a\u00020\u00122\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020'0&H\u0002J-\u0010(\u001a\u00020)*\u00020*2\u0006\u0010\u000f\u001a\u00020+2\u0017\u0010,\u001a\u0013\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020)0&\u00a2\u0006\u0002\b-H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/database/dialects/mongo/MongoPredicatesHelper;", "Lcom/intellij/database/dialects/base/BasePredicatesHelper;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "binaryPattern", "Lkotlin/text/Regex;", "idPattern", "uuidPattern", "equalsPredicate", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "column", "Lcom/intellij/database/data/types/ColumnRef;", "value", "Lcom/intellij/database/data/types/PredicateValue;", "op", "Lcom/intellij/database/data/types/ComparePredicateOperation;", "quote", "", "version", "Lcom/intellij/database/util/Version;", "alias", "", "getFormatTester", "Lcom/intellij/database/data/types/FormatTester;", "columnRef", "domain", "Lcom/intellij/database/data/types/domain/Domain;", "likePredicate", "Lcom/intellij/database/data/types/LikePredicateOperation;", "canCastToText", "inUpdate", "literal", "typeWithConstructor", "classNames", "", "quoteIfForcedMatched", "testUnwrapped", "Lkotlin/Function1;", "Lcom/intellij/database/data/types/FormatTestResult;", "operation", "", "Lcom/intellij/database/util/DdlBuilder;", "Lcom/intellij/database/data/types/PredicateOperation;", "rightOperand", "Lkotlin/ExtensionFunctionType;", "intellij.database.dialects.mongo"})
public final class MongoPredicatesHelper
extends BasePredicatesHelper {
    private final Regex idPattern;
    private final Regex uuidPattern;
    private final Regex binaryPattern;

    @Override
    @Nullable
    protected PredicatesHelper.PredicateProducer equalsPredicate(@NotNull ColumnRef column2, @NotNull PredicateValue value, @NotNull ComparePredicateOperation op, boolean quote, @Nullable Version version, @Nullable String alias) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        return new PredicatesHelper.PredicateProducer(CollectionsKt.listOf((Object)column2), value, (Function1)new Function1<DdlBuilder, Unit>(this, column2, op, value, quote, version){
            final /* synthetic */ MongoPredicatesHelper this$0;
            final /* synthetic */ ColumnRef $column;
            final /* synthetic */ ComparePredicateOperation $op;
            final /* synthetic */ PredicateValue $value;
            final /* synthetic */ boolean $quote;
            final /* synthetic */ Version $version;

            public final void invoke(@NotNull DdlBuilder builder) {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                PredicatesUtilKt.identifier((DdlBuilder)builder, null, (ColumnRef)this.$column).symbol(":").space();
                MongoPredicatesHelper.access$operation(this.this$0, builder, (PredicateOperation)this.$op, (Function1)new Function1<DdlBuilder, Unit>(this){
                    final /* synthetic */ equalsPredicate.1 this$0;

                    public final void invoke(@NotNull DdlBuilder $this$operation) {
                        block1: {
                            PredicateValue predicateValue;
                            block3: {
                                block2: {
                                    block0: {
                                        Intrinsics.checkNotNullParameter((Object)$this$operation, (String)"$receiver");
                                        predicateValue = this.this$0.$value;
                                        if (!Intrinsics.areEqual((Object)predicateValue, (Object)NullPredicateValue.INSTANCE)) break block0;
                                        $this$operation.literal("null");
                                        break block1;
                                    }
                                    if (!Intrinsics.areEqual((Object)predicateValue, (Object)JdbcPlaceholder.INSTANCE)) break block2;
                                    $this$operation.plain("$placeholder$");
                                    break block1;
                                }
                                if (!(predicateValue instanceof CustomPlaceholder)) break block3;
                                $this$operation.plain(((CustomPlaceholder)this.this$0.$value).getPlaceholder());
                                break block1;
                            }
                            if (!(predicateValue instanceof StringPredicateValue)) break block1;
                            $this$operation.literal(this.this$0.$quote ? MongoPredicatesHelper.access$literal(this.this$0.this$0, ((StringPredicateValue)this.this$0.$value).getStr(), this.this$0.$column, this.this$0.$version) : ((StringPredicateValue)this.this$0.$value).getStr());
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = mongoPredicatesHelper;
                this.$column = columnRef;
                this.$op = comparePredicateOperation;
                this.$value = predicateValue;
                this.$quote = bl;
                this.$version = version;
                super(1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void operation(DdlBuilder $this$operation, PredicateOperation op, Function1<? super DdlBuilder, Unit> rightOperand) {
        void rightOperand2;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = rightOperand;
        if (op instanceof EqualsPredicateOperation) {
            ((Function1)rightOperand2.element).invoke((Object)$this$operation);
        } else {
            String string;
            PredicateOperation predicateOperation = op;
            if (predicateOperation instanceof NotEqualsPredicateOperation) {
                string = "$ne";
            } else if (predicateOperation instanceof LessPredicateOperation) {
                string = "$lt";
            } else if (predicateOperation instanceof GreaterPredicateOperation) {
                string = "$gt";
            } else if (predicateOperation instanceof LikePredicateOperation) {
                if (((LikePredicateOperation)op).isNotLike()) {
                    Function1 operand = (Function1)rightOperand2.element;
                    rightOperand2.element = (Function1)new Function1<DdlBuilder, Unit>(this, op, operand){
                        final /* synthetic */ MongoPredicatesHelper this$0;
                        final /* synthetic */ PredicateOperation $op;
                        final /* synthetic */ Function1 $operand;

                        public final void invoke(@NotNull DdlBuilder $receiver) {
                            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                            MongoPredicatesHelper.access$operation(this.this$0, $receiver, (PredicateOperation)new LikePredicateOperation(((LikePredicateOperation)this.$op).getLikeType(), ((LikePredicateOperation)this.$op).getMatchCase(), false), this.$operand);
                        }
                        {
                            this.this$0 = mongoPredicatesHelper;
                            this.$op = predicateOperation;
                            this.$operand = function1;
                            super(1);
                        }
                    };
                    string = "$ne";
                } else {
                    string = "$regex";
                }
            } else {
                string = "unknown_operation_" + op;
            }
            String operator2 = string;
            MongoScriptUtilKt.inCurly$default($this$operation, false, false, (Function0)new Function0<Unit>($this$operation, (Ref.ObjectRef)rightOperand2, operator2){
                final /* synthetic */ DdlBuilder $this_operation;
                final /* synthetic */ Ref.ObjectRef $rightOperand;
                final /* synthetic */ String $operator;

                public final void invoke() {
                    Function1 function1 = (Function1)this.$rightOperand.element;
                    DdlBuilder ddlBuilder = this.$this_operation.plain(this.$operator).symbol(":").space();
                    Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"this.plain(operator).symbol(\":\").space()");
                    function1.invoke((Object)ddlBuilder);
                }
                {
                    this.$this_operation = ddlBuilder;
                    this.$rightOperand = objectRef;
                    this.$operator = string;
                    super(0);
                }
            }, 3, null);
        }
    }

    @Override
    @Nullable
    protected PredicatesHelper.PredicateProducer likePredicate(@NotNull ColumnRef columnRef, @NotNull PredicateValue value, @Nullable Domain domain, @NotNull LikePredicateOperation op, boolean canCastToText, @Nullable String alias, @Nullable Version version, boolean inUpdate) {
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        if (!(value instanceof StringPredicateValue) && !(value instanceof Placeholder) || op.getLikeType() == LikeOpType.MATCHES) {
            return null;
        }
        Domain domain2 = domain;
        if (domain2 == null || !domain2.supports(OperationKt.LIKE_OPERATION)) {
            return null;
        }
        return new PredicatesHelper.PredicateProducer(CollectionsKt.listOf((Object)columnRef), value, (Function1)new Function1<DdlBuilder, Unit>(this, columnRef, op, value){
            final /* synthetic */ MongoPredicatesHelper this$0;
            final /* synthetic */ ColumnRef $columnRef;
            final /* synthetic */ LikePredicateOperation $op;
            final /* synthetic */ PredicateValue $value;

            public final void invoke(@NotNull DdlBuilder builder) {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                PredicatesUtilKt.identifier((DdlBuilder)builder, null, (ColumnRef)this.$columnRef).symbol(":").space();
                MongoPredicatesHelper.access$operation(this.this$0, builder, (PredicateOperation)this.$op, (Function1)new Function1<DdlBuilder, Unit>(this){
                    final /* synthetic */ likePredicate.1 this$0;

                    public final void invoke(@NotNull DdlBuilder $this$operation) {
                        block1: {
                            PredicateValue predicateValue;
                            block3: {
                                block2: {
                                    block0: {
                                        Intrinsics.checkNotNullParameter((Object)$this$operation, (String)"$receiver");
                                        predicateValue = this.this$0.$value;
                                        if (!Intrinsics.areEqual((Object)predicateValue, (Object)NullPredicateValue.INSTANCE)) break block0;
                                        $this$operation.literal("null");
                                        break block1;
                                    }
                                    if (!Intrinsics.areEqual((Object)predicateValue, (Object)JdbcPlaceholder.INSTANCE)) break block2;
                                    $this$operation.plain("$placeholder$");
                                    break block1;
                                }
                                if (!(predicateValue instanceof CustomPlaceholder)) break block3;
                                $this$operation.plain(((CustomPlaceholder)this.this$0.$value).getPlaceholder());
                                break block1;
                            }
                            if (!(predicateValue instanceof StringPredicateValue)) break block1;
                            $this$operation.literal(this.this$0.$op.getLikeType().getDecorator().decorate(((StringPredicateValue)this.this$0.$value).getStr(), this.this$0.this$0.getDbms()));
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = mongoPredicatesHelper;
                this.$columnRef = columnRef;
                this.$op = likePredicateOperation;
                this.$value = predicateValue;
                super(1);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String literal(String value, ColumnRef columnRef, Version version) {
        String string;
        Domain domain;
        Domain domain2 = domain = this.getDomain(columnRef, version);
        String string2 = domain2 != null ? domain2.simpleName() : null;
        if (string2 != null) {
            switch (string2) {
                case "objectId": {
                    string = "ObjectId(\"" + StringUtil.escapeStringCharacters((String)value) + "\")";
                    return string;
                }
                case "date": {
                    string = "new ISODate(\"" + StringUtil.escapeStringCharacters((String)value) + "\")";
                    return string;
                }
                case "decimal": 
                case "decimal128": {
                    string = "NumberDecimal(\"" + StringUtil.escapeStringCharacters((String)value) + "\")";
                    return string;
                }
                case "binData": {
                    CharSequence charSequence = value;
                    boolean bl = false;
                    if (charSequence.length() == 0) {
                        return "UUID(\"\")";
                    }
                    boolean bl2 = false;
                    if (bl2) {
                        return "UUID(\"\")";
                    }
                    if (this.uuidPattern.matches((CharSequence)value)) {
                        string = "UUID(\"" + value + "\")";
                        return string;
                    }
                    MatchResult result2 = this.binaryPattern.matchEntire((CharSequence)value);
                    if (result2 == null) {
                        string = "\"" + StringUtil.escapeStringCharacters((String)value) + "\"";
                        return string;
                    }
                    Object object = result2.getGroups().get(2);
                    int subtype = object != null && (object = object.getValue()) != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 0;
                    MatchGroup matchGroup = result2.getGroups().get(1);
                    string = "BinData(" + subtype + ", \"" + (matchGroup != null ? matchGroup.getValue() : null) + "\")";
                    return string;
                }
            }
        }
        string = "\"" + StringUtil.escapeStringCharacters((String)value) + "\"";
        return string;
    }

    @Override
    @Nullable
    protected FormatTester getFormatTester(@NotNull ColumnRef columnRef, @Nullable Domain domain, @Nullable Version version) {
        FormatTester formatTester;
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        Domain domain2 = domain;
        if (domain2 == null || (domain2 = domain2.getLogicType()) == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)domain2, (String)"domain?.logicType ?: return null");
        Domain type = domain2;
        if (Intrinsics.areEqual((Object)domain.simpleName(), (Object)"decimal") || Intrinsics.areEqual((Object)domain.simpleName(), (Object)"decimal128")) {
            formatTester = this.typeWithConstructor(CollectionsKt.listOf((Object)"NumberDecimal"), true, (Function1<? super String, ? extends FormatTestResult>)((Function1)getFormatTester.1.INSTANCE));
        } else if (type == LogicalType.NUMBER) {
            formatTester = this.typeWithConstructor(CollectionsKt.listOf((Object[])new String[]{"NumberLong", "NumberInt"}), false, (Function1<? super String, ? extends FormatTestResult>)((Function1)getFormatTester.2.INSTANCE));
        } else if (type == LogicalType.UUID) {
            formatTester = this.typeWithConstructor(CollectionsKt.listOf((Object)"ObjectId"), true, (Function1<? super String, ? extends FormatTestResult>)((Function1)new Function1<String, FormatTestResult>(this){
                final /* synthetic */ MongoPredicatesHelper this$0;

                @NotNull
                public final FormatTestResult invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return MongoPredicatesHelper.access$getIdPattern$p(this.this$0).matches((CharSequence)it) ? FormatTestResult.QUOTE : FormatTestResult.NOT_MATCHED;
                }
                {
                    this.this$0 = mongoPredicatesHelper;
                    super(1);
                }
            }));
        } else if (type == LogicalType.BLOB) {
            formatTester = this.typeWithConstructor(CollectionsKt.listOf((Object[])new String[]{"UUID", "BinData"}), true, (Function1<? super String, ? extends FormatTestResult>)((Function1)new Function1<String, FormatTestResult>(this){
                final /* synthetic */ MongoPredicatesHelper this$0;

                @NotNull
                public final FormatTestResult invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return MongoPredicatesHelper.access$getUuidPattern$p(this.this$0).matches((CharSequence)it) || MongoPredicatesHelper.access$getBinaryPattern$p(this.this$0).matches((CharSequence)it) ? FormatTestResult.QUOTE : FormatTestResult.NOT_MATCHED;
                }
                {
                    this.this$0 = mongoPredicatesHelper;
                    super(1);
                }
            }));
        } else if (type == LogicalType.BOOLEAN) {
            formatTester = new FormatTester(false, (Function1)getFormatTester.5.INSTANCE);
        } else if (type == LogicalType.JSON) {
            formatTester = new FormatTester(false, (Function1)getFormatTester.6.INSTANCE);
        } else if (type == LogicalType.TIMESTAMP) {
            List list = CollectionsKt.listOf((Object)"ISODate");
            FormatTester formatTester2 = PredicatesUtilKt.getFormatTester((ColumnRef)columnRef, (Dbms)this.getDbms(), (LogicalType)LogicalType.TIMESTAMP);
            Intrinsics.checkNotNull((Object)formatTester2);
            formatTester = this.typeWithConstructor(list, true, (Function1<? super String, ? extends FormatTestResult>)formatTester2.getTest());
        } else {
            formatTester = null;
        }
        return formatTester;
    }

    private final FormatTester typeWithConstructor(List<String> classNames, boolean quoteIfForcedMatched, Function1<? super String, ? extends FormatTestResult> testUnwrapped) {
        return new FormatTester(quoteIfForcedMatched, (Function1)new Function1<String, FormatTestResult>(classNames, testUnwrapped){
            final /* synthetic */ List $classNames;
            final /* synthetic */ Function1 $testUnwrapped;

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final FormatTestResult invoke(@NotNull String it) {
                FormatTestResult formatTestResult;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (StringsKt.endsWith$default((String)it, (String)")", (boolean)false, (int)2, null)) {
                    boolean bl;
                    block5: {
                        Iterable $this$any$iv = this.$classNames;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                String name2 = (String)element$iv;
                                boolean bl2 = false;
                                if (!StringsKt.startsWith$default((String)it, (String)(name2 + '('), (boolean)false, (int)2, null)) continue;
                                bl = true;
                                break block5;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        formatTestResult = FormatTestResult.NOT_QUOTE;
                        return formatTestResult;
                    }
                }
                formatTestResult = (FormatTestResult)this.$testUnwrapped.invoke((Object)it);
                return formatTestResult;
            }
            {
                this.$classNames = list;
                this.$testUnwrapped = function1;
                super(1);
            }
        });
    }

    public MongoPredicatesHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
        this.idPattern = new Regex("[0-9a-f]{24}", RegexOption.IGNORE_CASE);
        this.uuidPattern = new Regex("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}", RegexOption.IGNORE_CASE);
        this.binaryPattern = new Regex("\\{\"base64\": \"([^\"]*)\", \"subType\": \"(\\d+)\"}", RegexOption.IGNORE_CASE);
    }

    public static final /* synthetic */ void access$operation(MongoPredicatesHelper $this, DdlBuilder $this$access_u24operation, PredicateOperation op, Function1 rightOperand) {
        $this.operation($this$access_u24operation, op, (Function1<? super DdlBuilder, Unit>)rightOperand);
    }

    public static final /* synthetic */ String access$literal(MongoPredicatesHelper $this, String value, ColumnRef columnRef, Version version) {
        return $this.literal(value, columnRef, version);
    }

    public static final /* synthetic */ Regex access$getIdPattern$p(MongoPredicatesHelper $this) {
        return $this.idPattern;
    }

    public static final /* synthetic */ Regex access$getUuidPattern$p(MongoPredicatesHelper $this) {
        return $this.uuidPattern;
    }

    public static final /* synthetic */ Regex access$getBinaryPattern$p(MongoPredicatesHelper $this) {
        return $this.binaryPattern;
    }
}

