/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mongo;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.BooleanDomain;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.Number2Domain;
import com.intellij.database.data.types.domain.OperationSupport;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.data.types.domain.UnknownDomain;

public class MongoDomains
extends DomainRegistry {
    public MongoDomains() {
        this.add((Domain)new SimpleDomain("object", ConversionPoint.JSON, PhysicalDomainType.UNKNOWN, OperationSupport.SUPPORTS_NOTHING));
        this.add((Domain)new TextDomain("string", ConversionPoint.TEXT, Integer.MAX_VALUE));
        this.add((Domain)new IntegerDomain("int", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add((Domain)new IntegerDomain("integer", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add((Domain)new IntegerDomain("long", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add((Domain)new Number2Domain("decimal", ConversionPoint.BIG_DECIMAL, Integer.MAX_VALUE, Integer.MAX_VALUE, false));
        this.add((Domain)new Number2Domain("decimal128", ConversionPoint.BIG_DECIMAL, Integer.MAX_VALUE, Integer.MAX_VALUE, false));
        this.add((Domain)new BooleanDomain("bool", ConversionPoint.BOOLEAN));
        this.add((Domain)new BooleanDomain("boolean", ConversionPoint.BOOLEAN));
        this.add((Domain)new FloatDomain("double", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
        this.add((Domain)new SimpleDomain("array", ConversionPoint.JSON, PhysicalDomainType.UNKNOWN));
        this.add((Domain)new SimpleDomain("objectId", ConversionPoint.UUID, PhysicalDomainType.UNKNOWN));
        this.add((Domain)new SimpleDomain("date", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP));
        this.add((Domain)new SimpleDomain("timestamp", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP));
        this.add((Domain)new BinaryDomain("binData", ConversionPoint.BLOB, Integer.MAX_VALUE));
        this.add((Domain)new UnknownDomain("null"));
        this.add((Domain)new UnknownDomain("maxKey"));
        this.add((Domain)new UnknownDomain("minKey"));
        this.add((Domain)new UnknownDomain("regex"));
        this.add((Domain)new UnknownDomain("unknown"));
    }
}

