/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.h2.model;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dialects.h2.model.H2Constant;
import com.intellij.database.dialects.h2.model.H2ObjectEditorFactory;
import com.intellij.database.dialects.h2.model.H2Routine;
import com.intellij.database.dialects.h2.model.H2TableColumn;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModTableColumn;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.schemaEditor.DbObjectEditorFactory;
import com.intellij.database.schemaEditor.SchemaApplyHelper;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.util.containers.JBIterable;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J,\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/dialects/h2/model/H2ModelHelper;", "Lcom/intellij/database/model/ModelHelper;", "()V", "applyH2Column", "", "from", "Lcom/intellij/database/schemaEditor/model/DeColumn;", "col", "Lcom/intellij/database/dialects/h2/model/H2TableColumn;", "exportApplyColumn", "helper", "Lcom/intellij/database/schemaEditor/SchemaApplyHelper;", "to", "Lcom/intellij/database/model/basic/BasicModTableColumn;", "fillPropertiesWithExamples", "e", "Lcom/intellij/database/model/basic/BasicModElement;", "variant", "Lcom/intellij/database/model/ModelHelper$ObjectKindVariant;", "vars", "", "", "generationVariants", "Lcom/intellij/util/containers/JBIterable;", "meta", "Lcom/intellij/database/model/meta/BasicMetaObject;", "getObjectEditorFactory", "Lcom/intellij/database/schemaEditor/DbObjectEditorFactory;", "Companion", "intellij.database.dialects.h2"})
public final class H2ModelHelper
extends ModelHelper {
    private static final ModelHelper.ObjectKindVariant ALIAS;
    public static final Companion Companion;

    public void exportApplyColumn(@NotNull SchemaApplyHelper helper, @NotNull DeColumn from, @NotNull BasicModTableColumn to) {
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        if (to instanceof H2TableColumn) {
            this.applyH2Column(from, (H2TableColumn)to);
        } else {
            super.exportApplyColumn(helper, from, to);
        }
    }

    @NotNull
    public JBIterable<ModelHelper.ObjectKindVariant> generationVariants(@NotNull BasicMetaObject<?> meta) {
        JBIterable jBIterable;
        Intrinsics.checkNotNullParameter(meta, (String)"meta");
        if (meta.kind == ObjectKind.ROUTINE) {
            JBIterable jBIterable2 = JBIterable.of((Object)ALIAS);
            jBIterable = jBIterable2;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"JBIterable.of(ALIAS)");
        } else {
            JBIterable jBIterable3 = super.generationVariants(meta);
            jBIterable = jBIterable3;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"super.generationVariants(meta)");
        }
        return jBIterable;
    }

    public void fillPropertiesWithExamples(@NotNull BasicModElement e2, @NotNull ModelHelper.ObjectKindVariant variant, @NotNull Map<String, String> vars) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter(vars, (String)"vars");
        if (e2 instanceof H2Constant) {
            ((H2Constant)e2).setValue("'val'");
            vars.put("value", "'val'");
        }
        if (e2 instanceof H2Routine) {
            ((H2Routine)e2).setSource("//todo: implement");
            String string = ((H2Routine)e2).getSource();
            Intrinsics.checkNotNull((Object)string);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.source!!");
            vars.put("source", string);
        }
        super.fillPropertiesWithExamples(e2, variant, vars);
    }

    @NotNull
    public DbObjectEditorFactory getObjectEditorFactory() {
        return H2ObjectEditorFactory.INSTANCE;
    }

    private final void applyH2Column(DeColumn from, H2TableColumn col) {
        BasicElement basicElement = from.unwrap();
        if (!(basicElement instanceof H2TableColumn)) {
            basicElement = null;
        }
        H2TableColumn prev = (H2TableColumn)basicElement;
        SequenceIdentity sequenceIdentity = SequenceIdentity.UNKNOWN;
        boolean bl = false;
        boolean bl2 = false;
        SequenceIdentity sequenceIdentity2 = sequenceIdentity;
        H2TableColumn h2TableColumn = col;
        boolean $i$a$-takeIf-H2ModelHelper$applyH2Column$22 = false;
        boolean bl3 = from.flags.contains(DeColumn.Flag.AUTO_INC);
        h2TableColumn.setSequenceIdentity((SequenceIdentity)(bl3 ? sequenceIdentity : null));
        boolean notChangedSeq = prev != null && prev.isAutoInc() && !col.isAutoInc() && Intrinsics.areEqual((Object)from.defaultValue, (Object)prev.getDefaultExpression());
        String string = from.defaultValue;
        bl2 = false;
        boolean bl4 = false;
        String $i$a$-takeIf-H2ModelHelper$applyH2Column$22 = string;
        h2TableColumn = col;
        boolean bl5 = false;
        bl3 = notChangedSeq;
        h2TableColumn.setDefaultExpression(!bl3 ? string : null);
    }

    static {
        Companion = new Companion(null);
        ALIAS = new ModelHelper.ObjectKindVariant(DatabaseBundle.messagePointer((String)"ObjectKindVariant.alias", (Object[])new Object[0]));
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/dialects/h2/model/H2ModelHelper$Companion;", "", "()V", "ALIAS", "Lcom/intellij/database/model/ModelHelper$ObjectKindVariant;", "intellij.database.dialects.h2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

