/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.greenplum.model.properties;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TLongHashSet;
import gnu.trove.TLongLongHashMap;
import gnu.trove.TLongObjectHashMap;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GPlumPartitionTree {
    public static final long NO_PARENT = 0L;
    private static final String CHILD_SEPARATOR = "$";
    private static final String VERTEX_SEPARATOR = "&";
    private final TLongObjectHashMap<TLongHashSet> myAdjacencyList = new TLongObjectHashMap();
    private final TLongLongHashMap myParents = new TLongLongHashMap();

    public void addEdge(long from, long to) {
        this.getChildren(from).add(to);
        this.myParents.put(to, from);
    }

    public void removeEdges(long vertex) {
        long[] lArray = this.getChildrenAsArray(vertex);
        int n = lArray.length;
        for (int j = 0; j < n; ++j) {
            Long child = lArray[j];
            this.removeEdges(child);
        }
        this.myAdjacencyList.remove(vertex);
        long parent2 = this.myParents.get(vertex);
        if (parent2 != 0L) {
            this.getChildren(parent2).remove(vertex);
        }
    }

    public long getParent(long vertex) {
        return this.myParents.get(vertex);
    }

    @Nullable
    public String serialize() {
        if (this.myAdjacencyList.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        long[] vertices = this.myAdjacencyList.keys();
        Arrays.sort(vertices);
        for (long vertex : vertices) {
            long[] children2 = this.getChildrenAsArray(vertex);
            if (children2.length == 0) continue;
            Arrays.sort(children2);
            sb.append(vertex).append(CHILD_SEPARATOR);
            for (long child : children2) {
                sb.append(child).append(CHILD_SEPARATOR);
            }
            sb.append(VERTEX_SEPARATOR);
        }
        return sb.toString();
    }

    public void deserialize(@Nullable String value) {
        if (value == null) {
            return;
        }
        List splitted = StringUtil.split((String)value, (String)VERTEX_SEPARATOR);
        for (String s : splitted) {
            if (StringUtil.isEmptyOrSpaces((String)s)) continue;
            List children2 = StringUtil.split((String)s, (String)CHILD_SEPARATOR);
            String parentString = (String)ContainerUtil.getFirstItem((List)children2);
            if (parentString == null) {
                this.clearAndReportError();
                return;
            }
            try {
                long parent2 = Long.parseLong(parentString);
                for (int i2 = 1; i2 < children2.size(); ++i2) {
                    String childString = (String)children2.get(i2);
                    if (StringUtil.isEmptyOrSpaces((String)childString)) continue;
                    long child = Long.parseLong(childString);
                    this.addEdge(parent2, child);
                }
            }
            catch (NumberFormatException e2) {
                this.clearAndReportError();
            }
        }
    }

    public long[] getChildrenAsArray(long vertex) {
        return this.getChildren(vertex).toArray();
    }

    @NotNull
    private TLongHashSet getChildren(long vertex) {
        if (!this.myAdjacencyList.containsKey(vertex)) {
            this.myAdjacencyList.put(vertex, (Object)new TLongHashSet());
        }
        TLongHashSet tLongHashSet = (TLongHashSet)this.myAdjacencyList.get(vertex);
        if (tLongHashSet == null) {
            GPlumPartitionTree.$$$reportNull$$$0(0);
        }
        return tLongHashSet;
    }

    private void clearAndReportError() {
        this.myAdjacencyList.clear();
        this.myParents.clear();
        throw new IllegalStateException("Failed to read partitions tree");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/greenplum/model/properties/GPlumPartitionTree", "getChildren"));
    }
}

