/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.greenplum.model;

import com.intellij.database.dialects.greenplum.model.GPlumExternalTable;
import com.intellij.database.dialects.greenplum.model.GPlumLocalTable;
import com.intellij.database.dialects.greenplum.model.GPlumLocalTableColumn;
import com.intellij.database.dialects.greenplum.model.GPlumModelHelper;
import com.intellij.database.dialects.greenplum.model.GPlumPartition;
import com.intellij.database.dialects.greenplum.model.properties.GPlumPartitionKind;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseModelHelper;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumDescriptionService;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.basic.BasicElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dialects/greenplum/model/GPlumDescriptionService;", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumDescriptionService;", "()V", "helper", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseModelHelper;", "getHelper", "()Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseModelHelper;", "content", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "describeExternalTable", "t", "Lcom/intellij/database/dialects/greenplum/model/GPlumExternalTable;", "describeLocalTable", "Lcom/intellij/database/dialects/greenplum/model/GPlumLocalTable;", "describePartition", "Lcom/intellij/database/dialects/greenplum/model/GPlumPartition;", "inclusiveOrExclusive", "inclusive", "", "intellij.database.dialects.greenplum"})
public final class GPlumDescriptionService
extends PgGPlumDescriptionService {
    @Override
    @NotNull
    protected PgGPlumBaseModelHelper getHelper() {
        return GPlumModelHelper.INSTANCE;
    }

    @Override
    @NotNull
    public String content(@NotNull BasicElement e2, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicElement basicElement = e2;
        return basicElement instanceof GPlumExternalTable ? this.describeExternalTable((GPlumExternalTable)e2, context) : (basicElement instanceof GPlumLocalTable ? this.describeLocalTable((GPlumLocalTable)e2, context) : (basicElement instanceof GPlumPartition ? this.describePartition((GPlumPartition)e2, context) : super.content(e2, context)));
    }

    private final String describeLocalTable(GPlumLocalTable t, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        Object object = GPlumLocalTable.DISTRIBUTION_KEYS;
        boolean bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = GPlumLocalTable.DISTRIBUTED_RANDOMLY;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = GPlumLocalTable.PARTITIONS_TREE;
        bl = false;
        collection.add(object);
        String res2 = super.describePgTable(t, context);
        List<Integer> list = t.getDistributionKeys();
        Intrinsics.checkNotNullExpressionValue(list, (String)"t.distributionKeys");
        object = list;
        bl = false;
        if (!object.isEmpty()) {
            res2 = res2 + " distribution_keys " + t.getDistributionKeys();
        }
        if (t.isDistributedRandomly()) {
            res2 = res2 + " distributed_randomly";
        }
        object = res2;
        bl = false;
        Object object2 = object;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)((CharSequence)object2))).toString();
    }

    private final String describeExternalTable(GPlumExternalTable t, DescriptionService.Context context) {
        String string;
        Collection collection = context.getDescribed();
        Object object = GPlumExternalTable.WRITABLE;
        boolean bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = GPlumExternalTable.LOCATIONS;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = GPlumExternalTable.EXEC_LOCATION;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = GPlumExternalTable.FORMAT;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = GPlumExternalTable.FORMAT_OPTIONS;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = GPlumExternalTable.ENCODING;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = GPlumExternalTable.REJECT_LIMIT;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = GPlumExternalTable.REJECT_LIMIT_TYPE;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = GPlumExternalTable.DISTRIBUTION_KEYS;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = GPlumExternalTable.DISTRIBUTED_RANDOMLY;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = GPlumExternalTable.COMMAND;
        bl = false;
        collection.add(object);
        ArrayList attributes2 = new ArrayList();
        object = attributes2;
        Object object2 = t.isWritable() ? "writable" : "readable";
        boolean bl2 = false;
        object.add((String)object2);
        object = attributes2;
        List<String> list = t.getLocations();
        Intrinsics.checkNotNullExpressionValue(list, (String)"t.locations");
        object2 = list;
        bl2 = false;
        if (!object2.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder().append("locations (");
            List<String> list2 = t.getLocations();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"t.locations");
            string = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list2, null, null, null, (int)0, null, null, (int)63, null)).append(')').toString();
        } else {
            string = "command (" + t.getCommand() + ')';
        }
        object2 = string;
        bl2 = false;
        object.add(object2);
        if (t.getExecLocation() != null) {
            object = attributes2;
            object2 = "exec location (" + t.getExecLocation() + ')';
            bl2 = false;
            object.add(object2);
        }
        object = attributes2;
        object2 = "format (" + t.getFormat().getName() + ')';
        bl2 = false;
        object.add(object2);
        object = attributes2;
        object2 = "options (" + t.getFormatOptions() + ')';
        bl2 = false;
        object.add(object2);
        object = attributes2;
        object2 = "encoding (" + t.getEncoding() + ')';
        bl2 = false;
        object.add(object2);
        if (t.getRejectLimit() != 0) {
            object = attributes2;
            object2 = "reject limit (" + t.getRejectLimit() + ' ' + t.getRejectLimitType().getName() + ')';
            bl2 = false;
            object.add(object2);
        }
        List<Integer> list3 = t.getDistributionKeys();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"t.distributionKeys");
        object = list3;
        boolean bl3 = false;
        if (!object.isEmpty()) {
            object = attributes2;
            String string2 = "distribution_keys " + t.getDistributionKeys();
            bl2 = false;
            object.add(string2);
        }
        if (t.isDistributedRandomly()) {
            object = attributes2;
            String string3 = "distributed_randomly";
            bl2 = false;
            object.add(string3);
        }
        return CollectionsKt.joinToString$default((Iterable)attributes2, null, null, null, (int)0, null, null, (int)63, null);
    }

    private final String describePartition(GPlumPartition e2, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        Object object = GPlumPartition.COLUMNS;
        boolean bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = GPlumPartition.PARTITION_KIND;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = GPlumPartition.VALUES;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = GPlumPartition.START_VALUE;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = GPlumPartition.START_INCLUSIVE;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = GPlumPartition.END_INCLUSIVE;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = GPlumPartition.END_VALUE;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = GPlumPartition.EVERY_VALUE;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = GPlumPartition.ORDER;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = GPlumPartition.DEFAULT_PARTITION;
        bl = false;
        collection.add(object);
        ArrayList descriptions = new ArrayList();
        GPlumLocalTable gPlumLocalTable = e2.getLocalTable();
        Intrinsics.checkNotNull((Object)gPlumLocalTable);
        Intrinsics.checkNotNullExpressionValue((Object)gPlumLocalTable, (String)"e.localTable!!");
        GPlumLocalTable table = gPlumLocalTable;
        ArrayList columns = new ArrayList();
        for (Integer attribute : e2.getColumns()) {
            Object object2 = (GPlumLocalTableColumn)table.getColumns().getByNaturalPosition((short)attribute.intValue());
            if (object2 == null || (object2 = object2.getName()) == null) {
                object2 = "?unknown?";
            }
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"table.columns.getByNatur\u2026t())?.name ?: \"?unknown?\"");
            Object column2 = object2;
            Collection collection2 = columns;
            boolean bl2 = false;
            collection2.add(column2);
        }
        Collection collection3 = columns;
        boolean bl3 = false;
        if (!collection3.isEmpty()) {
            collection3 = descriptions;
            String string = "columns (" + CollectionsKt.joinToString$default((Iterable)columns, null, null, null, (int)0, null, null, (int)63, null) + ')';
            boolean bl4 = false;
            collection3.add(string);
        }
        collection3 = descriptions;
        StringBuilder stringBuilder = new StringBuilder().append("kind (");
        GPlumPartitionKind gPlumPartitionKind = e2.getPartitionKind();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gPlumPartitionKind), (String)"e.partitionKind");
        String string = stringBuilder.append(gPlumPartitionKind.getSqlName()).append(')').toString();
        boolean bl5 = false;
        collection3.add(string);
        if (e2.getPartitionKind() == GPlumPartitionKind.LIST) {
            if (e2.getValues() != null) {
                collection3 = descriptions;
                string = "values (" + e2.getValues() + ')';
                bl5 = false;
                collection3.add(string);
            }
        } else {
            if (e2.getStartValue() != null) {
                collection3 = descriptions;
                string = "start (" + e2.getStartValue() + ' ' + this.inclusiveOrExclusive(e2.isStartInclusive()) + ')';
                bl5 = false;
                collection3.add(string);
            }
            if (e2.getEndValue() != null) {
                collection3 = descriptions;
                string = "end (" + e2.getEndValue() + ' ' + this.inclusiveOrExclusive(e2.isEndInclusive()) + ')';
                bl5 = false;
                collection3.add(string);
            }
            if (e2.getEveryValue() != null) {
                collection3 = descriptions;
                string = "every (" + e2.getEveryValue() + ')';
                bl5 = false;
                collection3.add(string);
            }
        }
        collection3 = descriptions;
        string = "order (" + e2.getOrder() + ')';
        bl5 = false;
        collection3.add(string);
        if (e2.isDefaultPartition()) {
            collection3 = descriptions;
            string = "default";
            bl5 = false;
            collection3.add(string);
        }
        return CollectionsKt.joinToString$default((Iterable)descriptions, null, null, null, (int)0, null, null, (int)63, null);
    }

    private final String inclusiveOrExclusive(boolean inclusive) {
        return inclusive ? "inclusive" : "exclusive";
    }
}

