/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.greenplum.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.IdCache;
import com.intellij.database.dialects.greenplum.introspector.GPlumIntroQueries;
import com.intellij.database.dialects.greenplum.introspector.GPlumIntrospector;
import com.intellij.database.dialects.greenplum.model.GPlumDatabase;
import com.intellij.database.dialects.greenplum.model.GPlumExternalTable;
import com.intellij.database.dialects.greenplum.model.GPlumLocalTable;
import com.intellij.database.dialects.greenplum.model.GPlumMatView;
import com.intellij.database.dialects.greenplum.model.GPlumModelHelper;
import com.intellij.database.dialects.greenplum.model.GPlumPartition;
import com.intellij.database.dialects.greenplum.model.GPlumRoot;
import com.intellij.database.dialects.greenplum.model.GPlumRule;
import com.intellij.database.dialects.greenplum.model.GPlumSchema;
import com.intellij.database.dialects.greenplum.model.GPlumTable;
import com.intellij.database.dialects.greenplum.model.GPlumTablespace;
import com.intellij.database.dialects.greenplum.model.GPlumTrigger;
import com.intellij.database.dialects.greenplum.model.properties.GPlumExternalTableFormat;
import com.intellij.database.dialects.greenplum.model.properties.GPlumExternalTableRejectLimitType;
import com.intellij.database.dialects.greenplum.model.properties.GPlumPartitionKind;
import com.intellij.database.dialects.greenplum.model.properties.GPlumPartitionTree;
import com.intellij.database.dialects.postgresbase.introspector.IntroStep;
import com.intellij.database.dialects.postgresbase.introspector.PgBaseIntroQueries;
import com.intellij.database.dialects.postgresbase.introspector.PgIntrospectorBase;
import com.intellij.database.dialects.postgresbase.introspector.PgIntrospectorBaseKt;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeStoredTable;
import com.intellij.database.dialects.postgresgreenplumbase.introspector.PgGPlumBaseIntroQueries;
import com.intellij.database.dialects.postgresgreenplumbase.introspector.PgGPlumIntrospectorBase;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseDatabase;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseLikeColumn;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseLikeStoredTable;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseModelHelper;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseSchema;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.model.families.ModIdentifyingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.PositioningFamily;
import com.intellij.database.remote.jdba.sql.Scriptum;
import com.intellij.database.util.Version;
import com.intellij.openapi.project.Project;
import com.intellij.util.text.StringKt;
import gnu.trove.TLongHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 #2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0004#$%&B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ4\u0010\u0016\u001a\u001e\u0012\u0004\u0012\u00020\u00030\u0017R\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0003H\u0014J6\u0010\u001c\u001a \u0012\u0006\b\u0001\u0012\u00020\u00040\u001dR\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u001e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u0004H\u0014J\b\u0010 \u001a\u00020!H\u0014J\b\u0010\"\u001a\u00020\u000fH\u0014R\u0014\u0010\n\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00138TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006'"}, d2={"Lcom/intellij/database/dialects/greenplum/introspector/GPlumIntrospector;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumIntrospectorBase;", "Lcom/intellij/database/dialects/greenplum/model/GPlumRoot;", "Lcom/intellij/database/dialects/greenplum/model/GPlumDatabase;", "Lcom/intellij/database/dialects/greenplum/model/GPlumSchema;", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/database/model/ModelFactory;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/model/ModelFactory;)V", "helper", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseModelHelper;", "getHelper", "()Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseModelHelper;", "isFifth", "", "()Z", "isSixth", "queries", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntroQueries;", "getQueries", "()Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntroQueries;", "createDatabaseRetriever", "Lcom/intellij/database/dialects/postgresbase/introspector/PgIntrospectorBase$DatabaseRetriever;", "Lcom/intellij/database/dialects/postgresbase/introspector/PgIntrospectorBase;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "createSchemaRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector;", "schema", "initConnectionRelatedState", "", "isItPossibleToRetrieveCurrentXid", "Companion", "Factory", "MyDatabaseRetriever", "MySchemaRetriever", "intellij.database.dialects.greenplum"})
public final class GPlumIntrospector
extends PgGPlumIntrospectorBase<GPlumRoot, GPlumDatabase, GPlumSchema> {
    private static final GPlumIntroQueries QUERIES;
    public static final Companion Companion;

    @Override
    @NotNull
    protected PgGPlumBaseModelHelper getHelper() {
        return GPlumModelHelper.INSTANCE;
    }

    private final boolean isFifth() {
        return this.getServerVersion().isOrGreater(new int[]{5});
    }

    private final boolean isSixth() {
        return this.getServerVersion().isOrGreater(new int[]{6});
    }

    @Override
    @NotNull
    protected PgGPlumBaseIntroQueries getQueries() {
        return QUERIES;
    }

    @Override
    protected void initConnectionRelatedState() {
        super.initConnectionRelatedState();
        int n = 0;
        BaseIntrospectionFunctions.setMajorMinorVersionParameters(this.getServerVersion(), 6, new IntRange(n, 1), this.getParametersMap());
        n = 0;
        BaseIntrospectionFunctions.setMajorMinorVersionParameters(this.getServerVersion(), 5, new IntRange(n, 23), this.getParametersMap());
        n = 0;
        BaseIntrospectionFunctions.setMajorMinorVersionParameters(this.getServerVersion(), 4, new IntRange(n, 3), this.getParametersMap());
    }

    @Override
    protected boolean isItPossibleToRetrieveCurrentXid() {
        return this.getServerVersion().isOrGreater(new int[]{5});
    }

    @Override
    @NotNull
    protected BaseIntrospector.AbstractSchemaRetriever<? extends GPlumSchema> createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull GPlumSchema schema) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return new MySchemaRetriever(transaction, schema);
    }

    @Override
    @NotNull
    protected PgIntrospectorBase.DatabaseRetriever<GPlumDatabase> createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull GPlumDatabase database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        return new MyDatabaseRetriever(transaction, database);
    }

    public GPlumIntrospector(@NotNull Project project, @NotNull ModelFactory factory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Dbms dbms = Dbms.GREENPLUM;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"Dbms.GREENPLUM");
        super(dbms, project, factory);
    }

    static {
        Companion = new Companion(null);
        Scriptum scriptum = Scriptum.of(GPlumIntroQueries.class);
        Intrinsics.checkNotNullExpressionValue((Object)scriptum, (String)"Scriptum.of(GPlumIntroQueries::class.java)");
        QUERIES = new GPlumIntroQueries(scriptum);
    }

    public static final /* synthetic */ List access$parseList(GPlumIntrospector $this, String str, Function1 converter) {
        return $this.parseList(str, converter);
    }

    public static final /* synthetic */ List access$parseListOfLongs(GPlumIntrospector $this, String str) {
        return $this.parseListOfLongs(str);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dialects/greenplum/introspector/GPlumIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "()V", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "dbms", "Lcom/intellij/database/Dbms;", "project", "Lcom/intellij/openapi/project/Project;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "isSupported", "version", "Lcom/intellij/database/util/Version;", "VERSION", "intellij.database.dialects.greenplum"})
    public static final class Factory
    implements DBIntrospector.Factory {
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return true;
        }

        @NotNull
        public DBIntrospector createIntrospector(@NotNull Dbms dbms, @NotNull Project project, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
            return new GPlumIntrospector(project, modelFactory);
        }

        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        public boolean isOutdatedCheckSupported(@Nullable BasicElement e2) {
            return !(e2 instanceof GPlumTablespace) && PgIntrospectorBaseKt.canCheckOutdated(e2);
        }

        public boolean isNative() {
            return DBIntrospector.Factory.DefaultImpls.isNative((DBIntrospector.Factory)this);
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/dialects/greenplum/introspector/GPlumIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "intellij.database.dialects.greenplum"})
        public static final class VERSION
        extends PerObjectVersion {
            public static final VERSION INSTANCE;

            private VERSION() {
            }

            static {
                VERSION vERSION;
                INSTANCE = vERSION = new VERSION();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0003B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\u000bH\u0014J\b\u0010\r\u001a\u00020\u000bH\u0014J\b\u0010\u000e\u001a\u00020\u000bH\u0014J\b\u0010\u000f\u001a\u00020\u000bH\u0014J\b\u0010\u0010\u001a\u00020\u000bH\u0014\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dialects/greenplum/introspector/GPlumIntrospector$MyDatabaseRetriever;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumIntrospectorBase$PgGPlumBaseDatabaseRetriever;", "Lcom/intellij/database/dialects/greenplum/model/GPlumDatabase;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumIntrospectorBase;", "Lcom/intellij/database/dialects/greenplum/model/GPlumRoot;", "Lcom/intellij/database/dialects/greenplum/model/GPlumSchema;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "(Lcom/intellij/database/dialects/greenplum/introspector/GPlumIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/greenplum/model/GPlumDatabase;)V", "beforeObjectsRetrieval", "", "cleanupDatabase", "introspectDatabaseObjects", "introspectUserMappings", "retrieveForeignDataWrappers", "retrieveForeignServers", "intellij.database.dialects.greenplum"})
    private final class MyDatabaseRetriever
    extends PgGPlumIntrospectorBase.PgGPlumBaseDatabaseRetriever<GPlumDatabase> {
        @Override
        protected void beforeObjectsRetrieval() {
            super.beforeObjectsRetrieval();
            this.setQueryParameter("umenabled", this.getMySuper() && GPlumIntrospector.this.isSixth());
        }

        @Override
        protected void introspectDatabaseObjects() {
            if (GPlumIntrospector.this.isFifth()) {
                super.introspectDatabaseObjects();
            }
        }

        @Override
        protected void cleanupDatabase() {
            if (GPlumIntrospector.this.isFifth()) {
                super.cleanupDatabase();
            }
        }

        @Override
        protected void retrieveForeignDataWrappers() {
            if (!GPlumIntrospector.this.isSixth()) {
                return;
            }
            super.retrieveForeignDataWrappers();
        }

        @Override
        protected void retrieveForeignServers() {
            if (!GPlumIntrospector.this.isSixth()) {
                return;
            }
            super.retrieveForeignServers();
        }

        @Override
        protected void introspectUserMappings() {
            if (!GPlumIntrospector.this.isSixth()) {
                return;
            }
            super.introspectUserMappings();
        }

        public MyDatabaseRetriever(@NotNull DBTransaction transaction, GPlumDatabase database) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            super((PgGPlumIntrospectorBase)GPlumIntrospector.this, transaction, (PgGPlumBaseDatabase)database);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0003B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0014J!\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0014\u00a2\u0006\u0002\u0010\u0013J#\u0010\u0014\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u00150\u00122\u0006\u0010\b\u001a\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010\u0017J\"\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0019H\u0014J\b\u0010\"\u001a\u00020\rH\u0014J\u0018\u0010#\u001a\u00020\r2\u0006\u0010!\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0014J\u0018\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020)2\u0006\u0010\b\u001a\u00020\u0002H\u0014J\b\u0010*\u001a\u00020\rH\u0014J\b\u0010+\u001a\u00020\rH\u0014J\b\u0010,\u001a\u00020\rH\u0014J\b\u0010-\u001a\u00020\rH\u0002J\b\u0010.\u001a\u00020\rH\u0014J\b\u0010/\u001a\u00020\rH\u0002J\b\u00100\u001a\u00020\rH\u0014J\b\u00101\u001a\u00020\rH\u0014J\b\u00102\u001a\u00020\rH\u0014J\b\u00103\u001a\u00020\rH\u0002J\b\u00104\u001a\u00020\u000bH\u0014J\u0013\u00105\u001a\b\u0012\u0004\u0012\u0002060\u0012H\u0014\u00a2\u0006\u0002\u00107J\b\u00108\u001a\u00020\u000bH\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/intellij/database/dialects/greenplum/introspector/GPlumIntrospector$MySchemaRetriever;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumIntrospectorBase$PgGPlumBaseSchemaRetriever;", "Lcom/intellij/database/dialects/greenplum/model/GPlumSchema;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumIntrospectorBase;", "Lcom/intellij/database/dialects/greenplum/model/GPlumRoot;", "Lcom/intellij/database/dialects/greenplum/model/GPlumDatabase;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "(Lcom/intellij/database/dialects/greenplum/introspector/GPlumIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/greenplum/model/GPlumSchema;)V", "wasExternalTables", "", "analyzeBriefInfo", "", "fixLabelsOrder", "", "", "labels", "", "([Ljava/lang/String;)Ljava/util/List;", "getSchemaChildrenToDrop", "Lcom/intellij/database/model/families/ModIdentifyingFamily;", "Lcom/intellij/database/model/basic/BasicModIdentifiedElement;", "(Lcom/intellij/database/dialects/greenplum/model/GPlumSchema;)[Lcom/intellij/database/model/families/ModIdentifyingFamily;", "getTableOrView", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseLikeStoredTable;", "relKind", "", "tableId", "", "parseExpressions", "ind", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntroQueries$OneIndex;", "table", "performNonIncrementalPart", "processModView", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeStoredTable;", "t", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneTable;", "removeDroppedClasses", "existentIds", "Lgnu/trove/TLongHashSet;", "retrieveAccessMethodOperators", "retrieveAccessMethodProcedures", "retrieveCollations", "retrieveDistributedColumns", "retrieveEnumLabels", "retrieveExternalTables", "retrieveForeignTables", "retrieveOperatorClasses", "retrieveOperatorFamilies", "retrievePartitions", "shouldIntrospectTableRelatedDataIncremental", "steps", "Lcom/intellij/database/dialects/postgresbase/introspector/IntroStep;", "()[Lcom/intellij/database/dialects/postgresbase/introspector/IntroStep;", "wasDataTables", "intellij.database.dialects.greenplum"})
    private final class MySchemaRetriever
    extends PgGPlumIntrospectorBase.PgGPlumBaseSchemaRetriever<GPlumSchema> {
        private boolean wasExternalTables;

        @Override
        @NotNull
        protected IntroStep[] steps() {
            return (IntroStep[])ArraysKt.plus((Object[])super.steps(), (Object[])new IntroStep[]{new IntroStep(this){
                final /* synthetic */ MySchemaRetriever this$0;

                public void perform() {
                    MySchemaRetriever.access$retrieveExternalTables(this.this$0);
                }

                public int priority() {
                    return 21;
                }
                {
                    this.this$0 = this$0;
                }

                public int compareTo(@NotNull IntroStep other) {
                    Intrinsics.checkNotNullParameter((Object)other, (String)"other");
                    return IntroStep.DefaultImpls.compareTo(this, other);
                }
            }, new IntroStep(this){
                final /* synthetic */ MySchemaRetriever this$0;

                public void perform() {
                    MySchemaRetriever.access$retrievePartitions(this.this$0);
                }

                public int priority() {
                    return 22;
                }
                {
                    this.this$0 = this$0;
                }

                public int compareTo(@NotNull IntroStep other) {
                    Intrinsics.checkNotNullParameter((Object)other, (String)"other");
                    return IntroStep.DefaultImpls.compareTo(this, other);
                }
            }, new IntroStep(this){
                final /* synthetic */ MySchemaRetriever this$0;

                public void perform() {
                    MySchemaRetriever.access$retrieveDistributedColumns(this.this$0);
                }

                public int priority() {
                    return 71;
                }
                {
                    this.this$0 = this$0;
                }

                public int compareTo(@NotNull IntroStep other) {
                    Intrinsics.checkNotNullParameter((Object)other, (String)"other");
                    return IntroStep.DefaultImpls.compareTo(this, other);
                }
            }});
        }

        @Override
        protected void retrieveOperatorFamilies() {
            if (GPlumIntrospector.this.isFifth()) {
                super.retrieveOperatorFamilies();
            }
        }

        @Override
        protected void retrieveOperatorClasses() {
            if (GPlumIntrospector.this.isFifth()) {
                super.retrieveOperatorClasses();
            }
        }

        @Override
        protected void retrieveAccessMethodOperators() {
            if (GPlumIntrospector.this.isFifth()) {
                super.retrieveAccessMethodOperators();
            }
        }

        @Override
        protected void retrieveAccessMethodProcedures() {
            if (GPlumIntrospector.this.isFifth()) {
                super.retrieveAccessMethodProcedures();
            }
        }

        @Override
        protected void performNonIncrementalPart() {
            super.performNonIncrementalPart();
            this.retrieveDistributedColumns();
        }

        @Override
        protected void analyzeBriefInfo() {
            super.analyzeBriefInfo();
            Boolean bl = this.performQuery(GPlumIntrospector.this.getQueries().isSuperUser());
            boolean isSuper = bl != null ? bl : false;
            this.setQueryParameter("SUPER", isSuper);
        }

        private final void retrieveDistributedColumns() {
            GPlumIntrospector.this.reportRetrieving("distribution key columns", "introspection.retrieve.distributedKey.columns");
            List<GPlumIntroQueries.OneDistributionKeys> distributionKeys = this.performQuery(QUERIES.getRetrieveDistributionKeys());
            if (distributionKeys.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<GPlumSchema, Unit>(this, distributionKeys){
                final /* synthetic */ MySchemaRetriever this$0;
                final /* synthetic */ List $distributionKeys;

                /*
                 * Unable to fully structure code
                 */
                public final void invoke(@NotNull GPlumSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    tableCache = new IdCache<T>();
                    for (GPlumIntroQueries.OneDistributionKeys keys : this.$distributionKeys) {
                        var6_6 = tableCache;
                        id$iv = keys.table_id;
                        $i$f$get = false;
                        this_$iv$iv = this_$iv;
                        $i$f$getOrCache = false;
                        if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
                        v0 = this_$iv$iv.getV();
                        Intrinsics.checkNotNull(v0);
                        if (v0.getObjectId() == id$iv) {
                            v1 = this_$iv$iv.getV();
                        } else lbl-1000:
                        // 2 sources

                        {
                            var12_11 = id$iv;
                            var14_12 = this_$iv$iv;
                            var15_13 = this_$iv$iv;
                            $i$a$-getOrCache-IdCache$get$1$iv = false;
                            var17_15 = (Function1)new Function1<ModIdentifyingFamily<? extends T>, T>(id$iv, schema){
                                final /* synthetic */ long $id$inlined;
                                final /* synthetic */ GPlumSchema $schema$inlined;
                                {
                                    this.$id$inlined = l;
                                    this.$schema$inlined = gPlumSchema;
                                    super(1);
                                }

                                @Nullable
                                public final T invoke(@NotNull ModIdentifyingFamily<? extends T> $this$invoke) {
                                    Intrinsics.checkNotNullParameter($this$invoke, (String)"$receiver");
                                    return (T)((BasicModIdentifiedElement)$this$invoke.getByObjectId(this.$id$inlined));
                                }
                            };
                            $this$get = $this$getOrCache$iv;
                            $i$a$-get-GPlumIntrospector$MySchemaRetriever$retrieveDistributedColumns$1$table$1 = false;
                            v2 = schema.getTables();
                            Intrinsics.checkNotNullExpressionValue(v2, (String)"schema.tables");
                            v3 = (GPlumTable)it.invoke(v2);
                            if (v3 == null) {
                                v4 = schema.getExternalTables();
                                Intrinsics.checkNotNullExpressionValue(v4, (String)"schema.externalTables");
                                v3 = (GPlumTable)it.invoke(v4);
                            }
                            var18_16 = v3;
                            var15_13.setV(var18_16);
                            v1 = this_$iv$iv.getV();
                        }
                        if ((GPlumTable)v1 == null) {
                            continue;
                        }
                        distKeys = GPlumIntrospector.access$parseList(this.this$0.GPlumIntrospector.this, keys.distribution_keys, retrieveDistributedColumns.distKeys.1.INSTANCE);
                        if (distKeys.isEmpty()) {
                            table.setDistributedRandomly(true);
                            table.setDistributionKeys(CollectionsKt.emptyList());
                            continue;
                        }
                        table.setDistributedRandomly(false);
                        table.setDistributionKeys(distKeys);
                    }
                }
                {
                    this.this$0 = mySchemaRetriever;
                    this.$distributionKeys = list;
                    super(1);
                }
            });
        }

        private final void retrievePartitions() {
            ObjectKind objectKind = ObjectKind.PARTITION;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ObjectKind.PARTITION");
            GPlumIntrospector.this.reportRetrieving(objectKind);
            List<GPlumIntroQueries.OnePartition> partitions = this.performQuery(QUERIES.getRetrievePartitions());
            if (partitions.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<GPlumSchema, Unit>(this, partitions){
                final /* synthetic */ MySchemaRetriever this$0;
                final /* synthetic */ List $partitions;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull GPlumSchema schema) {
                    void $this$groupByTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    Iterable $this$groupBy$iv = this.$partitions;
                    boolean $i$f$groupBy = false;
                    Iterable iterable = $this$groupBy$iv;
                    Map destination$iv$iv = new LinkedHashMap<K, V>();
                    boolean $i$f$groupByTo = false;
                    for (T element$iv$iv : $this$groupByTo$iv$iv) {
                        Object object;
                        GPlumIntroQueries.OnePartition it = (GPlumIntroQueries.OnePartition)element$iv$iv;
                        boolean bl = false;
                        Long key$iv$iv = it.table_id;
                        Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                        boolean $i$f$getOrPut = false;
                        V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                        if (value$iv$iv$iv == null) {
                            boolean bl2 = false;
                            List answer$iv$iv$iv = new ArrayList<E>();
                            $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                            object = answer$iv$iv$iv;
                        } else {
                            object = value$iv$iv$iv;
                        }
                        List list$iv$iv = (List)object;
                        list$iv$iv.add(element$iv$iv);
                    }
                    destination$iv$iv.forEach((BiConsumer)new BiConsumer<Long, List<? extends GPlumIntroQueries.OnePartition>>(this, schema){
                        final /* synthetic */ retrievePartitions.1 this$0;
                        final /* synthetic */ GPlumSchema $schema;

                        /*
                         * WARNING - void declaration
                         */
                        public final void accept(@NotNull Long table_id, @NotNull List<GPlumIntroQueries.OnePartition> ps) {
                            Intrinsics.checkNotNullParameter((Object)table_id, (String)"table_id");
                            Intrinsics.checkNotNullParameter(ps, (String)"ps");
                            GPlumLocalTable gPlumLocalTable = (GPlumLocalTable)this.$schema.getTables().getByObjectId(table_id.longValue());
                            if (gPlumLocalTable == null) {
                                return;
                            }
                            GPlumLocalTable table = gPlumLocalTable;
                            GPlumPartitionTree gPlumPartitionTree = table.getPartitionsTree();
                            if (gPlumPartitionTree == null) {
                                gPlumPartitionTree = new GPlumPartitionTree();
                            }
                            Intrinsics.checkNotNullExpressionValue((Object)gPlumPartitionTree, (String)"table.partitionsTree ?: GPlumPartitionTree()");
                            GPlumPartitionTree tree = gPlumPartitionTree;
                            table.setPartitionsTree(tree);
                            for (GPlumIntroQueries.OnePartition p : ps) {
                                Collection<Integer> collection;
                                void $this$mapTo$iv$iv;
                                void $this$map$iv;
                                GPlumPartition partition;
                                GPlumPartition gPlumPartition = partition = (GPlumPartition)table.getPartitions().renew(p.id, p.name);
                                Intrinsics.checkNotNullExpressionValue((Object)gPlumPartition, (String)"partition");
                                gPlumPartition.setPartitionKind(GPlumPartitionKind.of(p.kind));
                                Iterable iterable = GPlumIntrospector.access$parseListOfLongs(this.this$0.this$0.GPlumIntrospector.this, p.columns);
                                GPlumPartition gPlumPartition2 = partition;
                                boolean $i$f$map = false;
                                void var10_10 = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    void it;
                                    long l = ((Number)item$iv$iv).longValue();
                                    collection = destination$iv$iv;
                                    boolean bl = false;
                                    Integer n = (int)it;
                                    collection.add(n);
                                }
                                collection = (List)destination$iv$iv;
                                gPlumPartition2.setColumns(CollectionsKt.toList((Iterable)collection));
                                partition.setValues(StringKt.nullize((String)p.values_list, (boolean)true));
                                partition.setStartValue(StringKt.nullize((String)p.start_value, (boolean)true));
                                partition.setEndValue(StringKt.nullize((String)p.end_value, (boolean)true));
                                partition.setEveryValue(StringKt.nullize((String)p.every_value, (boolean)true));
                                partition.setStartInclusive(p.start_inclusive);
                                partition.setEndInclusive(p.end_inclusive);
                                partition.setDefaultPartition(p.is_default);
                                partition.setOrder(p.order);
                                partition.setLevel(p.level);
                                tree.addEdge(p.parent_id, p.id);
                            }
                            table.getPartitions().sort();
                        }
                        {
                            this.this$0 = var1_1;
                            this.$schema = gPlumSchema;
                        }
                    });
                }
                {
                    this.this$0 = mySchemaRetriever;
                    this.$partitions = list;
                    super(1);
                }
            });
        }

        private final void retrieveExternalTables() {
            GPlumIntrospector.this.reportRetrieving("external tables", "introspection.retrieve.external.tables");
            List<GPlumIntroQueries.OneExternalTable> tbls = this.performQuery(QUERIES.getRetrieveExternalTables());
            if (tbls.isEmpty()) {
                return;
            }
            this.wasExternalTables = true;
            this.inSchema((Function1)new Function1<GPlumSchema, Unit>(tbls){
                final /* synthetic */ List $tbls;

                public final void invoke(@NotNull GPlumSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    for (GPlumIntroQueries.OneExternalTable t : this.$tbls) {
                        String string;
                        GPlumExternalTable table;
                        GPlumExternalTable gPlumExternalTable = table = (GPlumExternalTable)schema.getExternalTables().renew(t.id, t.name);
                        Intrinsics.checkNotNullExpressionValue((Object)gPlumExternalTable, (String)"table");
                        gPlumExternalTable.setStateNumber(t.state_number);
                        table.setWritable(t.writable);
                        table.setLocations(ArraysKt.toList((Object[])t.locations));
                        table.setCommand(t.command);
                        table.setExecLocation(t.exec_location);
                        table.setFormat(GPlumExternalTableFormat.of(t.format));
                        if (t.format_options != null) {
                            String string2;
                            boolean bl = false;
                            String string3 = string2;
                            if (string3 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                            }
                            string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                        } else {
                            string = null;
                        }
                        table.setFormatOptions(string);
                        table.setEncoding(t.encoding);
                        table.setRejectLimit(t.reject_limit);
                        table.setRejectLimitType(GPlumExternalTableRejectLimitType.of(t.reject_limit_type));
                    }
                    schema.getExternalTables().sort();
                }
                {
                    this.$tbls = list;
                    super(1);
                }
            });
        }

        @Override
        protected void retrieveCollations() {
            if (!GPlumIntrospector.this.isSixth()) {
                return;
            }
            super.retrieveCollations();
        }

        @Override
        protected void retrieveForeignTables() {
            if (!GPlumIntrospector.this.isSixth()) {
                return;
            }
            super.retrieveForeignTables();
        }

        @Override
        @NotNull
        protected ModIdentifyingFamily<? extends BasicModIdentifiedElement>[] getSchemaChildrenToDrop(@NotNull GPlumSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            return (ModIdentifyingFamily[])ArraysKt.plus((Object[])super.getSchemaChildrenToDrop((PgGPlumBaseSchema)schema), (Object[])new ModNamingIdentifyingFamily[]{schema.getExternalTables()});
        }

        @Override
        protected boolean wasDataTables() {
            return super.wasDataTables() || this.wasExternalTables;
        }

        @Override
        protected boolean shouldIntrospectTableRelatedDataIncremental() {
            return super.shouldIntrospectTableRelatedDataIncremental() || ((GPlumSchema)this.getSchema()).getExternalTables().hasChildren();
        }

        @Override
        protected void processModView(@NotNull PgBaseLikeStoredTable table, @NotNull PgBaseIntroQueries.OneTable t) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        }

        @Override
        protected void removeDroppedClasses(@NotNull TLongHashSet existentIds, @NotNull GPlumSchema schema) {
            Intrinsics.checkNotNullParameter((Object)existentIds, (String)"existentIds");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            super.removeDroppedClasses(existentIds, (PgGPlumBaseSchema)schema);
            for (GPlumExternalTable et : schema.getExternalTables()) {
                ModIdentifyingFamily[] modIdentifyingFamilyArray = new ModIdentifyingFamily[2];
                GPlumExternalTable gPlumExternalTable = et;
                Intrinsics.checkNotNullExpressionValue((Object)gPlumExternalTable, (String)"et");
                ModNamingIdentifyingFamily<? extends GPlumRule> modNamingIdentifyingFamily = gPlumExternalTable.getRules();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"et.rules");
                modIdentifyingFamilyArray[0] = (ModIdentifyingFamily)modNamingIdentifyingFamily;
                ModNamingIdentifyingFamily<? extends GPlumTrigger> modNamingIdentifyingFamily2 = et.getTriggers();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"et.triggers");
                modIdentifyingFamilyArray[1] = (ModIdentifyingFamily)modNamingIdentifyingFamily2;
                PgIntrospectorBaseKt.removeDroppedChildren(existentIds, modIdentifyingFamilyArray);
            }
            for (GPlumLocalTable t : schema.getTables()) {
                ModIdentifyingFamily[] modIdentifyingFamilyArray = new ModIdentifyingFamily[1];
                GPlumLocalTable gPlumLocalTable = t;
                Intrinsics.checkNotNullExpressionValue((Object)gPlumLocalTable, (String)"t");
                ModNamingIdentifyingFamily<? extends GPlumPartition> modNamingIdentifyingFamily = gPlumLocalTable.getPartitions();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"t.partitions");
                modIdentifyingFamilyArray[0] = (ModIdentifyingFamily)modNamingIdentifyingFamily;
                PgIntrospectorBaseKt.iterateThruDroppedChildrenAndDrop(existentIds, modIdentifyingFamilyArray, (Function1<? super BasicModIdentifiedElement, Unit>)((Function1)new Function1<BasicModIdentifiedElement, Unit>(t){
                    final /* synthetic */ GPlumLocalTable $t;

                    public final void invoke(@NotNull BasicModIdentifiedElement it) {
                        block0: {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            GPlumLocalTable gPlumLocalTable = this.$t;
                            Intrinsics.checkNotNullExpressionValue((Object)gPlumLocalTable, (String)"t");
                            GPlumPartitionTree gPlumPartitionTree = gPlumLocalTable.getPartitionsTree();
                            if (gPlumPartitionTree == null) break block0;
                            gPlumPartitionTree.removeEdges(((GPlumPartition)it).getObjectId());
                        }
                    }
                    {
                        this.$t = gPlumLocalTable;
                        super(1);
                    }
                }));
            }
        }

        @Override
        @Nullable
        protected PgGPlumBaseLikeStoredTable getTableOrView(@NotNull GPlumSchema schema, char relKind, long tableId) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            PgGPlumBaseLikeStoredTable pgGPlumBaseLikeStoredTable = super.getTableOrView((PgGPlumBaseSchema)schema, relKind, tableId);
            if (pgGPlumBaseLikeStoredTable == null) {
                switch (relKind) {
                    case 'e': {
                        pgGPlumBaseLikeStoredTable = (PgGPlumBaseLikeStoredTable)schema.getExternalTables().getByObjectId(tableId);
                        break;
                    }
                    case '\u0000': {
                        GPlumMatView gPlumMatView = (GPlumMatView)schema.getMatViews().getByObjectId(tableId);
                        if (gPlumMatView != null) {
                            pgGPlumBaseLikeStoredTable = gPlumMatView;
                            break;
                        }
                        pgGPlumBaseLikeStoredTable = (PgGPlumBaseLikeStoredTable)schema.getExternalTables().getByObjectId(tableId);
                        break;
                    }
                    default: {
                        pgGPlumBaseLikeStoredTable = null;
                    }
                }
            }
            return pgGPlumBaseLikeStoredTable;
        }

        @Override
        protected void retrieveEnumLabels() {
            if (GPlumIntrospector.this.isFifth()) {
                super.retrieveEnumLabels();
            }
        }

        @Override
        @NotNull
        protected List<String> fixLabelsOrder(@NotNull String[] labels) {
            Intrinsics.checkNotNullParameter((Object)labels, (String)"labels");
            return CollectionsKt.sorted((Iterable)CollectionsKt.listOf((Object[])Arrays.copyOf(labels, labels.length)));
        }

        @Override
        @NotNull
        protected List<String> parseExpressions(@NotNull PgGPlumBaseIntroQueries.OneIndex ind, @NotNull PgGPlumBaseLikeStoredTable table) {
            Intrinsics.checkNotNullParameter((Object)ind, (String)"ind");
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            List<String> expressions = super.parseExpressions(ind, table);
            if (GPlumIntrospector.this.isFifth()) {
                return expressions;
            }
            String what = "Index " + ind.index_name + " column positions";
            List<Short> positions = PgIntrospectorBaseKt.parseArrayOfPositions(ind.column_positions, what);
            Collection collection = positions;
            boolean bl = false;
            if (!collection.isEmpty() && ((Number)positions.get(0)).shortValue() != (short)0) {
                String string = ind.column_positions;
                ModPositioningNamingFamily<? extends PgGPlumBaseLikeColumn> modPositioningNamingFamily = table.getColumns();
                Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"table.columns");
                List<String> otherColNames = PgIntrospectorBaseKt.peekColNames(string, what, (PositioningFamily<? extends BasicTableOrViewColumn>)((PositioningFamily)modPositioningNamingFamily));
                return CollectionsKt.plus((Collection)otherColNames.subList(0, 1), (Iterable)expressions);
            }
            return expressions;
        }

        public MySchemaRetriever(@NotNull DBTransaction transaction, GPlumSchema schema) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            super((PgGPlumIntrospectorBase)GPlumIntrospector.this, transaction, (PgGPlumBaseSchema)schema);
        }

        public static final /* synthetic */ void access$retrieveExternalTables(MySchemaRetriever $this) {
            $this.retrieveExternalTables();
        }

        public static final /* synthetic */ void access$retrievePartitions(MySchemaRetriever $this) {
            $this.retrievePartitions();
        }

        public static final /* synthetic */ void access$retrieveDistributedColumns(MySchemaRetriever $this) {
            $this.retrieveDistributedColumns();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/dialects/greenplum/introspector/GPlumIntrospector$Companion;", "", "()V", "QUERIES", "Lcom/intellij/database/dialects/greenplum/introspector/GPlumIntroQueries;", "intellij.database.dialects.greenplum"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

