/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.generic;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.base.BaseDmlGenerator;
import com.intellij.database.dialects.generic.GenericDmlGeneratorKt;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.util.registry.Registry;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u000eH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/dialects/generic/GenericDmlGenerator;", "Lcom/intellij/database/dialects/base/BaseDmlGenerator;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "appendLimit", "Lcom/intellij/database/util/DdlBuilder;", "builder", "dialect", "Lcom/intellij/database/dialects/DatabaseDialectEx;", "limit", "", "offset", "atBeginning", "", "getPlaceForLimit", "Lcom/intellij/database/dialects/base/BaseDmlGenerator$Companion$LimitPlace;", "shouldUseLimit", "intellij.database.dialects.generic"})
public final class GenericDmlGenerator
extends BaseDmlGenerator {
    @Override
    @NotNull
    protected BaseDmlGenerator.Companion.LimitPlace getPlaceForLimit() {
        return Intrinsics.areEqual((Object)this.getDbms(), (Object)Dbms.TIBERO) ? BaseDmlGenerator.Companion.LimitPlace.BOTH : (GenericDmlGeneratorKt.DEFAULT_LIMIT_DBS.contains(this.getDbms()) || Intrinsics.areEqual((Object)this.getDbms(), (Object)Dbms.FILEMAKER) ? BaseDmlGenerator.Companion.LimitPlace.END : BaseDmlGenerator.Companion.LimitPlace.BEGIN);
    }

    @Override
    @NotNull
    protected DdlBuilder appendLimit(@NotNull DdlBuilder builder, @NotNull DatabaseDialectEx dialect, int limit, int offset, boolean atBeginning) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        if (!this.shouldUseLimit()) {
            return builder;
        }
        return DbImplUtil.isPageSizeUnlimited((int)limit) ? builder : (GenericDmlGeneratorKt.DEFAULT_LIMIT_DBS.contains(this.getDbms()) ? super.appendLimit(builder, dialect, limit, offset, atBeginning) : (GenericDmlGeneratorKt.TOP_LIMIT_DBS.contains(this.getDbms()) ? this.top(builder, "TOP", limit) : (Intrinsics.areEqual((Object)this.getDbms(), (Object)Dbms.INGRES) ? this.top(builder, "FIRST", limit) : (Intrinsics.areEqual((Object)this.getDbms(), (Object)Dbms.TIBERO) ? this.rowNumLimit(builder, limit, atBeginning) : (Intrinsics.areEqual((Object)this.getDbms(), (Object)Dbms.FILEMAKER) ? this.fetchFirst(builder, limit) : builder)))));
    }

    private final boolean shouldUseLimit() {
        return Registry.is((String)"database.generic_dialect.limit", (boolean)true);
    }

    public GenericDmlGenerator(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
    }
}

