/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.exasol.model;

import com.intellij.database.dialects.exasol.model.ExaConnection;
import com.intellij.database.dialects.exasol.model.ExaDescriptionService;
import com.intellij.database.dialects.exasol.model.ExaScript;
import com.intellij.database.dialects.exasol.model.ExaUser;
import com.intellij.database.dialects.exasol.model.ExaVirtualSchema;
import com.intellij.database.dialects.exasol.model.properties.ExaScriptType;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.NameValue;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J0\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0014\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dialects/exasol/model/ExaDescriptionService;", "Lcom/intellij/database/model/DescriptionService;", "()V", "content", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "describeExaScript", "r", "Lcom/intellij/database/dialects/exasol/model/ExaScript;", "describeExaVirtualSchema", "s", "Lcom/intellij/database/dialects/exasol/model/ExaVirtualSchema;", "isPropertyValueDefault", "", "property", "Lcom/intellij/database/model/meta/BasicMetaProperty;", "propertyIndex", "", "meta", "Lcom/intellij/database/model/meta/BasicMetaObject;", "intellij.database.dialects.exasol"})
public final class ExaDescriptionService
extends DescriptionService {
    @NotNull
    public String content(@NotNull BasicElement e2, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicElement basicElement = e2;
        return basicElement instanceof ExaScript ? this.describeExaScript((ExaScript)e2, context) : (basicElement instanceof ExaVirtualSchema ? this.describeExaVirtualSchema((ExaVirtualSchema)e2, context) : super.content(e2, context));
    }

    private final String describeExaScript(ExaScript r, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        BasicMetaProperty<ExaScriptType> basicMetaProperty = ExaScript.SCRIPT_TYPE;
        boolean bl = false;
        collection.add(basicMetaProperty);
        return "script " + StringUtil.toLowerCase((String)String.valueOf((Object)r.getScriptType()));
    }

    private final String describeExaVirtualSchema(ExaVirtualSchema s, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        Object object = ExaVirtualSchema.ADAPTER_NAME;
        boolean bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = ExaVirtualSchema.ADAPTER_SCHEMA;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = ExaVirtualSchema.PROPERTIES;
        bl = false;
        collection.add(object);
        StringBuilder stringBuilder = new StringBuilder().append("vschema using ").append(s.getAdapterSchema()).append('.').append(s.getAdapterName()).append(" props {");
        List<NameValue> list = s.getProperties();
        Intrinsics.checkNotNullExpressionValue(list, (String)"s.properties");
        return stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list, (CharSequence)",", null, null, (int)0, null, (Function1)describeExaVirtualSchema.1.INSTANCE, (int)30, null)).toString();
    }

    protected boolean isPropertyValueDefault(@NotNull BasicElement e2, @NotNull BasicMetaProperty<?> property, int propertyIndex, @NotNull BasicMetaObject<?> meta) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter(property, (String)"property");
        Intrinsics.checkNotNullParameter(meta, (String)"meta");
        return Intrinsics.areEqual(property, ExaUser.PASSWORD) || Intrinsics.areEqual(property, ExaConnection.PASSWORD) || super.isPropertyValueDefault(e2, property, propertyIndex, meta);
    }
}

