/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.derby;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.ComparePredicateOperation;
import com.intellij.database.data.types.ConsumerColumnRef;
import com.intellij.database.data.types.DasColumnRef;
import com.intellij.database.data.types.LikePredicateOperation;
import com.intellij.database.data.types.Placeholder;
import com.intellij.database.data.types.PredicateValue;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.data.types.PredicatesUtilKt;
import com.intellij.database.data.types.StringPredicateValue;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.Operation;
import com.intellij.database.data.types.domain.OperationKt;
import com.intellij.database.dialects.base.BasePredicatesHelper;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J>\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0007H\u0014J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u001c\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00072\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0007H\u0002JP\u0010\u0019\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u000e\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001e\u001a\u00020\u0011H\u0014R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/dialects/derby/DerbyPredicatesHelper;", "Lcom/intellij/database/dialects/base/BasePredicatesHelper;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "typeCanCastToText", "", "", "equalsPredicate", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "column", "Lcom/intellij/database/data/types/ColumnRef;", "value", "Lcom/intellij/database/data/types/PredicateValue;", "op", "Lcom/intellij/database/data/types/ComparePredicateOperation;", "quote", "", "version", "Lcom/intellij/database/util/Version;", "alias", "isBitDataType", "columnRef", "typeName", "suffix", "likePredicate", "domain", "Lcom/intellij/database/data/types/domain/Domain;", "Lcom/intellij/database/data/types/LikePredicateOperation;", "canCastToText", "inUpdate", "intellij.database.dialects.derby"})
public final class DerbyPredicatesHelper
extends BasePredicatesHelper {
    private final Set<String> typeCanCastToText;

    @Override
    @Nullable
    protected PredicatesHelper.PredicateProducer equalsPredicate(@NotNull ColumnRef column2, @NotNull PredicateValue value, @NotNull ComparePredicateOperation op, boolean quote, @Nullable Version version, @Nullable String alias) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        return this.isBitDataType(column2) ? null : super.equalsPredicate(column2, value, op, quote, version, alias);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    protected PredicatesHelper.PredicateProducer likePredicate(@NotNull ColumnRef columnRef, @NotNull PredicateValue value, @Nullable Domain domain, @NotNull LikePredicateOperation op, boolean canCastToText, @Nullable String alias, @Nullable Version version, boolean inUpdate) {
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        if (this.isBitDataType(columnRef)) {
            return null;
        }
        if (!(value instanceof StringPredicateValue) && !(value instanceof Placeholder)) {
            return null;
        }
        v0 = domain;
        v1 = typeSupportsOperation = v0 != null && v0.supports(OperationKt.LIKE_OPERATION) == true;
        if (!canCastToText) ** GOTO lbl-1000
        v2 = domain;
        if (v2 != null && v2.supports((Operation)OperationKt.EQUALS_TO_NUMBER_OPERATION)) ** GOTO lbl-1000
        v3 = columnRef.getTypeName();
        if (v3 == null) ** GOTO lbl-1000
        var11_10 = v3;
        var12_11 = false;
        var13_12 = false;
        it = var11_10;
        $i$a$-let-DerbyPredicatesHelper$likePredicate$canCast$1 = false;
        if (this.typeCanCastToText.contains(StringUtil.toLowerCase((String)it))) {
            v4 = true;
        } else lbl-1000:
        // 4 sources

        {
            v4 = canCast = false;
        }
        if (!canCast && !typeSupportsOperation) {
            return null;
        }
        v5 = PredicatesUtilKt.getLikeKeyword((boolean)op.getMatchCase(), (boolean)op.isNotLike(), (Dbms)this.getDbms(), (Version)version, (boolean)inUpdate);
        if (v5 == null) {
            return null;
        }
        likeWord = v5;
        return new PredicatesHelper.PredicateProducer(CollectionsKt.listOf((Object)columnRef), value, (Function1)new Function1<DdlBuilder, Unit>(this, typeSupportsOperation, alias, columnRef, likeWord, value, op){
            final /* synthetic */ DerbyPredicatesHelper this$0;
            final /* synthetic */ boolean $typeSupportsOperation;
            final /* synthetic */ String $alias;
            final /* synthetic */ ColumnRef $columnRef;
            final /* synthetic */ String $likeWord;
            final /* synthetic */ PredicateValue $value;
            final /* synthetic */ LikePredicateOperation $op;

            public final void invoke(@NotNull DdlBuilder builder) {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                if (!this.$typeSupportsOperation) {
                    DdlBuilder ddlBuilder = builder.keyword("CAST").symbol("(");
                    Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"builder.keyword(\"CAST\").symbol(\"(\")");
                    PredicatesUtilKt.identifier((DdlBuilder)ddlBuilder, (String)this.$alias, (ColumnRef)this.$columnRef).space().keyword("AS").space().type("VARCHAR(100)").symbol(")");
                } else {
                    PredicatesUtilKt.identifier((DdlBuilder)builder, (String)this.$alias, (ColumnRef)this.$columnRef);
                }
                DdlBuilder ddlBuilder = builder.space().keyword(this.$likeWord).space();
                Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"builder.space().keyword(likeWord).space()");
                PredicatesUtilKt.value((DdlBuilder)ddlBuilder, (PredicateValue)this.$value, (Dbms)this.this$0.getDbms(), (DbImplUtil.StringLiteralDecorator)this.$op.getLikeType().getDecorator());
            }
            {
                this.this$0 = derbyPredicatesHelper;
                this.$typeSupportsOperation = bl;
                this.$alias = string;
                this.$columnRef = columnRef;
                this.$likeWord = string2;
                this.$value = predicateValue;
                this.$op = likePredicateOperation;
                super(1);
            }
        });
    }

    private final boolean isBitDataType(ColumnRef columnRef) {
        boolean bl;
        ColumnRef columnRef2 = columnRef;
        if (columnRef2 instanceof ConsumerColumnRef) {
            String string = ((ConsumerColumnRef)columnRef).getCol().typeName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"columnRef.col.typeName");
            bl = DerbyPredicatesHelper.isBitDataType$default(this, string, null, 2, null);
        } else if (columnRef2 instanceof DasColumnRef) {
            String string = ((DasColumnRef)columnRef).getCol().getDataType().typeName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"columnRef.col.dataType.typeName");
            bl = this.isBitDataType(string, ((DasColumnRef)columnRef).getCol().getDataType().suffix);
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isBitDataType(String typeName, String suffix2) {
        return StringUtil.equalsIgnoreCase((CharSequence)suffix2, (CharSequence)"FOR BIT DATA") || StringUtil.endsWithIgnoreCase((String)typeName, (String)"FOR BIT DATA");
    }

    static /* synthetic */ boolean isBitDataType$default(DerbyPredicatesHelper derbyPredicatesHelper, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return derbyPredicatesHelper.isBitDataType(string, string2);
    }

    public DerbyPredicatesHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
        this.typeCanCastToText = SetsKt.setOf((Object[])new String[]{"time", "date", "timestamp", "clob"});
    }
}

