/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.couchbase.model;

import com.intellij.database.dialects.couchbase.model.CouchbaseIndex;
import com.intellij.database.dialects.couchbase.model.CouchbaseLikeTable;
import com.intellij.database.dialects.couchbase.model.CouchbaseSchema;
import com.intellij.database.dialects.couchbase.model.CouchbaseTableColumn;
import com.intellij.database.model.basic.BasicModTable;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaType;
import com.intellij.database.model.properties.PropertyConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CouchbaseTable
extends BasicModTable,
CouchbaseLikeTable {
    public static final BasicMetaProperty<Boolean> FLUSH_ENABLED = BasicMetaProperty.create((String)"FlushEnabled", (BasicMetaType)PropertyConverter.T_BOOLEAN, CouchbaseTable.class);
    public static final BasicMetaProperty<Long> RAM_QUOTAM_B = BasicMetaProperty.create((String)"RamQuotaMB", (BasicMetaType)PropertyConverter.T_LONG, CouchbaseTable.class);
    public static final BasicMetaProperty<Integer> REPLICA_NUMBER = BasicMetaProperty.create((String)"ReplicaNumber", (BasicMetaType)PropertyConverter.T_INT, CouchbaseTable.class);
    public static final BasicMetaProperty<Boolean> REPLICA_INDEXES = BasicMetaProperty.create((String)"ReplicaIndexes", (BasicMetaType)PropertyConverter.T_BOOLEAN, CouchbaseTable.class);
    public static final BasicMetaProperty<Integer> MAXTT_L = BasicMetaProperty.create((String)"MaxTTL", (BasicMetaType)PropertyConverter.T_INT, CouchbaseTable.class);
    public static final BasicMetaProperty<String> COMPRESSION_MODE = BasicMetaProperty.create((String)"CompressionMode", (BasicMetaType)PropertyConverter.T_STRING, CouchbaseTable.class);
    public static final BasicMetaProperty<String> BUCKET_TYPE = BasicMetaProperty.create((String)"BucketType", (BasicMetaType)PropertyConverter.T_STRING, CouchbaseTable.class);
    public static final BasicMetaProperty<String> CONFLICT_RESOLUTION_TYPE = BasicMetaProperty.create((String)"ConflictResolutionType", (BasicMetaType)PropertyConverter.T_STRING, CouchbaseTable.class);
    public static final BasicMetaProperty<String> EVICTION_POLICY = BasicMetaProperty.create((String)"EvictionPolicy", (BasicMetaType)PropertyConverter.T_STRING, CouchbaseTable.class);

    @Nullable
    default public CouchbaseSchema getSchema() {
        return this.getParent();
    }

    @Nullable
    public CouchbaseSchema getParent();

    default public @Nullable NamingFamily<@NotNull ? extends CouchbaseTable> getParentFamily() {
        return null;
    }

    @NotNull
    public @NotNull ModPositioningNamingFamily<@NotNull ? extends CouchbaseTableColumn> getColumns();

    @NotNull
    public @NotNull ModNamingFamily<@NotNull ? extends CouchbaseIndex> getIndices();

    public boolean isFlushEnabled();

    public long getRamQuotaMB();

    public int getReplicaNumber();

    public boolean isReplicaIndexes();

    public int getMaxTTL();

    @NotNull
    public String getCompressionMode();

    @NotNull
    public String getBucketType();

    @NotNull
    public String getConflictResolutionType();

    @NotNull
    public String getEvictionPolicy();

    public void setFlushEnabled(boolean var1);

    public void setRamQuotaMB(long var1);

    public void setReplicaNumber(int var1);

    public void setReplicaIndexes(boolean var1);

    public void setMaxTTL(int var1);

    public void setCompressionMode(@NotNull String var1);

    public void setBucketType(@NotNull String var1);

    public void setConflictResolutionType(@NotNull String var1);

    public void setEvictionPolicy(@NotNull String var1);
}

