/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.couchbase;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.dialects.base.BaseDmlGenerator;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.script.generator.dml.ColumnRefs;
import com.intellij.database.script.generator.dml.CountAll;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.OrderBy;
import com.intellij.database.script.generator.dml.QueryColumns;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.script.generator.dml.SelectUsingKeys;
import com.intellij.database.script.generator.dml.WhereClause;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u000eH\u0014J\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dialects/couchbase/CouchbaseDmlGenerator;", "Lcom/intellij/database/dialects/base/BaseDmlGenerator;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "appendRowId", "Lcom/intellij/database/util/DdlBuilder;", "builder", "alias", "", "generate", "task", "Lcom/intellij/database/script/generator/dml/DmlTask;", "select", "Lcom/intellij/database/script/generator/dml/SelectTask;", "selectUsingKeys", "Lcom/intellij/database/script/generator/dml/SelectUsingKeys;", "intellij.database.dialects.couchbase"})
public final class CouchbaseDmlGenerator
extends BaseDmlGenerator {
    @Override
    @NotNull
    protected DdlBuilder appendRowId(@NotNull DdlBuilder builder, @NotNull String alias) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        DdlBuilder ddlBuilder = builder.symbol(",").space().plain("meta().id");
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"builder.symbol(\",\").space().plain(\"meta().id\")");
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DmlTask task) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        return task instanceof SelectUsingKeys ? this.selectUsingKeys(builder, (SelectUsingKeys)task) : super.generate(builder, task);
    }

    private final DdlBuilder selectUsingKeys(DdlBuilder builder, SelectUsingKeys task) {
        DasTable dasTable = task.getTable();
        if (dasTable == null) {
            throw (Throwable)new IllegalArgumentException("table is not set");
        }
        DasTable table = dasTable;
        builder.keyword("SELECT").space();
        String string = task.getAlias();
        if (string == null) {
            string = "t";
        }
        String alias = string;
        this.appendColumns(builder, table, (QueryColumns)new ColumnRefs(CollectionsKt.emptyList()), alias);
        if (task.getAppendRowId()) {
            this.appendRowId(builder, alias);
        }
        DmlUtilKt.space((DdlBuilder)builder, (boolean)task.getInsertNewLines());
        this.appendFromTable(builder, table, alias);
        DmlUtilKt.space((DdlBuilder)builder, (boolean)task.getInsertNewLines());
        builder.keyword("USE").space().keyword("KEYS").space().symbol("[");
        DataConsumer.Column col = (DataConsumer.Column)task.getModel().getColumn(ModelIndex.forColumn((GridModel)((GridModel)task.getModel()), (int)0));
        if (col != null) {
            boolean isFirst = true;
            for (DataConsumer.Row row : task.getModel().getRows()) {
                String literal;
                String key2;
                Object object = col.getValue(row);
                if (!(object instanceof String)) {
                    object = null;
                }
                if ((String)object == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)DbImplUtil.StringLiteralDecorator.PLAIN.decorate(key2, this.getDbms()), (String)"DbImplUtil.StringLiteral\u2026PLAIN.decorate(key, dbms)");
                if (isFirst) {
                    isFirst = false;
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)builder.symbol(",").space(), (String)"builder.symbol(\",\").space()");
                }
                builder.literal(literal);
            }
        }
        builder.symbol("]");
        return builder;
    }

    @Override
    @NotNull
    protected DdlBuilder select(@NotNull DdlBuilder builder, @NotNull SelectTask task) {
        WhereClause it;
        boolean bl;
        boolean bl2;
        WhereClause whereClause;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        DasTable dasTable = task.getTable();
        if (dasTable == null) {
            return super.select(builder, task);
        }
        DasTable table = dasTable;
        if (!task.getKeysOnly() || Intrinsics.areEqual((Object)task.getColumns(), (Object)CountAll.INSTANCE)) {
            return super.select(builder, task);
        }
        builder.plain("GET KEYS");
        DmlUtilKt.space((DdlBuilder)builder, (boolean)task.getInsertNewLines());
        builder.keyword("FROM").space().qualifiedRef((DasObject)table);
        WhereClause whereClause2 = task.getWhereClause();
        if (whereClause2 != null) {
            whereClause = whereClause2;
            bl2 = false;
            bl = false;
            it = whereClause;
            boolean bl3 = false;
            DmlUtilKt.space((DdlBuilder)builder, (boolean)task.getInsertNewLines());
            this.produce(it, builder, (DmlTask)task, true);
        }
        OrderBy orderBy = task.getOrderBy();
        if (orderBy != null) {
            whereClause = orderBy;
            bl2 = false;
            bl = false;
            it = whereClause;
            boolean bl4 = false;
            DmlUtilKt.space((DdlBuilder)builder, (boolean)task.getInsertNewLines());
            this.produce((OrderBy)it, builder);
        }
        if (!DbImplUtil.isPageSizeUnlimited((int)task.getLimit())) {
            this.appendNumericProperty(builder, "LIMIT", task.getLimit());
        }
        if (task.getOffset() > 0) {
            this.appendNumericProperty(builder, "OFFSET", task.getOffset());
        }
        return builder;
    }

    public CouchbaseDmlGenerator(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
    }
}

