/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.clickhouse;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceSslConfiguration;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.database.dialects.base.BaseDatabaseErrorHandler;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CHouseErrorHandler
extends BaseDatabaseErrorHandler {
    public int getErrorOffsetFromException(@NotNull Project project, @NotNull Throwable error, @NotNull String queryText) {
        Matcher matcher;
        if (project == null) {
            CHouseErrorHandler.$$$reportNull$$$0(0);
        }
        if (error == null) {
            CHouseErrorHandler.$$$reportNull$$$0(1);
        }
        if (queryText == null) {
            CHouseErrorHandler.$$$reportNull$$$0(2);
        }
        if (!(matcher = Pattern.compile("\\bfailed at position (\\d+)\\b").matcher(StringUtil.notNullize((String)error.getMessage()))).find()) {
            return -1;
        }
        int pos = StringUtil.parseInt((String)matcher.group(1), (int)-1);
        return pos == -1 ? -1 : pos - 1;
    }

    @Override
    @NotNull
    public String getErrorMessage(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause, @Nullable Consumer<? super DatabaseErrorHandler.Fix> fixes) {
        String message2;
        if (original == null) {
            CHouseErrorHandler.$$$reportNull$$$0(3);
        }
        if (cause == null) {
            CHouseErrorHandler.$$$reportNull$$$0(4);
        }
        if ((message2 = original.getMessage()) != null && message2.contains("HTTP request was sent to HTTPS port")) {
            DataSourceSslConfiguration ssl;
            DataSourceSslConfiguration dataSourceSslConfiguration = ssl = dataSource == null ? null : dataSource.getSslCfg();
            if (ssl == null || !ssl.myEnabled) {
                CHouseErrorHandler.addSettingsFix(fixes, DatabaseBundle.message((String)"enable.ssl", (Object[])new Object[0]), dataSource, (Consumer<? super DataSourceConfigurable>)((Consumer)c -> DataSourceUiUtil.modify((DataSourceConfigurable)c, ds -> {
                    DataSourceSslConfiguration cur = ds.getSslCfg();
                    if (cur == null) {
                        cur = new DataSourceSslConfiguration("", "", "", true, JdbcSettings.SslMode.REQUIRE, LocalDataSource.Storage.PERSIST);
                    } else {
                        cur.myEnabled = true;
                    }
                    ds.setSslCfg(cur);
                })));
            }
        }
        String string = message2 == null || !StringUtil.startsWithIgnoreCase((String)message2, (String)"ClickHouse exception") ? super.getErrorMessage(dataSource, original, cause, fixes) : CHouseErrorHandler.getGenericMessage(cause);
        if (string == null) {
            CHouseErrorHandler.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/clickhouse/CHouseErrorHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/clickhouse/CHouseErrorHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getErrorOffsetFromException";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

