/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.cassandra.model;

import com.intellij.database.dialects.cassandra.generator.producers.CassElementOption;
import com.intellij.database.dialects.cassandra.generator.producers.CassKeyProducersKt;
import com.intellij.database.dialects.cassandra.generator.producers.CassTableProducersKt;
import com.intellij.database.dialects.cassandra.model.CassAggregate;
import com.intellij.database.dialects.cassandra.model.CassDescriptionService;
import com.intellij.database.dialects.cassandra.model.CassFunction;
import com.intellij.database.dialects.cassandra.model.CassIndex;
import com.intellij.database.dialects.cassandra.model.CassKey;
import com.intellij.database.dialects.cassandra.model.CassLikeTable;
import com.intellij.database.dialects.cassandra.model.CassMatView;
import com.intellij.database.dialects.cassandra.model.CassRole;
import com.intellij.database.dialects.cassandra.model.CassSchema;
import com.intellij.database.dialects.cassandra.model.CassTable;
import com.intellij.database.dialects.cassandra.model.CassTableColumn;
import com.intellij.database.dialects.cassandra.model.properties.CassKeyColumn;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.model.basic.BasicView;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.properties.IndexColumn;
import com.intellij.database.view.DbNodeDescriptor;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0003J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020 2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010!\u001a\u00020 H\u0002J\u0018\u0010\"\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010!\u001a\u00020#H\u0014J\u0010\u0010$\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010%\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020&2\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020)2\u0006\u0010!\u001a\u00020*2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006+"}, d2={"Lcom/intellij/database/dialects/cassandra/model/CassDescriptionService;", "Lcom/intellij/database/model/DescriptionService;", "()V", "content", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "describeCassAggregate", "Lcom/intellij/database/dialects/cassandra/model/CassAggregate;", "describeCassFunction", "Lcom/intellij/database/dialects/cassandra/model/CassFunction;", "describeCassIndex", "index", "Lcom/intellij/database/dialects/cassandra/model/CassIndex;", "describeCassKey", "key", "Lcom/intellij/database/dialects/cassandra/model/CassKey;", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "describeCassKeyImpl", "describeCassMatView", "Lcom/intellij/database/dialects/cassandra/model/CassMatView;", "describeCassRole", "Lcom/intellij/database/dialects/cassandra/model/CassRole;", "describeCassSchema", "Lcom/intellij/database/dialects/cassandra/model/CassSchema;", "describeCassTable", "Lcom/intellij/database/dialects/cassandra/model/CassTable;", "describeCassTableColumn", "Lcom/intellij/database/dialects/cassandra/model/CassTableColumn;", "o", "describeIndex", "Lcom/intellij/database/model/DasIndex;", "describeIndexingItems", "describeLikeTable", "Lcom/intellij/database/dialects/cassandra/model/CassLikeTable;", "updatePresentation", "project", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/database/model/DasObject;", "intellij.database.dialects.cassandra"})
public final class CassDescriptionService
extends DescriptionService {
    @NotNull
    public String content(@NotNull BasicElement e2, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicElement basicElement = e2;
        return basicElement instanceof CassKey ? this.describeCassKey((CassKey)e2, context) : (basicElement instanceof CassTableColumn ? this.describeCassTableColumn((CassTableColumn)e2, context) : (basicElement instanceof CassIndex ? this.describeCassIndex((CassIndex)e2, context) : (basicElement instanceof CassFunction ? this.describeCassFunction((CassFunction)e2, context) : (basicElement instanceof CassAggregate ? this.describeCassAggregate((CassAggregate)e2, context) : (basicElement instanceof CassRole ? this.describeCassRole((CassRole)e2, context) : (basicElement instanceof CassSchema ? this.describeCassSchema((CassSchema)e2, context) : (basicElement instanceof CassTable ? this.describeCassTable((CassTable)e2, context) : (basicElement instanceof CassMatView ? this.describeCassMatView((CassMatView)e2, context) : super.content(e2, context)))))))));
    }

    private final String describeCassMatView(CassMatView e2, DescriptionService.Context context) {
        String desc = super.describeView((BasicView)e2, context);
        String likeTableDesc = this.describeLikeTable(e2, context);
        CharSequence charSequence = desc;
        boolean bl = false;
        if (charSequence.length() > 0) {
            charSequence = likeTableDesc;
            bl = false;
            if (charSequence.length() > 0) {
                return desc + ' ' + likeTableDesc;
            }
        }
        return desc + likeTableDesc;
    }

    private final String describeCassTable(CassTable e2, DescriptionService.Context context) {
        String desc = super.describeTable((BasicTable)e2, context);
        String likeTableDesc = this.describeLikeTable(e2, context);
        CharSequence charSequence = desc;
        boolean bl = false;
        if (charSequence.length() > 0) {
            charSequence = likeTableDesc;
            bl = false;
            if (charSequence.length() > 0) {
                return desc + ' ' + likeTableDesc;
            }
        }
        return desc + likeTableDesc;
    }

    private final String describeLikeTable(CassLikeTable e2, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        Object object = CassLikeTable.COMMENT;
        boolean bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = CassLikeTable.BLOOM_FILTER_FP_CHANCE;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = CassLikeTable.CACHING;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = CassLikeTable.CDC;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = CassLikeTable.COMPACTION;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = CassLikeTable.COMPRESSION;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = CassLikeTable.CRC_CHECK_CHANCE;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = CassLikeTable.DCLOCAL_READ_REPAIR_CHANCE;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = CassLikeTable.DEFAULT_TIME_TO_LIVE;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = CassLikeTable.SPECULATIVE_RETRY;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = CassLikeTable.GC_GRACE_SECONDS;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = CassLikeTable.MAX_INDEX_INTERVAL;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = CassLikeTable.MEMTABLE_FLUSH_PERIOD_IN_MS;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = CassLikeTable.MIN_INDEX_INTERVAL;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = CassLikeTable.READ_REPAIR_CHANCE;
        bl = false;
        collection.add(object);
        String desc = "";
        for (CassElementOption<CassLikeTable, ? extends Object> option : CassTableProducersKt.getTableOptions()) {
            Object realValue;
            if (Intrinsics.areEqual((Object)option.getName(), (Object)"comment") || !(Intrinsics.areEqual((Object)(realValue = option.getValueGetter().invoke((Object)e2)), (Object)option.getDefaultValue()) ^ true)) continue;
            desc = desc + ' ' + option.getName() + " = " + option.getLiteral((CassLikeTable)((BasicElement)e2));
        }
        object = desc;
        boolean bl2 = false;
        Object object2 = object;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)((CharSequence)object2))).toString();
    }

    private final String describeCassSchema(CassSchema e2, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        BasicMetaProperty<String> basicMetaProperty = CassSchema.REPLICATION;
        boolean bl = false;
        collection.add(basicMetaProperty);
        String desc = super.describeBasicElement((BasicElement)e2) + " durable_writes: " + e2.isDurableWrites();
        if (e2.getReplication() != null) {
            desc = desc + " replication: " + e2.getReplication();
        }
        return desc;
    }

    private final String describeCassRole(CassRole e2, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        BasicMetaProperty<Boolean> basicMetaProperty = CassRole.SUPER_ROLE;
        boolean bl = false;
        collection.add(basicMetaProperty);
        collection = context.getDescribed();
        basicMetaProperty = CassRole.CAN_LOGIN;
        bl = false;
        collection.add(basicMetaProperty);
        String desc = "";
        if (e2.isSuperRole()) {
            desc = desc + " superuser";
        }
        if (e2.isCanLogin()) {
            desc = desc + " login";
        }
        return desc;
    }

    private final String describeCassAggregate(CassAggregate e2, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        Object object = CassAggregate.STATE_TYPE;
        boolean bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = CassAggregate.STATE_FUNC;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = CassAggregate.FINAL_FUNC;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = CassAggregate.INIT_COND;
        bl = false;
        collection.add(object);
        String description = super.describeRoutine((BasicRoutine)e2, context) + " state_type: " + e2.getStateType();
        if (e2.getStateFunc() != null) {
            description = description + " state_func: " + e2.getStateFunc();
        }
        if (e2.getFinalFunc() != null) {
            description = description + " final_func: " + e2.getFinalFunc();
        }
        if (e2.getInitCond() != null) {
            description = description + " init_cond: " + e2.getInitCond();
        }
        return description;
    }

    private final String describeCassFunction(CassFunction e2, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        Object object = CassFunction.LANGUAGE;
        boolean bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = CassFunction.CALLED_ON_NULL_INPUT;
        bl = false;
        collection.add(object);
        String description = super.describeRoutine((BasicRoutine)e2, context);
        if (e2.getLanguage() != null) {
            description = description + " language: " + e2.getLanguage();
        }
        return description + " called_on_null_input: " + e2.isCalledOnNullInput();
    }

    private final String describeCassTableColumn(CassTableColumn e2, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        BasicMetaProperty<Boolean> basicMetaProperty = CassTableColumn.STATIC_COLUMN;
        boolean bl = false;
        collection.add(basicMetaProperty);
        String description = this.describeTableOrViewColumn((BasicTableOrViewColumn)e2, context);
        if (e2.isStaticColumn()) {
            return description + " static";
        }
        return description;
    }

    private final String describeCassKey(CassKey key2, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        BasicMetaProperty<List<CassKeyColumn>> basicMetaProperty = CassKey.COLUMNS;
        boolean bl = false;
        collection.add(basicMetaProperty);
        return this.describeCassKeyImpl(key2);
    }

    @NlsSafe
    private final String describeCassKeyImpl(CassKey key2) {
        String res2 = '(' + CassKeyProducersKt.describeKey(key2, (Function1<? super String, String>)((Function1)describeCassKeyImpl.res.1.INSTANCE)) + ')';
        if (CassKeyProducersKt.isDefaultClusteringOrder(key2)) {
            return res2;
        }
        return res2 + " clustering order by (" + CassKeyProducersKt.getClusteringOrderBy(key2, (Function1<? super String, String>)((Function1)describeCassKeyImpl.1.INSTANCE)) + ')';
    }

    private final String describeCassIndex(CassIndex index2, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        Object object = CassIndex.COLUMNS;
        boolean bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = CassIndex.CUSTOM;
        bl = false;
        collection.add(object);
        String inner = this.describeIndexingItems(index2);
        return (index2.isCustom() ? "custom index" : "index") + " (" + inner + ')';
    }

    private final String describeIndexingItems(CassIndex index2) {
        String string;
        if (index2.getColumns().isEmpty()) {
            string = "???";
        } else {
            List<IndexColumn> list = index2.getColumns();
            Intrinsics.checkNotNullExpressionValue(list, (String)"index.columns");
            string = CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, null, (int)63, null);
        }
        return string;
    }

    public void updatePresentation(@NotNull Project project, @NotNull DasObject o2, @NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        DasObject dasObject = o2;
        if (dasObject instanceof CassKey) {
            this.describeCassKey(presentation, (CassKey)o2);
        } else if (dasObject instanceof CassTableColumn) {
            this.describeCassTableColumn(presentation, (CassTableColumn)o2);
        } else {
            super.updatePresentation(project, o2, presentation);
        }
    }

    private final void describeCassKey(PresentationData presentation, CassKey key2) {
        presentation.addText(" " + this.describeCassKeyImpl(key2), DbNodeDescriptor.INFO_ATTRS);
    }

    private final void describeCassTableColumn(PresentationData presentation, CassTableColumn o2) {
        super.describeColumn(presentation, (DasColumn)o2);
        if (o2.isStaticColumn()) {
            String string = " static";
            presentation.addText(string, DbNodeDescriptor.INFO_ATTRS);
        }
    }

    protected void describeIndex(@NotNull PresentationData presentation, @NotNull DasIndex o2) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
        if (!(o2 instanceof CassIndex)) {
            return;
        }
        List<IndexColumn> list = ((CassIndex)o2).getColumns();
        Intrinsics.checkNotNullExpressionValue(list, (String)"o.columns");
        String columns = CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, null, (int)63, null);
        presentation.addText(" (" + columns + ')', DbNodeDescriptor.INFO_ATTRS);
    }
}

