/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.cassandra.introspector;

import com.intellij.database.dialects.cassandra.introspector.CassIntrospectorHelperKt;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.io.JsonUtil;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\b\u001a$\u0010\u0004\u001a\u0004\u0018\u00010\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\b\u001a\u0012\u0010\t\u001a\u00020\u00012\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u001a.\u0010\f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00100\u000f\u001a\u001e\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000b0\u0003H\u0002\u001a\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0014\u001a\u00020\u0001\u001a$\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00032\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\u001a\u0010\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"userType", "", "validatorToCType", "", "concatClassAndOptions", "className", "options", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "jsonObjectToCassandraMapObject", "value", "", "jsonToCassandraMapLiteral", "json", "keyFilter", "Lkotlin/Function1;", "", "mapToCassandraMap", "map", "parseDataType", "validator", "parseObject", "quote", "s", "intellij.database.dialects.cassandra"})
public final class CassIntrospectorHelperKt {
    private static final String userType = "UserType";
    private static final Map<String, String> validatorToCType = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"AsciiType", (Object)"ascii"), TuplesKt.to((Object)"LongType", (Object)"bigint"), TuplesKt.to((Object)"BooleanType", (Object)"boolean"), TuplesKt.to((Object)"CounterColumnType", (Object)"counter"), TuplesKt.to((Object)"DecimalType", (Object)"decimal"), TuplesKt.to((Object)"DoubleType", (Object)"double"), TuplesKt.to((Object)"DurationType", (Object)"duration"), TuplesKt.to((Object)"FloatType", (Object)"float"), TuplesKt.to((Object)"Int32Type", (Object)"int"), TuplesKt.to((Object)"UTF8Type", (Object)"text"), TuplesKt.to((Object)"TimestampType", (Object)"timestamp"), TuplesKt.to((Object)"UUIDType", (Object)"uuid"), TuplesKt.to((Object)"UTF8Type", (Object)"varchar"), TuplesKt.to((Object)"IntegerType", (Object)"varint"), TuplesKt.to((Object)"TimeUUIDType", (Object)"timeuuid"), TuplesKt.to((Object)"InetAddressType", (Object)"inet"), TuplesKt.to((Object)"SimpleDateType", (Object)"date"), TuplesKt.to((Object)"TimeType", (Object)"time"), TuplesKt.to((Object)"ShortType", (Object)"smallint"), TuplesKt.to((Object)"ByteType", (Object)"tinyint"), TuplesKt.to((Object)"BytesType", (Object)"blob"), TuplesKt.to((Object)"MapType", (Object)"map"), TuplesKt.to((Object)"SetType", (Object)"set"), TuplesKt.to((Object)"ListType", (Object)"list"), TuplesKt.to((Object)"UserType", (Object)"map"), TuplesKt.to((Object)"TupleType", (Object)"tuple"), TuplesKt.to((Object)"FrozenType", (Object)"frozen")});

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String parseDataType(@NotNull String validator) {
        String currentValidator;
        Intrinsics.checkNotNullParameter((Object)validator, (String)"validator");
        int parenthPos = StringsKt.indexOf$default((CharSequence)validator, (char)'(', (int)0, (boolean)false, (int)6, null);
        if (parenthPos == -1) {
            String string = validator;
            int n = StringsKt.lastIndexOf$default((CharSequence)validator, (char)'.', (int)0, (boolean)false, (int)6, null) + 1;
            boolean bl = false;
            String string2 = string.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            return validatorToCType.get(string2);
        }
        String string = validator;
        int n = 0;
        int n2 = 0;
        String string3 = string.substring(n, parenthPos);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string4 = currentValidator = string3;
        n2 = StringsKt.lastIndexOf$default((CharSequence)currentValidator, (char)'.', (int)0, (boolean)false, (int)6, null) + 1;
        boolean bl = false;
        String string5 = string4;
        if (string5 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.substring(n2);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
        String currentValidatorClass = string6;
        if (Intrinsics.areEqual((Object)currentValidatorClass, (Object)userType)) {
            return validator;
        }
        String string7 = validatorToCType.get(currentValidatorClass);
        if (string7 == null) {
            return null;
        }
        String type = string7;
        StringBuilder sb = new StringBuilder(type).append("<");
        int currentDepth = 0;
        int lastComma = 0;
        String string8 = validator;
        int n3 = parenthPos + 1;
        int n4 = validator.length() - 1;
        boolean bl2 = false;
        String string9 = string8.substring(n3, n4);
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String parameters2 = string9;
        String separator = "";
        CharSequence $this$forEachIndexed$iv = parameters2;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        CharSequence charSequence = $this$forEachIndexed$iv;
        for (int j = 0; j < charSequence.length(); ++j) {
            int n5;
            void c;
            char item$iv = charSequence.charAt(j);
            int n6 = index$iv++;
            char c2 = item$iv;
            int index2 = n6;
            boolean bl3 = false;
            if (c == 40) {
                n5 = currentDepth;
                currentDepth = n5 + 1;
            }
            if (c == 41) {
                n5 = currentDepth;
                currentDepth = n5 + -1;
            }
            if (currentDepth != 0 || c != 44) continue;
            sb.append(separator);
            separator = ", ";
            String string10 = parameters2;
            int n7 = lastComma;
            boolean bl4 = false;
            String string11 = string10;
            if (string11 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string12 = string11.substring(n7, index2);
            Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string13 = CassIntrospectorHelperKt.parseDataType(string12);
            if (string13 == null) {
                string13 = "unknown";
            }
            sb.append(string13);
            lastComma = index2 + 1;
        }
        StringBuilder stringBuilder = sb.append(separator);
        String string14 = parameters2;
        n4 = lastComma;
        bl2 = false;
        String string15 = string14;
        if (string15 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string16 = string15.substring(n4);
        Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"(this as java.lang.String).substring(startIndex)");
        String string17 = CassIntrospectorHelperKt.parseDataType(string16);
        if (string17 == null) {
            string17 = "unknown";
        }
        stringBuilder.append(string17);
        return sb.append(">").toString();
    }

    @Nullable
    public static final String concatClassAndOptions(@Nullable String className, @Nullable String options, @NotNull Logger log) {
        String o2;
        String string;
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        if (className == null || options == null) {
            return null;
        }
        String string2 = CassIntrospectorHelperKt.jsonToCassandraMapLiteral$default(options, log, null, 4, null);
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            String string4 = it;
            int n = 1;
            int n2 = it.length() - 1;
            boolean bl4 = false;
            String string5 = string4;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n, n2);
            string = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string = o2 = null;
        }
        if (o2 == null) {
            return "{'class': " + CassIntrospectorHelperKt.quote(className) + '}';
        }
        return "{'class': " + CassIntrospectorHelperKt.quote(className) + ", " + o2 + '}';
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String jsonToCassandraMapLiteral(@NotNull String json, @NotNull Logger log, @NotNull Function1<? super String, Boolean> keyFilter) {
        String string;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter(keyFilter, (String)"keyFilter");
        Map<String, Object> map2 = CassIntrospectorHelperKt.parseObject(json, log);
        if (map2 != null) {
            void $this$filterTo$iv$iv;
            Map<String, Object> $this$filter$iv = map2;
            boolean $i$f$filter = false;
            Map<String, Object> map3 = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            void var8_9 = $this$filterTo$iv$iv;
            boolean bl = false;
            Iterator iterator = var8_9.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator.next();
                boolean bl2 = false;
                if (!((Boolean)keyFilter.invoke(it.getKey())).booleanValue()) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map map4 = destination$iv$iv;
            boolean bl3 = false;
            boolean bl4 = false;
            Map it = map4;
            boolean bl5 = false;
            string = CassIntrospectorHelperKt.mapToCassandraMap(it);
        } else {
            string = null;
        }
        return string;
    }

    public static /* synthetic */ String jsonToCassandraMapLiteral$default(String string, Logger logger, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = jsonToCassandraMapLiteral.1.INSTANCE;
        }
        return CassIntrospectorHelperKt.jsonToCassandraMapLiteral(string, logger, (Function1<? super String, Boolean>)function1);
    }

    @Nullable
    public static final Map<String, Object> parseObject(@NotNull String json, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        try {
            return JsonUtil.nextObject((JsonReaderEx)new JsonReaderEx((CharSequence)json).lenient(true));
        }
        catch (Exception e2) {
            log.warn((Throwable)e2);
            return null;
        }
    }

    private static final String mapToCassandraMap(Map<String, ? extends Object> map2) {
        if (map2.isEmpty()) {
            return null;
        }
        Iterable $this$sortedBy$iv = map2.entrySet();
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        return "{" + CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Map.Entry it = (Map.Entry)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = (String)it.getKey();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        }), null, null, null, (int)0, null, (Function1)mapToCassandraMap.2.INSTANCE, (int)31, null) + "}";
    }

    private static final String jsonObjectToCassandraMapObject(Object value) {
        String string;
        Object object = value;
        if (object == null) {
            string = "null";
        } else if (object instanceof String) {
            string = CassIntrospectorHelperKt.quote((String)value);
        } else if (object instanceof Double) {
            string = value.toString();
        } else if (object instanceof Boolean) {
            string = value.toString();
        } else if (object instanceof List) {
            string = "[" + CollectionsKt.joinToString$default((Iterable)((Iterable)value), null, null, null, (int)0, null, (Function1)jsonObjectToCassandraMapObject.1.INSTANCE, (int)31, null) + "]";
        } else if (object instanceof Map) {
            Object object2 = value;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
            }
            string = CassIntrospectorHelperKt.mapToCassandraMap((Map)object2);
            if (string == null) {
                string = "{}";
            }
        } else {
            string = "class " + value.getClass() + " is not supported";
        }
        return string;
    }

    private static final String quote(String s) {
        return '\'' + StringsKt.replace$default((String)s, (String)"'", (String)"''", (boolean)false, (int)4, null) + '\'';
    }

    public static final /* synthetic */ String access$quote(String s) {
        return CassIntrospectorHelperKt.quote(s);
    }

    public static final /* synthetic */ String access$jsonObjectToCassandraMapObject(Object value) {
        return CassIntrospectorHelperKt.jsonObjectToCassandraMapObject(value);
    }
}

