/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.cassandra;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.remote.jdbc.RemoteDatabaseMetaData;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ThrowableConvertor;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CassDialect
extends AbstractDatabaseDialect
implements DatabaseDialect {
    public CassDialect() {
        super(new TypeHelper.CassTypeHelper());
    }

    @NotNull
    public String getDisplayName() {
        return "Cassandra";
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.CASSANDRA;
        if (dbms == null) {
            CassDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnection connection) throws SQLException {
        String s;
        if (system == null) {
            CassDialect.$$$reportNull$$$0(1);
        }
        if (connection == null) {
            CassDialect.$$$reportNull$$$0(2);
        }
        return StringUtil.isEmpty((String)(s = (String)JdbcNativeUtil.computeRemote(() -> connection.getRemoteConnection().getSchema()))) ? null : SearchPath.of((ObjectPath)ObjectPath.create((String)s, (ObjectKind)ObjectKind.SCHEMA));
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    @Override
    public DdlBuilder sqlCreateView(@NotNull DdlBuilder builder, @NotNull DasTable view, @NotNull String definition) {
        if (builder == null) {
            CassDialect.$$$reportNull$$$0(3);
        }
        if (view == null) {
            CassDialect.$$$reportNull$$$0(4);
        }
        if (definition == null) {
            CassDialect.$$$reportNull$$$0(5);
        }
        throw new UnsupportedOperationException(DatabaseBundle.message((String)"ddl.error.create.view", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropView(@NotNull DdlBuilder builder, @NotNull DasTable view, boolean cascade) {
        if (builder == null) {
            CassDialect.$$$reportNull$$$0(6);
        }
        if (view == null) {
            CassDialect.$$$reportNull$$$0(7);
        }
        throw new UnsupportedOperationException(DatabaseBundle.message((String)"ddl.error.drop.view", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    public boolean supportsTableDefinition() {
        return true;
    }

    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            CassDialect.$$$reportNull$$$0(8);
        }
        if (sequence == null) {
            CassDialect.$$$reportNull$$$0(9);
        }
        throw new UnsupportedOperationException(DatabaseBundle.message((String)"ddl.error.drop.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsViewDefinition() {
        return false;
    }

    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            CassDialect.$$$reportNull$$$0(10);
        }
        throw new UnsupportedOperationException();
    }

    public boolean supportsProcedureDefinition() {
        return false;
    }

    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            CassDialect.$$$reportNull$$$0(11);
        }
        throw new UnsupportedOperationException(DatabaseBundle.message((String)"ddl.error.procedure.definition", (Object[])new Object[]{this.getDisplayName()}));
    }

    @NotNull
    public DdlBuilder qualifiedIdentifier(@NotNull DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (builder == null) {
            CassDialect.$$$reportNull$$$0(12);
        }
        if (identifier == null) {
            CassDialect.$$$reportNull$$$0(13);
        }
        if (qualifier == null) {
            CassDialect.$$$reportNull$$$0(14);
        }
        DasObject db = CassDialect.getDB(qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, db, DasUtil.getName((DasObject)db), null, null, null, null);
        if (ddlBuilder == null) {
            CassDialect.$$$reportNull$$$0(15);
        }
        return ddlBuilder;
    }

    @Nullable
    private static DasObject getDB(@NotNull DasObject qualifier) {
        DasObject schema;
        if (qualifier == null) {
            CassDialect.$$$reportNull$$$0(16);
        }
        return (schema = DasUtil.getSchemaObject((DasObject)qualifier)) != null && !StringUtil.isEmpty((String)schema.getName()) ? schema : DasUtil.getCatalogObject((DasObject)qualifier);
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            CassDialect.$$$reportNull$$$0(17);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        String schema = this.getNamingService().nameToScript(current.getDisplayName(), current.kind, false, this.getCodeStyle().getQuotesPriority());
        return String.format("use %s", schema);
    }

    @Override
    public boolean supportsLoadDatabaseList() {
        return true;
    }

    @Override
    @NotNull
    public List<String> tryToLoadDatabaseList(@NotNull DatabaseConnection connection) throws Exception {
        RemoteDatabaseMetaData metaData;
        if (connection == null) {
            CassDialect.$$$reportNull$$$0(18);
        }
        if ((metaData = connection.getRemoteMetaData()) == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                CassDialect.$$$reportNull$$$0(19);
            }
            return list;
        }
        String query = connection.getVersion().isOrGreater(new int[]{3}) ? "select keyspace_name from system_schema.keyspaces" : "select keyspace_name from system.schema_keyspaces";
        List list = (List)DbImplUtil.executeAndGetResult((DatabaseConnection)connection, (String)query, (ThrowableConvertor)DbImplUtil.RS_AS_STRING_LIST);
        if (list == null) {
            CassDialect.$$$reportNull$$$0(20);
        }
        return list;
    }

    @Override
    @NotNull
    public String getBinaryLiteralString(byte @NotNull [] binaryData) {
        Charset charset;
        if (binaryData == null) {
            CassDialect.$$$reportNull$$$0(21);
        }
        String text = (charset = DbImplUtil.guessCharsetFromContent((byte[])binaryData)) == null ? null : DbImplUtil.validateDetectedString((String)CharsetToolkit.tryDecodeString((byte[])binaryData, (Charset)charset));
        String string = text != null ? "textAsBlob(" + DbImplUtil.StringLiteralDecorator.PLAIN.decorate(text, this.getDbms()) + ")" : "0x" + DialectUtils.toHexString((byte[])binaryData);
        if (string == null) {
            CassDialect.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    public JdbcHelper.LikeSupport getLikeSupport(@Nullable Version version) {
        JdbcHelper.LikeSupport likeSupport = version != null && version.isOrGreater(new int[]{3, 4}) ? JdbcHelper.LikeSupport.SELECTS_ONLY : JdbcHelper.LikeSupport.NONE;
        if (likeSupport == null) {
            CassDialect.$$$reportNull$$$0(23);
        }
        return likeSupport;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 21: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 21: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/cassandra/CassDialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 2: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/cassandra/CassDialect";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadDatabaseList";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryLiteralString";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getLikeSupport";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateView";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropView";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDB";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadDatabaseList";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryLiteralString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 21: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

