/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.cassandra;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.BooleanDomain;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.Number2Domain;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.util.Version;
import org.jetbrains.annotations.Nullable;

public class Cass21Domains
extends DomainRegistry {
    public Cass21Domains() {
        this.add((Domain)new TextDomain("ascii", ConversionPoint.TEXT, Integer.MAX_VALUE));
        this.add((Domain)new IntegerDomain("bigint", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add((Domain)new BinaryDomain("blob", ConversionPoint.BLOB, Integer.MAX_VALUE, Integer.MAX_VALUE, false, true));
        this.add((Domain)new BooleanDomain("boolean", ConversionPoint.BOOLEAN));
        this.add((Domain)new Number2Domain("decimal", ConversionPoint.BIG_DECIMAL, Integer.MAX_VALUE, Integer.MAX_VALUE, false));
        this.add((Domain)new FloatDomain("double", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
        this.add((Domain)new IntegerDomain("counter", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add((Domain)new FloatDomain("float", ConversionPoint.SINGLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
        this.add((Domain)new SimpleDomain("inet", ConversionPoint.INET, PhysicalDomainType.UNKNOWN));
        this.add((Domain)new IntegerDomain("int", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add((Domain)new TextDomain("text", ConversionPoint.TEXT, Integer.MAX_VALUE));
        this.add((Domain)new FractionDomain("timestamp", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, 6));
        this.add((Domain)new SimpleDomain("uuid", ConversionPoint.UUID, PhysicalDomainType.UNKNOWN));
        this.add((Domain)new SimpleDomain("timeuuid", ConversionPoint.UUID, PhysicalDomainType.UNKNOWN));
        this.add((Domain)new TextDomain("varchar", ConversionPoint.VARCHAR, Integer.MAX_VALUE, Integer.MAX_VALUE, false, true));
        this.add((Domain)new IntegerDomain("varint", ConversionPoint.BIG_DECIMAL, -9.223372036854776E18, 9.223372036854776E18));
    }

    public boolean isSuitable(@Nullable Version productVersion) {
        return productVersion == null || productVersion.less(new int[]{2, 2});
    }
}

