/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector.jdbc;

import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicTypedElement;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.JdbcUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdbcIntrospectorLegacyModelUtils {
    @Nullable
    public static Pair<String, Short> fixProcedureName(@Nullable String schema, @NotNull Dbms dbms, @Nullable String name2) {
        int tmpPos;
        int idx;
        if (dbms == null) {
            JdbcIntrospectorLegacyModelUtils.$$$reportNull$$$0(0);
        }
        short pos = 1;
        if ((dbms.isSybase() || dbms == Dbms.HIVE) && name2 != null && schema != null && JdbcIntrospectorLegacyModelUtils.startsWithQualifier(name2, schema)) {
            name2 = name2.substring(schema.length() + 1);
        }
        if (dbms.isTransactSql() && name2 != null && (idx = name2.indexOf(59)) > -1 && (tmpPos = StringUtil.parseInt((String)name2.substring(idx + 1), (int)-1)) >= 0) {
            name2 = name2.substring(0, idx);
            pos = (short)tmpPos;
        }
        return name2 == null ? null : Pair.create((Object)name2, (Object)pos);
    }

    public static boolean startsWithQualifier(@NotNull String name2, @NotNull String schema) {
        if (name2 == null) {
            JdbcIntrospectorLegacyModelUtils.$$$reportNull$$$0(1);
        }
        if (schema == null) {
            JdbcIntrospectorLegacyModelUtils.$$$reportNull$$$0(2);
        }
        return name2.startsWith(schema) && name2.length() > schema.length() + 1 && name2.charAt(schema.length()) == '.';
    }

    @Nullable
    public static String fixDefaultValue(@NotNull Dbms dbms, @NotNull BasicTypedElement column2, @Nullable String defaultValue) {
        int jdbc;
        if (dbms == null) {
            JdbcIntrospectorLegacyModelUtils.$$$reportNull$$$0(3);
        }
        if (column2 == null) {
            JdbcIntrospectorLegacyModelUtils.$$$reportNull$$$0(4);
        }
        if (dbms == Dbms.SNOWFLAKE) {
            defaultValue = StringUtil.nullize((String)defaultValue);
        }
        if (defaultValue == null) {
            return null;
        }
        int reportedJdbc = column2.getDataType().jdbcType;
        int n = jdbc = reportedJdbc == 1111 || reportedJdbc == 0 ? JdbcUtil.guessJdbcTypeByName((String)column2.getDataType().typeName) : reportedJdbc;
        if (jdbc == 1 || jdbc == 2005 || jdbc == 12 || jdbc == -15 || jdbc == 2011 || jdbc == -9 || jdbc == 91 || jdbc == 92 || jdbc == 93) {
            if (dbms.isOracle()) {
                return defaultValue;
            }
            if (dbms.isPostgres()) {
                int dotIndex = defaultValue.indexOf("::");
                if (dotIndex == -1) {
                    return defaultValue;
                }
                if (defaultValue.startsWith("('") && dotIndex > 4) {
                    return defaultValue;
                }
                if (defaultValue.startsWith("''") && defaultValue.endsWith("'")) {
                    return defaultValue.substring(1, dotIndex);
                }
                return defaultValue.substring(0, dotIndex);
            }
            if ((jdbc == 91 || jdbc == 92 || jdbc == 93) && defaultValue.length() > 0 && Character.isLetter(defaultValue.charAt(0))) {
                return defaultValue;
            }
            if (!StringUtil.startsWithChar((CharSequence)defaultValue, (char)'\'')) {
                return "'" + defaultValue + "'";
            }
        } else if (jdbc == -7) {
            if (defaultValue.contains("\u0000")) {
                return "0";
            }
            if (defaultValue.contains("\u0001")) {
                return "1";
            }
        }
        return defaultValue;
    }

    public static <T extends BasicModNamedElement> ModNamingFamily<T> familyOf(@Nullable BasicModElement element, @NotNull ObjectKind kind) {
        if (kind == null) {
            JdbcIntrospectorLegacyModelUtils.$$$reportNull$$$0(5);
        }
        return (ModNamingFamily)ObjectUtils.tryCast((Object)DbImplUtil.familyOf((BasicModElement)element, (ObjectKind)kind), ModNamingFamily.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/base/introspector/jdbc/JdbcIntrospectorLegacyModelUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fixProcedureName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "startsWithQualifier";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "fixDefaultValue";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "familyOf";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

