/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService;
import com.intellij.database.dialects.base.introspector.BaseIntroQueries;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseIntrospector$WhenMappings;
import com.intellij.database.dialects.base.introspector.DBFacadeProvider;
import com.intellij.database.dialects.base.introspector.IntrospectionKindMessagesI18n;
import com.intellij.database.dialects.base.introspector.IntrospectionQueryContext;
import com.intellij.database.dialects.base.introspector.IntrospectorSqlHelper;
import com.intellij.database.dialects.base.introspector.QueryStats;
import com.intellij.database.dialects.base.introspector.query.PreprocessedQuery;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.IntrospectionLogRecord;
import com.intellij.database.introspection.IntrospectionMode;
import com.intellij.database.layoutedQueries.DBFacade;
import com.intellij.database.layoutedQueries.DBSession;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.layoutedQueries.InSession;
import com.intellij.database.layoutedQueries.InSessionNoResult;
import com.intellij.database.layoutedQueries.InTransactionNoResult;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicModDatabase;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.remote.jdba.core.ConnectionInfo;
import com.intellij.database.remote.jdba.exceptions.DBException;
import com.intellij.database.remote.jdba.sql.SqlQuery;
import com.intellij.database.util.BooleanFunKt;
import com.intellij.database.util.Case;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.StringFun;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.Version;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PairConsumer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a4\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u000b\n\u0002\u0010%\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010!\n\u0002\b\u0005\b&\u0018\u0000 \u00de\u0001*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u00062\u00020\u00072\u00020\b:\b\u00db\u0001\u00dc\u0001\u00dd\u0001\u00de\u0001B\u001f\b\u0014\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010^\u001a\u00020_2\u0006\u0010`\u001a\u00020\u0015H\u0016J\u0018\u0010a\u001a\u0004\u0018\u00010-2\f\u0010b\u001a\b\u0012\u0004\u0012\u00020d0cH\u0016J\u001a\u0010e\u001a\u00020-2\u0006\u0010f\u001a\u00020-2\b\u0010g\u001a\u0004\u0018\u00010-H\u0002J\u001a\u0010h\u001a\u00020_2\f\u0010i\u001a\b\u0012\u0004\u0012\u00020_0jH\u0086\b\u00f8\u0001\u0000J;\u0010k\u001a \u0012\u0006\b\u0001\u0012\u00028\u00010lR\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00002\u0006\u0010m\u001a\u00020n2\u0006\u0010o\u001a\u00028\u0001H$\u00a2\u0006\u0002\u0010pJ;\u0010q\u001a \u0012\u0006\b\u0001\u0012\u00028\u00020rR\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00002\u0006\u0010m\u001a\u00020n2\u0006\u0010s\u001a\u00028\u0002H$\u00a2\u0006\u0002\u0010tJ\b\u0010u\u001a\u00020_H\u0016J\n\u0010v\u001a\u0004\u0018\u00010-H\u0016J\u001e\u0010w\u001a\u00020_2\u0006\u0010x\u001a\u00020-2\f\u0010y\u001a\b\u0012\u0004\u0012\u00020_0jH\u0004J\u001c\u0010z\u001a\u00020_2\u0012\u0010{\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020_0|H\u0004J\u0010\u0010}\u001a\u00020\u00112\u0006\u0010~\u001a\u00020dH\u0004J?\u0010\u007f\u001a\u0003H\u0080\u0001\"\u0005\b\u0003\u0010\u0080\u00012'\u0010\u0081\u0001\u001a\"\u0012\u0017\u0012\u00150\u0082\u0001\u00a2\u0006\u000f\b\u0083\u0001\u0012\n\b\u0084\u0001\u0012\u0005\b\b(\u0085\u0001\u0012\u0005\u0012\u0003H\u0080\u00010|H\u0004\u00a2\u0006\u0003\u0010\u0086\u0001J6\u0010\u007f\u001a\u00020_2&\u0010\u0081\u0001\u001a!\u0012\u0017\u0012\u00150\u0082\u0001\u00a2\u0006\u000f\b\u0083\u0001\u0012\n\b\u0084\u0001\u0012\u0005\b\b(\u0085\u0001\u0012\u0004\u0012\u00020_0|H\u0005\u00a2\u0006\u0003\b\u0087\u0001J?\u0010\u0088\u0001\u001a\u0003H\u0080\u0001\"\u0005\b\u0003\u0010\u0080\u00012&\u0010\u0081\u0001\u001a!\u0012\u0016\u0012\u00140n\u00a2\u0006\u000f\b\u0083\u0001\u0012\n\b\u0084\u0001\u0012\u0005\b\b(\u0089\u0001\u0012\u0005\u0012\u0003H\u0080\u00010|H\u0004\u00a2\u0006\u0003\u0010\u0086\u0001J6\u0010\u0088\u0001\u001a\u00020_2%\u0010\u0081\u0001\u001a \u0012\u0016\u0012\u00140n\u00a2\u0006\u000f\b\u0083\u0001\u0012\n\b\u0084\u0001\u0012\u0005\b\b(\u0089\u0001\u0012\u0004\u0012\u00020_0|H\u0005\u00a2\u0006\u0003\b\u008a\u0001JG\u0010\u0088\u0001\u001a\u0003H\u0080\u0001\"\u0005\b\u0003\u0010\u0080\u00012\u0006\u0010\u001d\u001a\u00020\u001e2&\u0010\u0081\u0001\u001a!\u0012\u0016\u0012\u00140n\u00a2\u0006\u000f\b\u0083\u0001\u0012\n\b\u0084\u0001\u0012\u0005\b\b(\u0089\u0001\u0012\u0005\u0012\u0003H\u0080\u00010|H\u0004\u00a2\u0006\u0003\u0010\u008b\u0001J\u0013\u0010\u008c\u0001\u001a\u00020@2\b\u0010C\u001a\u0004\u0018\u00010@H\u0016J\t\u0010\u008d\u0001\u001a\u00020_H\u0014J\t\u0010\u008e\u0001\u001a\u00020_H\u0014J'\u0010\u008f\u0001\u001a\u00020_2\u0016\u0010\u0090\u0001\u001a\f\u0012\u0007\b\u0001\u0012\u00030\u0092\u00010\u0091\u0001\"\u00030\u0092\u0001H\u0016\u00a2\u0006\u0003\u0010\u0093\u0001J%\u0010\u0094\u0001\u001a\u00020_2\u0007\u0010\u0089\u0001\u001a\u00020n2\u0011\u0010\u0090\u0001\u001a\f\u0012\u0005\u0012\u00030\u0092\u0001\u0018\u00010\u0095\u0001H$JA\u0010\u0096\u0001\u001a\u00020_2\b\u0010\u0097\u0001\u001a\u00030\u0092\u00012\u0007\u0010\u0098\u0001\u001a\u00020\u00112\u0007\u0010\u0099\u0001\u001a\u0002072\u0014\u0010\u009a\u0001\u001a\u000b\u0012\u0006\b\u0001\u0012\u00020-0\u0091\u0001\"\u00020-H\u0016\u00a2\u0006\u0003\u0010\u009b\u0001J\t\u0010\u009c\u0001\u001a\u00020_H\u0016J\u0012\u0010\u009d\u0001\u001a\u00020_2\u0007\u0010\u0089\u0001\u001a\u00020nH$J3\u0010\u009e\u0001\u001a\u0015\u0012\u0004\u0012\u00020d\u0012\u000b\u0012\t\u0012\u0004\u0012\u00020-0\u0091\u0001062\f\u0010b\u001a\b\u0012\u0004\u0012\u00020d0c2\u0007\u0010\u009f\u0001\u001a\u00020\u0011H\u0016J=\u0010\u009e\u0001\u001a\u00020_2\f\u0010b\u001a\b\u0012\u0004\u0012\u00020d0c2\u0007\u0010\u009f\u0001\u001a\u00020\u00112\u001b\u0010\u00a0\u0001\u001a\u0016\u0012\u0004\u0012\u00020d\u0012\u000b\u0012\t\u0012\u0004\u0012\u00020-0\u0091\u00010\u00a1\u0001H&J\t\u0010\u00a2\u0001\u001a\u00020_H\u0004J \u0010\u00a2\u0001\u001a\u00020_2\u0007\u0010\u00a3\u0001\u001a\u00028\u00002\u0006\u0010`\u001a\u00020\u0015H\u0014\u00a2\u0006\u0003\u0010\u00a4\u0001J\t\u0010\u00a5\u0001\u001a\u00020_H\u0016J\t\u0010\u00a6\u0001\u001a\u00020_H\u0016J\u0012\u0010\u00a6\u0001\u001a\u00020_2\u0007\u0010\u0089\u0001\u001a\u00020nH\u0014J\u0011\u0010\u00a7\u0001\u001a\u00020\u00112\u0006\u0010~\u001a\u00020dH\u0004J\u0018\u0010\u00a8\u0001\u001a\u00020_2\u0006\u0010g\u001a\u00020-2\u0007\u0010\u00a9\u0001\u001a\u00020.J\u000f\u0010\u00aa\u0001\u001a\u00020_2\u0006\u0010g\u001a\u00020-J\u0011\u0010\u00ab\u0001\u001a\u00020_2\u0006\u0010g\u001a\u00020-H\u0014J\u000f\u0010\u00ac\u0001\u001a\u00020_2\u0006\u0010g\u001a\u00020-J\u0018\u0010\u00ac\u0001\u001a\u00020_2\u0006\u0010g\u001a\u00020-2\u0007\u0010\u00a9\u0001\u001a\u00020.J\u0011\u0010\u00ad\u0001\u001a\u00020\u00112\u0006\u0010C\u001a\u00020@H\u0014J%\u0010\u00ae\u0001\u001a\u0005\u0018\u0001H\u0080\u0001\"\u0007\b\u0003\u0010\u0080\u0001\u0018\u00012\u0007\u0010\u00af\u0001\u001a\u00020-H\u0084\b\u00a2\u0006\u0003\u0010\u00b0\u0001J?\u0010\u00b1\u0001\u001a\u0002H\u0001\"\u0004\b\u0003\u0010\u00012\u000e\u0010\u00b2\u0001\u001a\t\u0012\u0004\u0012\u0002H\u00010\u00b3\u00012\u0018\b\u0002\u0010\u00b4\u0001\u001a\u0011\u0012\u0004\u0012\u00020-\u0012\u0005\u0012\u00030\u00b5\u0001\u0018\u000106H\u0004\u00a2\u0006\u0003\u0010\u00b6\u0001JI\u0010\u00b7\u0001\u001a\u00020_\"\u0005\b\u0003\u0010\u00b8\u00012\u0017\u0010\u00b2\u0001\u001a\u0012\u0012\r\b\u0001\u0012\t\u0012\u0005\u0012\u0003H\u00b8\u00010c0\u00b3\u00012\t\b\u0002\u0010\u00b9\u0001\u001a\u0002082\u0013\u0010i\u001a\u000f\u0012\u0005\u0012\u0003H\u00b8\u0001\u0012\u0004\u0012\u00020_0|H\u0004J\t\u0010\u00ba\u0001\u001a\u00020_H\u0004J\u0012\u0010\u00bb\u0001\u001a\u00020_2\u0007\u0010\u00a3\u0001\u001a\u00020\u0002H\u0004J=\u0010\u00bc\u0001\u001a\u00020_2\t\b\u0001\u0010\u00bd\u0001\u001a\u00020-2\t\b\u0001\u0010\u00be\u0001\u001a\u00020-2\u0016\u0010\u00bf\u0001\u001a\f\u0012\u0007\b\u0001\u0012\u00030\u00b5\u00010\u0091\u0001\"\u00030\u00b5\u0001H\u0004\u00a2\u0006\u0003\u0010\u00c0\u0001J\u0014\u0010\u00c1\u0001\u001a\u00020_2\t\b\u0001\u0010\u00c2\u0001\u001a\u00020-H\u0004J\"\u0010\u00c3\u0001\u001a\u00020_2\t\b\u0001\u0010\u00c4\u0001\u001a\u00020-2\f\b\u0002\u0010\u00c5\u0001\u001a\u0005\u0018\u00010\u00c6\u0001H\u0004J\u0014\u0010\u00c7\u0001\u001a\u00020_2\t\b\u0001\u0010\u00c4\u0001\u001a\u00020-H\u0004J\u0012\u0010\u00c8\u0001\u001a\u00020_2\u0007\u0010\u00c9\u0001\u001a\u000207H\u0004J\u001f\u0010\u00c8\u0001\u001a\u00020_2\t\b\u0001\u0010\u00bd\u0001\u001a\u00020-2\t\b\u0001\u0010\u00be\u0001\u001a\u00020-H\u0004J=\u0010\u00c8\u0001\u001a\u00020_2\t\b\u0001\u0010\u00bd\u0001\u001a\u00020-2\t\b\u0001\u0010\u00be\u0001\u001a\u00020-2\u0016\u0010\u00bf\u0001\u001a\f\u0012\u0007\b\u0001\u0012\u00030\u00b5\u00010\u0091\u0001\"\u00030\u00b5\u0001H\u0004\u00a2\u0006\u0003\u0010\u00c0\u0001J\u001f\u0010\u00ca\u0001\u001a\u00020_2\t\b\u0001\u0010\u00bd\u0001\u001a\u00020-2\t\b\u0001\u0010\u00cb\u0001\u001a\u00020-H\u0002J\u001f\u0010\u00cc\u0001\u001a\u00020_2\t\b\u0001\u0010\u00ab\u0001\u001a\u00020-2\t\b\u0001\u0010\u00cd\u0001\u001a\u00020-H\u0004J#\u0010\u00ce\u0001\u001a\u000e\u0012\u0004\u0012\u00020d\u0012\u0004\u0012\u00020\u0011062\f\u0010b\u001a\b\u0012\u0004\u0012\u00020d0cH\u0016J\u001e\u0010\u00cf\u0001\u001a\u00020_2\u000f\b\u0004\u0010\u00d0\u0001\u001a\b\u0012\u0004\u0012\u00020-0jH\u0084\b\u00f8\u0001\u0000J\u0011\u0010\u00cf\u0001\u001a\u00020_2\u0006\u0010g\u001a\u00020-H\u0004J\u001d\u0010\u00d1\u0001\u001a\u00020_2\t\b\u0001\u0010\u00d2\u0001\u001a\u00020-2\u0007\u0010\u00d3\u0001\u001a\u00020-H\u0005J\u001e\u0010\u00d4\u0001\u001a\u00020_2\u000f\b\u0004\u0010\u00d5\u0001\u001a\b\u0012\u0004\u0012\u00020_0jH\u0084\b\u00f8\u0001\u0000J\r\u0010\u00d6\u0001\u001a\u00020-*\u00020-H\u0004JE\u0010\u00d7\u0001\u001a\n\u0012\u0005\u0012\u0003H\u0080\u00010\u0091\u0001\"\u0005\b\u0003\u0010\u0080\u0001*\n\u0012\u0005\u0012\u0003H\u0080\u00010\u0091\u00012\u0015\u0010\u00d8\u0001\u001a\u0010\u0012\u0005\u0012\u0003H\u0080\u0001\u0012\u0005\u0012\u0003H\u0080\u00010|H\u0084\b\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00d9\u0001J?\u0010\u00d7\u0001\u001a\n\u0012\u0005\u0012\u0003H\u0080\u00010\u00da\u0001\"\u0005\b\u0003\u0010\u0080\u0001*\n\u0012\u0005\u0012\u0003H\u0080\u00010\u00da\u00012\u0015\u0010\u00d8\u0001\u001a\u0010\u0012\u0005\u0012\u0003H\u0080\u0001\u0012\u0005\u0012\u0003H\u0080\u00010|H\u0084\b\u00f8\u0001\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\"\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001e\u0010(\u001a\u00020'2\u0006\u0010\u0014\u001a\u00020'@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R&\u0010+\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020.0,X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u0014\u00103\u001a\u00020\u00118DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u0013R \u00105\u001a\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020806X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u0014\u0010;\u001a\u000208X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=R\u001c\u0010>\u001a\n\u0012\u0006\b\u0001\u0012\u00020@0?X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010BR\u0014\u0010C\u001a\u00020@8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bD\u0010ER\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010GR\"\u0010H\u001a\u0004\u0018\u00010@2\b\u0010\u0014\u001a\u0004\u0018\u00010@@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010ER\u001a\u0010J\u001a\u00020KX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010M\"\u0004\bN\u0010OR\u001c\u0010P\u001a\u0004\u0018\u00010QX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bR\u0010S\"\u0004\bT\u0010UR\u0014\u0010\u000b\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bV\u0010WR\u001e\u0010X\u001a\u00020'2\u0006\u0010\u0014\u001a\u00020'@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bY\u0010*R\u0014\u0010Z\u001a\u00020[X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\\\u0010]\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u00df\u0001"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseIntrospector;", "R", "Lcom/intellij/database/model/basic/BasicModRoot;", "D", "Lcom/intellij/database/model/basic/BasicModDatabase;", "S", "Lcom/intellij/database/model/basic/BasicModSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseIntroQueries;", "Lcom/intellij/database/introspection/DBIntrospector;", "dbms", "Lcom/intellij/database/Dbms;", "project", "Lcom/intellij/openapi/project/Project;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "(Lcom/intellij/database/Dbms;Lcom/intellij/openapi/project/Project;Lcom/intellij/database/model/ModelFactory;)V", "considerSystemSchemasReinstrospection", "", "getConsiderSystemSchemasReinstrospection", "()Z", "<set-?>", "Lcom/intellij/database/dataSource/DatabaseConnection;", "dbConnection", "getDbConnection", "()Lcom/intellij/database/dataSource/DatabaseConnection;", "dbConnectionInfo", "Lcom/intellij/database/remote/jdba/core/ConnectionInfo;", "getDbConnectionInfo", "()Lcom/intellij/database/remote/jdba/core/ConnectionInfo;", "dbFacade", "Lcom/intellij/database/layoutedQueries/DBFacade;", "dbLogger", "Ljava/util/logging/Logger;", "getDbLogger", "()Ljava/util/logging/Logger;", "setDbLogger", "(Ljava/util/logging/Logger;)V", "getDbms", "()Lcom/intellij/database/Dbms;", "Lcom/intellij/database/util/Version;", "driverVersion", "getDriverVersion", "()Lcom/intellij/database/util/Version;", "errorSink", "Lcom/intellij/util/PairConsumer;", "", "", "getErrorSink", "()Lcom/intellij/util/PairConsumer;", "setErrorSink", "(Lcom/intellij/util/PairConsumer;)V", "initialized", "getInitialized", "introspectorKindVersions", "", "Lcom/intellij/database/model/ObjectKind;", "", "getIntrospectorKindVersions", "()Ljava/util/Map;", "introspectorVersion", "getIntrospectorVersion", "()I", "modModelClass", "Ljava/lang/Class;", "Lcom/intellij/database/model/basic/BasicModModel;", "getModModelClass", "()Ljava/lang/Class;", "model", "getModel", "()Lcom/intellij/database/model/basic/BasicModModel;", "getModelFactory", "()Lcom/intellij/database/model/ModelFactory;", "myModel", "getMyModel", "options", "Lcom/intellij/database/introspection/DBIntrospectionOptions;", "getOptions", "()Lcom/intellij/database/introspection/DBIntrospectionOptions;", "setOptions", "(Lcom/intellij/database/introspection/DBIntrospectionOptions;)V", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getProgressIndicator", "()Lcom/intellij/openapi/progress/ProgressIndicator;", "setProgressIndicator", "(Lcom/intellij/openapi/progress/ProgressIndicator;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "serverVersion", "getServerVersion", "sqlHelper", "Lcom/intellij/database/dialects/base/introspector/IntrospectorSqlHelper;", "getSqlHelper", "()Lcom/intellij/database/dialects/base/introspector/IntrospectorSqlHelper;", "attachToDB", "", "connection", "collectDiagnosticInfo", "elements", "", "Lcom/intellij/database/model/basic/BasicElement;", "concatErrorContextPrefixWithMessage", "prefix", "message", "continueOnDbError", "action", "Lkotlin/Function0;", "createDatabaseRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$AbstractDatabaseRetriever;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModDatabase;)Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$AbstractDatabaseRetriever;", "createSchemaRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$AbstractSchemaRetriever;", "schema", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModSchema;)Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$AbstractSchemaRetriever;", "detachFromDB", "getCurrentDatabase", "handleErrors", "operationName", "operation", "inModel", "modifier", "Lkotlin/Function1;", "inScope", "e", "inSession", "T", "block", "Lcom/intellij/database/layoutedQueries/DBSession;", "Lkotlin/ParameterName;", "name", "session", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "inSessionUnit", "inTransaction", "tran", "inTransactionUnit", "(Lcom/intellij/database/layoutedQueries/DBFacade;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "init", "initConnectionRelatedState", "initModelRelatedState", "introspectAuto", "namespaces", "", "Lcom/intellij/database/model/basic/BasicNamespace;", "([Lcom/intellij/database/model/basic/BasicNamespace;)V", "introspectAutoInTran", "", "introspectFragment", "namespace", "withSources", "objectKind", "objectNames", "(Lcom/intellij/database/model/basic/BasicNamespace;ZLcom/intellij/database/model/ObjectKind;[Ljava/lang/String;)V", "introspectNamespaces", "introspectNamespacesInTran", "introspectNativeDefinitions", "withNestedElements", "result", "", "introspectServerInfo", "root", "(Lcom/intellij/database/model/basic/BasicModRoot;Lcom/intellij/database/dataSource/DatabaseConnection;)V", "introspectServerObjects", "introspectSessionState", "isIntrospected", "logError", "exception", "logInfo", "logMessage", "logWarn", "modelCanBeAccepted", "parseStatement", "src", "(Ljava/lang/String;)Ljava/lang/Object;", "performQuery", "query", "Lcom/intellij/database/remote/jdba/sql/SqlQuery;", "namedParameters", "", "(Lcom/intellij/database/remote/jdba/sql/SqlQuery;Ljava/util/Map;)Ljava/lang/Object;", "performQueryHandleEachRow", "X", "packSize", "postIntrospectionProcess", "postIntrospectionProcessWithModel", "reportIntrospecting", "logWhat", "progressWhatKey", "params", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)V", "reportIntrospectingDatabase", "databaseName", "reportIntrospectingSchema", "schemaName", "mode", "Lcom/intellij/database/introspection/IntrospectionMode;", "reportIntrospectingSchemaUsingJdbc", "reportRetrieving", "kind", "reportRetrievingInt", "progressWhat", "reportStatusDetails", "statusDetailKey", "retrieveInvalid", "trace", "messageProducer", "updateStatus", "status", "details", "writeSources", "r", "dbIntern", "inplace", "t", "([Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)[Ljava/lang/Object;", "", "AbstractDatabaseRetriever", "AbstractRetriever", "AbstractSchemaRetriever", "Companion", "intellij.database.dialects.base"})
public abstract class BaseIntrospector<R extends BasicModRoot, D extends BasicModDatabase, S extends BasicModSchema>
extends BaseIntroQueries
implements DBIntrospector {
    @NotNull
    private final Dbms dbms;
    private final int introspectorVersion;
    @NotNull
    private final Map<ObjectKind, Integer> introspectorKindVersions;
    @NotNull
    private final Project project;
    @NotNull
    private final ModelFactory modelFactory;
    @NotNull
    private final Class<? extends BasicModModel> modModelClass;
    @Nullable
    private BasicModModel myModel;
    @NotNull
    private DBIntrospectionOptions options;
    private final boolean considerSystemSchemasReinstrospection;
    @Nullable
    private ProgressIndicator progressIndicator;
    @Nullable
    private DatabaseConnection dbConnection;
    private DBFacade dbFacade;
    @NotNull
    private Version serverVersion;
    @NotNull
    private Version driverVersion;
    @NotNull
    private final IntrospectorSqlHelper sqlHelper;
    @NotNull
    private PairConsumer<String, Throwable> errorSink;
    @Nullable
    private java.util.logging.Logger dbLogger;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Dbms getDbms() {
        return this.dbms;
    }

    protected int getIntrospectorVersion() {
        return this.introspectorVersion;
    }

    @NotNull
    protected Map<ObjectKind, Integer> getIntrospectorKindVersions() {
        return this.introspectorKindVersions;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final ModelFactory getModelFactory() {
        return this.modelFactory;
    }

    @NotNull
    protected final Class<? extends BasicModModel> getModModelClass() {
        return this.modModelClass;
    }

    @Nullable
    public final BasicModModel getMyModel() {
        return this.myModel;
    }

    @NotNull
    public final DBIntrospectionOptions getOptions() {
        return this.options;
    }

    public final void setOptions(@NotNull DBIntrospectionOptions dBIntrospectionOptions) {
        Intrinsics.checkNotNullParameter((Object)dBIntrospectionOptions, (String)"<set-?>");
        this.options = dBIntrospectionOptions;
    }

    protected final boolean getConsiderSystemSchemasReinstrospection() {
        return this.considerSystemSchemasReinstrospection;
    }

    @Nullable
    public final ProgressIndicator getProgressIndicator() {
        return this.progressIndicator;
    }

    public final void setProgressIndicator(@Nullable ProgressIndicator progressIndicator) {
        this.progressIndicator = progressIndicator;
    }

    @Nullable
    public final DatabaseConnection getDbConnection() {
        return this.dbConnection;
    }

    @NotNull
    public final Version getServerVersion() {
        return this.serverVersion;
    }

    @NotNull
    public final Version getDriverVersion() {
        return this.driverVersion;
    }

    protected final boolean getInitialized() {
        return this.myModel != null && this.dbConnection != null;
    }

    @NotNull
    protected final IntrospectorSqlHelper getSqlHelper() {
        return this.sqlHelper;
    }

    @NotNull
    public PairConsumer<String, Throwable> getErrorSink() {
        return this.errorSink;
    }

    public void setErrorSink(@NotNull PairConsumer<String, Throwable> pairConsumer) {
        Intrinsics.checkNotNullParameter(pairConsumer, (String)"<set-?>");
        this.errorSink = pairConsumer;
    }

    @Nullable
    protected final java.util.logging.Logger getDbLogger() {
        return this.dbLogger;
    }

    protected final void setDbLogger(@Nullable java.util.logging.Logger logger) {
        this.dbLogger = logger;
    }

    @NotNull
    public BasicModModel init(@Nullable BasicModModel model) {
        if (this.myModel != null) {
            throw (Throwable)new IllegalStateException(this.getClass().getSimpleName() + " is already initialized");
        }
        this.myModel = model != null && this.modelCanBeAccepted(model) ? model : this.modelFactory.createModel(this.dbms, this.modModelClass);
        this.initModelRelatedState();
        BasicModModel basicModModel = this.myModel;
        Intrinsics.checkNotNull((Object)basicModModel);
        return basicModModel;
    }

    protected boolean modelCanBeAccepted(@NotNull BasicModModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return this.modModelClass.isAssignableFrom(model.getClass());
    }

    protected void initModelRelatedState() {
    }

    protected void initConnectionRelatedState() {
        DatabaseConnection databaseConnection = this.dbConnection;
        boolean bl = Intrinsics.areEqual((Object)this.dbms, (Object)(databaseConnection != null ? databaseConnection.getDbms() : null));
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            DatabaseConnection databaseConnection2 = this.dbConnection;
            String string = "Introspector for " + this.dbms.getDisplayName() + ", but connection for " + (databaseConnection2 != null ? databaseConnection2.getDbms() : null);
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    @NotNull
    public BasicModModel getModel() {
        if (this.myModel == null) {
            throw (Throwable)new IllegalStateException("The introspector is not initialized yet: model is not created");
        }
        BasicModModel basicModModel = this.myModel;
        Intrinsics.checkNotNull((Object)basicModModel);
        return basicModModel;
    }

    public void attachToDB(@NotNull DatabaseConnection connection) {
        DBFacade db;
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        boolean bl = Intrinsics.areEqual((Object)this.dbms, (Object)connection.getDbms());
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-BaseIntrospector$attachToDB$22 = false;
            String $i$a$-assert-BaseIntrospector$attachToDB$22 = this.getClass().getSimpleName() + " expects a connection to " + this.dbms + " but got to " + connection.getDbms() + " that is not good";
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-BaseIntrospector$attachToDB$22));
        }
        if (this.dbConnection != null) {
            this.detachFromDB();
        }
        this.dbConnection = connection;
        this.dbLogger = DatabaseGlobalAuditService.Companion.logger(this.project, connection);
        this.setStatistics(new QueryStats(null, 1, null));
        this.dbFacade = db = DBFacadeProvider.createFacadeWithSingleLeasedConnection(connection);
        Version version = connection.getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)version, (String)"connection.version");
        this.serverVersion = version;
        int[] nArray = db.getConnectionInfo().driverVersion.toArray();
        Version version2 = Version.of((int[])Arrays.copyOf(nArray, nArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)version2, (String)"Version.of(*db.connectio\u2026.driverVersion.toArray())");
        this.driverVersion = version2;
        BaseIntrospector this_$iv = this;
        boolean $i$f$trace = false;
        if (this_$iv.dbLogger != null) {
            BaseIntrospector baseIntrospector = this_$iv;
            boolean bl3 = false;
            String doubleLine = StringFun.replicate$default((String)"=", (int)40, null, null, (int)6, null);
            StringBuilder stringBuilder = new StringBuilder().append("|\n         |").append(doubleLine).append("  Introspection  ").append(doubleLine).append("\n         |Product:              ");
            ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
            String string = StringsKt.trimMargin$default((String)stringBuilder.append(applicationInfo.getFullApplicationName()).append("\n         |Introspector version: ").append(this.getIntrospectorVersion()).append("\n         |DBMS:                 ").append(this.getDbms().getDisplayName()).append("\n         |Server version:       ").append(this.getServerVersion()).append("\n         |Driver version:       ").append(this.getDriverVersion()).append("\n         |\n      ").toString(), null, (int)1, null);
            baseIntrospector.trace(string);
        }
        this.initConnectionRelatedState();
    }

    public void detachFromDB() {
        this.dbConnection = null;
        DBFacade dBFacade = this.dbFacade;
        if (dBFacade != null) {
            dBFacade.detachFromDB();
        }
        this.dbFacade = null;
        QueryStats stats = this.getStatistics();
        if (stats != null) {
            this.trace(stats.getSortedText());
            this.setStatistics(null);
        }
        this.dbLogger = null;
        Version version = Version.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)version, (String)"Version.ZERO");
        this.serverVersion = version;
        Version version2 = Version.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)version2, (String)"Version.ZERO");
        this.driverVersion = version2;
    }

    @NotNull
    protected final ConnectionInfo getDbConnectionInfo() {
        DBFacade dBFacade = this.dbFacade;
        if (dBFacade == null) {
            throw (Throwable)new IllegalStateException("Not attached to DB facade");
        }
        DBFacade dbf = dBFacade;
        ConnectionInfo connectionInfo = dbf.getConnectionInfo();
        Intrinsics.checkNotNullExpressionValue((Object)connectionInfo, (String)"dbf.connectionInfo");
        return connectionInfo;
    }

    protected final <T> T inSession(@NotNull Function1<? super DBSession, ? extends T> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        DBFacade dBFacade = this.dbFacade;
        if (dBFacade == null) {
            throw (Throwable)new IllegalStateException("Not attached to DB facade");
        }
        DBFacade dbf = dBFacade;
        Object result2 = dbf.inSession(new InSession<T>(block){
            final /* synthetic */ Function1 $block;

            public final T run(@NotNull DBSession session) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                return (T)this.$block.invoke((Object)session);
            }
            {
                this.$block = function1;
            }
        });
        return (T)result2;
    }

    @JvmName(name="inSessionUnit")
    protected final void inSessionUnit(@NotNull Function1<? super DBSession, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        DBFacade dBFacade = this.dbFacade;
        if (dBFacade == null) {
            throw (Throwable)new IllegalStateException("Not attached to DB facade");
        }
        DBFacade dbf = dBFacade;
        dbf.inSession(new InSessionNoResult(block){
            final /* synthetic */ Function1 $block;

            public final void run(@NotNull DBSession session) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                this.$block.invoke((Object)session);
            }
            {
                this.$block = function1;
            }
        });
    }

    protected final <T> T inTransaction(@NotNull Function1<? super DBTransaction, ? extends T> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        DBFacade dBFacade = this.dbFacade;
        if (dBFacade == null) {
            throw (Throwable)new IllegalStateException("Not attached to DB facade");
        }
        DBFacade dbf = dBFacade;
        return this.inTransaction(dbf, block);
    }

    @JvmName(name="inTransactionUnit")
    protected final void inTransactionUnit(@NotNull Function1<? super DBTransaction, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        DBFacade dBFacade = this.dbFacade;
        if (dBFacade == null) {
            throw (Throwable)new IllegalStateException("Not attached to DB facade");
        }
        DBFacade dbf = dBFacade;
        this.inTransaction(dbf, block);
    }

    protected final <T> T inTransaction(@NotNull DBFacade dbFacade, @NotNull Function1<? super DBTransaction, ? extends T> block) {
        Intrinsics.checkNotNullParameter((Object)dbFacade, (String)"dbFacade");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        return (T)dbFacade.inSession(new InSession<T>(block){
            final /* synthetic */ Function1 $block;

            public final T run(@NotNull DBSession session) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                return (T)this.$block.invoke((Object)session);
            }
            {
                this.$block = function1;
            }
        });
    }

    protected final <R> R performQuery(@NotNull SqlQuery<R> query, @Nullable Map<String, ? extends Object> namedParameters) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        PreprocessedQuery pq = IntrospectionQueryContext.preprocessQuery$default(this, query, namedParameters, null, 4, null);
        return (R)this.inTransaction((Function1)new Function1<DBTransaction, R>(this, pq){
            final /* synthetic */ BaseIntrospector this$0;
            final /* synthetic */ PreprocessedQuery $pq;

            public final R invoke(@NotNull DBTransaction transaction) {
                Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
                SqlQuery<X> sqlQuery = this.$pq.query;
                Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"pq.query");
                return (R)this.this$0.runQuery(transaction, sqlQuery, this.$pq.bindableParameters);
            }
            {
                this.this$0 = baseIntrospector;
                this.$pq = preprocessedQuery;
                super(1);
            }
        });
    }

    public static /* synthetic */ Object performQuery$default(BaseIntrospector baseIntrospector, SqlQuery sqlQuery, Map map2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: performQuery");
        }
        if ((n & 2) != 0) {
            map2 = null;
        }
        return baseIntrospector.performQuery(sqlQuery, map2);
    }

    protected final <X> void performQueryHandleEachRow(@NotNull SqlQuery<? extends Iterable<? extends X>> query, int packSize, @NotNull Function1<? super X, Unit> action) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        PreprocessedQuery pq = IntrospectionQueryContext.preprocessQuery$default(this, query, null, null, 6, null);
        this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)new Function1<DBTransaction, Unit>(this, pq, packSize, action){
            final /* synthetic */ BaseIntrospector this$0;
            final /* synthetic */ PreprocessedQuery $pq;
            final /* synthetic */ int $packSize;
            final /* synthetic */ Function1 $action;

            public final void invoke(@NotNull DBTransaction transaction) {
                Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
                SqlQuery<X> sqlQuery = this.$pq.query;
                Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"pq.query");
                this.this$0.runQueryHandleEachRow(transaction, sqlQuery, this.$pq.bindableParameters, this.$packSize, null, null, this.$action);
            }
            {
                this.this$0 = baseIntrospector;
                this.$pq = preprocessedQuery;
                this.$packSize = n;
                this.$action = function1;
                super(1);
            }
        }));
    }

    public static /* synthetic */ void performQueryHandleEachRow$default(BaseIntrospector baseIntrospector, SqlQuery sqlQuery, int n, Function1 function1, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: performQueryHandleEachRow");
        }
        if ((n2 & 2) != 0) {
            n = 4096;
        }
        baseIntrospector.performQueryHandleEachRow(sqlQuery, n, function1);
    }

    @Nullable
    protected final /* synthetic */ <T> T parseStatement(@NotNull String src2) {
        int $i$f$parseStatement = 0;
        Intrinsics.checkNotNullParameter((Object)src2, (String)"src");
        try {
            IntrospectorSqlHelper this_$iv = this.sqlHelper;
            boolean $i$f$statements = false;
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            return (T)this_$iv.statements(src2, Object.class).first();
        }
        catch (ProcessCanceledException pce) {
            throw (Throwable)pce;
        }
        catch (Exception e2) {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            if (application.isUnitTestMode()) {
                this.log.error((Throwable)e2);
            }
            this.log.warn("Failed to parse sources", (Throwable)e2);
            return null;
        }
    }

    protected final void introspectServerInfo() {
        if (!this.getInitialized()) {
            throw (Throwable)new IllegalStateException("Introspector is not initialized yet.");
        }
        DatabaseConnection databaseConnection = this.dbConnection;
        if (databaseConnection == null) {
            throw (Throwable)new IllegalStateException("Database is not attached yet.");
        }
        DatabaseConnection dbConnection = databaseConnection;
        this.inModel((Function1)new Function1<R, Unit>(this, dbConnection){
            final /* synthetic */ BaseIntrospector this$0;
            final /* synthetic */ DatabaseConnection $dbConnection;

            public final void invoke(@NotNull R root2) {
                Intrinsics.checkNotNullParameter(root2, (String)"root");
                this.this$0.introspectServerInfo(root2, this.$dbConnection);
            }
            {
                this.this$0 = baseIntrospector;
                this.$dbConnection = databaseConnection;
                super(1);
            }
        });
    }

    protected void introspectServerInfo(@NotNull R root2, @NotNull DatabaseConnection connection) {
        Intrinsics.checkNotNullParameter(root2, (String)"root");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        root2.setDbms(connection.getDbms());
        root2.setServerVersion(connection.getVersion());
    }

    public void introspectAuto(BasicNamespace ... namespaces) {
        Intrinsics.checkNotNullParameter((Object)namespaces, (String)"namespaces");
        this.introspectServerInfo();
        int n = namespaces.length;
        ArrayList<BasicNamespace> theNamespaces = new ArrayList<BasicNamespace>(n);
        if (n > 0) {
            for (BasicNamespace ns : namespaces) {
                boolean bl = this.getModel().contains((DasObject)ns);
                boolean bl2 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string = "Namespaces must be from this model";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                theNamespaces.add(ns);
            }
        }
        this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)new Function1<DBTransaction, Unit>(this, theNamespaces){
            final /* synthetic */ BaseIntrospector this$0;
            final /* synthetic */ ArrayList $theNamespaces;

            public final void invoke(@NotNull DBTransaction tran) {
                Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
                this.this$0.introspectAutoInTran(tran, this.$theNamespaces);
            }
            {
                this.this$0 = baseIntrospector;
                this.$theNamespaces = arrayList;
                super(1);
            }
        }));
    }

    protected abstract void introspectAutoInTran(@NotNull DBTransaction var1, @Nullable Collection<? extends BasicNamespace> var2);

    public void introspectNamespaces() {
        this.introspectServerInfo();
        this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)new Function1<DBTransaction, Unit>(this){
            final /* synthetic */ BaseIntrospector this$0;

            public final void invoke(@NotNull DBTransaction it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.introspectNamespacesInTran(it);
            }
            {
                this.this$0 = baseIntrospector;
                super(1);
            }
        }));
    }

    protected abstract void introspectNamespacesInTran(@NotNull DBTransaction var1);

    public void introspectSessionState() {
        this.introspectServerInfo();
        this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)new Function1<DBTransaction, Unit>(this){
            final /* synthetic */ BaseIntrospector this$0;

            public final void invoke(@NotNull DBTransaction it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.introspectSessionState(it);
            }
            {
                this.this$0 = baseIntrospector;
                super(1);
            }
        }));
    }

    protected void introspectSessionState(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
    }

    public void introspectServerObjects() {
    }

    public void introspectFragment(@NotNull BasicNamespace namespace, boolean withSources, @NotNull ObjectKind objectKind, String ... objectNames) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)objectKind, (String)"objectKind");
        Intrinsics.checkNotNullParameter((Object)objectNames, (String)"objectNames");
    }

    @NotNull
    public Map<BasicElement, String[]> introspectNativeDefinitions(@NotNull Iterable<? extends BasicElement> elements2, boolean withNestedElements) {
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        Map result2 = new LinkedHashMap();
        this.introspectNativeDefinitions(elements2, withNestedElements, result2);
        return result2;
    }

    public abstract void introspectNativeDefinitions(@NotNull Iterable<? extends BasicElement> var1, boolean var2, @NotNull Map<BasicElement, String[]> var3);

    @NotNull
    protected abstract AbstractDatabaseRetriever<? extends D> createDatabaseRetriever(@NotNull DBTransaction var1, @NotNull D var2);

    @NotNull
    protected abstract AbstractSchemaRetriever<? extends S> createSchemaRetriever(@NotNull DBTransaction var1, @NotNull S var2);

    protected final void postIntrospectionProcess() {
        this.getModel().modify(BasicModRoot.class, (ModelModifier)new ModelModifier<BasicModRoot>(this){
            final /* synthetic */ BaseIntrospector this$0;

            public final void perform(BasicModRoot r) {
                BasicModRoot basicModRoot = r;
                Intrinsics.checkNotNullExpressionValue((Object)basicModRoot, (String)"r");
                this.this$0.postIntrospectionProcessWithModel(basicModRoot);
            }
            {
                this.this$0 = baseIntrospector;
            }
        });
    }

    protected final void postIntrospectionProcessWithModel(@NotNull BasicModRoot root2) {
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        Iterator iterator = root2.getAllSchemas().iterator();
        while (iterator.hasNext()) {
            BasicModSchema schema;
            BasicModSchema basicModSchema = schema = (BasicModSchema)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)basicModSchema, (String)"schema");
            BaseIntrospectionFunctions.derefAll(basicModSchema);
        }
    }

    protected final void writeSources(@NotNull Function0<Unit> r) {
        int $i$f$writeSources = 0;
        Intrinsics.checkNotNullParameter(r, (String)"r");
        this.getModel().writeSources(new Runnable(r){
            final /* synthetic */ Function0 $r;

            public final void run() {
                this.$r.invoke();
            }
            {
                this.$r = function0;
            }
        });
    }

    @Nullable
    public String getCurrentDatabase() {
        return this.getDbConnectionInfo().databaseName;
    }

    @Nullable
    public String collectDiagnosticInfo(@NotNull Iterable<? extends BasicElement> elements2) {
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        return this.getClass().getSimpleName();
    }

    protected final void handleErrors(@NotNull String operationName, @NotNull Function0<Unit> operation2) {
        Intrinsics.checkNotNullParameter((Object)operationName, (String)"operationName");
        Intrinsics.checkNotNullParameter(operation2, (String)"operation");
        try {
            operation2.invoke();
        }
        catch (InterruptedException ie) {
            throw (Throwable)ie;
        }
        catch (ProcessCanceledException pce) {
            throw (Throwable)pce;
        }
        catch (DBException d) {
            String prefix = "Error encountered when performing " + operationName;
            String message2 = this.concatErrorContextPrefixWithMessage(prefix, d.getMessage());
            this.logWarn(message2, d);
            this.getErrorSink().consume((Object)message2, (Object)d);
        }
        catch (NullPointerException npe) {
            String message3 = "NPE encountered when performing " + operationName;
            this.logError(message3, npe);
            this.getErrorSink().consume((Object)message3, (Object)npe);
        }
        catch (Exception e2) {
            String prefix = "Unexpected error (" + e2.getClass().getSimpleName() + ") encountered when performing " + operationName;
            String message4 = this.concatErrorContextPrefixWithMessage(prefix, e2.getMessage());
            this.logError(message4, e2);
            this.getErrorSink().consume((Object)message4, (Object)e2);
        }
    }

    private final String concatErrorContextPrefixWithMessage(String prefix, String message2) {
        return message2 == null ? prefix : (StringsKt.contains$default((CharSequence)message2, (char)'\n', (boolean)false, (int)2, null) ? prefix + ":\n" + message2 : prefix + ": " + message2);
    }

    @NotNull
    public Map<BasicElement, Boolean> retrieveInvalid(@NotNull Iterable<? extends BasicElement> elements2) {
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        Map<BasicElement, Boolean> map2 = Collections.emptyMap();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"Collections.emptyMap()");
        return map2;
    }

    protected final void inModel(@NotNull Function1<? super R, Unit> modifier) {
        Intrinsics.checkNotNullParameter(modifier, (String)"modifier");
        this.getModel().modify(BasicModRoot.class, (ModelModifier)new ModelModifier<BasicModRoot>(modifier){
            final /* synthetic */ Function1 $modifier;

            public final void perform(BasicModRoot root2) {
                BasicModRoot basicModRoot = root2;
                if (basicModRoot == null) {
                    throw new NullPointerException("null cannot be cast to non-null type R");
                }
                this.$modifier.invoke((Object)basicModRoot);
            }
            {
                this.$modifier = function1;
            }
        });
    }

    protected final void reportIntrospectingDatabase(@NlsSafe @NotNull String databaseName) {
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        String logMessage = "Introspecting database " + databaseName;
        this.log.debug(logMessage);
        ProgressIndicator progressIndicator = this.progressIndicator;
        if (progressIndicator == null) {
            return;
        }
        ProgressIndicator pi = progressIndicator;
        pi.checkCanceled();
        pi.setText(DatabaseBundle.message((String)"introspector.progress.status.database", (Object[])new Object[]{databaseName}));
        pi.setText2("");
    }

    protected final void reportIntrospectingSchema(@NlsSafe @NotNull String schemaName, @Nullable IntrospectionMode mode) {
        String string;
        Intrinsics.checkNotNullParameter((Object)schemaName, (String)"schemaName");
        String logMessage = "Introspecting schema " + schemaName;
        if (mode != null) {
            logMessage = logMessage + " in mode " + mode.code;
        }
        this.log.debug(logMessage);
        ProgressIndicator progressIndicator = this.progressIndicator;
        if (progressIndicator == null) {
            return;
        }
        ProgressIndicator pi = progressIndicator;
        pi.checkCanceled();
        IntrospectionMode introspectionMode = mode;
        if (introspectionMode == null) {
            string = DatabaseBundle.message((String)"introspector.progress.status.main.plain", (Object[])new Object[]{schemaName});
        } else {
            switch (BaseIntrospector$WhenMappings.$EnumSwitchMapping$0[introspectionMode.ordinal()]) {
                case 1: {
                    string = DatabaseBundle.message((String)"introspector.progress.status.main.full", (Object[])new Object[]{schemaName});
                    break;
                }
                case 2: {
                    string = DatabaseBundle.message((String)"introspector.progress.status.main.inc", (Object[])new Object[]{schemaName});
                    break;
                }
                case 3: {
                    string = DatabaseBundle.message((String)"introspector.progress.status.main.frag", (Object[])new Object[]{schemaName});
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        pi.setText(string);
        pi.setText2("");
    }

    public static /* synthetic */ void reportIntrospectingSchema$default(BaseIntrospector baseIntrospector, String string, IntrospectionMode introspectionMode, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reportIntrospectingSchema");
        }
        if ((n & 2) != 0) {
            introspectionMode = null;
        }
        baseIntrospector.reportIntrospectingSchema(string, introspectionMode);
    }

    protected final void reportIntrospectingSchemaUsingJdbc(@NlsSafe @NotNull String schemaName) {
        Intrinsics.checkNotNullParameter((Object)schemaName, (String)"schemaName");
        String logMessage = "Introspecting schema " + schemaName + " using JDBC metadata";
        this.log.debug(logMessage);
        ProgressIndicator progressIndicator = this.progressIndicator;
        if (progressIndicator == null) {
            return;
        }
        ProgressIndicator pi = progressIndicator;
        pi.checkCanceled();
        pi.setText(DatabaseBundle.message((String)"introspector.progress.status.main.jdbc", (Object[])new Object[]{schemaName}));
        pi.setText2("");
    }

    protected final void reportIntrospecting(@NonNls @NotNull String logWhat, @NonNls @PropertyKey(resourceBundle="messages.DatabaseBundle") @NotNull String progressWhatKey, Object ... params) {
        Intrinsics.checkNotNullParameter((Object)logWhat, (String)"logWhat");
        Intrinsics.checkNotNullParameter((Object)progressWhatKey, (String)"progressWhatKey");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        String logMessage = "Introspecting " + logWhat;
        this.log.debug(logMessage);
        ProgressIndicator progressIndicator = this.progressIndicator;
        if (progressIndicator == null) {
            return;
        }
        ProgressIndicator pi = progressIndicator;
        pi.checkCanceled();
        pi.setText(DatabaseBundle.message((String)progressWhatKey, (Object[])new Object[]{params}));
        pi.setText2("");
    }

    protected final void reportRetrieving(@NotNull ObjectKind kind) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        String string = kind.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kind.name()");
        String string2 = string;
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.ENGLISH");
        Locale locale2 = locale;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
        String string5 = StringUtil.pluralize((String)string4);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"StringUtil.pluralize(kin\u2026owerCase(Locale.ENGLISH))");
        String logWhat = string5;
        String progressWhat = IntrospectionKindMessagesI18n.INSTANCE.messageRetrieveObjects(kind);
        this.reportRetrievingInt(logWhat, progressWhat);
    }

    protected final void reportRetrieving(@NlsSafe @NotNull String logWhat, @NonNls @PropertyKey(resourceBundle="messages.DatabaseBundle") @NotNull String progressWhatKey) {
        Intrinsics.checkNotNullParameter((Object)logWhat, (String)"logWhat");
        Intrinsics.checkNotNullParameter((Object)progressWhatKey, (String)"progressWhatKey");
        String string = DatabaseBundle.message((String)progressWhatKey, (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(progressWhatKey)");
        String progressWhat = string;
        this.reportRetrievingInt(logWhat, progressWhat);
    }

    protected final void reportRetrieving(@NlsSafe @NotNull String logWhat, @NonNls @PropertyKey(resourceBundle="messages.DatabaseBundle") @NotNull String progressWhatKey, Object ... params) {
        Intrinsics.checkNotNullParameter((Object)logWhat, (String)"logWhat");
        Intrinsics.checkNotNullParameter((Object)progressWhatKey, (String)"progressWhatKey");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        String string = DatabaseBundle.message((String)progressWhatKey, (Object[])Arrays.copyOf(params, params.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(progressWhatKey, *params)");
        String progressWhat = string;
        this.reportRetrievingInt(logWhat, progressWhat);
    }

    private final void reportRetrievingInt(@NlsSafe String logWhat, @Nls String progressWhat) {
        String logMessage = "Retrieving " + logWhat;
        this.trace(logMessage);
        ProgressIndicator progressIndicator = this.progressIndicator;
        if (progressIndicator == null) {
            return;
        }
        ProgressIndicator pi = progressIndicator;
        pi.checkCanceled();
        pi.setText2(progressWhat);
    }

    protected final void reportStatusDetails(@NonNls @NotNull String logMessage, @NonNls @PropertyKey(resourceBundle="messages.DatabaseBundle") @NotNull String statusDetailKey) {
        Intrinsics.checkNotNullParameter((Object)logMessage, (String)"logMessage");
        Intrinsics.checkNotNullParameter((Object)statusDetailKey, (String)"statusDetailKey");
        this.trace(logMessage);
        ProgressIndicator progressIndicator = this.progressIndicator;
        if (progressIndicator == null) {
            return;
        }
        ProgressIndicator pi = progressIndicator;
        pi.checkCanceled();
        pi.setText2(DatabaseBundle.message((String)statusDetailKey, (Object[])new Object[0]));
    }

    @Deprecated(message="Use NLS-friendly methods like 'reportIntrospecting*' and 'reportRetrieving*'")
    protected final void updateStatus(@Nls @NotNull String status, @NotNull String details) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            Intrinsics.checkNotNullParameter((Object)details, (String)"details");
            this.trace("Working on: " + status + " (" + details + ')');
            ProgressIndicator progressIndicator = this.progressIndicator;
            if (progressIndicator != null) {
                progressIndicator.checkCanceled();
            }
            ProgressIndicator progressIndicator2 = this.progressIndicator;
            if (progressIndicator2 != null) {
                progressIndicator2.setText(status);
            }
            ProgressIndicator progressIndicator3 = this.progressIndicator;
            if (progressIndicator3 == null) break block2;
            progressIndicator3.setText2(StringUtil.capitalize((String)Case.LOWER.apply(details)));
        }
    }

    public final void continueOnDbError(@NotNull Function0<Unit> action) {
        int $i$f$continueOnDbError = 0;
        Intrinsics.checkNotNullParameter(action, (String)"action");
        try {
            action.invoke();
        }
        catch (DBException e2) {
            this.getErrorSink().consume(null, (Object)e2);
        }
    }

    @NotNull
    protected final String dbIntern(@NotNull String $this$dbIntern) {
        Intrinsics.checkNotNullParameter((Object)$this$dbIntern, (String)"$this$dbIntern");
        String string = DbUtil.intern((String)$this$dbIntern);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DbUtil.intern(this)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final <T> T[] inplace(@NotNull T[] $this$inplace, @NotNull Function1<? super T, ? extends T> t) {
        int $i$f$inplace = 0;
        Intrinsics.checkNotNullParameter($this$inplace, (String)"$this$inplace");
        Intrinsics.checkNotNullParameter(t, (String)"t");
        T[] TArray = $this$inplace;
        boolean bl = false;
        boolean bl2 = false;
        T[] $this$apply = TArray;
        boolean bl3 = false;
        T[] $this$forEachIndexed$iv = $this$apply;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (T item$iv : $this$forEachIndexed$iv) {
            void s;
            int n = index$iv++;
            T t2 = item$iv;
            int i2 = n;
            boolean bl4 = false;
            $this$apply[i2] = t.invoke((Object)s);
        }
        return TArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final <T> List<T> inplace(@NotNull List<T> $this$inplace, @NotNull Function1<? super T, ? extends T> t) {
        int $i$f$inplace = 0;
        Intrinsics.checkNotNullParameter($this$inplace, (String)"$this$inplace");
        Intrinsics.checkNotNullParameter(t, (String)"t");
        List<T> list = $this$inplace;
        boolean bl = false;
        boolean bl2 = false;
        List<T> $this$apply = list;
        boolean bl3 = false;
        Iterable $this$forEachIndexed$iv = $this$apply;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void s;
            int n = index$iv++;
            boolean bl4 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t2 = item$iv;
            int i2 = n;
            boolean bl5 = false;
            $this$apply.set(i2, t.invoke((Object)s));
        }
        return list;
    }

    protected final boolean inScope(@NotNull BasicElement e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        return DataSourceSchemaMapping.matches((TreePattern)this.options.getScope(), (DasObject)((DasObject)e2));
    }

    protected final boolean isIntrospected(@NotNull BasicElement e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        return this.inScope(e2) || this.options.getScope().isEmpty() && DataSourceSchemaMapping.matches((TreePattern)this.getDefaultScope(), (DasObject)((DasObject)e2));
    }

    public final void logInfo(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.trace(message2);
        this.log.info(message2);
    }

    public final void logWarn(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.trace(message2);
        this.log.warn(message2);
    }

    public final void logWarn(@NotNull String message2, @NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        this.trace(message2);
        this.log.warn(message2, exception);
    }

    public final void logError(@NotNull String message2, @NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        this.trace(message2);
        this.log.error(message2, exception);
    }

    @Override
    protected void logMessage(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.trace(message2);
    }

    protected final void trace(@NotNull Function0<String> messageProducer) {
        int $i$f$trace = 0;
        Intrinsics.checkNotNullParameter(messageProducer, (String)"messageProducer");
        if (this.dbLogger != null) {
            this.trace((String)messageProducer.invoke());
        }
    }

    protected final void trace(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        java.util.logging.Logger logger = this.dbLogger;
        if (logger != null) {
            Level level = Level.FINE;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"Level.FINE");
            IntrospectionLogRecord record = new IntrospectionLogRecord(level, message2);
            logger.log((LogRecord)record);
        }
    }

    protected BaseIntrospector(@NotNull Dbms dbms, @NotNull Project project, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        this.introspectorKindVersions = MapsKt.emptyMap();
        this.options = BaseIntrospectionFunctions.DEFAULT_OPTIONS;
        Version version = Version.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)version, (String)"Version.ZERO");
        this.serverVersion = version;
        Version version2 = Version.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)version2, (String)"Version.ZERO");
        this.driverVersion = version2;
        this.errorSink = errorSink.1.INSTANCE;
        this.dbms = dbms;
        this.project = project;
        this.modelFactory = modelFactory;
        ModelFacade modelFacade = ModelFacade.forDbms((Dbms)dbms);
        Intrinsics.checkNotNullExpressionValue((Object)modelFacade, (String)"ModelFacade.forDbms(dbms)");
        Class clazz = modelFacade.getMetaModel().apiClass;
        Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"ModelFacade.forDbms(dbms).metaModel.apiClass");
        this.modModelClass = clazz;
        this.considerSystemSchemasReinstrospection = BaseIntrospectionFunctions.stringToBoolean(System.getProperty("dbe.always.reintrospect.system.schemas"));
        this.sqlHelper = new IntrospectorSqlHelper(project, dbms);
    }

    public static final /* synthetic */ Version access$getServerVersion$p(BaseIntrospector $this) {
        return $this.serverVersion;
    }

    public static final /* synthetic */ void access$setServerVersion$p(BaseIntrospector $this, Version version) {
        $this.serverVersion = version;
    }

    public static final /* synthetic */ Version access$getDriverVersion$p(BaseIntrospector $this) {
        return $this.driverVersion;
    }

    public static final /* synthetic */ void access$setDriverVersion$p(BaseIntrospector $this, Version version) {
        $this.driverVersion = version;
    }

    public static final /* synthetic */ void access$setDbLogger$p(BaseIntrospector $this, java.util.logging.Logger logger) {
        $this.dbLogger = logger;
    }

    @JvmStatic
    @Deprecated(message="Don't use this function", replaceWith=@ReplaceWith(imports={}, expression="p.log"))
    @ApiStatus.Internal
    @NotNull
    public static final /* synthetic */ Logger access$getLog$p(@NotNull BaseIntrospector<?, ?, ?> p) {
        return Companion.access$getLog$p(p);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00a4\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J!\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0003\u0010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000eH\u0004\u00a2\u0006\u0002\u0010\u000fJK\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0003\u0010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000e2\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00112\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0015\"\u00020\u0013H\u0004\u00a2\u0006\u0002\u0010\u0016JL\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00190\u0018\"\u0004\b\u0003\u0010\u00192\u0014\u0010\r\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u00190\u001a0\u000e2\u0016\b\u0002\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00112\b\b\u0002\u0010\u001b\u001a\u00020\u001cH\u0014JB\u0010\u001d\u001a\u00020\u001e\"\u0004\b\u0003\u0010\f2\u0014\u0010\r\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\f0\u001a0\u000e2\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u00020\u001e0 H\u0004J/\u0010!\u001a\u0004\u0018\u0001H\f\"\b\b\u0003\u0010\f*\u00020\u00132\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000e2\u0006\u0010\"\u001a\u00020\u0012H\u0004\u00a2\u0006\u0002\u0010#J2\u0010$\u001a\b\u0012\u0004\u0012\u0002H\u00190\u0018\"\u0004\b\u0003\u0010\u00192\u0014\u0010\r\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u00190\u001a0\u000e2\u0006\u0010\"\u001a\u00020\u0012H\u0004J\b\u0010%\u001a\u00020\u001eH&R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006&"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$AbstractRetriever;", "Lcom/intellij/database/dialects/base/introspector/IntrospectionQueryContext;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "(Lcom/intellij/database/dialects/base/introspector/BaseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;)V", "model", "Lcom/intellij/database/model/basic/BasicModModel;", "getModel", "()Lcom/intellij/database/model/basic/BasicModModel;", "getTransaction", "()Lcom/intellij/database/layoutedQueries/DBTransaction;", "performQuery", "X", "query", "Lcom/intellij/database/remote/jdba/sql/SqlQuery;", "(Lcom/intellij/database/remote/jdba/sql/SqlQuery;)Ljava/lang/Object;", "namedParameters", "", "", "", "freeParameters", "", "(Lcom/intellij/database/remote/jdba/sql/SqlQuery;Ljava/util/Map;[Ljava/lang/Object;)Ljava/lang/Object;", "performQueryForList", "", "R", "", "packSize", "", "performQueryHandleEachRow", "", "action", "Lkotlin/Function1;", "performQuerySafe", "introspectionScopeRemark", "(Lcom/intellij/database/remote/jdba/sql/SqlQuery;Ljava/lang/String;)Ljava/lang/Object;", "performQuerySafeList", "process", "intellij.database.dialects.base"})
    protected abstract class AbstractRetriever
    extends IntrospectionQueryContext {
        @NotNull
        private final BasicModModel model;
        @NotNull
        private final DBTransaction transaction;

        @NotNull
        protected final BasicModModel getModel() {
            return this.model;
        }

        public abstract void process();

        protected final <X> X performQuery(@NotNull SqlQuery<X> query) {
            Intrinsics.checkNotNullParameter(query, (String)"query");
            return this.performQuery(this.transaction, query);
        }

        protected final <X> X performQuery(@NotNull SqlQuery<X> query, @Nullable Map<String, ? extends Object> namedParameters, Object ... freeParameters) {
            Intrinsics.checkNotNullParameter(query, (String)"query");
            Intrinsics.checkNotNullParameter((Object)freeParameters, (String)"freeParameters");
            return this.performQuery(this.transaction, query, namedParameters, Arrays.copyOf(freeParameters, freeParameters.length));
        }

        @NotNull
        protected <R> List<R> performQueryForList(@NotNull SqlQuery<? extends Iterable<? extends R>> query, @Nullable Map<String, ? extends Object> namedParameters, int packSize) {
            Intrinsics.checkNotNullParameter(query, (String)"query");
            return this.performQueryForList(this.transaction, query, namedParameters, packSize);
        }

        public static /* synthetic */ List performQueryForList$default(AbstractRetriever abstractRetriever, SqlQuery sqlQuery, Map map2, int n, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: performQueryForList");
            }
            if ((n2 & 2) != 0) {
                map2 = null;
            }
            if ((n2 & 4) != 0) {
                n = 4096;
            }
            return abstractRetriever.performQueryForList(sqlQuery, map2, n);
        }

        protected final <X> void performQueryHandleEachRow(@NotNull SqlQuery<? extends Iterable<? extends X>> query, int packSize, @NotNull Function1<? super X, Unit> action) {
            Intrinsics.checkNotNullParameter(query, (String)"query");
            Intrinsics.checkNotNullParameter(action, (String)"action");
            this.performQueryHandleEachRow(this.transaction, query, packSize, action);
        }

        public static /* synthetic */ void performQueryHandleEachRow$default(AbstractRetriever abstractRetriever, SqlQuery sqlQuery, int n, Function1 function1, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: performQueryHandleEachRow");
            }
            if ((n2 & 2) != 0) {
                n = 1000;
            }
            abstractRetriever.performQueryHandleEachRow(sqlQuery, n, function1);
        }

        @Nullable
        protected final <X> X performQuerySafe(@NotNull SqlQuery<X> query, @NotNull String introspectionScopeRemark) {
            Intrinsics.checkNotNullParameter(query, (String)"query");
            Intrinsics.checkNotNullParameter((Object)introspectionScopeRemark, (String)"introspectionScopeRemark");
            try {
                return this.performQuery(query);
            }
            catch (DBException e2) {
                this.log.error("Error occurred when introspected " + introspectionScopeRemark + ", query " + query.getDisplayName() + ":\n" + e2.getMessage() + "\nSQL statement:\n" + e2.statementText);
                return null;
            }
        }

        @NotNull
        protected final <R> List<R> performQuerySafeList(@NotNull SqlQuery<? extends Iterable<? extends R>> query, @NotNull String introspectionScopeRemark) {
            Intrinsics.checkNotNullParameter(query, (String)"query");
            Intrinsics.checkNotNullParameter((Object)introspectionScopeRemark, (String)"introspectionScopeRemark");
            try {
                return AbstractRetriever.performQueryForList$default(this, query, null, 0, 6, null);
            }
            catch (DBException e2) {
                this.log.error("Error occurred when introspected " + introspectionScopeRemark + ", query " + query.getDisplayName() + ":\n" + e2.getMessage() + "\nSQL statement:\n" + e2.statementText);
                return CollectionsKt.emptyList();
            }
        }

        @NotNull
        protected final DBTransaction getTransaction() {
            return this.transaction;
        }

        public AbstractRetriever(DBTransaction transaction) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            super(BaseIntrospector.this, null, 2, null);
            this.transaction = transaction;
            this.model = BaseIntrospector.this.getModel();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00a4\u0004\u0018\u0000*\b\b\u0003\u0010\u0001*\u00020\u00022\u00180\u0003R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004B\u0017\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0003\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0014J\u001c\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00020\u00110\u0013H\u0004J8\u0010\u0014\u001a\u00020\u00112\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u0018H\u0016J0\u0010\u0014\u001a\u00020\u00112\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u0018H\u0014J8\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u0018H\u0014J\b\u0010\u001e\u001a\u00020\u0011H\u0016J\b\u0010\u001f\u001a\u00020\u0011H\u0016R\u0016\u0010\u0007\u001a\u00028\u0003X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006 "}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$AbstractDatabaseRetriever;", "D", "Lcom/intellij/database/model/basic/BasicModDatabase;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$AbstractRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "(Lcom/intellij/database/dialects/base/introspector/BaseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModDatabase;)V", "getDatabase", "()Lcom/intellij/database/model/basic/BasicModDatabase;", "Lcom/intellij/database/model/basic/BasicModDatabase;", "expandElementsBeforeRetrievingNativeDefinitions", "", "Lcom/intellij/database/model/basic/BasicElement;", "elements", "inDatabase", "", "modifier", "Lkotlin/Function1;", "retrieveNativeDefinitions", "withNestedElements", "", "result", "", "", "", "retrieveNativeDefinitionsFor", "kind", "Lcom/intellij/database/model/ObjectKind;", "retrieveObjects", "retrieveSchemas", "intellij.database.dialects.base"})
    protected static abstract class AbstractDatabaseRetriever<D extends BasicModDatabase>
    extends AbstractRetriever {
        @NotNull
        private final D database;
        final /* synthetic */ BaseIntrospector this$0;

        public void retrieveSchemas() {
        }

        public void retrieveObjects() {
        }

        protected final void inDatabase(@NotNull Function1<? super D, Unit> modifier) {
            Intrinsics.checkNotNullParameter(modifier, (String)"modifier");
            this.getModel().modify((BasicElement)this.database, BasicModDatabase.class, (ModelModifier)new ModelModifier<BasicModDatabase>(modifier){
                final /* synthetic */ Function1 $modifier;

                public final void perform(BasicModDatabase it) {
                    BasicModDatabase basicModDatabase = it;
                    if (basicModDatabase == null) {
                        throw new NullPointerException("null cannot be cast to non-null type D");
                    }
                    this.$modifier.invoke((Object)basicModDatabase);
                }
                {
                    this.$modifier = function1;
                }
            });
        }

        public void retrieveNativeDefinitions(@NotNull Iterable<? extends BasicElement> elements2, boolean withNestedElements, @NotNull Map<BasicElement, String[]> result2) {
            Intrinsics.checkNotNullParameter(elements2, (String)"elements");
            Intrinsics.checkNotNullParameter(result2, (String)"result");
            Iterable<? extends BasicElement> elementsToProcess = withNestedElements ? this.expandElementsBeforeRetrievingNativeDefinitions(elements2) : elements2;
            this.retrieveNativeDefinitions(elementsToProcess, result2);
        }

        @NotNull
        protected Iterable<BasicElement> expandElementsBeforeRetrievingNativeDefinitions(@NotNull Iterable<? extends BasicElement> elements2) {
            Intrinsics.checkNotNullParameter(elements2, (String)"elements");
            return CollectionsKt.toList(elements2);
        }

        /*
         * WARNING - void declaration
         */
        protected void retrieveNativeDefinitions(@NotNull Iterable<? extends BasicElement> elements2, @NotNull Map<BasicElement, String[]> result2) {
            Map groups;
            Map $this$groupByTo$iv$iv;
            Intrinsics.checkNotNullParameter(elements2, (String)"elements");
            Intrinsics.checkNotNullParameter(result2, (String)"result");
            Iterable<? extends BasicElement> $this$groupBy$iv = elements2;
            boolean $i$f$groupBy = false;
            Iterable<? extends BasicElement> iterable = $this$groupBy$iv;
            Map destination$iv$iv22 = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            Iterator iterator = $this$groupByTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object object;
                Object element$iv$iv = iterator.next();
                BasicElement it = (BasicElement)element$iv$iv;
                boolean bl = false;
                ObjectKind key$iv$iv = it.getKind();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv22;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            $this$groupByTo$iv$iv = groups = destination$iv$iv22;
            boolean destination$iv$iv22 = false;
            Iterator iterator2 = $this$groupByTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                void kind;
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator2.next();
                boolean bl = false;
                $this$groupByTo$iv$iv = (ObjectKind)entry2.getKey();
                entry2 = entry;
                bl = false;
                List kindElements = (List)entry2.getValue();
                void v1 = kind;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"kind");
                this.retrieveNativeDefinitionsFor((ObjectKind)v1, kindElements, result2);
            }
        }

        protected void retrieveNativeDefinitionsFor(@NotNull ObjectKind kind, @NotNull Iterable<? extends BasicElement> elements2, @NotNull Map<BasicElement, String[]> result2) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Intrinsics.checkNotNullParameter(elements2, (String)"elements");
            Intrinsics.checkNotNullParameter(result2, (String)"result");
        }

        @NotNull
        protected final D getDatabase() {
            return this.database;
        }

        protected AbstractDatabaseRetriever(@NotNull DBTransaction transaction, D database) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter(database, (String)"database");
            this.this$0 = this$0;
            super(transaction);
            this.database = database;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001c\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00a4\u0004\u0018\u0000*\b\b\u0003\u0010\u0001*\u00020\u00022\u00180\u0003R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004B\u0017\b\u0014\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0003\u00a2\u0006\u0002\u0010\bB!\b\u0014\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\b\u00104\u001a\u000205H\u0014J\b\u00106\u001a\u000205H\u0014J\u0016\u00107\u001a\b\u0012\u0004\u0012\u00020\r0(2\u0006\u00108\u001a\u000209H\u0002J\b\u0010:\u001a\u000205H\u0014J\b\u0010;\u001a\u000205H\u0014J\b\u0010<\u001a\u00020=H\u0014J\u001c\u0010>\u001a\u0002052\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u0002050@H\u0004J\u001d\u0010A\u001a\u00020/2\u0006\u0010B\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u0003H\u0014\u00a2\u0006\u0002\u0010CJ'\u0010D\u001a\u0004\u0018\u0001HE\"\b\b\u0004\u0010E*\u00020F2\f\u0010G\u001a\b\u0012\u0004\u0012\u0002HE0HH\u0004\u00a2\u0006\u0002\u0010IJ*\u0010J\u001a\b\u0012\u0004\u0012\u0002HL0K\"\u0004\b\u0004\u0010L2\u0014\u0010G\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002HL0M0HH\u0004J\b\u0010N\u001a\u000205H\u0014J\b\u0010O\u001a\u000205H\u0016J\u0006\u0010P\u001a\u000205J\u0006\u0010Q\u001a\u000205J\b\u0010R\u001a\u000205H\u0014J\b\u0010S\u001a\u000205H\u0014J\u0015\u0010T\u001a\u00020/2\u0006\u0010\u0007\u001a\u00028\u0003H\u0014\u00a2\u0006\u0002\u0010UJ\u0010\u0010V\u001a\u0002052\u0006\u0010W\u001a\u00020XH\u0005J\u0010\u0010V\u001a\u0002052\u0006\u0010Y\u001a\u00020ZH\u0015R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R$\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0019\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001d\"\u0004\b\"\u0010\u001fR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020\r0(X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0013\u0010\u0007\u001a\u00028\u0003\u00a2\u0006\n\n\u0002\u0010-\u001a\u0004\b+\u0010,R\u001a\u0010.\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103\u00a8\u0006["}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$AbstractSchemaRetriever;", "S", "Lcom/intellij/database/model/basic/BasicModSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$AbstractRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "(Lcom/intellij/database/dialects/base/introspector/BaseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModSchema;)V", "mode", "Lcom/intellij/database/introspection/IntrospectionMode;", "(Lcom/intellij/database/dialects/base/introspector/BaseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModSchema;Lcom/intellij/database/introspection/IntrospectionMode;)V", "fragmentKind", "Lcom/intellij/database/model/ObjectKind;", "getFragmentKind", "()Lcom/intellij/database/model/ObjectKind;", "setFragmentKind", "(Lcom/intellij/database/model/ObjectKind;)V", "fragmentNames", "", "", "getFragmentNames", "()[Ljava/lang/String;", "setFragmentNames", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "fromTimestamp", "Ljava/sql/Timestamp;", "getFromTimestamp", "()Ljava/sql/Timestamp;", "setFromTimestamp", "(Ljava/sql/Timestamp;)V", "introspectionBeginTimestamp", "getIntrospectionBeginTimestamp", "setIntrospectionBeginTimestamp", "getMode", "()Lcom/intellij/database/introspection/IntrospectionMode;", "setMode", "(Lcom/intellij/database/introspection/IntrospectionMode;)V", "outdatedKinds", "", "getOutdatedKinds", "()Ljava/util/Set;", "getSchema", "()Lcom/intellij/database/model/basic/BasicModSchema;", "Lcom/intellij/database/model/basic/BasicModSchema;", "withSources", "", "getWithSources", "()Z", "setWithSources", "(Z)V", "analyzeBriefInfo", "", "analyzeCurrentContent", "checkOutdatedKinds", "existentVersion", "", "clearSchema", "finishSchema", "getSchemaStateNumber", "", "inSchema", "modifier", "Lkotlin/Function1;", "isPossibleToIntrospectSchemaIncrementally", "tran", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModSchema;)Z", "performQuerySafe", "X", "", "query", "Lcom/intellij/database/remote/jdba/sql/SqlQuery;", "(Lcom/intellij/database/remote/jdba/sql/SqlQuery;)Ljava/lang/Object;", "performQuerySafeList", "", "R", "", "prepareParameters", "process", "processMainPhase", "processPreliminaryPhase", "retrieveMainContent", "retrieveMajorNames", "whetherSourcesActual", "(Lcom/intellij/database/model/basic/BasicModSchema;)Z", "work", "block", "Lcom/intellij/database/layoutedQueries/InTransactionNoResult;", "runnable", "Ljava/lang/Runnable;", "intellij.database.dialects.base"})
    protected abstract class AbstractSchemaRetriever<S extends BasicModSchema>
    extends AbstractRetriever {
        @NotNull
        private final S schema;
        @NotNull
        private IntrospectionMode mode;
        private boolean withSources;
        @NotNull
        private ObjectKind fragmentKind;
        @NotNull
        private String[] fragmentNames;
        @NotNull
        private Timestamp fromTimestamp;
        @Nullable
        private Timestamp introspectionBeginTimestamp;
        @NotNull
        private final Set<ObjectKind> outdatedKinds;
        final /* synthetic */ BaseIntrospector this$0;

        @NotNull
        public final S getSchema() {
            return this.schema;
        }

        @NotNull
        public final IntrospectionMode getMode() {
            return this.mode;
        }

        public final void setMode(@NotNull IntrospectionMode introspectionMode) {
            Intrinsics.checkNotNullParameter((Object)introspectionMode, (String)"<set-?>");
            this.mode = introspectionMode;
        }

        public final boolean getWithSources() {
            return this.withSources;
        }

        public final void setWithSources(boolean bl) {
            this.withSources = bl;
        }

        @NotNull
        public final ObjectKind getFragmentKind() {
            return this.fragmentKind;
        }

        public final void setFragmentKind(@NotNull ObjectKind objectKind) {
            Intrinsics.checkNotNullParameter((Object)objectKind, (String)"<set-?>");
            this.fragmentKind = objectKind;
        }

        @NotNull
        public final String[] getFragmentNames() {
            return this.fragmentNames;
        }

        public final void setFragmentNames(@NotNull String[] stringArray) {
            Intrinsics.checkNotNullParameter((Object)stringArray, (String)"<set-?>");
            this.fragmentNames = stringArray;
        }

        @NotNull
        public final Timestamp getFromTimestamp() {
            return this.fromTimestamp;
        }

        public final void setFromTimestamp(@NotNull Timestamp timestamp) {
            Intrinsics.checkNotNullParameter((Object)timestamp, (String)"<set-?>");
            this.fromTimestamp = timestamp;
        }

        @Nullable
        public final Timestamp getIntrospectionBeginTimestamp() {
            return this.introspectionBeginTimestamp;
        }

        public final void setIntrospectionBeginTimestamp(@Nullable Timestamp timestamp) {
            this.introspectionBeginTimestamp = timestamp;
        }

        @NotNull
        protected final Set<ObjectKind> getOutdatedKinds() {
            return this.outdatedKinds;
        }

        /*
         * WARNING - void declaration
         */
        private final Set<ObjectKind> checkOutdatedKinds(int existentVersion) {
            ObjectKind kindVersions = this.this$0.getIntrospectorKindVersions();
            if (kindVersions.isEmpty()) {
                return SetsKt.emptySet();
            }
            TreeSet kinds = new TreeSet();
            ObjectKind objectKind = kindVersions;
            boolean bl = false;
            for (Map.Entry<ObjectKind, Integer> entry : objectKind.entrySet()) {
                void k;
                Object object = entry;
                boolean bl2 = false;
                objectKind = object.getKey();
                object = entry;
                bl2 = false;
                int v2 = ((Number)object.getValue()).intValue();
                if (Intrinsics.areEqual((Object)k, (Object)ObjectKind.NONE) || existentVersion >= v2) continue;
                object = kinds;
                bl2 = false;
                object.add(k);
            }
            return kinds;
        }

        protected boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull S schema) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            return schema.getIntrospectionTimestamp() != null && (this.this$0.getOptions().getSources() == DBIntrospectionOptions.SourceLoading.NO_SOURCES || this.whetherSourcesActual(schema));
        }

        protected boolean whetherSourcesActual(@NotNull S schema) {
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            Date date = schema.getIntrospectionTimestamp();
            return Intrinsics.areEqual((Object)this.getModel().getSchemaSourcesVersion((BasicSchema)schema), (Object)(date != null ? Long.valueOf(date.getTime()) : null));
        }

        protected void prepareParameters() {
            BaseIntrospectionFunctions.setupModeParameters(this.mode, this.getParametersMap());
            this.setQueryParameter("SCHEMA_NAME", this.schema.getRealName());
            this.setQueryParameter("SCHEMA_ID", this.schema instanceof BasicIdentifiedElement && ((BasicIdentifiedElement)this.schema).getObjectId() != Long.MIN_VALUE ? Long.valueOf(((BasicIdentifiedElement)this.schema).getObjectId()) : null);
            this.setQueryParameter("SINCE", this.fromTimestamp);
        }

        protected final void inSchema(@NotNull Function1<? super S, Unit> modifier) {
            Intrinsics.checkNotNullParameter(modifier, (String)"modifier");
            this.getModel().modify((BasicElement)this.schema, this.schema.getMetaObject().apiClass, new ModelModifier(modifier){
                final /* synthetic */ Function1 $modifier;

                public final void perform(BasicElement schema) {
                    BasicElement basicElement = schema;
                    if (basicElement == null) {
                        throw new NullPointerException("null cannot be cast to non-null type S");
                    }
                    this.$modifier.invoke((Object)((BasicModSchema)basicElement));
                }
                {
                    this.$modifier = function1;
                }
            });
        }

        @Nullable
        protected final <X> X performQuerySafe(@NotNull SqlQuery<X> query) {
            Intrinsics.checkNotNullParameter(query, (String)"query");
            return this.performQuerySafe(query, "schema " + this.schema.getRealName());
        }

        @NotNull
        protected final <R> List<R> performQuerySafeList(@NotNull SqlQuery<? extends Iterable<? extends R>> query) {
            Intrinsics.checkNotNullParameter(query, (String)"query");
            return this.performQuerySafeList(query, "schema " + this.schema.getRealName());
        }

        @Override
        public void process() {
            String string = this.schema.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"schema.name");
            BaseIntrospector.reportIntrospectingSchema$default(this.this$0, string, null, 2, null);
            this.prepareParameters();
            this.processPreliminaryPhase();
            this.processMainPhase();
        }

        public final void processPreliminaryPhase() {
            if (this.mode.fragment) {
                return;
            }
            this.analyzeBriefInfo();
            if (this.mode.increment) {
                this.analyzeCurrentContent();
            } else {
                this.clearSchema();
                this.retrieveMajorNames();
            }
        }

        public final void processMainPhase() {
            this.retrieveMainContent();
            this.finishSchema();
        }

        @Deprecated(message="use inModel,inSchema instead", replaceWith=@ReplaceWith(imports={}, expression="inSchema"))
        protected void work(@NotNull Runnable runnable) {
            Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
            this.getModel().modify(BasicModRoot.class, (ModelModifier)new ModelModifier<BasicModRoot>(runnable){
                final /* synthetic */ Runnable $runnable;

                public final void perform(BasicModRoot it) {
                    this.$runnable.run();
                }
                {
                    this.$runnable = runnable;
                }
            });
        }

        @Deprecated(message="use inModel,inSchema instead", replaceWith=@ReplaceWith(imports={}, expression="inSchema"))
        protected final void work(@NotNull InTransactionNoResult block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            this.getModel().modify(BasicModRoot.class, (ModelModifier)new ModelModifier<BasicModRoot>(this, block){
                final /* synthetic */ AbstractSchemaRetriever this$0;
                final /* synthetic */ InTransactionNoResult $block;

                public final void perform(BasicModRoot it) {
                    this.$block.run(this.this$0.getTransaction());
                }
                {
                    this.this$0 = abstractSchemaRetriever;
                    this.$block = inTransactionNoResult;
                }
            });
        }

        protected void analyzeBriefInfo() {
        }

        protected void analyzeCurrentContent() {
        }

        protected void retrieveMajorNames() {
        }

        protected void retrieveMainContent() {
        }

        protected void finishSchema() {
            this.this$0.reportStatusDetails("Finishing retrieving the schema " + this.schema.getName(), "introspection.report.status.finishingTheSchema");
            if (this.withSources && this.mode != IntrospectionMode.FRAGMENT) {
                this.getModel().setSchemaSourcesVersion((BasicSchema)this.schema, Long.valueOf(this.getSchemaStateNumber()));
            }
            if (this.mode.full || this.mode.increment) {
                this.schema.setIntrospectionVersion(this.this$0.getIntrospectorVersion());
            }
        }

        protected long getSchemaStateNumber() {
            Timestamp timestamp = this.introspectionBeginTimestamp;
            return timestamp != null ? timestamp.getTime() : 0L;
        }

        protected void clearSchema() {
            this.getModel().modify((BasicElement)this.schema, BasicModSchema.class, (ModelModifier)clearSchema.1.INSTANCE);
            this.getModel().setSchemaSourcesVersion((BasicSchema)this.schema, null);
        }

        protected AbstractSchemaRetriever(@NotNull DBTransaction transaction, S schema) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            this(this$0, transaction, (BasicModSchema)schema, null);
        }

        protected AbstractSchemaRetriever(@NotNull DBTransaction transaction, @Nullable S schema, IntrospectionMode mode) {
            String string;
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            super(transaction);
            this.this$0 = this$0;
            ObjectKind objectKind = ObjectKind.NONE;
            Intrinsics.checkNotNull((Object)objectKind);
            this.fragmentKind = objectKind;
            this.fragmentNames = new String[0];
            this.fromTimestamp = BaseIntrospectionFunctions.AGES_AGO;
            this.schema = schema;
            this$0.trace("---------------------------------- schema " + schema.getName() + " ----------------------------------");
            boolean schemaHasChildren = schema.hasChildren();
            IntrospectionMode introspectionMode = mode;
            if (introspectionMode == null) {
                introspectionMode = schemaHasChildren && this.isPossibleToIntrospectSchemaIncrementally(transaction, schema) ? IntrospectionMode.INCREMENT : IntrospectionMode.FULL;
            }
            this.mode = introspectionMode;
            this.withSources = this$0.getOptions().getSources().compareTo((Enum)DBIntrospectionOptions.SourceLoading.USER_SOURCES) >= 0;
            Date lastIntrospectionTimestamp = schema.getIntrospectionTimestamp();
            this.fromTimestamp = this.mode.increment && lastIntrospectionTimestamp != null ? new Timestamp(lastIntrospectionTimestamp.getTime()) : BaseIntrospectionFunctions.AGES_AGO;
            reference var7_7 = this$0;
            boolean $i$f$trace = false;
            if (((BaseIntrospector)var7_7).dbLogger != null) {
                reference var19_10 = var7_7;
                bl = false;
                string = StringsKt.trimMargin$default((String)("|Configuration info:\n           |    - schema id:             " + (schema instanceof BasicIdentifiedElement ? String.valueOf(((BasicIdentifiedElement)schema).getObjectId()) : "no") + "\n           |    - schema has children:   " + BooleanFunKt.getYesNo((boolean)schemaHasChildren) + "\n           |    - last intro timestamp:  " + lastIntrospectionTimestamp + "\n           |    - mode:                  " + mode + "\n           |    - with sources:          " + BooleanFunKt.getYesNo((boolean)this.getWithSources()) + "\n        "), null, (int)1, null);
                ((BaseIntrospector)var19_10).trace(string);
            }
            this.outdatedKinds = this.checkOutdatedKinds(schema.getIntrospectionVersion());
            if (schemaHasChildren) {
                reference var7_8 = this$0;
                $i$f$trace = false;
                if (((BaseIntrospector)var7_8).dbLogger != null) {
                    reference var19_11 = var7_8;
                    bl = false;
                    StringBuilder b = new StringBuilder();
                    b.append("Families before introspection:");
                    List list = schema.getFamilyKinds();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"schema.familyKinds");
                    List kinds = list;
                    for (ObjectKind kind : kinds) {
                        Locale locale;
                        String string2;
                        ModFamily f;
                        if ((ModFamily)schema.familyOf(kind) == null) {
                            continue;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)f, (String)"schema.familyOf(kind) ?: continue");
                        int n = f.size();
                        if (n <= 0) continue;
                        b.append('\n');
                        StringBuilder stringBuilder = b.append("    - ");
                        Intrinsics.checkNotNullExpressionValue((Object)kind.code(), (String)"kind.code()");
                        Intrinsics.checkNotNullExpressionValue((Object)Locale.ROOT, (String)"Locale.ROOT");
                        boolean bl2 = false;
                        String string3 = string2;
                        if (string3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string4 = string3.toLowerCase(locale);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
                        stringBuilder.append(string4);
                        b.append(": ").append(n);
                        if (!this.getOutdatedKinds().contains(kind)) continue;
                        b.append("  (outdated)");
                    }
                    String string5 = b.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"b.toString()");
                    string = string5;
                    ((BaseIntrospector)var19_11).trace(string);
                }
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$Companion;", "", "()V", "access$getLog$p", "Lcom/intellij/openapi/diagnostic/Logger;", "p", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector;", "intellij.database.dialects.base"})
    public static final class Companion {
        @JvmStatic
        @Deprecated(message="Don't use this function", replaceWith=@ReplaceWith(imports={}, expression="p.log"))
        @ApiStatus.Internal
        @NotNull
        public final /* synthetic */ Logger access$getLog$p(@NotNull BaseIntrospector<?, ?, ?> p) {
            Intrinsics.checkNotNullParameter(p, (String)"p");
            return p.log;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

