/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator;

import com.intellij.database.dialects.base.generator.ScriptGeneratorHelper;
import com.intellij.database.model.ElementDelta;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.generator.CodeTextBuilder;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.ScriptLocus;
import com.intellij.database.script.generator.ScriptingAlterTask;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.ScriptingTaskKt;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001TB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0015\u0010\t\u001a\u00060\nR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R!\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R!\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001c\"\u0004\b!\u0010\u001eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0011\u0010.\u001a\u00020/\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u001a\u00102\u001a\u000203X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u001c\u0010:\u001a\u0004\u0018\u00010;X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u0017\u0010@\u001a\b\u0012\u0004\u0012\u00020B0A\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010DR!\u0010E\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030G\u0012\u0004\u0012\u00020\u00010F\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010IR\u0013\u0010J\u001a\u0004\u0018\u00010K8F\u00a2\u0006\u0006\u001a\u0004\bL\u0010MR\u0013\u0010N\u001a\u0004\u0018\u00010O8F\u00a2\u0006\u0006\u001a\u0004\bP\u0010QR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u0010S\u00a8\u0006U"}, d2={"Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "", "project", "Lcom/intellij/openapi/project/Project;", "task", "Lcom/intellij/database/script/generator/ScriptingTask;", "helper", "Lcom/intellij/database/dialects/base/generator/ScriptGeneratorHelper;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/script/generator/ScriptingTask;Lcom/intellij/database/dialects/base/generator/ScriptGeneratorHelper;)V", "adapter", "Lcom/intellij/database/dialects/base/generator/ScriptingContext$NewCodingAdapter;", "getAdapter", "()Lcom/intellij/database/dialects/base/generator/ScriptingContext$NewCodingAdapter;", "builder", "Lcom/intellij/database/script/generator/CodeTextBuilder;", "getBuilder", "()Lcom/intellij/database/script/generator/CodeTextBuilder;", "bySource", "Ljava/util/HashMap;", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/model/ElementDelta;", "getBySource", "()Ljava/util/HashMap;", "byTarget", "getByTarget", "currentDatabaseName", "", "getCurrentDatabaseName", "()Ljava/lang/String;", "setCurrentDatabaseName", "(Ljava/lang/String;)V", "currentSchemaName", "getCurrentSchemaName", "setCurrentSchemaName", "getHelper", "()Lcom/intellij/database/dialects/base/generator/ScriptGeneratorHelper;", "locus", "Lcom/intellij/database/script/generator/ScriptLocus;", "getLocus", "()Lcom/intellij/database/script/generator/ScriptLocus;", "setLocus", "(Lcom/intellij/database/script/generator/ScriptLocus;)V", "model", "Lcom/intellij/database/model/basic/BasicModel;", "getModel", "()Lcom/intellij/database/model/basic/BasicModel;", "naming", "Lcom/intellij/database/script/generator/NamingService;", "getNaming", "()Lcom/intellij/database/script/generator/NamingService;", "options", "Lcom/intellij/database/script/generator/ScriptingOptions;", "getOptions", "()Lcom/intellij/database/script/generator/ScriptingOptions;", "setOptions", "(Lcom/intellij/database/script/generator/ScriptingOptions;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "result", "Lcom/intellij/database/script/generator/ScriptingResult;", "getResult", "()Lcom/intellij/database/script/generator/ScriptingResult;", "setResult", "(Lcom/intellij/database/script/generator/ScriptingResult;)V", "script", "", "Lcom/intellij/database/script/CompositeText;", "getScript", "()Ljava/util/List;", "sharedData", "", "Lcom/intellij/openapi/util/Key;", "getSharedData", "()Ljava/util/Map;", "sqlDef", "Lcom/intellij/lang/ParserDefinition;", "getSqlDef", "()Lcom/intellij/lang/ParserDefinition;", "sqlLang", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "getSqlLang", "()Lcom/intellij/sql/dialects/SqlLanguageDialect;", "getTask", "()Lcom/intellij/database/script/generator/ScriptingTask;", "NewCodingAdapter", "intellij.database.dialects.base"})
public final class ScriptingContext {
    @Nullable
    private String currentDatabaseName;
    @Nullable
    private String currentSchemaName;
    @NotNull
    private ScriptingOptions options;
    @NotNull
    private final List<CompositeText> script;
    @Nullable
    private ScriptingResult result;
    @NotNull
    private final CodeTextBuilder builder;
    @NotNull
    private final NewCodingAdapter adapter;
    @NotNull
    private ScriptLocus locus;
    @NotNull
    private final NamingService naming;
    @NotNull
    private final Map<Key<?>, Object> sharedData;
    @NotNull
    private final HashMap<BasicElement, ElementDelta<?>> bySource;
    @NotNull
    private final HashMap<BasicElement, ElementDelta<?>> byTarget;
    @NotNull
    private final Project project;
    @NotNull
    private final ScriptingTask task;
    @NotNull
    private final ScriptGeneratorHelper helper;

    @NotNull
    public final BasicModel getModel() {
        BasicModel basicModel = ScriptingTaskKt.getAnyModel((ScriptingTask)this.task);
        Intrinsics.checkNotNull((Object)basicModel);
        return basicModel;
    }

    @Nullable
    public final String getCurrentDatabaseName() {
        return this.currentDatabaseName;
    }

    public final void setCurrentDatabaseName(@Nullable String string) {
        this.currentDatabaseName = string;
    }

    @Nullable
    public final String getCurrentSchemaName() {
        return this.currentSchemaName;
    }

    public final void setCurrentSchemaName(@Nullable String string) {
        this.currentSchemaName = string;
    }

    @NotNull
    public final ScriptingOptions getOptions() {
        return this.options;
    }

    public final void setOptions(@NotNull ScriptingOptions scriptingOptions) {
        Intrinsics.checkNotNullParameter((Object)scriptingOptions, (String)"<set-?>");
        this.options = scriptingOptions;
    }

    @NotNull
    public final List<CompositeText> getScript() {
        return this.script;
    }

    @Nullable
    public final ScriptingResult getResult() {
        return this.result;
    }

    public final void setResult(@Nullable ScriptingResult scriptingResult) {
        this.result = scriptingResult;
    }

    @NotNull
    public final CodeTextBuilder getBuilder() {
        return this.builder;
    }

    @NotNull
    public final NewCodingAdapter getAdapter() {
        return this.adapter;
    }

    @NotNull
    public final ScriptLocus getLocus() {
        return this.locus;
    }

    public final void setLocus(@NotNull ScriptLocus scriptLocus) {
        Intrinsics.checkNotNullParameter((Object)scriptLocus, (String)"<set-?>");
        this.locus = scriptLocus;
    }

    @NotNull
    public final NamingService getNaming() {
        return this.naming;
    }

    @Nullable
    public final SqlLanguageDialect getSqlLang() {
        return this.helper.getSqlLang();
    }

    @Nullable
    public final ParserDefinition getSqlDef() {
        return this.helper.getSqlDef();
    }

    @NotNull
    public final Map<Key<?>, Object> getSharedData() {
        return this.sharedData;
    }

    @NotNull
    public final HashMap<BasicElement, ElementDelta<?>> getBySource() {
        return this.bySource;
    }

    @NotNull
    public final HashMap<BasicElement, ElementDelta<?>> getByTarget() {
        return this.byTarget;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ScriptingTask getTask() {
        return this.task;
    }

    @NotNull
    public final ScriptGeneratorHelper getHelper() {
        return this.helper;
    }

    public ScriptingContext(@NotNull Project project, @NotNull ScriptingTask task, @NotNull ScriptGeneratorHelper helper) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        this.project = project;
        this.task = task;
        this.helper = helper;
        BasicDatabase basicDatabase = ScriptingTaskKt.getAnyCurrentDatabase((ScriptingTask)this.task);
        this.currentDatabaseName = basicDatabase != null ? basicDatabase.getRealName() : null;
        BasicSchema basicSchema = ScriptingTaskKt.getAnyCurrentSchema((ScriptingTask)this.task);
        this.currentSchemaName = basicSchema != null ? basicSchema.getRealName() : null;
        this.options = this.task.getOptions();
        this.script = new ArrayList();
        this.builder = new CodeTextBuilder(0, 1, null);
        this.adapter = new NewCodingAdapter();
        this.locus = ScriptLocus.OUTSIDE;
        this.naming = this.helper.getNamingService$intellij_database_dialects_base(ScriptingTaskKt.getAnyModel((ScriptingTask)this.task), ScriptingTaskKt.getAnyCurrentDatabase((ScriptingTask)this.task));
        this.sharedData = new HashMap();
        this.bySource = new HashMap();
        this.byTarget = new HashMap();
        ScriptingTask scriptingTask = this.task;
        if (!(scriptingTask instanceof ScriptingAlterTask)) {
            scriptingTask = null;
        }
        if ((object = (ScriptingAlterTask)scriptingTask) != null && (object = object.getCorrespondence()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BasicElement it;
                BasicElement basicElement;
                boolean bl;
                boolean bl2;
                ElementDelta d = (ElementDelta)element$iv;
                boolean bl3 = false;
                if (d.getSourceElement() != null) {
                    bl2 = false;
                    bl = false;
                    it = basicElement;
                    boolean bl4 = false;
                    ((Map)this.bySource).put(it, d);
                }
                if (d.getTargetElement() != null) {
                    bl2 = false;
                    bl = false;
                    it = basicElement;
                    boolean bl5 = false;
                    ((Map)this.byTarget).put(it, d);
                }
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\f\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020$J$\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020%2\b\b\u0002\u0010&\u001a\u00020'2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)J\u0006\u0010*\u001a\u00020\u0005J\u001a\u0010+\u001a\u00020\u00052\u0006\u0010#\u001a\u00020%2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)J\u000e\u0010(\u001a\u00020\u00052\u0006\u0010,\u001a\u00020)J\u0006\u0010-\u001a\u00020\u0005J\u001c\u0010.\u001a\u00020\u00052\u000e\b\u0004\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0086\b\u00f8\u0001\u0000J\u0006\u00100\u001a\u00020\tJ\u0019\u00101\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u00102\u001a\u0004\u0018\u00010)H\u0086\bJ\u0006\u00103\u001a\u00020\u0005J\u0006\u00104\u001a\u00020\u0005J\u0006\u0010\u0012\u001a\u00020\u0005J\b\u00105\u001a\u00020\u0005H\u0002J,\u00106\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010#\u001a\u0004\u0018\u00010)2\u000e\b\u0004\u00107\u001a\b\u0012\u0004\u0012\u00020)0\u0004H\u0086\b\u00f8\u0001\u0000J\u0010\u00108\u001a\u00020\u00052\u0006\u0010#\u001a\u00020%H\u0002J\u001c\u00109\u001a\u0004\u0018\u00010)2\u0006\u0010:\u001a\u00020;2\n\b\u0002\u00101\u001a\u0004\u0018\u00010)J\u001a\u00109\u001a\u0004\u0018\u00010)2\b\u0010#\u001a\u0004\u0018\u00010)2\u0006\u0010<\u001a\u00020\tJ\u0019\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010>\u001a\u0004\u0018\u00010;H\u0086\bJ!\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010#\u001a\u0004\u0018\u00010)2\u0006\u0010<\u001a\u00020\tH\u0086\bJ$\u0010?\u001a\u00020\u00052\b\b\u0002\u0010\u0018\u001a\u00020\u00192\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0086\b\u00f8\u0001\u0000J\u0013\u0010@\u001a\u00020\u00052\b\u0010A\u001a\u0004\u0018\u00010$H\u0086\bJ\u0006\u0010B\u001a\u00020\u0005J \u0010C\u001a\u00060\u0000R\u00020D2\u000e\b\u0004\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0086\b\u00f8\u0001\u0000J\u0006\u0010E\u001a\u00020\u0005J$\u0010F\u001a\u00020\u00052\b\b\u0002\u0010G\u001a\u00020\t2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0086\b\u00f8\u0001\u0000JB\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\"\u0004\b\u0000\u0010I*\b\u0012\u0004\u0012\u0002HI0J2\b\b\u0002\u0010K\u001a\u00020)2\u0014\b\u0004\u0010L\u001a\u000e\u0012\u0004\u0012\u0002HI\u0012\u0004\u0012\u00020\u00050MH\u0086\b\u00f8\u0001\u0000J%\u0010N\u001a\u00060\u0000R\u00020D*\u00060\u0000R\u00020D2\u000e\u0010O\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004H\u0086\u0002J\u001f\u0010N\u001a\u00060\u0000R\u00020D*\u00060\u0000R\u00020D2\b\u0010L\u001a\u0004\u0018\u00010PH\u0086\u0002J\u001f\u0010N\u001a\u00060\u0000R\u00020D*\u00060\u0000R\u00020D2\b\u0010L\u001a\u0004\u0018\u00010$H\u0086\u0002J\u001f\u0010N\u001a\u00060\u0000R\u00020D*\u00060\u0000R\u00020D2\b\u0010Q\u001a\u0004\u0018\u00010%H\u0086\u0002J%\u0010R\u001a\u00060\u0000R\u00020D*\u00060\u0000R\u00020D2\u000e\u0010O\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004H\u0086\u0002J\u001f\u0010R\u001a\u00060\u0000R\u00020D*\u00060\u0000R\u00020D2\b\u0010L\u001a\u0004\u0018\u00010PH\u0086\u0002J\u001f\u0010R\u001a\u00060\u0000R\u00020D*\u00060\u0000R\u00020D2\b\u0010L\u001a\u0004\u0018\u00010$H\u0086\u0002J\u001f\u0010R\u001a\u00060\u0000R\u00020D*\u00060\u0000R\u00020D2\b\u0010Q\u001a\u0004\u0018\u00010%H\u0086\u0002J\u001c\u0010S\u001a\u00060\u0000R\u00020D*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004H\u0086\n\u00f8\u0001\u0000J\u0013\u0010S\u001a\u00060\u0000R\u00020D*\u0004\u0018\u00010PH\u0086\u0002J\u0013\u0010S\u001a\u00060\u0000R\u00020D*\u0004\u0018\u00010%H\u0086\u0002J\u001c\u0010T\u001a\u00060\u0000R\u00020D*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004H\u0086\n\u00f8\u0001\u0000J\u0013\u0010T\u001a\u00060\u0000R\u00020D*\u0004\u0018\u00010PH\u0086\u0002J\u0013\u0010T\u001a\u00060\u0000R\u00020D*\u0004\u0018\u00010%H\u0086\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000b\"\u0004\b\u0014\u0010\rR\u001a\u0010\u0015\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000b\"\u0004\b\u0017\u0010\rR\u001e\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001e\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001f\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u000b\"\u0004\b!\u0010\r\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006U"}, d2={"Lcom/intellij/database/dialects/base/generator/ScriptingContext$NewCodingAdapter;", "", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;)V", "EOLN", "Lkotlin/Function0;", "", "getEOLN", "()Lkotlin/jvm/functions/Function0;", "blockStart", "", "getBlockStart", "()Z", "setBlockStart", "(Z)V", "builder", "Lcom/intellij/database/script/generator/CodeTextBuilder;", "getBuilder", "()Lcom/intellij/database/script/generator/CodeTextBuilder;", "noSpace", "getNoSpace", "setNoSpace", "onNewLine", "getOnNewLine", "setOnNewLine", "separator", "", "getSeparator", "()Ljava/lang/Character;", "setSeparator", "(Ljava/lang/Character;)V", "Ljava/lang/Character;", "startWithNewLine", "getStartWithNewLine", "setStartWithNewLine", "appendSimple", "text", "Lcom/intellij/database/script/CompositeText;", "", "kind", "Lcom/intellij/database/script/CompositeText$Kind;", "error", "", "blankLine", "comment", "msg", "indent", "indenting", "block", "lastIsError", "name", "quotedName", "newLine", "noNewLine", "onStart", "orError", "err", "prepareAppend", "quote", "e", "Lcom/intellij/database/model/basic/BasicElement;", "plain", "scr", "element", "separated", "source", "src", "space", "startBlock", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "unindent", "withNewLines", "nl", "joined", "T", "", "sep", "t", "Lkotlin/Function1;", "minus", "op", "Lcom/intellij/database/script/CompositeText$Fragment;", "s", "plus", "unaryMinus", "unaryPlus", "intellij.database.dialects.base"})
    public final class NewCodingAdapter {
        @NotNull
        private final CodeTextBuilder builder;
        @NotNull
        private final Function0<Unit> EOLN;
        private boolean noSpace;
        private boolean blockStart;
        private boolean startWithNewLine;
        private boolean onNewLine;
        @Nullable
        private Character separator;

        @NotNull
        public final CodeTextBuilder getBuilder() {
            return this.builder;
        }

        @NotNull
        public final Function0<Unit> getEOLN() {
            return this.EOLN;
        }

        public final boolean getNoSpace() {
            return this.noSpace;
        }

        public final void setNoSpace(boolean bl) {
            this.noSpace = bl;
        }

        public final boolean getBlockStart() {
            return this.blockStart;
        }

        public final void setBlockStart(boolean bl) {
            this.blockStart = bl;
        }

        public final boolean getStartWithNewLine() {
            return this.startWithNewLine;
        }

        public final void setStartWithNewLine(boolean bl) {
            this.startWithNewLine = bl;
        }

        public final boolean getOnNewLine() {
            return this.onNewLine;
        }

        public final void setOnNewLine(boolean bl) {
            this.onNewLine = bl;
        }

        @Nullable
        public final Character getSeparator() {
            return this.separator;
        }

        public final void setSeparator(@Nullable Character c) {
            this.separator = c;
        }

        public final void withNewLines(boolean nl, @NotNull Function0<Unit> block) {
            int $i$f$withNewLines = 0;
            Intrinsics.checkNotNullParameter(block, (String)"block");
            boolean prev = this.getStartWithNewLine();
            this.setStartWithNewLine(nl);
            block.invoke();
            this.setStartWithNewLine(prev);
        }

        public static /* synthetic */ void withNewLines$default(NewCodingAdapter this_, boolean nl, Function0 block, int n, Object object) {
            if ((n & 1) != 0) {
                nl = true;
            }
            boolean $i$f$withNewLines = false;
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            boolean prev = this_.getStartWithNewLine();
            this_.setStartWithNewLine(nl);
            block.invoke();
            this_.setStartWithNewLine(prev);
        }

        public final void separated(char separator, @NotNull Function0<Unit> block) {
            int $i$f$separated = 0;
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Character prev = this.getSeparator();
            this.setSeparator(Character.valueOf(separator));
            block.invoke();
            this.setSeparator(prev);
        }

        public static /* synthetic */ void separated$default(NewCodingAdapter this_, char separator, Function0 block, int n, Object object) {
            if ((n & 1) != 0) {
                separator = (char)44;
            }
            boolean $i$f$separated = false;
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            Character prev = this_.getSeparator();
            this_.setSeparator(Character.valueOf(separator));
            block.invoke();
            this_.setSeparator(prev);
        }

        @NotNull
        public final NewCodingAdapter plus(@NotNull NewCodingAdapter $this$plus, @Nullable CompositeText.Fragment t) {
            Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"$this$plus");
            return $this$plus.plus($this$plus, (Function0<? extends Object>)((Function0)new Function0<Object>($this$plus, t){
                final /* synthetic */ NewCodingAdapter $this_plus;
                final /* synthetic */ CompositeText.Fragment $t;

                @Nullable
                public final Object invoke() {
                    CompositeText.Fragment fragment;
                    CompositeText.Fragment fragment2 = this.$t;
                    if (fragment2 != null) {
                        CompositeText.Fragment fragment3 = fragment2;
                        boolean bl = false;
                        boolean bl2 = false;
                        CompositeText.Fragment $this$apply = fragment3;
                        boolean bl3 = false;
                        this.$this_plus.appendSimple($this$apply.getText(), $this$apply.getKind(), $this$apply.getError());
                        fragment = fragment3;
                    } else {
                        fragment = null;
                    }
                    return fragment;
                }
                {
                    this.$this_plus = newCodingAdapter;
                    this.$t = fragment;
                    super(0);
                }
            }));
        }

        @NotNull
        public final NewCodingAdapter minus(@NotNull NewCodingAdapter $this$minus, @Nullable CompositeText.Fragment t) {
            Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"$this$minus");
            return $this$minus.minus($this$minus, (Function0<? extends Object>)((Function0)new Function0<Object>($this$minus, t){
                final /* synthetic */ NewCodingAdapter $this_minus;
                final /* synthetic */ CompositeText.Fragment $t;

                @Nullable
                public final Object invoke() {
                    CompositeText.Fragment fragment;
                    CompositeText.Fragment fragment2 = this.$t;
                    if (fragment2 != null) {
                        CompositeText.Fragment fragment3 = fragment2;
                        boolean bl = false;
                        boolean bl2 = false;
                        CompositeText.Fragment $this$apply = fragment3;
                        boolean bl3 = false;
                        this.$this_minus.appendSimple($this$apply.getText(), $this$apply.getKind(), $this$apply.getError());
                        fragment = fragment3;
                    } else {
                        fragment = null;
                    }
                    return fragment;
                }
                {
                    this.$this_minus = newCodingAdapter;
                    this.$t = fragment;
                    super(0);
                }
            }));
        }

        @NotNull
        public final NewCodingAdapter plus(@NotNull NewCodingAdapter $this$plus, @Nullable CompositeText t) {
            Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"$this$plus");
            return $this$plus.plus($this$plus, (Function0<? extends Object>)((Function0)new Function0<Object>($this$plus, t){
                final /* synthetic */ NewCodingAdapter $this_plus;
                final /* synthetic */ CompositeText $t;

                @Nullable
                public final Object invoke() {
                    Unit unit;
                    CompositeText compositeText = this.$t;
                    if (compositeText != null) {
                        CompositeText compositeText2 = compositeText;
                        boolean bl = false;
                        boolean bl2 = false;
                        CompositeText it = compositeText2;
                        boolean bl3 = false;
                        this.$this_plus.appendSimple(it);
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    return unit;
                }
                {
                    this.$this_plus = newCodingAdapter;
                    this.$t = compositeText;
                    super(0);
                }
            }));
        }

        @NotNull
        public final NewCodingAdapter minus(@NotNull NewCodingAdapter $this$minus, @Nullable CompositeText t) {
            Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"$this$minus");
            return $this$minus.minus($this$minus, (Function0<? extends Object>)((Function0)new Function0<Object>($this$minus, t){
                final /* synthetic */ NewCodingAdapter $this_minus;
                final /* synthetic */ CompositeText $t;

                @Nullable
                public final Object invoke() {
                    Unit unit;
                    CompositeText compositeText = this.$t;
                    if (compositeText != null) {
                        CompositeText compositeText2 = compositeText;
                        boolean bl = false;
                        boolean bl2 = false;
                        CompositeText it = compositeText2;
                        boolean bl3 = false;
                        this.$this_minus.appendSimple(it);
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    return unit;
                }
                {
                    this.$this_minus = newCodingAdapter;
                    this.$t = compositeText;
                    super(0);
                }
            }));
        }

        @NotNull
        public final NewCodingAdapter plus(@NotNull NewCodingAdapter $this$plus, @Nullable CharSequence s) {
            Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"$this$plus");
            return $this$plus.plus($this$plus, (Function0<? extends Object>)((Function0)new Function0<Object>($this$plus, s){
                final /* synthetic */ NewCodingAdapter $this_plus;
                final /* synthetic */ CharSequence $s;

                @Nullable
                public final Object invoke() {
                    Unit unit;
                    CharSequence charSequence = this.$s;
                    if (charSequence != null) {
                        CharSequence charSequence2 = charSequence;
                        boolean bl = false;
                        boolean bl2 = false;
                        CharSequence it = charSequence2;
                        boolean bl3 = false;
                        NewCodingAdapter.appendSimple$default(this.$this_plus, it, null, null, 6, null);
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    return unit;
                }
                {
                    this.$this_plus = newCodingAdapter;
                    this.$s = charSequence;
                    super(0);
                }
            }));
        }

        @NotNull
        public final NewCodingAdapter minus(@NotNull NewCodingAdapter $this$minus, @Nullable CharSequence s) {
            Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"$this$minus");
            return $this$minus.minus($this$minus, (Function0<? extends Object>)((Function0)new Function0<Object>($this$minus, s){
                final /* synthetic */ NewCodingAdapter $this_minus;
                final /* synthetic */ CharSequence $s;

                @Nullable
                public final Object invoke() {
                    Unit unit;
                    CharSequence charSequence = this.$s;
                    if (charSequence != null) {
                        CharSequence charSequence2 = charSequence;
                        boolean bl = false;
                        boolean bl2 = false;
                        CharSequence it = charSequence2;
                        boolean bl3 = false;
                        NewCodingAdapter.appendSimple$default(this.$this_minus, it, null, null, 6, null);
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    return unit;
                }
                {
                    this.$this_minus = newCodingAdapter;
                    this.$s = charSequence;
                    super(0);
                }
            }));
        }

        @NotNull
        public final NewCodingAdapter plus(@NotNull NewCodingAdapter $this$plus, @NotNull Function0<? extends Object> op) {
            Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"$this$plus");
            Intrinsics.checkNotNullParameter(op, (String)"op");
            NewCodingAdapter newCodingAdapter = $this$plus;
            boolean bl = false;
            boolean bl2 = false;
            NewCodingAdapter $this$apply = newCodingAdapter;
            boolean bl3 = false;
            op.invoke();
            return newCodingAdapter;
        }

        @NotNull
        public final NewCodingAdapter minus(@NotNull NewCodingAdapter $this$minus, @NotNull Function0<? extends Object> op) {
            Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"$this$minus");
            Intrinsics.checkNotNullParameter(op, (String)"op");
            NewCodingAdapter newCodingAdapter = $this$minus;
            boolean bl = false;
            boolean bl2 = false;
            NewCodingAdapter $this$apply = newCodingAdapter;
            boolean bl3 = false;
            $this$apply.noSpace = true;
            op.invoke();
            return newCodingAdapter;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final NewCodingAdapter unaryPlus(@Nullable CharSequence $this$unaryPlus) {
            void var2_2;
            NewCodingAdapter this_$iv = this;
            boolean $i$f$startBlock = false;
            boolean prev$iv = this_$iv.getBlockStart();
            this_$iv.setBlockStart(true);
            boolean bl = false;
            this.plus(this, $this$unaryPlus);
            if (this_$iv.getBlockStart()) {
                this_$iv.setBlockStart(prev$iv);
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final NewCodingAdapter unaryMinus(@Nullable CharSequence $this$unaryMinus) {
            void var2_2;
            NewCodingAdapter this_$iv = this;
            boolean $i$f$startBlock = false;
            boolean prev$iv = this_$iv.getBlockStart();
            this_$iv.setBlockStart(true);
            boolean bl = false;
            this.minus(this, $this$unaryMinus);
            if (this_$iv.getBlockStart()) {
                this_$iv.setBlockStart(prev$iv);
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final NewCodingAdapter unaryPlus(@Nullable CompositeText.Fragment $this$unaryPlus) {
            void var2_2;
            NewCodingAdapter this_$iv = this;
            boolean $i$f$startBlock = false;
            boolean prev$iv = this_$iv.getBlockStart();
            this_$iv.setBlockStart(true);
            boolean bl = false;
            this.plus(this, $this$unaryPlus);
            if (this_$iv.getBlockStart()) {
                this_$iv.setBlockStart(prev$iv);
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final NewCodingAdapter unaryMinus(@Nullable CompositeText.Fragment $this$unaryMinus) {
            void var2_2;
            NewCodingAdapter this_$iv = this;
            boolean $i$f$startBlock = false;
            boolean prev$iv = this_$iv.getBlockStart();
            this_$iv.setBlockStart(true);
            boolean bl = false;
            this.minus(this, $this$unaryMinus);
            if (this_$iv.getBlockStart()) {
                this_$iv.setBlockStart(prev$iv);
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final NewCodingAdapter unaryPlus(@NotNull Function0<? extends Object> $this$unaryPlus) {
            void var3_3;
            int $i$f$unaryPlus = 0;
            Intrinsics.checkNotNullParameter($this$unaryPlus, (String)"$this$unaryPlus");
            NewCodingAdapter this_$iv = this;
            boolean $i$f$startBlock = false;
            boolean prev$iv = this_$iv.getBlockStart();
            this_$iv.setBlockStart(true);
            boolean bl = false;
            this.plus(this, $this$unaryPlus);
            if (this_$iv.getBlockStart()) {
                this_$iv.setBlockStart(prev$iv);
            }
            return var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final NewCodingAdapter unaryMinus(@NotNull Function0<? extends Object> $this$unaryMinus) {
            void var3_3;
            int $i$f$unaryMinus = 0;
            Intrinsics.checkNotNullParameter($this$unaryMinus, (String)"$this$unaryMinus");
            NewCodingAdapter this_$iv = this;
            boolean $i$f$startBlock = false;
            boolean prev$iv = this_$iv.getBlockStart();
            this_$iv.setBlockStart(true);
            boolean bl = false;
            this.minus(this, $this$unaryMinus);
            if (this_$iv.getBlockStart()) {
                this_$iv.setBlockStart(prev$iv);
            }
            return var3_3;
        }

        @NotNull
        public final NewCodingAdapter startBlock(@NotNull Function0<Unit> block) {
            int $i$f$startBlock = 0;
            Intrinsics.checkNotNullParameter(block, (String)"block");
            boolean prev = this.getBlockStart();
            this.setBlockStart(true);
            block.invoke();
            if (this.getBlockStart()) {
                this.setBlockStart(prev);
            }
            return this;
        }

        @NotNull
        public final <T> Function0<Unit> joined(@NotNull Iterable<? extends T> $this$joined, @NotNull String sep2, @NotNull Function1<? super T, Unit> t) {
            int $i$f$joined = 0;
            Intrinsics.checkNotNullParameter($this$joined, (String)"$this$joined");
            Intrinsics.checkNotNullParameter((Object)sep2, (String)"sep");
            Intrinsics.checkNotNullParameter(t, (String)"t");
            return (Function0)new Function0<Unit>(this, $this$joined, t, sep2){
                final /* synthetic */ NewCodingAdapter this$0;
                final /* synthetic */ Iterable $this_joined;
                final /* synthetic */ Function1 $t;
                final /* synthetic */ String $sep;

                public final void invoke() {
                    Iterator<T> it = this.$this_joined.iterator();
                    if (it.hasNext()) {
                        this.$t.invoke(it.next());
                        while (it.hasNext()) {
                            this.this$0.noSpace();
                            NewCodingAdapter.appendSimple$default(this.this$0, this.$sep, null, null, 6, null);
                            this.$t.invoke(it.next());
                        }
                    }
                }
                {
                    this.this$0 = newCodingAdapter;
                    this.$this_joined = iterable;
                    this.$t = function1;
                    this.$sep = string;
                    super(0);
                }
            };
        }

        public static /* synthetic */ Function0 joined$default(NewCodingAdapter this_, Iterable $this$joined, String sep2, Function1 t, int n, Object object) {
            if ((n & 1) != 0) {
                sep2 = ", ";
            }
            boolean $i$f$joined = false;
            Intrinsics.checkNotNullParameter((Object)$this$joined, (String)"$this$joined");
            Intrinsics.checkNotNullParameter((Object)sep2, (String)"sep");
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            return (Function0)new /* invalid duplicate definition of identical inner class */;
        }

        public final void noSpace() {
            this.noSpace = true;
        }

        public final void comment(@NotNull CharSequence text, @Nullable String error) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.appendSimple("-- " + text + '\n', CompositeText.Kind.COMMENT, error);
        }

        public static /* synthetic */ void comment$default(NewCodingAdapter newCodingAdapter, CharSequence charSequence, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = null;
            }
            newCodingAdapter.comment(charSequence, string);
        }

        public final void appendSimple(@NotNull CompositeText text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.prepareAppend(text.getText());
            for (CompositeText.Fragment fragment : text.getFragments()) {
                this.builder.appendSimple(fragment.getText(), fragment.getKind(), fragment.getError());
            }
        }

        public final void appendSimple(@NotNull CharSequence text, @NotNull CompositeText.Kind kind, @Nullable String error) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            this.prepareAppend(text);
            this.builder.appendSimple(text, kind, error);
        }

        public static /* synthetic */ void appendSimple$default(NewCodingAdapter newCodingAdapter, CharSequence charSequence, CompositeText.Kind kind, String string, int n, Object object) {
            if ((n & 2) != 0) {
                kind = CompositeText.Kind.PLAIN_TEXT;
            }
            if ((n & 4) != 0) {
                string = null;
            }
            newCodingAdapter.appendSimple(charSequence, kind, string);
        }

        private final void prepareAppend(CharSequence text) {
            CharSequence charSequence = text;
            boolean bl = false;
            if (charSequence.length() > 0) {
                if (this.blockStart) {
                    this.onStart();
                }
                if (this.onNewLine) {
                    CodeTextBuilder.ensureEoln$default((CodeTextBuilder)this.builder, null, (int)1, null);
                    this.onNewLine = false;
                }
                if (!this.noSpace) {
                    if (!CharsKt.isWhitespace((char)text.charAt(0))) {
                        this.space();
                    }
                } else {
                    this.noSpace = false;
                }
            }
        }

        public final void space() {
            char last;
            CharSequence text = this.builder.getText();
            Character c = StringsKt.lastOrNull((CharSequence)text);
            char c2 = last = c != null ? c.charValue() : (char)'\n';
            if (last == '\n') {
                this.builder.appendIndent();
            }
            if (CharsKt.isWhitespace((char)last)) {
                return;
            }
            CodeTextBuilder.appendSimple$default((CodeTextBuilder)this.builder, (CharSequence)" ", null, null, (int)6, null);
        }

        private final void onStart() {
            this.blockStart = false;
            if (this.separator != null) {
                Character c = this.separator;
                Intrinsics.checkNotNull((Object)c);
                if (!this.builder.endsWithIgnoreSpace((CharSequence)String.valueOf(c.charValue()))) {
                    Character c2 = this.separator;
                    Intrinsics.checkNotNull((Object)c2);
                    this.builder.addSuffixToTheLastLine(c2.charValue());
                }
            }
            if (this.startWithNewLine) {
                CodeTextBuilder.ensureEoln$default((CodeTextBuilder)this.builder, null, (int)1, null);
            }
        }

        public final void newLine() {
            this.onNewLine = true;
        }

        public final void noNewLine() {
            this.onNewLine = false;
        }

        public final void blankLine() {
            CodeTextBuilder.ensureBlankLine$default((CodeTextBuilder)this.builder, null, (int)1, null);
        }

        public final void error(@NotNull String msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            this.comment(msg, msg);
        }

        public final void indenting(@NotNull Function0<Unit> block) {
            int $i$f$indenting = 0;
            Intrinsics.checkNotNullParameter(block, (String)"block");
            boolean prev = this.getOnNewLine();
            int length = this.getBuilder().getLength();
            this.newLine();
            this.indent();
            block.invoke();
            this.unindent();
            if (length == this.getBuilder().getLength()) {
                this.setOnNewLine(prev);
            }
        }

        public final void indent() {
            CodeTextBuilder.indent$default((CodeTextBuilder)this.builder, null, (int)1, null);
        }

        public final void unindent() {
            this.builder.unindent();
        }

        @NotNull
        public final Function0<Unit> orError(@Nullable String text, @NotNull Function0<String> err) {
            int $i$f$orError = 0;
            Intrinsics.checkNotNullParameter(err, (String)"err");
            return (Function0)new Function0<Unit>(this, text, err){
                final /* synthetic */ NewCodingAdapter this$0;
                final /* synthetic */ String $text;
                final /* synthetic */ Function0 $err;

                public final void invoke() {
                    if (this.$text != null) {
                        NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                    } else {
                        NewCodingAdapter.appendSimple$default(this.this$0, "???", null, (String)this.$err.invoke(), 2, null);
                    }
                }
                {
                    this.this$0 = newCodingAdapter;
                    this.$text = string;
                    this.$err = function0;
                    super(0);
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Function0<Unit> scr(@Nullable BasicElement element) {
            void this_$iv;
            String string;
            int $i$f$scr = 0;
            NewCodingAdapter newCodingAdapter = this;
            BasicElement basicElement = element;
            if (basicElement != null) {
                BasicElement basicElement2 = basicElement;
                boolean bl = false;
                boolean bl2 = false;
                BasicElement it = basicElement2;
                boolean bl3 = false;
                string = NewCodingAdapter.quote$default(this, it, null, 2, null);
            } else {
                string = null;
            }
            String quotedName$iv = string;
            boolean $i$f$name = false;
            void this_$iv$iv = this_$iv;
            boolean $i$f$orError = false;
            return (Function0)new Function0<Unit>((NewCodingAdapter)this_$iv$iv, quotedName$iv){
                final /* synthetic */ NewCodingAdapter this$0;
                final /* synthetic */ String $text;
                {
                    this.this$0 = newCodingAdapter;
                    this.$text = string;
                    super(0);
                }

                public final void invoke() {
                    if (this.$text != null) {
                        NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                    } else {
                        CompositeText.Kind kind = null;
                        CharSequence charSequence = "???";
                        NewCodingAdapter newCodingAdapter = this.this$0;
                        boolean bl = false;
                        String string = "unknown name";
                        NewCodingAdapter.appendSimple$default(newCodingAdapter, charSequence, kind, string, 2, null);
                    }
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Function0<Unit> scr(@Nullable String text, boolean plain) {
            void this_$iv;
            int $i$f$scr = 0;
            NewCodingAdapter newCodingAdapter = this;
            String quotedName$iv = this.quote(text, plain);
            boolean $i$f$name = false;
            void this_$iv$iv = this_$iv;
            boolean $i$f$orError = false;
            return (Function0)new Function0<Unit>((NewCodingAdapter)this_$iv$iv, quotedName$iv){
                final /* synthetic */ NewCodingAdapter this$0;
                final /* synthetic */ String $text;
                {
                    this.this$0 = newCodingAdapter;
                    this.$text = string;
                    super(0);
                }

                public final void invoke() {
                    if (this.$text != null) {
                        NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                    } else {
                        CompositeText.Kind kind = null;
                        CharSequence charSequence = "???";
                        NewCodingAdapter newCodingAdapter = this.this$0;
                        boolean bl = false;
                        String string = "unknown name";
                        NewCodingAdapter.appendSimple$default(newCodingAdapter, charSequence, kind, string, 2, null);
                    }
                }
            };
        }

        @NotNull
        public final Function0<Unit> name(@Nullable String quotedName) {
            int $i$f$name = 0;
            NewCodingAdapter this_$iv = this;
            boolean $i$f$orError = false;
            return (Function0)new Function0<Unit>(this_$iv, quotedName){
                final /* synthetic */ NewCodingAdapter this$0;
                final /* synthetic */ String $text;
                {
                    this.this$0 = newCodingAdapter;
                    this.$text = string;
                    super(0);
                }

                public final void invoke() {
                    if (this.$text != null) {
                        NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                    } else {
                        CompositeText.Kind kind = null;
                        CharSequence charSequence = "???";
                        NewCodingAdapter newCodingAdapter = this.this$0;
                        boolean bl = false;
                        String string = "unknown name";
                        NewCodingAdapter.appendSimple$default(newCodingAdapter, charSequence, kind, string, 2, null);
                    }
                }
            };
        }

        public final void source(@Nullable CompositeText src2) {
            int $i$f$source = 0;
            if (src2 != null) {
                this.appendSimple(src2);
            } else {
                this.error("missing source code");
            }
        }

        @Nullable
        public final String quote(@NotNull BasicElement e2, @Nullable String name2) {
            String string;
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            String string2 = name2;
            if (string2 != null) {
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String it = string3;
                boolean bl3 = false;
                string = ScriptingContext.this.getNaming().nameToScript(it, e2.getKind(), e2 instanceof BasicNamedElement && ((BasicNamedElement)e2).isNameScripted() && !((BasicNamedElement)e2).isNameQuoted(), ((SqlCodeStyleSettings)ScriptingContext.this.getOptions().get(ScriptingOptionStatic.CODE_STYLE)).getQuotesPriority());
            } else {
                string = null;
            }
            return string;
        }

        public static /* synthetic */ String quote$default(NewCodingAdapter newCodingAdapter, BasicElement basicElement, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = basicElement.getRealName();
            }
            return newCodingAdapter.quote(basicElement, string);
        }

        @Nullable
        public final String quote(@Nullable String text, boolean plain) {
            String string;
            String string2 = text;
            if (string2 != null) {
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String it = string3;
                boolean bl3 = false;
                string = ScriptingContext.this.getNaming().nameToScript(it, null, plain, ((SqlCodeStyleSettings)ScriptingContext.this.getOptions().get(ScriptingOptionStatic.CODE_STYLE)).getQuotesPriority());
            } else {
                string = null;
            }
            return string;
        }

        public final boolean lastIsError() {
            CodeTextBuilder.Fragment fragment = (CodeTextBuilder.Fragment)CollectionsKt.lastOrNull((List)this.builder.getFragments());
            return (fragment != null ? fragment.getError() : null) != null;
        }

        public NewCodingAdapter() {
            this.builder = ScriptingContext.this.getBuilder();
            this.EOLN = (Function0)new Function0<Unit>(this){
                final /* synthetic */ NewCodingAdapter this$0;

                public final void invoke() {
                    this.this$0.newLine();
                }
                {
                    this.this$0 = newCodingAdapter;
                    super(0);
                }
            };
        }
    }
}

