/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base;

import com.intellij.database.console.ExecutionEnvironmentHelper;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlCodeFragment;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.util.ThreeState;
import com.intellij.util.ThrowableRunnable;
import java.rmi.RemoteException;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseExecutionEnvironmentHelper
implements ExecutionEnvironmentHelper {
    private static final String EXPRESSION = "'keep alive'";

    @NotNull
    public String getQuery(@NotNull String text, @NotNull SqlElement sqlElement) {
        if (text == null) {
            BaseExecutionEnvironmentHelper.$$$reportNull$$$0(0);
        }
        if (sqlElement == null) {
            BaseExecutionEnvironmentHelper.$$$reportNull$$$0(1);
        }
        if (sqlElement instanceof SqlExpression && BaseExecutionEnvironmentHelper.isSufficientExpression((SqlExpression)sqlElement)) {
            String string = text;
            if (string == null) {
                BaseExecutionEnvironmentHelper.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = this.generateSelectStatement(text, sqlElement);
        if (string == null) {
            BaseExecutionEnvironmentHelper.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static boolean isSufficientExpression(@NotNull SqlExpression expression) {
        if (expression == null) {
            BaseExecutionEnvironmentHelper.$$$reportNull$$$0(4);
        }
        return expression instanceof SqlResultSetExpression;
    }

    @NotNull
    protected String generateSelectStatement(@NotNull String text, @NotNull SqlElement sqlElement) {
        if (text == null) {
            BaseExecutionEnvironmentHelper.$$$reportNull$$$0(5);
        }
        if (sqlElement == null) {
            BaseExecutionEnvironmentHelper.$$$reportNull$$$0(6);
        }
        String string = String.format("SELECT %s", text);
        if (string == null) {
            BaseExecutionEnvironmentHelper.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public ThreeState getSslState(@NotNull DatabaseConnection connection) {
        if (connection == null) {
            BaseExecutionEnvironmentHelper.$$$reportNull$$$0(8);
        }
        return null;
    }

    @NotNull
    public String getKeepAliveQuery(@NotNull Project project, @NotNull LocalDataSource dataSource) {
        if (project == null) {
            BaseExecutionEnvironmentHelper.$$$reportNull$$$0(9);
        }
        if (dataSource == null) {
            BaseExecutionEnvironmentHelper.$$$reportNull$$$0(10);
        }
        SqlLanguageDialect dialect = DbSqlUtil.getSqlDialect((LocalDataSource)dataSource);
        String string = (String)ReadAction.compute(() -> {
            SqlCodeFragment fragment = SqlPsiFacade.getInstance((Project)project).createExpressionFragment((Language)dialect, null, null, EXPRESSION);
            SqlElement child = (SqlElement)fragment.getFirstChild();
            return this.getQuery(EXPRESSION, child);
        });
        if (string == null) {
            BaseExecutionEnvironmentHelper.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    public Long getCountRows(@NotNull RemoteResultSet resultSet) throws RemoteException, SQLException {
        if (resultSet == null) {
            BaseExecutionEnvironmentHelper.$$$reportNull$$$0(12);
        }
        if (!resultSet.next()) {
            throw new AssertionError((Object)"Incorrect count query!");
        }
        return resultSet.getLong(1);
    }

    @NotNull
    public ExecutionEnvironmentHelper.TimeZoneManager getTimeZoneManager() {
        ExecutionEnvironmentHelper.TimeZoneManager timeZoneManager = ExecutionEnvironmentHelper.TimeZoneManager.UNSUPPORTED;
        if (timeZoneManager == null) {
            BaseExecutionEnvironmentHelper.$$$reportNull$$$0(13);
        }
        return timeZoneManager;
    }

    public void runInSpecificEnvironment(@NotNull String sql, @NotNull Configuration configuration, @NotNull DatabaseConnection connection, @Nullable Project project, @NotNull ThrowableRunnable<Exception> execution) throws Exception {
        if (sql == null) {
            BaseExecutionEnvironmentHelper.$$$reportNull$$$0(14);
        }
        if (configuration == null) {
            BaseExecutionEnvironmentHelper.$$$reportNull$$$0(15);
        }
        if (connection == null) {
            BaseExecutionEnvironmentHelper.$$$reportNull$$$0(16);
        }
        if (execution == null) {
            BaseExecutionEnvironmentHelper.$$$reportNull$$$0(17);
        }
        execution.run();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlElement";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/base/BaseExecutionEnvironmentHelper";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sql";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execution";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/base/BaseExecutionEnvironmentHelper";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuery";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "generateSelectStatement";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeepAliveQuery";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimeZoneManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuery";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isSufficientExpression";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateSelectStatement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSslState";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getKeepAliveQuery";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCountRows";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "runInSpecificEnvironment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

