/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.PredicateValue;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.data.types.PredicatesUtilKt;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.base.BaseDmlGenerator;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.script.generator.dml.ColumnRefs;
import com.intellij.database.script.generator.dml.ColumnsOrderBy;
import com.intellij.database.script.generator.dml.CountAll;
import com.intellij.database.script.generator.dml.DeleteRowsTask;
import com.intellij.database.script.generator.dml.DmlGenerator;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlTaskWithTable;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.OrderBy;
import com.intellij.database.script.generator.dml.PlainWhereClause;
import com.intellij.database.script.generator.dml.PredicatesWhereClause;
import com.intellij.database.script.generator.dml.QueryColumns;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.script.generator.dml.ValuesWhereClause;
import com.intellij.database.script.generator.dml.WhereClause;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlOrderByClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSelectOption;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlWithQueryExpression;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.TIntArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00d8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 X2\u00020\u0001:\u0001XB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J,\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\u00162\b\u0010\r\u001a\u0004\u0018\u00010\bH\u0004J2\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00172\b\u0010\r\u001a\u0004\u0018\u00010\bH\u0014J \u0010\u0018\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\bH\u0014J0\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0014J \u0010\"\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\u001eH\u0004J\u0018\u0010%\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\bH\u0014J(\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0002J'\u0010+\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020,2\u0006\u0010-\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010.J\u0018\u0010/\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00100\u001a\u000201H\u0014J\u0012\u00102\u001a\u0004\u0018\u00010\b2\u0006\u00100\u001a\u000201H\u0014J\u0018\u00103\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00104\u001a\u00020\u001eH\u0004J\u0012\u00105\u001a\u0004\u0018\u00010,2\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u00106\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00100\u001a\u000207H\u0016J\b\u00108\u001a\u000209H\u0014J\u0018\u0010:\u001a\u00020\f2\u0006\u0010;\u001a\u00020<2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010:\u001a\u00020\f2\u0006\u0010;\u001a\u00020=2\u0006\u0010\u000e\u001a\u00020\u000fH\u0004J \u0010:\u001a\u00020\f2\u0006\u0010>\u001a\u00020?2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010@\u001a\u00020!H\u0002J(\u0010:\u001a\u00020\f2\u0006\u0010>\u001a\u00020A2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00100\u001a\u0002072\u0006\u0010@\u001a\u00020!H\u0002J(\u0010:\u001a\u00020\f2\u0006\u0010>\u001a\u00020B2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00100\u001a\u0002072\u0006\u0010@\u001a\u00020!H\u0002J\"\u0010:\u001a\u00020\f2\b\u0010>\u001a\u0004\u0018\u00010C2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00100\u001a\u000207H\u0016J*\u0010:\u001a\u00020\f2\b\u0010>\u001a\u0004\u0018\u00010C2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00100\u001a\u0002072\u0006\u0010@\u001a\u00020!H\u0004JX\u0010:\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00100\u001a\u0002072\f\u0010D\u001a\b\u0012\u0004\u0012\u00020E0\u00172\u0006\u0010F\u001a\u00020\b2\u0006\u0010@\u001a\u00020!2 \u0010G\u001a\u001c\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020I\u0012\u0004\u0012\u00020\f\u0018\u00010Hj\u0004\u0018\u0001`JH\u0002J \u0010K\u001a\u00020\b2\u0006\u0010L\u001a\u00020M2\u0006\u0010*\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020NH\u0002J \u0010O\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00104\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0004J\u0018\u0010P\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00100\u001a\u00020QH\u0014J \u0010R\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010S\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0004J,\u0010T\u001a\u0004\u0018\u00010U2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010*\u001a\u0004\u0018\u00010\b2\u0006\u0010L\u001a\u00020M2\u0006\u00100\u001a\u000207H\u0016J,\u0010V\u001a\u0004\u0018\u00010W2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010*\u001a\u0004\u0018\u00010\b2\u0006\u0010L\u001a\u00020M2\u0006\u00100\u001a\u00020QH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006Y"}, d2={"Lcom/intellij/database/dialects/base/BaseDmlGenerator;", "Lcom/intellij/database/script/generator/dml/DmlGenerator;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "getDbms", "()Lcom/intellij/database/Dbms;", "emptyWhereClause", "", "getEmptyWhereClause", "()Ljava/lang/String;", "appendColumnList", "", "alias", "builder", "Lcom/intellij/database/util/DdlBuilder;", "columns", "", "Lcom/intellij/database/data/types/ColumnRef;", "appendColumns", "table", "Lcom/intellij/database/model/DasTable;", "Lcom/intellij/database/script/generator/dml/QueryColumns;", "", "appendFromTable", "dasTable", "appendLimit", "dialect", "Lcom/intellij/database/dialects/DatabaseDialectEx;", "limit", "", "offset", "atBeginning", "", "appendNumericProperty", "property", "value", "appendRowId", "appendWrappedQueryTail", "head", "e", "Lcom/intellij/sql/psi/SqlResultSetExpression;", "query", "buildOptimizedCountQuery", "Lcom/intellij/sql/psi/SqlQueryExpression;", "queryText", "(Lcom/intellij/database/util/DdlBuilder;Lcom/intellij/sql/psi/SqlQueryExpression;Ljava/lang/String;)Ljava/lang/Integer;", "deleteRows", "task", "Lcom/intellij/database/script/generator/dml/DeleteRowsTask;", "deleteRowsTableAlias", "fetchFirst", "rows", "findQuery", "generate", "Lcom/intellij/database/script/generator/dml/DmlTask;", "getPlaceForLimit", "Lcom/intellij/database/dialects/base/BaseDmlGenerator$Companion$LimitPlace;", "produce", "orderBy", "Lcom/intellij/database/script/generator/dml/ColumnsOrderBy;", "Lcom/intellij/database/script/generator/dml/OrderBy;", "whereClause", "Lcom/intellij/database/script/generator/dml/PlainWhereClause;", "printWhereKeyword", "Lcom/intellij/database/script/generator/dml/PredicatesWhereClause;", "Lcom/intellij/database/script/generator/dml/ValuesWhereClause;", "Lcom/intellij/database/script/generator/dml/WhereClause;", "predicates", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "op", "processor", "Lkotlin/Function2;", "Lcom/intellij/database/data/types/PredicateValue;", "Lcom/intellij/database/script/generator/dml/ColumnValueConsumer;", "removeOrderByClause", "project", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "rowNumLimit", "select", "Lcom/intellij/database/script/generator/dml/SelectTask;", "top", "topWord", "wrap", "Lcom/intellij/database/script/generator/dml/DmlGenerator$Companion$Result;", "wrapInSelect", "Lcom/intellij/database/script/generator/dml/DmlGenerator$Companion$WrapQueryResult;", "Companion", "intellij.database.dialects.base"})
public abstract class BaseDmlGenerator
implements DmlGenerator {
    @NotNull
    private final String emptyWhereClause;
    @NotNull
    private final Dbms dbms;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getEmptyWhereClause() {
        return this.emptyWhereClause;
    }

    @NotNull
    public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DmlTask task) {
        DdlBuilder ddlBuilder;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        DmlTask dmlTask = task;
        if (dmlTask instanceof SelectTask) {
            ddlBuilder = this.select(builder, (SelectTask)task);
        } else if (dmlTask instanceof DeleteRowsTask) {
            ddlBuilder = this.deleteRows(builder, (DeleteRowsTask)task);
        } else {
            throw (Throwable)new UnsupportedOperationException("Task is not supported " + task);
        }
        return ddlBuilder;
    }

    @Nullable
    public DmlGenerator.Companion.Result wrap(@NotNull DdlBuilder builder, @Nullable String query, @NotNull Project project, @NotNull DmlTask task) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        DmlTask dmlTask = task;
        if (!(dmlTask instanceof SelectTask)) {
            throw (Throwable)new UnsupportedOperationException("Task is not supported " + task);
        }
        return (DmlGenerator.Companion.Result)this.wrapInSelect(builder, query, project, (SelectTask)task);
    }

    @NotNull
    protected Companion.LimitPlace getPlaceForLimit() {
        return Companion.LimitPlace.END;
    }

    @NotNull
    protected DdlBuilder select(@NotNull DdlBuilder builder, @NotNull SelectTask task) {
        WhereClause it;
        boolean bl;
        boolean bl2;
        WhereClause whereClause;
        String string;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        DasTable table = task.getTable();
        if (table == null) {
            return builder;
        }
        DatabaseDialectEx databaseDialectEx = DbImplUtil.getDatabaseDialect((Dbms)this.dbms);
        Intrinsics.checkNotNullExpressionValue((Object)databaseDialectEx, (String)"getDatabaseDialect(dbms)");
        DatabaseDialectEx dialect = databaseDialectEx;
        boolean limited = !DbImplUtil.isPageSizeUnlimited((int)task.getLimit()) || task.getOffset() > 0;
        Companion.LimitPlace limitPlace = this.getPlaceForLimit();
        if (limited) {
            Companion.LimitPlace.BOTH.appendLimit(builder, this, dialect, limitPlace, task.getLimit(), task.getOffset(), true);
        }
        builder.keyword("SELECT").space();
        if (limited) {
            Companion.LimitPlace.BEGIN.appendLimit(builder, this, dialect, limitPlace, task.getLimit(), task.getOffset(), true);
        }
        if ((string = task.getAlias()) == null) {
            string = "t";
        }
        String alias = string;
        this.appendColumns(builder, table, task.getColumns(), alias);
        if (dialect.hasRowId(task.getVersion()) && task.getAppendRowId()) {
            this.appendRowId(builder, alias);
        }
        DmlUtilKt.space((DdlBuilder)builder, (boolean)task.getInsertNewLines());
        this.appendFromTable(builder, table, alias);
        WhereClause whereClause2 = task.getWhereClause();
        if (whereClause2 != null) {
            whereClause = whereClause2;
            bl2 = false;
            bl = false;
            it = whereClause;
            boolean bl3 = false;
            DmlUtilKt.space((DdlBuilder)builder, (boolean)task.getInsertNewLines());
            this.produce(it, builder, (DmlTask)task, true);
        }
        OrderBy orderBy = task.getOrderBy();
        if (orderBy != null) {
            whereClause = orderBy;
            bl2 = false;
            bl = false;
            it = whereClause;
            boolean bl4 = false;
            DmlUtilKt.space((DdlBuilder)builder, (boolean)task.getInsertNewLines());
            this.produce((OrderBy)it, builder);
        }
        if (limited) {
            Companion.LimitPlace.BOTH.appendLimit(builder, this, dialect, limitPlace, task.getLimit(), task.getOffset(), false);
            Companion.LimitPlace.END.appendLimit(builder, this, dialect, limitPlace, task.getLimit(), task.getOffset(), false);
        }
        return builder;
    }

    @NotNull
    protected DdlBuilder deleteRows(@NotNull DdlBuilder builder, @NotNull DeleteRowsTask task) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            DasTable dasTable = task.getTable();
            if (dasTable == null) {
                return builder;
            }
            DasTable table = dasTable;
            String alias = this.deleteRowsTableAlias(task);
            builder.keyword("DELETE").space().keyword("FROM").space().qualifiedRef((DasObject)table);
            if (alias != null) {
                builder.space().alias(alias);
            }
            WhereClause whereClause = task.getWhereClause();
            if (whereClause == null) break block2;
            WhereClause whereClause2 = whereClause;
            boolean bl = false;
            boolean bl2 = false;
            WhereClause it = whereClause2;
            boolean bl3 = false;
            DmlUtilKt.space((DdlBuilder)builder, (boolean)task.getInsertNewLines());
            this.produce(it, builder, (DmlTask)task, true);
        }
        return builder;
    }

    @Nullable
    protected String deleteRowsTableAlias(@NotNull DeleteRowsTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        return null;
    }

    public void produce(@Nullable WhereClause whereClause, @NotNull DdlBuilder builder, @NotNull DmlTask task) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.produce(whereClause, builder, task, false);
    }

    protected final void produce(@Nullable WhereClause whereClause, @NotNull DdlBuilder builder, @NotNull DmlTask task, boolean printWhereKeyword) {
        block1: {
            WhereClause whereClause2;
            block2: {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                    Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                    whereClause2 = whereClause;
                    if (!(whereClause2 instanceof ValuesWhereClause)) break block0;
                    this.produce((ValuesWhereClause)whereClause, builder, task, printWhereKeyword);
                    break block1;
                }
                if (!(whereClause2 instanceof PredicatesWhereClause)) break block2;
                this.produce((PredicatesWhereClause)whereClause, builder, task, printWhereKeyword);
                break block1;
            }
            if (!(whereClause2 instanceof PlainWhereClause)) break block1;
            this.produce((PlainWhereClause)whereClause, builder, printWhereKeyword);
        }
    }

    protected final void produce(@NotNull OrderBy orderBy, @NotNull DdlBuilder builder) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)orderBy, (String)"orderBy");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            OrderBy orderBy2 = orderBy;
            if (!(orderBy2 instanceof ColumnsOrderBy)) break block0;
            this.produce((ColumnsOrderBy)orderBy, builder);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void produce(ColumnsOrderBy orderBy, DdlBuilder builder) {
        boolean first2 = true;
        for (Pair pair : orderBy.getColumns()) {
            void name2;
            String string = (String)pair.component1();
            RowSortOrder.Type order = (RowSortOrder.Type)pair.component2();
            if (first2) {
                builder.keywords(new String[]{"ORDER", "BY"});
                first2 = false;
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)builder.symbol(","), (String)"builder.symbol(\",\")");
            }
            builder.space().columnRef((String)name2);
            if (order == RowSortOrder.Type.ASC) continue;
            builder.space().keyword(order.toString());
        }
    }

    private final void produce(ValuesWhereClause whereClause, DdlBuilder builder, DmlTask task, boolean printWhereKeyword) {
        if (!(task instanceof DmlTaskWithTable)) {
            return;
        }
        List predicates = whereClause.getPredicates(this.dbms, ((DmlTaskWithTable)task).getAlias(), ((DmlTaskWithTable)task).getVersion(), DmlTaskKt.isUpdate((DmlTask)task));
        this.produce(builder, task, predicates, whereClause.getOp(), printWhereKeyword, (Function2<? super ColumnRef, ? super PredicateValue, Unit>)whereClause.getProcessor());
    }

    private final void produce(PredicatesWhereClause whereClause, DdlBuilder builder, DmlTask task, boolean printWhereKeyword) {
        this.produce(builder, task, whereClause.getPredicates(), whereClause.getOp(), printWhereKeyword, (Function2<? super ColumnRef, ? super PredicateValue, Unit>)whereClause.getProcessor());
    }

    private final void produce(DdlBuilder builder, DmlTask task, List<PredicatesHelper.PredicateProducer> predicates, String op, boolean printWhereKeyword, Function2<? super ColumnRef, ? super PredicateValue, Unit> processor) {
        if (!(task instanceof DmlTaskWithTable) || predicates.isEmpty()) {
            return;
        }
        if (printWhereKeyword) {
            builder.keyword("WHERE").space();
        }
        boolean first2 = true;
        for (PredicatesHelper.PredicateProducer predicate : predicates) {
            if (first2) {
                first2 = false;
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)DmlUtilKt.space((DdlBuilder)builder, (boolean)((DmlTaskWithTable)task).getInsertNewLines()).keyword(op).space(), (String)"builder.space(task.inser\u2026ines).keyword(op).space()");
            }
            if (processor != null) {
                Iterable $this$forEach$iv = predicate.getColumnRefs();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ColumnRef it = (ColumnRef)element$iv;
                    boolean bl = false;
                    processor.invoke((Object)it, (Object)predicate.getValue());
                }
            }
            predicate.getProduce().invoke((Object)builder);
        }
    }

    private final void produce(PlainWhereClause whereClause, DdlBuilder builder, boolean printWhereKeyword) {
        if (StringsKt.isBlank((CharSequence)whereClause.getFilter())) {
            return;
        }
        if (printWhereKeyword) {
            builder.keyword("WHERE");
        }
        builder.space().plain(whereClause.getFilter());
    }

    @NotNull
    protected DdlBuilder appendRowId(@NotNull DdlBuilder builder, @NotNull String alias) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        return builder;
    }

    protected void appendFromTable(@NotNull DdlBuilder builder, @NotNull DasTable dasTable, @NotNull String alias) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)dasTable, (String)"dasTable");
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        builder.keyword("FROM").space().qualifiedRef((DasObject)dasTable).space().alias(alias);
    }

    protected final void appendColumns(@NotNull DdlBuilder builder, @Nullable DasTable table, @NotNull QueryColumns columns, @Nullable String alias) {
        block1: {
            QueryColumns queryColumns;
            block0: {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                Intrinsics.checkNotNullParameter((Object)columns, (String)"columns");
                queryColumns = columns;
                if (!(queryColumns instanceof ColumnRefs)) break block0;
                this.appendColumns(builder, table, ((ColumnRefs)columns).getColumns(), alias);
                break block1;
            }
            if (!(queryColumns instanceof CountAll)) break block1;
            Intrinsics.checkNotNullExpressionValue((Object)builder.keyword("COUNT").symbol("(").symbol("*").symbol(")"), (String)"builder.keyword(\"COUNT\")\u2026).symbol(\"*\").symbol(\")\")");
        }
    }

    protected void appendColumns(@NotNull DdlBuilder builder, @Nullable DasTable table, @NotNull List<? extends ColumnRef> columns, @Nullable String alias) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        if (columns.isEmpty()) {
            if (alias != null) {
                builder.alias(alias).symbol(".");
            }
            Intrinsics.checkNotNullExpressionValue((Object)builder.symbol("*"), (String)"builder.symbol(\"*\")");
        } else {
            this.appendColumnList(alias, builder, (Iterable<? extends ColumnRef>)columns);
        }
    }

    private final void appendColumnList(String alias, DdlBuilder builder, Iterable<? extends ColumnRef> columns) {
        DialectUtils.appendCommaSeparated((DdlBuilder)builder, (Iterable)ContainerUtil.map(columns, (Function)((Function)new Function<ColumnRef, Consumer<DdlBuilder>>(alias){
            final /* synthetic */ String $alias;

            public final Consumer<DdlBuilder> fun(ColumnRef column2) {
                return (Consumer)new Consumer<DdlBuilder>(this, column2){
                    final /* synthetic */ appendColumnList.1 this$0;
                    final /* synthetic */ ColumnRef $column;

                    public final void consume(@NotNull DdlBuilder b) {
                        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                        String string = this.this$0.$alias;
                        ColumnRef columnRef = this.$column;
                        Intrinsics.checkNotNullExpressionValue((Object)columnRef, (String)"column");
                        PredicatesUtilKt.identifier((DdlBuilder)b, (String)string, (ColumnRef)columnRef);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$column = columnRef;
                    }
                };
            }
            {
                this.$alias = string;
            }
        })));
    }

    private final DmlGenerator.Companion.WrapQueryResult wrapInSelect(DdlBuilder builder, String query, Project project, SelectTask task) {
        int offset2;
        block6: {
            WhereClause it;
            boolean bl;
            boolean bl2;
            WhereClause whereClause;
            Integer offset;
            SqlQueryExpression queryExpression;
            if (query == null) {
                return null;
            }
            String string = StringUtil.trimEnd((String)query, (String)";");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.trimEnd(query, \";\")");
            String queryText = string;
            SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect((Dbms)this.dbms);
            Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialect, (String)"DbSqlUtil.getSqlDialect(dbms)");
            SqlLanguageDialect dialect = sqlLanguageDialect;
            if (task.getColumns() instanceof CountAll) {
                queryText = this.removeOrderByClause(project, queryText, dialect);
            }
            SqlResultSetExpression sqlResultSetExpression = DbSqlUtil.parseSqlQuery((Project)project, (SqlLanguageDialect)dialect, (String)queryText, null);
            if (sqlResultSetExpression == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)sqlResultSetExpression, (String)"DbSqlUtil.parseSqlQuery(\u2026ext, null) ?: return null");
            SqlResultSetExpression e2 = sqlResultSetExpression;
            if (Intrinsics.areEqual((Object)task.getColumns(), (Object)CountAll.INSTANCE) && (queryExpression = this.findQuery(e2)) != null && (offset = this.buildOptimizedCountQuery(builder, queryExpression, queryText)) != null) {
                return new DmlGenerator.Companion.WrapQueryResult(builder, offset.intValue());
            }
            builder.keyword("SELECT").space();
            this.appendColumns(builder, task.getTable(), task.getColumns(), task.getAlias());
            builder.space().keyword("FROM").space().symbol("(");
            int currentHeadLength = builder.length();
            String string2 = task.getAlias();
            if (string2 == null) {
                string2 = "t";
            }
            offset2 = currentHeadLength + this.appendWrappedQueryTail(builder, e2, queryText, string2);
            WhereClause whereClause2 = task.getWhereClause();
            if (whereClause2 != null) {
                whereClause = whereClause2;
                bl2 = false;
                bl = false;
                it = whereClause;
                boolean bl3 = false;
                DmlUtilKt.space((DdlBuilder)builder, (boolean)task.getInsertNewLines());
                this.produce(it, builder, (DmlTask)task, true);
            }
            OrderBy orderBy = task.getOrderBy();
            if (orderBy == null) break block6;
            whereClause = orderBy;
            bl2 = false;
            bl = false;
            it = whereClause;
            boolean bl4 = false;
            DmlUtilKt.space((DdlBuilder)builder, (boolean)task.getInsertNewLines());
            this.produce((OrderBy)it, builder);
        }
        return new DmlGenerator.Companion.WrapQueryResult(builder, offset2);
    }

    private final Integer buildOptimizedCountQuery(DdlBuilder builder, SqlQueryExpression query, String queryText) {
        SqlSelectClause sqlSelectClause = query.getSelectClause();
        if (sqlSelectClause == null) {
            return null;
        }
        SqlSelectClause selectClause = sqlSelectClause;
        Iterator iterator = selectClause.getOptions().iterator();
        while (iterator.hasNext()) {
            SqlSelectOption option;
            SqlSelectOption sqlSelectOption = option = (SqlSelectOption)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)sqlSelectOption, (String)"option");
            if (!StringUtil.startsWithIgnoreCase((String)sqlSelectOption.getOptionName(), (String)"DISTINCT") && option.getClause() == null) continue;
            return null;
        }
        SqlTableExpression tableExp = query.getTableExpression();
        if (tableExp == null || tableExp.getHavingClause() != null || tableExp.getGroupByClause() != null) {
            return null;
        }
        List list = selectClause.getExpressions();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"selectClause.expressions");
        List expressions = list;
        for (SqlExpression e2 : expressions) {
            JBIterable jBIterable = ((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)e2)).preOrderDfsTraversal().filter(SqlFunctionCallExpression.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"SyntaxTraverser.psiTrave\u2026llExpression::class.java)");
            if (jBIterable.isEmpty()) continue;
            return null;
        }
        SqlExpression firstExpression = (SqlExpression)ContainerUtil.getFirstItem((List)expressions);
        SqlExpression lastExpression = (SqlExpression)ContainerUtil.getLastItem((List)expressions);
        if (firstExpression == null || lastExpression == null) {
            return null;
        }
        TextRange textRange = firstExpression.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"firstExpression.textRange");
        int expressionsStartOffset = textRange.getStartOffset();
        TextRange textRange2 = lastExpression.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"lastExpression.textRange");
        int expressionsEndOffset = textRange2.getEndOffset();
        DdlBuilder ddlBuilder = builder.clear();
        String string = queryText;
        int n = 0;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, expressionsStartOffset);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        DdlBuilder ddlBuilder2 = ddlBuilder.plain(string3).keyword("COUNT").symbol("(").symbol("*").symbol(")");
        string = queryText;
        n = 0;
        String string4 = string;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(expressionsEndOffset);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
        ddlBuilder2.plain(string5);
        return builder.length() - queryText.length();
    }

    private final String removeOrderByClause(Project project, String query, SqlLanguageDialect dialect) {
        SqlResultSetExpression sqlResultSetExpression = DbSqlUtil.parseSqlQuery((Project)project, (SqlLanguageDialect)dialect, (String)query, null);
        if (sqlResultSetExpression == null) {
            return query;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sqlResultSetExpression, (String)"DbSqlUtil.parseSqlQuery(\u2026ry, null) ?: return query");
        SqlResultSetExpression e2 = sqlResultSetExpression;
        SqlQueryExpression queryExpression = this.findQuery(e2);
        SqlOrderByClause sqlOrderByClause = (SqlOrderByClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)queryExpression), SqlOrderByClause.class);
        if (sqlOrderByClause == null) {
            return query;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sqlOrderByClause, (String)"PsiTreeUtil.getChildOfTy\u2026ass.java) ?: return query");
        SqlOrderByClause clause = sqlOrderByClause;
        StringBuilder stringBuilder = new StringBuilder();
        String string = query;
        int n = 0;
        TextRange textRange = clause.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"clause.textRange");
        int n2 = textRange.getStartOffset();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        StringBuilder stringBuilder2 = stringBuilder.append(string3);
        string = query;
        TextRange textRange2 = clause.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"clause.textRange");
        n = textRange2.getEndOffset();
        n2 = 0;
        String string4 = string;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
        String queryText = stringBuilder2.append(string5).toString();
        String string6 = StringUtil.trimEnd((String)queryText, (String)" ");
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"StringUtil.trimEnd(queryText, \" \")");
        return string6;
    }

    private final SqlQueryExpression findQuery(SqlResultSetExpression e2) {
        SqlQueryExpression sqlQueryExpression;
        SqlResultSetExpression sqlResultSetExpression = e2;
        if (sqlResultSetExpression instanceof SqlWithQueryExpression) {
            SqlExpression sqlExpression = ((SqlWithQueryExpression)e2).getExpression();
            if (!(sqlExpression instanceof SqlQueryExpression)) {
                sqlExpression = null;
            }
            sqlQueryExpression = (SqlQueryExpression)sqlExpression;
        } else {
            sqlQueryExpression = sqlResultSetExpression instanceof SqlQueryExpression ? (SqlQueryExpression)e2 : null;
        }
        return sqlQueryExpression;
    }

    private final int appendWrappedQueryTail(DdlBuilder head, SqlResultSetExpression e2, String query, String alias) {
        DatabaseDialectEx databaseDialectEx = head.getDialect();
        Intrinsics.checkNotNullExpressionValue((Object)databaseDialectEx, (String)"head.dialect");
        Dbms dbms = databaseDialectEx.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"head.dialect.dbms");
        boolean needSelectTargetAliases = dbms.isMicrosoft();
        int placeholdersOffset = 0;
        if (needSelectTargetAliases) {
            TIntArrayList endOffsets = new TIntArrayList();
            Iterator iterator = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)e2)).filter(SqlSelectClause.class).iterator();
            while (iterator.hasNext()) {
                SqlSelectClause selectClause;
                SqlSelectClause sqlSelectClause = selectClause = (SqlSelectClause)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)sqlSelectClause, (String)"selectClause");
                for (SqlExpression expression : sqlSelectClause.getExpressions()) {
                    if (expression instanceof SqlAsExpression || expression instanceof SqlReferenceExpression) continue;
                    SqlExpression sqlExpression = expression;
                    Intrinsics.checkNotNullExpressionValue((Object)sqlExpression, (String)"expression");
                    TextRange textRange = sqlExpression.getTextRange();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"expression.textRange");
                    endOffsets.add(textRange.getEndOffset());
                }
            }
            endOffsets.sort();
            int prevIdx = 0;
            int count = 0;
            int len = endOffsets.size();
            for (int i2 = 0; i2 < len; ++i2) {
                int offset = endOffsets.get(i2);
                String string = query;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(prevIdx, offset);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                head.plain(string3);
                String name2 = "_" + ++count;
                placeholdersOffset += name2.length();
                head.space().columnRef(name2);
                prevIdx = offset;
            }
            String string = e2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.text");
            String string4 = string;
            boolean bl = false;
            String string5 = string4;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(prevIdx);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
            head.plain(string6);
        } else {
            head.plain(query);
        }
        head.symbol(")").space().alias(alias);
        return placeholdersOffset;
    }

    @NotNull
    protected DdlBuilder appendLimit(@NotNull DdlBuilder builder, @NotNull DatabaseDialectEx dialect, int limit, int offset, boolean atBeginning) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        DdlBuilder b = builder;
        if (!DbImplUtil.isPageSizeUnlimited((int)limit)) {
            b = this.appendNumericProperty(builder, "LIMIT", limit);
        }
        if (offset != 0 && DbImplUtil.supportsOffset((Dbms)this.dbms)) {
            b = this.appendNumericProperty(builder, "OFFSET", offset);
        }
        return b;
    }

    @NotNull
    protected final DdlBuilder top(@NotNull DdlBuilder builder, @NotNull String topWord, int limit) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)topWord, (String)"topWord");
        DdlBuilder ddlBuilder = builder.keyword(topWord).space().literal(String.valueOf(limit)).space();
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"builder.keyword(topWord)\u2026limit.toString()).space()");
        return ddlBuilder;
    }

    @NotNull
    protected final DdlBuilder appendNumericProperty(@NotNull DdlBuilder builder, @NotNull String property, int value) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        DdlBuilder ddlBuilder = builder.newLine().keyword(property).space().literal(String.valueOf(value));
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"builder.newLine().keywor\u2026literal(value.toString())");
        return ddlBuilder;
    }

    @NotNull
    protected final DdlBuilder fetchFirst(@NotNull DdlBuilder builder, int rows) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        DdlBuilder ddlBuilder = builder.newLine().keywords(new String[]{"FETCH", "FIRST"}).space().literal(String.valueOf(rows)).space().keywords(new String[]{"ROWS", "ONLY"});
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"builder.newLine().keywor\u2026.keywords(\"ROWS\", \"ONLY\")");
        return ddlBuilder;
    }

    @NotNull
    protected final DdlBuilder rowNumLimit(@NotNull DdlBuilder builder, int rows, boolean atBeginning) {
        DdlBuilder ddlBuilder;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        if (atBeginning) {
            DdlBuilder ddlBuilder2 = builder.keyword("SELECT").space().symbol("*").space().keyword("FROM").space().symbol("(").indent("    ").newLine();
            ddlBuilder = ddlBuilder2;
            Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder2, (String)"builder.keyword(\"SELECT\"\u2026.indent(\"    \").newLine()");
        } else {
            DdlBuilder ddlBuilder3 = builder.indent(null).newLine().symbol(")").space().keyword("WHERE").space().keyword("ROWNUM").space().symbol("<=").space().literal(String.valueOf(rows));
            ddlBuilder = ddlBuilder3;
            Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder3, (String)"builder.indent(null).new\u2026.literal(rows.toString())");
        }
        return ddlBuilder;
    }

    @NotNull
    public final Dbms getDbms() {
        return this.dbms;
    }

    public BaseDmlGenerator(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        this.dbms = dbms;
        this.emptyWhereClause = "";
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/dialects/base/BaseDmlGenerator$Companion;", "", "()V", "LimitPlace", "intellij.database.dialects.base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/dialects/base/BaseDmlGenerator$Companion$LimitPlace;", "", "(Ljava/lang/String;I)V", "appendLimit", "Lcom/intellij/database/util/DdlBuilder;", "builder", "generator", "Lcom/intellij/database/dialects/base/BaseDmlGenerator;", "dialect", "Lcom/intellij/database/dialects/DatabaseDialectEx;", "place", "limit", "", "offset", "atBeginning", "", "BEGIN", "END", "BOTH", "intellij.database.dialects.base"})
        public static final class LimitPlace
        extends Enum<LimitPlace> {
            public static final /* enum */ LimitPlace BEGIN;
            public static final /* enum */ LimitPlace END;
            public static final /* enum */ LimitPlace BOTH;
            private static final /* synthetic */ LimitPlace[] $VALUES;

            static {
                LimitPlace[] limitPlaceArray = new LimitPlace[3];
                LimitPlace[] limitPlaceArray2 = limitPlaceArray;
                limitPlaceArray[0] = BEGIN = new LimitPlace();
                limitPlaceArray[1] = END = new LimitPlace();
                limitPlaceArray[2] = BOTH = new LimitPlace();
                $VALUES = limitPlaceArray;
            }

            @NotNull
            public final DdlBuilder appendLimit(@NotNull DdlBuilder builder, @NotNull BaseDmlGenerator generator, @NotNull DatabaseDialectEx dialect, @NotNull LimitPlace place, int limit, int offset, boolean atBeginning) {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
                Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
                Intrinsics.checkNotNullParameter((Object)((Object)place), (String)"place");
                return place == this ? generator.appendLimit(builder, dialect, limit, offset, atBeginning) : builder;
            }

            public static LimitPlace[] values() {
                return (LimitPlace[])$VALUES.clone();
            }

            public static LimitPlace valueOf(String string) {
                return Enum.valueOf(LimitPlace.class, string);
            }
        }
    }
}

