/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.io.netty.handler.codec.http2;

import com.android.tools.idea.io.netty.handler.codec.http2.Http2CodecUtil;
import com.android.tools.idea.io.netty.handler.codec.http2.Http2Connection;
import com.android.tools.idea.io.netty.handler.codec.http2.Http2ConnectionAdapter;
import com.android.tools.idea.io.netty.handler.codec.http2.Http2Error;
import com.android.tools.idea.io.netty.handler.codec.http2.Http2Exception;
import com.android.tools.idea.io.netty.handler.codec.http2.Http2Stream;
import com.android.tools.idea.io.netty.handler.codec.http2.StreamByteDistributor;
import com.android.tools.idea.io.netty.util.internal.MathUtil;
import com.android.tools.idea.io.netty.util.internal.ObjectUtil;
import com.android.tools.idea.io.netty.util.internal.PriorityQueue;
import com.android.tools.idea.io.netty.util.internal.PriorityQueueNode;
import java.util.Queue;

public final class WeightedFairQueueByteDistributor
implements StreamByteDistributor {
    private final Http2Connection.PropertyKey stateKey;
    private final State connectionState;
    private int allocationQuantum = 1024;

    public WeightedFairQueueByteDistributor(Http2Connection connection) {
        this.stateKey = connection.newKey();
        Http2Stream connectionStream = connection.connectionStream();
        this.connectionState = new State(connectionStream, 16);
        connectionStream.setProperty(this.stateKey, this.connectionState);
        connection.addListener(new Http2ConnectionAdapter(){

            @Override
            public void onStreamAdded(Http2Stream stream) {
                stream.setProperty(WeightedFairQueueByteDistributor.this.stateKey, new State(stream));
            }

            @Override
            public void onWeightChanged(Http2Stream stream, short oldWeight) {
                Http2Stream parent;
                if (((WeightedFairQueueByteDistributor)WeightedFairQueueByteDistributor.this).state((Http2Stream)stream).activeCountForTree != 0 && (parent = stream.parent()) != null) {
                    ((WeightedFairQueueByteDistributor)WeightedFairQueueByteDistributor.this).state((Http2Stream)parent).totalQueuedWeights += (long)(stream.weight() - oldWeight);
                }
            }

            @Override
            public void onStreamClosed(Http2Stream stream) {
                WeightedFairQueueByteDistributor.this.state(stream).close();
            }

            @Override
            public void onPriorityTreeParentChanged(Http2Stream stream, Http2Stream oldParent) {
                Http2Stream parent = stream.parent();
                if (parent != null) {
                    State state = WeightedFairQueueByteDistributor.this.state(stream);
                    if (state.activeCountForTree != 0) {
                        State pState = WeightedFairQueueByteDistributor.this.state(parent);
                        pState.offerAndInitializePseudoTime(state);
                        pState.isActiveCountChangeForTree(state.activeCountForTree);
                    }
                }
            }

            @Override
            public void onPriorityTreeParentChanging(Http2Stream stream, Http2Stream newParent) {
                Http2Stream parent = stream.parent();
                if (parent != null) {
                    State state = WeightedFairQueueByteDistributor.this.state(stream);
                    if (state.activeCountForTree != 0) {
                        State pState = WeightedFairQueueByteDistributor.this.state(parent);
                        pState.remove(state);
                        pState.isActiveCountChangeForTree(-state.activeCountForTree);
                    }
                }
            }
        });
    }

    @Override
    public void updateStreamableBytes(StreamByteDistributor.StreamState state) {
        this.state(state.stream()).updateStreamableBytes(Http2CodecUtil.streamableBytes(state), state.hasFrame() && state.windowSize() >= 0);
    }

    @Override
    public boolean distribute(int maxBytes, StreamByteDistributor.Writer writer) throws Http2Exception {
        int oldIsActiveCountForTree;
        ObjectUtil.checkNotNull(writer, "writer");
        if (this.connectionState.activeCountForTree == 0) {
            return false;
        }
        do {
            oldIsActiveCountForTree = this.connectionState.activeCountForTree;
            maxBytes -= this.distributeToChildren(maxBytes, writer, this.connectionState);
        } while (this.connectionState.activeCountForTree != 0 && (maxBytes > 0 || oldIsActiveCountForTree != this.connectionState.activeCountForTree));
        return this.connectionState.activeCountForTree != 0;
    }

    public void allocationQuantum(int allocationQuantum) {
        if (allocationQuantum <= 0) {
            throw new IllegalArgumentException("allocationQuantum must be > 0");
        }
        this.allocationQuantum = allocationQuantum;
    }

    private int distribute(int maxBytes, StreamByteDistributor.Writer writer, State state) throws Http2Exception {
        if (state.active) {
            int nsent = Math.min(maxBytes, state.streamableBytes);
            state.write(nsent, writer);
            if (nsent == 0 && maxBytes != 0) {
                state.updateStreamableBytes(state.streamableBytes, false);
            }
            return nsent;
        }
        return this.distributeToChildren(maxBytes, writer, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int distributeToChildren(int maxBytes, StreamByteDistributor.Writer writer, State state) throws Http2Exception {
        long oldTotalQueuedWeights = state.totalQueuedWeights;
        State childState = state.poll();
        State nextChildState = state.peek();
        try {
            assert (nextChildState == null || nextChildState.pseudoTimeToWrite >= childState.pseudoTimeToWrite) : "nextChildState.pseudoTime(" + nextChildState.pseudoTimeToWrite + ") < " + " childState.pseudoTime(" + childState.pseudoTimeToWrite + ")";
            int nsent = this.distribute(nextChildState == null ? maxBytes : Math.min(maxBytes, (int)Math.min((nextChildState.pseudoTimeToWrite - childState.pseudoTimeToWrite) * (long)childState.stream.weight() / oldTotalQueuedWeights + (long)this.allocationQuantum, Integer.MAX_VALUE)), writer, childState);
            state.pseudoTime += (long)nsent;
            childState.updatePseudoTime(state, nsent, oldTotalQueuedWeights);
            int n = nsent;
            return n;
        }
        finally {
            if (childState.activeCountForTree != 0) {
                state.offer(childState);
            }
        }
    }

    private State state(Http2Stream stream) {
        return (State)stream.getProperty(this.stateKey);
    }

    int streamableBytes0(Http2Stream stream) {
        return this.state((Http2Stream)stream).streamableBytes;
    }

    private final class State
    implements PriorityQueueNode<State> {
        final Http2Stream stream;
        private final Queue<State> queue;
        int streamableBytes;
        int activeCountForTree;
        private int priorityQueueIndex = -1;
        long pseudoTimeToWrite;
        long pseudoTime;
        long totalQueuedWeights;
        boolean active;

        State(Http2Stream stream) {
            this(stream, 0);
        }

        State(Http2Stream stream, int initialSize) {
            this.stream = stream;
            this.queue = new PriorityQueue<State>(initialSize);
        }

        void write(int numBytes, StreamByteDistributor.Writer writer) throws Http2Exception {
            try {
                writer.write(this.stream, numBytes);
            }
            catch (Throwable t) {
                throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, t, "byte distribution write error", new Object[0]);
            }
        }

        void isActiveCountChangeForTree(int increment) {
            assert (this.activeCountForTree + increment >= 0);
            this.activeCountForTree += increment;
            if (!this.stream.isRoot()) {
                State pState = WeightedFairQueueByteDistributor.this.state(this.stream.parent());
                if (this.activeCountForTree == 0) {
                    pState.remove(this);
                } else if (this.activeCountForTree - increment == 0) {
                    pState.offerAndInitializePseudoTime(this);
                }
                pState.isActiveCountChangeForTree(increment);
            }
        }

        void updateStreamableBytes(int newStreamableBytes, boolean isActive) {
            if (this.active != isActive) {
                this.isActiveCountChangeForTree(isActive ? 1 : -1);
                this.active = isActive;
            }
            this.streamableBytes = newStreamableBytes;
        }

        void updatePseudoTime(State parentState, int nsent, long totalQueuedWeights) {
            assert (this.stream.id() != 0 && nsent >= 0);
            this.pseudoTimeToWrite = Math.min(this.pseudoTimeToWrite, parentState.pseudoTime) + (long)nsent * totalQueuedWeights / (long)this.stream.weight();
        }

        void offerAndInitializePseudoTime(State state) {
            state.pseudoTimeToWrite = this.pseudoTime;
            this.offer(state);
        }

        void offer(State state) {
            this.queue.offer(state);
            this.totalQueuedWeights += (long)state.stream.weight();
        }

        State poll() {
            State state = this.queue.poll();
            this.totalQueuedWeights -= (long)state.stream.weight();
            return state;
        }

        void remove(State state) {
            if (this.queue.remove(state)) {
                this.totalQueuedWeights -= (long)state.stream.weight();
            }
        }

        State peek() {
            return this.queue.peek();
        }

        void close() {
            this.updateStreamableBytes(0, false);
        }

        @Override
        public int compareTo(State o) {
            return MathUtil.compare(this.pseudoTimeToWrite, o.pseudoTimeToWrite);
        }

        @Override
        public int priorityQueueIndex() {
            return this.priorityQueueIndex;
        }

        @Override
        public void priorityQueueIndex(int i) {
            this.priorityQueueIndex = i;
        }
    }
}

