/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.recommenders.models;

import com.intellij.recommenders.java.util.ArtifactRevisionId;
import com.intellij.recommenders.java.util.ModelRevisionId;
import com.intellij.recommenders.java.util.Version;
import com.intellij.recommenders.models.ModelsIndex;
import com.intellij.recommenders.models.ModelsIndexService;
import com.intellij.recommenders.models.ModelsRepository;
import com.intellij.serviceContainer.NonInjectable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0001\u001eB\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0013H\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0016\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u0018H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u0010H\u0002R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001f"}, d2={"Lcom/intellij/recommenders/models/ModelsIndexDefaultImpl;", "Lcom/intellij/recommenders/models/ModelsIndex;", "Lcom/intellij/recommenders/models/ModelsIndexService;", "repository", "Lcom/intellij/recommenders/models/ModelsRepository;", "(Lcom/intellij/recommenders/models/ModelsRepository;)V", "content", "", "", "", "Lcom/intellij/recommenders/java/util/ArtifactRevisionId;", "getRepository", "()Lcom/intellij/recommenders/models/ModelsRepository;", "computeDistance", "", "it", "Lcom/intellij/recommenders/java/util/Version;", "startingPoint", "findAll", "", "request", "Lcom/intellij/recommenders/java/util/ModelRevisionId;", "findClosestVersion", "candidates", "", "findOne", "refresh", "", "toVersionInt", "version", "Companion", "intellij.recommenders"})
public class ModelsIndexDefaultImpl
implements ModelsIndex,
ModelsIndexService {
    private Map<String, ? extends Set<ArtifactRevisionId>> content;
    @NotNull
    private final ModelsRepository repository;
    @NotNull
    private static final ArtifactRevisionId INDEX;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public ArtifactRevisionId findOne(@NotNull ModelRevisionId request) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Iterable $this$map$iv = this.findAll(request);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ArtifactRevisionId artifactRevisionId = (ArtifactRevisionId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)Version.Companion.parse(it.getRevision()), (Object)it);
            collection.add(pair);
        }
        Map candidates = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        Version targetVersion = Version.Companion.parse(request.getRevision());
        Version closestVersion = this.findClosestVersion(targetVersion, candidates.keySet());
        return closestVersion != null ? (ArtifactRevisionId)candidates.get(closestVersion) : null;
    }

    @Override
    @NotNull
    public Set<ArtifactRevisionId> findAll(@NotNull ModelRevisionId request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        boolean bl = false;
        return this.content.getOrDefault(request.getGroup() + ':' + request.getModule() + ':' + request.getType(), (Set)new LinkedHashSet());
    }

    @Override
    @NotNull
    public List<ArtifactRevisionId> findAll() {
        return CollectionsKt.flatten((Iterable)this.content.values());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void refresh() {
        boolean bl = false;
        Map newContent = new LinkedHashMap();
        Iterable<Path> iterable = this.repository.refresh(INDEX);
        if (iterable != null) {
            Path path = iterable;
            boolean bl2 = false;
            boolean bl3 = false;
            Path it = path;
            boolean bl4 = false;
            iterable = Files.readAllLines(it);
            if (iterable != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = iterable;
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl5 = false;
                    void v1 = it2;
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                    ArtifactRevisionId artifactRevisionId = ArtifactRevisionId.Companion.parse((String)v1);
                    collection.add(artifactRevisionId);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Object object;
                    void $this$getOrPut$iv;
                    Object item$iv$iv;
                    ArtifactRevisionId it3 = (ArtifactRevisionId)element$iv;
                    boolean bl6 = false;
                    item$iv$iv = newContent;
                    String key$iv = it3.getGroup() + ':' + it3.getModule() + ':' + it3.getType();
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl7 = false;
                        boolean bl8 = false;
                        Set answer$iv = new LinkedHashSet();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    ((Set)object).add(it3);
                }
            }
        }
        this.content = newContent;
    }

    private final Version findClosestVersion(Version startingPoint, Collection<Version> candidates) {
        Object v0;
        if (candidates.isEmpty()) {
            return null;
        }
        Iterable $this$minBy$iv = candidates;
        boolean $i$f$minBy = false;
        Iterable $this$minByOrNull$iv$iv = $this$minBy$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv$iv = $this$minByOrNull$iv$iv.iterator();
        if (!iterator$iv$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv$iv = iterator$iv$iv.next();
            if (!iterator$iv$iv.hasNext()) {
                v0 = minElem$iv$iv;
            } else {
                Version it = (Version)minElem$iv$iv;
                boolean bl = false;
                int minValue$iv$iv = this.computeDistance(it, startingPoint);
                do {
                    Object e$iv$iv = iterator$iv$iv.next();
                    Version it2 = (Version)e$iv$iv;
                    $i$a$-minBy-ModelsIndexDefaultImpl$findClosestVersion$1 = false;
                    int v$iv$iv = this.computeDistance(it2, startingPoint);
                    if (minValue$iv$iv <= v$iv$iv) continue;
                    minElem$iv$iv = e$iv$iv;
                    minValue$iv$iv = v$iv$iv;
                } while (iterator$iv$iv.hasNext());
                v0 = minElem$iv$iv;
            }
        }
        return v0;
    }

    private final int computeDistance(Version it, Version startingPoint) {
        int n = this.toVersionInt(it) - this.toVersionInt(startingPoint);
        boolean bl = false;
        return Math.abs(n);
    }

    private final int toVersionInt(Version version) {
        return version.getMajor() * 100000000 + version.getMinor() * 100000 + version.getPatch();
    }

    @NotNull
    protected final ModelsRepository getRepository() {
        return this.repository;
    }

    @NonInjectable
    public ModelsIndexDefaultImpl(@NotNull ModelsRepository repository) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        this.repository = repository;
        boolean bl = false;
        this.content = MapsKt.emptyMap();
    }

    static {
        Companion = new Companion(null);
        INDEX = ArtifactRevisionId.Companion.of("reserved.recommenders", "index", "", "txt", "0.0.0");
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/recommenders/models/ModelsIndexDefaultImpl$Companion;", "", "()V", "INDEX", "Lcom/intellij/recommenders/java/util/ArtifactRevisionId;", "getINDEX", "()Lcom/intellij/recommenders/java/util/ArtifactRevisionId;", "intellij.recommenders"})
    public static final class Companion {
        @NotNull
        public final ArtifactRevisionId getINDEX() {
            return INDEX;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

