/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.recommenders.java.util;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.intellij.recommenders.java.util.ArtifactId;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\b\u0010\u001b\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u0011\u0010\u0011\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lcom/intellij/recommenders/java/util/ArtifactRevisionId;", "", "artifactId", "Lcom/intellij/recommenders/java/util/ArtifactId;", "revision", "", "(Lcom/intellij/recommenders/java/util/ArtifactId;Ljava/lang/String;)V", "getArtifactId", "()Lcom/intellij/recommenders/java/util/ArtifactId;", "ext", "getExt", "()Ljava/lang/String;", "group", "getGroup", "module", "getModule", "getRevision", "type", "getType", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.recommenders"})
public final class ArtifactRevisionId {
    @NotNull
    private final ArtifactId artifactId;
    @NotNull
    private final String revision;
    private static final Interner<ArtifactRevisionId> interner;
    public static final Companion Companion;

    @NotNull
    public final String getGroup() {
        return this.artifactId.getGroup();
    }

    @NotNull
    public final String getModule() {
        return this.artifactId.getModule();
    }

    @NotNull
    public final String getType() {
        return this.artifactId.getType();
    }

    @NotNull
    public final String getExt() {
        return this.artifactId.getExt();
    }

    @NotNull
    public String toString() {
        return this.getGroup() + ':' + this.getModule() + ':' + this.getType() + ':' + this.getExt() + ':' + this.revision;
    }

    @NotNull
    public final ArtifactId getArtifactId() {
        return this.artifactId;
    }

    @NotNull
    public final String getRevision() {
        return this.revision;
    }

    public ArtifactRevisionId(@NotNull ArtifactId artifactId, @NotNull String revision) {
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)revision, (String)"revision");
        this.artifactId = artifactId;
        this.revision = revision;
    }

    static {
        Companion = new Companion(null);
        interner = Interners.newWeakInterner();
    }

    @NotNull
    public final ArtifactId component1() {
        return this.artifactId;
    }

    @NotNull
    public final String component2() {
        return this.revision;
    }

    @NotNull
    public final ArtifactRevisionId copy(@NotNull ArtifactId artifactId, @NotNull String revision) {
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)revision, (String)"revision");
        return new ArtifactRevisionId(artifactId, revision);
    }

    public static /* synthetic */ ArtifactRevisionId copy$default(ArtifactRevisionId artifactRevisionId, ArtifactId artifactId, String string, int n, Object object) {
        if ((n & 1) != 0) {
            artifactId = artifactRevisionId.artifactId;
        }
        if ((n & 2) != 0) {
            string = artifactRevisionId.revision;
        }
        return artifactRevisionId.copy(artifactId, string);
    }

    public int hashCode() {
        ArtifactId artifactId = this.artifactId;
        String string = this.revision;
        return (artifactId != null ? ((Object)artifactId).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ArtifactRevisionId)) break block3;
                ArtifactRevisionId artifactRevisionId = (ArtifactRevisionId)object;
                if (!Intrinsics.areEqual((Object)this.artifactId, (Object)artifactRevisionId.artifactId) || !Intrinsics.areEqual((Object)this.revision, (Object)artifactRevisionId.revision)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ.\u0010\u0007\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000bR2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/recommenders/java/util/ArtifactRevisionId$Companion;", "", "()V", "interner", "Lcom/google/common/collect/Interner;", "Lcom/intellij/recommenders/java/util/ArtifactRevisionId;", "kotlin.jvm.PlatformType", "of", "artifactId", "Lcom/intellij/recommenders/java/util/ArtifactId;", "revision", "", "group", "module", "type", "ext", "parse", "value", "intellij.recommenders"})
    public static final class Companion {
        @NotNull
        public final ArtifactRevisionId of(@NotNull ArtifactId artifactId, @NotNull String revision) {
            Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
            Intrinsics.checkNotNullParameter((Object)revision, (String)"revision");
            Object object = interner.intern((Object)new ArtifactRevisionId(artifactId, revision));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"interner.intern(\n       \u2026Id(artifactId, revision))");
            return (ArtifactRevisionId)object;
        }

        @NotNull
        public final ArtifactRevisionId of(@NotNull String group, @NotNull String module, @NotNull String type, @NotNull String ext, @NotNull String revision) {
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
            Intrinsics.checkNotNullParameter((Object)revision, (String)"revision");
            return this.of(ArtifactId.Companion.of(group, module, type, ext), revision);
        }

        @NotNull
        public final ArtifactRevisionId parse(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            List parts = StringsKt.split$default((CharSequence)value, (String[])new String[]{":"}, (boolean)false, (int)5, (int)2, null);
            boolean bl = parts.size() == 5;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Cannot parse artifact-revision-id from string '" + value + "': Invalid number of segments.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            return this.of((String)parts.get(0), (String)parts.get(1), (String)parts.get(2), (String)parts.get(3), (String)parts.get(4));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

