/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Asserts {
    private Asserts() {
    }

    public static void arrayFilled(@NotNull Object[] array) {
        if (array == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        for (int i = array.length - 1; i >= 0; --i) {
            if (array[i] != null) continue;
            throw new IllegalArgumentException("array contains null at " + i + "; length=" + array.length);
        }
    }

    public static void fail() {
        throw new IllegalStateException("assertion failed");
    }

    public static void assertEqual(int a, int b) {
        if (a != b) {
            throw new IllegalArgumentException("assertion failed: " + a + " != " + b);
        }
    }

    public static void assertEqual(long a, long b) {
        if (a != b) {
            throw new IllegalArgumentException("assertion failed: " + a + " != " + b);
        }
    }

    public static void assertEqual(double a, double b) {
        if (a != b) {
            throw new IllegalArgumentException("assertion failed: " + a + " != " + b);
        }
    }

    public static void assertEqual(float a, float b) {
        if (a != b) {
            throw new IllegalArgumentException("assertion failed: " + a + " != " + b);
        }
    }

    public static void assertEqual(boolean a, boolean b) {
        if (a != b) {
            throw new IllegalArgumentException("assertion failed: " + a + " != " + b);
        }
    }

    public static void assertEqual(@Nullable Object a, @Nullable Object b) {
        if (!Objects.equals(a, b)) {
            throw new IllegalArgumentException("assertion failed: " + a + " != " + b);
        }
    }
}

