/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.loader;

import com.yourkit.util.Asserts;
import com.yourkit.util.Util;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppVersion {
    @NotNull
    public static final AppVersion CURRENT = new AppVersion("2019.8.126");
    private static final int ELEMENT_COUNT = 3;
    @NotNull
    private final String myOriginal;
    @NotNull
    private final int[] myParsed;
    private final boolean myValid;

    public static boolean isRunningFromSources() {
        return !CURRENT.isValid();
    }

    @NotNull
    public static String getCurrentAsString() {
        return CURRENT.isValid() ? CURRENT.asString() : "running_from_sources";
    }

    public AppVersion(@NotNull String versionAs3Numbers) {
        if (versionAs3Numbers == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myOriginal = versionAs3Numbers;
        int[] parsed = AppVersion.parseVersionAsNumbers(versionAs3Numbers);
        boolean bl = this.myValid = parsed != null;
        if (this.myValid) {
            this.myParsed = parsed;
        } else {
            parsed = AppVersion.parseVersionAsNumbers("2019.8.1");
            if (parsed == null) {
                Asserts.fail();
            }
            this.myParsed = parsed;
        }
    }

    public boolean isValid() {
        return this.myValid;
    }

    public int compareTo(@NotNull AppVersion other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (!this.isValid()) {
            Asserts.fail();
        }
        if (!other.isValid()) {
            Asserts.fail();
        }
        for (int i = 0; i < this.myParsed.length; ++i) {
            int v1 = this.myParsed[i];
            int v2 = other.myParsed[i];
            if (v1 == v2) continue;
            return Util.compare(v1, v2);
        }
        return 0;
    }

    @NotNull
    private String asString() {
        String string = this.myOriginal;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @Nullable
    private static int[] parseVersionAsNumbers(@NotNull String versionStr) {
        if (versionStr == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String[] elements = versionStr.split("\\.");
        if (elements.length != 3) {
            return null;
        }
        int[] result = new int[3];
        for (int i = 0; i < elements.length; ++i) {
            String element = elements[i];
            try {
                result[i] = Integer.parseInt(element);
                continue;
            }
            catch (NumberFormatException ignored) {
                return null;
            }
        }
        return result;
    }

    @NotNull
    public String getYearDotMonth() {
        int year = this.myParsed[0];
        int month = this.myParsed[1];
        String string = year + "." + month;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }
}

