/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.containers.ConcurrentSoftHashMap;
import com.intellij.util.containers.ConcurrentSoftKeySoftValueHashMap;
import com.intellij.util.containers.ConcurrentSoftValueHashMap;
import com.intellij.util.containers.ConcurrentWeakHashMap;
import com.intellij.util.containers.ConcurrentWeakKeySoftValueHashMap;
import com.intellij.util.containers.ConcurrentWeakKeyWeakValueHashMap;
import com.intellij.util.containers.ConcurrentWeakValueHashMap;
import com.intellij.util.containers.FastUtilHashingStrategies;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.SoftHashMap;
import com.intellij.util.containers.WeakHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class CollectionFactory {
    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakMap() {
        return new ConcurrentWeakHashMap(0.75f);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakValueMap() {
        return new ConcurrentWeakValueHashMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftValueMap() {
        return new ConcurrentSoftValueHashMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakIdentityMap() {
        return new ConcurrentWeakHashMap(HashingStrategy.identity());
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakMap() {
        return new WeakHashMap(4, 0.8f, HashingStrategy.canonical());
    }

    @Contract(value="_,_,_ -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeySoftValueIdentityMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return new ConcurrentWeakKeySoftValueHashMap(initialCapacity, loadFactor, concurrencyLevel, HashingStrategy.identity());
    }

    @NotNull
    public static <K, V> Map<K, V> createWeakIdentityMap(int initialCapacity, float loadFactor) {
        return new WeakHashMap(initialCapacity, loadFactor, HashingStrategy.identity());
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeyWeakValueMap() {
        return new ConcurrentWeakKeyWeakValueHashMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), HashingStrategy.canonical());
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeyWeakValueIdentityMap() {
        return new ConcurrentWeakKeyWeakValueHashMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), HashingStrategy.identity());
    }

    @Contract(value="_,_,_ -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return new ConcurrentWeakHashMap(initialCapacity, loadFactor, concurrencyLevel, HashingStrategy.canonical());
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeySoftValueMap() {
        return CollectionFactory.createConcurrentWeakKeySoftValueMap(100, 0.75f, Runtime.getRuntime().availableProcessors());
    }

    @Contract(value="_,_,_,-> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeySoftValueMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return new ConcurrentWeakKeySoftValueHashMap(initialCapacity, loadFactor, concurrencyLevel, HashingStrategy.canonical());
    }

    @NotNull
    public static <T> Map<CharSequence, T> createCharSequenceMap(boolean caseSensitive, int expectedSize, float loadFactor) {
        return new Object2ObjectOpenCustomHashMap(expectedSize, loadFactor, FastUtilHashingStrategies.getCharSequenceStrategy(caseSensitive));
    }

    @NotNull
    public static Set<CharSequence> createCharSequenceSet(boolean caseSensitive, int expectedSize, float loadFactor) {
        return new ObjectOpenCustomHashSet(expectedSize, loadFactor, FastUtilHashingStrategies.getCharSequenceStrategy(caseSensitive));
    }

    @NotNull
    public static Set<CharSequence> createCharSequenceSet(List<CharSequence> items) {
        return new ObjectOpenCustomHashSet(items, FastUtilHashingStrategies.getCharSequenceStrategy(true));
    }

    @NotNull
    public static Set<CharSequence> createCharSequenceSet(boolean caseSensitive, int expectedSize) {
        return new ObjectOpenCustomHashSet(expectedSize, FastUtilHashingStrategies.getCharSequenceStrategy(caseSensitive));
    }

    @NotNull
    public static Set<CharSequence> createCharSequenceSet(boolean caseSensitive) {
        return new ObjectOpenCustomHashSet(FastUtilHashingStrategies.getCharSequenceStrategy(caseSensitive));
    }

    @NotNull
    public static <T> Map<CharSequence, T> createCharSequenceMap(boolean caseSensitive) {
        return new Object2ObjectOpenCustomHashMap(FastUtilHashingStrategies.getCharSequenceStrategy(caseSensitive));
    }

    @NotNull
    public static <T> Map<CharSequence, T> createCharSequenceMap(int capacity, float loadFactory, boolean caseSensitive) {
        return new Object2ObjectOpenCustomHashMap(capacity, loadFactory, FastUtilHashingStrategies.getCharSequenceStrategy(caseSensitive));
    }

    @NotNull
    public static Set<String> createCaseInsensitiveStringSet() {
        return new ObjectOpenCustomHashSet(FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static Set<String> createCaseInsensitiveStringSet(@NotNull Collection<String> items) {
        if (items == null) {
            CollectionFactory.$$$reportNull$$$0(0);
        }
        return new ObjectOpenCustomHashSet(items, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static <V> Map<String, V> createCaseInsensitiveStringMap() {
        return new Object2ObjectOpenCustomHashMap(FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @Contract(value="_,_,_ -> new", pure=true)
    @NotNull
    static <K, V> ConcurrentMap<K, V> createConcurrentSoftKeySoftValueMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return new ConcurrentSoftKeySoftValueHashMap(initialCapacity, loadFactor, concurrencyLevel, HashingStrategy.canonical());
    }

    @Contract(value="_,_,_ -> new", pure=true)
    @NotNull
    static <K, V> ConcurrentMap<K, V> createConcurrentSoftKeySoftValueIdentityMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return new ConcurrentSoftKeySoftValueHashMap(initialCapacity, loadFactor, concurrencyLevel, HashingStrategy.identity());
    }

    @NotNull
    public static Set<String> createFilePathSet() {
        if (SystemInfoRt.isFileSystemCaseSensitive) {
            return new HashSet<String>();
        }
        return CollectionFactory.createCaseInsensitiveStringSet();
    }

    @NotNull
    public static Set<String> createFilePathSet(int expectedSize) {
        return CollectionFactory.createFilePathSet(expectedSize, SystemInfoRt.isFileSystemCaseSensitive);
    }

    @NotNull
    public static Set<String> createFilePathSet(int expectedSize, boolean isFileSystemCaseSensitive) {
        if (isFileSystemCaseSensitive) {
            return new HashSet<String>(expectedSize);
        }
        return new ObjectOpenCustomHashSet(expectedSize, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static Set<String> createFilePathSet(@NotNull Collection<String> paths, boolean isFileSystemCaseSensitive) {
        if (paths == null) {
            CollectionFactory.$$$reportNull$$$0(1);
        }
        if (isFileSystemCaseSensitive) {
            return new HashSet<String>(paths);
        }
        return new ObjectOpenCustomHashSet(paths, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static Set<String> createFilePathSet(String @NotNull [] paths, boolean isFileSystemCaseSensitive) {
        if (paths == null) {
            CollectionFactory.$$$reportNull$$$0(2);
        }
        if (isFileSystemCaseSensitive) {
            return new HashSet<String>(Arrays.asList(paths));
        }
        return new ObjectOpenCustomHashSet((Object[])paths, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static Set<String> createFilePathSet(@NotNull Collection<String> paths) {
        if (paths == null) {
            CollectionFactory.$$$reportNull$$$0(3);
        }
        return CollectionFactory.createFilePathSet(paths, SystemInfoRt.isFileSystemCaseSensitive);
    }

    @NotNull
    public static <V> Map<String, V> createFilePathMap() {
        if (SystemInfoRt.isFileSystemCaseSensitive) {
            return new HashMap();
        }
        return CollectionFactory.createCaseInsensitiveStringMap();
    }

    @NotNull
    public static <V> Map<String, V> createFilePathMap(int expectedSize) {
        return CollectionFactory.createFilePathMap(expectedSize, SystemInfoRt.isFileSystemCaseSensitive);
    }

    @NotNull
    public static <V> Map<String, V> createFilePathMap(int expectedSize, boolean isFileSystemCaseSensitive) {
        if (isFileSystemCaseSensitive) {
            return new HashMap(expectedSize);
        }
        return new Object2ObjectOpenCustomHashMap(expectedSize, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static Set<String> createFilePathLinkedSet() {
        if (SystemInfoRt.isFileSystemCaseSensitive) {
            return new ObjectLinkedOpenHashSet();
        }
        return new ObjectLinkedOpenCustomHashSet(FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static <V> Map<String, V> createFilePathLinkedMap() {
        if (SystemInfoRt.isFileSystemCaseSensitive) {
            return CollectionFactory.createSmallMemoryFootprintLinkedMap();
        }
        return new Object2ObjectLinkedOpenCustomHashMap(FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSmallMemoryFootprintLinkedMap() {
        return new Object2ObjectLinkedOpenHashMap();
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSmallMemoryFootprintMap() {
        return new Object2ObjectOpenHashMap();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSmallMemoryFootprintMap(int expected) {
        return new Object2ObjectOpenHashMap(expected);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSmallMemoryFootprintMap(@NotNull Map<? extends K, ? extends V> map) {
        if (map == null) {
            CollectionFactory.$$$reportNull$$$0(4);
        }
        return new Object2ObjectOpenHashMap(map);
    }

    @Contract(value="_,_ -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSmallMemoryFootprintMap(int expected, float loadFactor) {
        return new Object2ObjectOpenHashMap(expected, loadFactor);
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static <K> Set<K> createSmallMemoryFootprintSet() {
        return new ObjectOpenHashSet();
    }

    @Contract(value="_-> new", pure=true)
    @NotNull
    public static <K> Set<K> createSmallMemoryFootprintSet(int expected) {
        return new ObjectOpenHashSet(expected);
    }

    @Contract(value="_-> new", pure=true)
    @NotNull
    public static <K> Set<K> createSmallMemoryFootprintSet(@NotNull Collection<? extends K> collection) {
        if (collection == null) {
            CollectionFactory.$$$reportNull$$$0(5);
        }
        return new ObjectOpenHashSet(collection);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftMap() {
        return new ConcurrentSoftHashMap();
    }

    @NotNull
    public static <K, V> Map<K, V> createSoftIdentityMap() {
        return new SoftHashMap(HashingStrategy.identity());
    }

    public static void trimMap(@NotNull Map<?, ?> map) {
        if (map == null) {
            CollectionFactory.$$$reportNull$$$0(6);
        }
        if (map instanceof Object2ObjectOpenHashMap) {
            ((Object2ObjectOpenHashMap)map).trim();
        } else if (map instanceof Object2ObjectOpenCustomHashMap) {
            ((Object2ObjectOpenCustomHashMap)map).trim();
        }
    }

    public static void trimSet(@NotNull Set<?> set) {
        if (set == null) {
            CollectionFactory.$$$reportNull$$$0(7);
        }
        if (set instanceof ObjectOpenHashSet) {
            ((ObjectOpenHashSet)set).trim();
        } else if (set instanceof ObjectOpenCustomHashSet) {
            ((ObjectOpenCustomHashSet)set).trim();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/containers/CollectionFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createCaseInsensitiveStringSet";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createFilePathSet";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createSmallMemoryFootprintMap";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createSmallMemoryFootprintSet";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "trimMap";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "trimSet";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

