/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.utils;

import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiClassPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.psi.PsiMethod;
import com.intellij.semantic.SemContributor;
import com.intellij.semantic.SemRegistrar;
import com.intellij.semantic.SemService;
import com.intellij.spring.data.cassandra.jam.EnableCassandraRepositories;
import com.intellij.spring.data.cassandra.jam.EnableReactiveCassandraRepositories;
import com.intellij.spring.data.commons.model.jam.SpringCustomQueryAnnotation;
import com.intellij.spring.data.commons.model.jam.SpringRepositoryDefinition;
import com.intellij.spring.data.couchbase.jam.EnableCouchbaseRepositories;
import com.intellij.spring.data.elasticsearch.jam.EnableElasticsearchRepositories;
import com.intellij.spring.data.gemfire.jam.EnableGemfireRepositories;
import com.intellij.spring.data.jpa.model.jam.EnableJpaRepositories;
import com.intellij.spring.data.keyValue.jam.EnableMapRepositories;
import com.intellij.spring.data.ldap.jam.EnableLdapRepositories;
import com.intellij.spring.data.mongoDB.jam.EnableMongoAuditing;
import com.intellij.spring.data.mongoDB.jam.EnableMongoDBRepositories;
import com.intellij.spring.data.mongoDB.jam.EnableReactiveMongoRepositories;
import com.intellij.spring.data.neo4j.jam.EnableNeo4jRepositories;
import com.intellij.spring.data.redis.jam.EnableRedisRepositories;
import com.intellij.spring.data.rest.SpringProjectionJamComponent;
import com.intellij.spring.data.rest.SpringRepositoryRestResource;
import com.intellij.spring.data.solr.jam.EnableSolrRepositories;
import com.intellij.spring.model.jam.SpringSemContributorUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import org.jetbrains.annotations.NotNull;

final class SpringDataSemContributor
extends SemContributor {
    SpringDataSemContributor() {
    }

    public void registerSemProviders(@NotNull SemRegistrar registrar, @NotNull Project project) {
        if (registrar == null) {
            SpringDataSemContributor.$$$reportNull$$$0(0);
        }
        if (project == null) {
            SpringDataSemContributor.$$$reportNull$$$0(1);
        }
        PsiClassPattern psiClassPattern = PsiJavaPatterns.psiClass().nonAnnotationType();
        SpringRepositoryDefinition.META.register(registrar, (ElementPattern)psiClassPattern.withAnnotation("org.springframework.data.repository.RepositoryDefinition"));
        EnableJpaRepositories.META.register(registrar, (ElementPattern)psiClassPattern.withAnnotation("org.springframework.data.jpa.repository.config.EnableJpaRepositories"));
        EnableNeo4jRepositories.META.register(registrar, (ElementPattern)psiClassPattern.withAnnotation("org.springframework.data.neo4j.config.EnableNeo4jRepositories"));
        EnableGemfireRepositories.META.register(registrar, (ElementPattern)psiClassPattern.withAnnotation("org.springframework.data.gemfire.repository.config.EnableGemfireRepositories"));
        EnableMongoDBRepositories.META.register(registrar, (ElementPattern)psiClassPattern.withAnnotation("org.springframework.data.mongodb.repository.config.EnableMongoRepositories"));
        EnableReactiveMongoRepositories.META.register(registrar, (ElementPattern)psiClassPattern.withAnnotation("org.springframework.data.mongodb.repository.config.EnableReactiveMongoRepositories"));
        EnableMongoAuditing.META.register(registrar, (ElementPattern)psiClassPattern.withAnnotation("org.springframework.data.mongodb.config.EnableMongoAuditing"));
        EnableCassandraRepositories.META.register(registrar, (ElementPattern)psiClassPattern.withAnnotation("org.springframework.data.cassandra.repository.config.EnableCassandraRepositories"));
        EnableReactiveCassandraRepositories.META.register(registrar, (ElementPattern)psiClassPattern.withAnnotation("org.springframework.data.cassandra.repository.config.EnableReactiveCassandraRepositories"));
        EnableElasticsearchRepositories.META.register(registrar, (ElementPattern)psiClassPattern.withAnnotation("org.springframework.data.elasticsearch.repository.config.EnableElasticsearchRepositories"));
        EnableRedisRepositories.META.register(registrar, (ElementPattern)psiClassPattern.withAnnotation("org.springframework.data.redis.repository.configuration.EnableRedisRepositories"));
        EnableSolrRepositories.META.register(registrar, (ElementPattern)psiClassPattern.withAnnotation("org.springframework.data.solr.repository.config.EnableSolrRepositories"));
        EnableLdapRepositories.META.register(registrar, (ElementPattern)psiClassPattern.withAnnotation("org.springframework.ldap.repository.config.EnableLdapRepositories"));
        EnableCouchbaseRepositories.META.register(registrar, (ElementPattern)psiClassPattern.withAnnotation("org.springframework.data.couchbase.repository.config.EnableCouchbaseRepositories"));
        EnableMapRepositories.META.register(registrar, (ElementPattern)psiClassPattern.withAnnotation("org.springframework.data.map.repository.config.EnableMapRepositories"));
        SpringProjectionJamComponent.META.register(registrar, (ElementPattern)psiClassPattern.withAnnotation("org.springframework.data.rest.core.config.Projection"));
        SemService semService = SemService.getSemService((Project)project);
        SpringDataSemContributor.registerRestRepositories(registrar, psiClassPattern, semService);
        SpringDataSemContributor.registerQueryAnnotations(registrar, semService);
    }

    private static void registerQueryAnnotations(SemRegistrar registrar, @NotNull SemService semService) {
        if (semService == null) {
            SpringDataSemContributor.$$$reportNull$$$0(2);
        }
        PsiMethodPattern methodPattern = PsiJavaPatterns.psiMethod().constructor(false);
        SpringSemContributorUtil.registerMetaComponents((SemService)semService, (SemRegistrar)registrar, (ElementPattern)methodPattern, SpringCustomQueryAnnotation.META_KEY, SpringCustomQueryAnnotation.JAM_KEY, (NullableFunction)SpringSemContributorUtil.createFunction(SpringCustomQueryAnnotation.JAM_KEY, SpringCustomQueryAnnotation.class, (Function)SpringSemContributorUtil.getCustomMetaAnnotations((String)"org.springframework.data.annotation.QueryAnnotation"), pair -> new SpringCustomQueryAnnotation((String)pair.first, (PsiMethod)pair.second), null, null));
    }

    private static void registerRestRepositories(SemRegistrar registrar, PsiClassPattern psiClassPattern, @NotNull SemService semService) {
        if (semService == null) {
            SpringDataSemContributor.$$$reportNull$$$0(3);
        }
        SpringSemContributorUtil.registerMetaComponents((SemService)semService, (SemRegistrar)registrar, (ElementPattern)psiClassPattern, SpringRepositoryRestResource.META_KEY, SpringRepositoryRestResource.JAM_KEY, (NullableFunction)SpringSemContributorUtil.createFunction(SpringRepositoryRestResource.JAM_KEY, SpringRepositoryRestResource.class, SpringRepositoryRestResource.getRepositoryRestResourceAnnotations(), SpringRepositoryRestResource.getRepositoryRestResourceProducer(), (Consumer)SpringSemContributorUtil.createStereotypeConsumer()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "semService";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/data/utils/SpringDataSemContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerSemProviders";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "registerQueryAnnotations";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "registerRestRepositories";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

