/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jpa.frameworks.data.util.FrameworksDataBundle;
import com.intellij.jpa.frameworks.data.util.inspections.PartTreeInconsistencyUtils;
import com.intellij.jpa.frameworks.data.util.parser.Part;
import com.intellij.jpa.frameworks.data.util.parser.PartTree;
import com.intellij.jpa.frameworks.data.util.parser.PartTreeParserContext;
import com.intellij.lang.jvm.JvmMethod;
import com.intellij.lang.jvm.actions.ChangeParametersRequest;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.lang.jvm.actions.MethodRequestsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.data.commons.inspections.SpringDataRepositoriesInspection;
import com.intellij.spring.data.commons.util.SpringDataPartTreeParserContext;
import com.intellij.spring.data.commons.util.SpringDataPartTypes;
import com.intellij.spring.data.commons.util.SpringDataUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UMethod;

public class SpringDataRepositoryMethodParametersInspection
extends SpringDataRepositoriesInspection {
    @Override
    protected void checkRepositoryMethod(@NotNull ProblemsHolder holder, UClass repositoryClass, @NotNull UMethod psiMethod, @NotNull Module module, @NotNull Pair<PsiClass, ? extends PsiType> typePair) {
        PsiClass domainClass;
        String methodName;
        PartTree partTree;
        if (holder == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(0);
        }
        if (psiMethod == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(1);
        }
        if (module == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(2);
        }
        if (typePair == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(3);
        }
        if (!SpringDataUtil.hasQueryAnnotation(psiMethod.getJavaPsi()) && !PartTreeInconsistencyUtils.hasUnresolvedPropertyPaths((PartTree)(partTree = new PartTree(methodName = psiMethod.getName(), domainClass = (PsiClass)typePair.getFirst(), (PartTreeParserContext)SpringDataPartTreeParserContext.create())))) {
            this.checkParameters(holder, partTree, psiMethod, domainClass, repositoryClass);
        }
    }

    private void checkParameters(@NotNull ProblemsHolder holder, @NotNull PartTree partTree, @NotNull UMethod psiMethod, @NotNull PsiClass domainClass, UClass repositoryClass) {
        PsiElement identifier;
        if (holder == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(4);
        }
        if (partTree == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(5);
        }
        if (psiMethod == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(6);
        }
        if (domainClass == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(7);
        }
        List parts = partTree.getParts();
        List requiredParameterTypes = PartTreeInconsistencyUtils.getRequiredParameterTypes((Iterable)parts, (Project)psiMethod.getJavaPsi().getProject(), part -> SpringDataRepositoryMethodParametersInspection.isCollectionTypeRequired(part), part -> SpringDataRepositoryMethodParametersInspection.isCollectionElementTypeRequired(part));
        if (!PartTreeInconsistencyUtils.areAssignableTypes((PsiMethod)psiMethod.getJavaPsi(), (List)requiredParameterTypes, (PsiClass)domainClass, (UClass)repositoryClass, (PartTreeInconsistencyUtils.PartTreeParametersCheckHelper)new MyPartTreeParametersChecker()) && (identifier = UElementKt.getSourcePsiElement((UElement)psiMethod.getUastAnchor())) != null) {
            String text = PartTreeInconsistencyUtils.getRequiredParametersTypesToString((List)requiredParameterTypes, (PsiParameterList)psiMethod.getJavaPsi().getParameterList());
            holder.registerProblem(identifier, FrameworksDataBundle.message((String)"required.parameters", (Object[])new Object[]{text}), SpringDataRepositoryMethodParametersInspection.getQuickFixes(psiMethod.getJavaPsi(), parts));
        }
    }

    private static LocalQuickFix[] getQuickFixes(PsiMethod psiMethod, Iterable<Part> requiredParameterTypes) {
        List actions = JvmElementActionFactories.createChangeParametersActions((JvmMethod)psiMethod, (ChangeParametersRequest)MethodRequestsKt.setMethodParametersRequest(SpringDataRepositoryMethodParametersInspection.createParamMap(requiredParameterTypes, psiMethod).entrySet()));
        return IntentionWrapper.wrapToQuickFixes((IntentionAction[])actions.toArray(IntentionAction.EMPTY_ARRAY), (PsiFile)psiMethod.getContainingFile());
    }

    private static boolean isReactiveRepository(UClass uClass) {
        PsiClass psiClass = uClass.getJavaPsi();
        return InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"org.springframework.data.repository.reactive.ReactiveCrudRepository") || InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"org.springframework.data.repository.reactive.RxJava2CrudRepository") || InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"org.springframework.data.repository.kotlin.CoroutineCrudRepository");
    }

    private static boolean isCoroutineRepository(UClass uClass) {
        PsiClass psiClass = uClass.getJavaPsi();
        return InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"org.springframework.data.repository.kotlin.CoroutineCrudRepository");
    }

    @NotNull
    private static String[] getPossibleWrappers(boolean withReactive) {
        ArrayList<String> wrappers = new ArrayList<String>(Collections.singletonList("java.util.Optional"));
        if (withReactive) {
            ContainerUtil.addAll(wrappers, (Object[])new String[]{"reactor.core.publisher.Mono", "rx.Single", "io.reactivex.Maybe", "io.reactivex.Single", "org.reactivestreams.Publisher"});
        }
        String[] stringArray = ArrayUtil.toStringArray(wrappers);
        if (stringArray == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(8);
        }
        return stringArray;
    }

    @NotNull
    private static String[] getPossibleCollections(boolean withReactive, boolean withCoroutines) {
        ArrayList<String> wrappers = new ArrayList<String>(Collections.singletonList("java.util.Collection"));
        if (withReactive) {
            ContainerUtil.addAll(wrappers, (Object[])new String[]{"reactor.core.publisher.Flux", "rx.Observable", "io.reactivex.Flowable", "io.reactivex.Observable", "org.reactivestreams.Publisher"});
        }
        if (withCoroutines) {
            wrappers.add("kotlinx.coroutines.flow.Flow");
        }
        String[] stringArray = ArrayUtil.toStringArray(wrappers);
        if (stringArray == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(9);
        }
        return stringArray;
    }

    private static boolean isNotQueryParameter(@NotNull PsiMethod psiMethod, PsiType parameterType) {
        if (psiMethod == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(10);
        }
        if (InheritanceUtil.isInheritor((PsiType)parameterType, (String)"java.lang.Class")) {
            return true;
        }
        if (InheritanceUtil.isInheritor((PsiType)parameterType, (String)"org.springframework.data.domain.Pageable") || InheritanceUtil.isInheritor((PsiType)parameterType, (String)"org.springframework.data.domain.Sort")) {
            return true;
        }
        return InheritanceUtil.isInheritor((PsiType)parameterType, (String)"org.springframework.data.geo.Distance") && InheritanceUtil.isInheritor((PsiType)psiMethod.getReturnType(), (String)"org.springframework.data.geo.GeoResults");
    }

    private static boolean isCollectionTypeRequired(@NotNull Part part) {
        if (part == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(11);
        }
        return part.getType() == SpringDataPartTypes.IN || part.getType() == SpringDataPartTypes.NOT_IN;
    }

    private static boolean isCollectionElementTypeRequired(@NotNull Part part) {
        if (part == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(12);
        }
        return part.getType() == SpringDataPartTypes.CONTAINING || part.getType() == SpringDataPartTypes.NOT_CONTAINING;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return "SpringDataRepositoryMethodParametersInspection";
    }

    @NotNull
    private static Map<String, PsiType> createParamMap(@NotNull Iterable<Part> nodes, @NotNull PsiMethod psiMethod) {
        String pageable;
        if (nodes == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(13);
        }
        if (psiMethod == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(14);
        }
        Map paramMap = PartTreeInconsistencyUtils.getPropertyPathParamsMap(nodes, (PsiMethod)psiMethod, part -> SpringDataRepositoryMethodParametersInspection.isCollectionTypeRequired(part));
        if (InheritanceUtil.isInheritor((PsiType)psiMethod.getReturnType(), (String)"org.springframework.data.domain.Page")) {
            pageable = PartTreeInconsistencyUtils.getUnusedName((Map)paramMap, (String)"pageable");
            PsiType pageablePsiType = PartTreeInconsistencyUtils.getPsiType((Project)psiMethod.getProject(), (String)"org.springframework.data.domain.Pageable");
            if (pageablePsiType != null) {
                paramMap.put(pageable, pageablePsiType);
            }
        } else if (InheritanceUtil.isInheritor((PsiType)psiMethod.getReturnType(), (String)"org.springframework.data.geo.GeoResults")) {
            pageable = PartTreeInconsistencyUtils.getUnusedName((Map)paramMap, (String)"distance");
            PsiType distanceType = PartTreeInconsistencyUtils.getPsiType((Project)psiMethod.getProject(), (String)"org.springframework.data.geo.Distance");
            if (distanceType != null) {
                paramMap.put(pageable, distanceType);
            }
        }
        for (PsiParameter parameter : psiMethod.getParameterList().getParameters()) {
            if (!InheritanceUtil.isInheritor((PsiType)parameter.getType(), (String)"org.springframework.data.domain.Sort")) continue;
            paramMap.put(parameter.getName(), PartTreeInconsistencyUtils.getPsiType((Project)parameter.getProject(), (String)"org.springframework.data.domain.Sort"));
            break;
        }
        Map map = paramMap;
        if (map == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(15);
        }
        return map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typePair";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partTree";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domainClass";
                break;
            }
            case 8: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "part";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleWrappers";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleCollections";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createParamMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkRepositoryMethod";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkParameters";
                break;
            }
            case 8: 
            case 9: 
            case 15: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isNotQueryParameter";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isCollectionTypeRequired";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isCollectionElementTypeRequired";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createParamMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyPartTreeParametersChecker
    implements PartTreeInconsistencyUtils.PartTreeParametersCheckHelper {
        private MyPartTreeParametersChecker() {
        }

        public String[] getPossibleWrappers(boolean withReactive) {
            return SpringDataRepositoryMethodParametersInspection.getPossibleWrappers(withReactive);
        }

        public String[] getPossibleCollections(boolean withReactive, boolean withCoroutines) {
            return SpringDataRepositoryMethodParametersInspection.getPossibleCollections(withReactive, withCoroutines);
        }

        public boolean isReactiveRepository(UClass uClass) {
            return SpringDataRepositoryMethodParametersInspection.isReactiveRepository(uClass);
        }

        public boolean isCoroutineRepository(UClass uClass) {
            return SpringDataRepositoryMethodParametersInspection.isCoroutineRepository(uClass);
        }

        public boolean isNotQueryParameter(@NotNull PsiMethod psiMethod, PsiType parameterType) {
            if (psiMethod == null) {
                MyPartTreeParametersChecker.$$$reportNull$$$0(0);
            }
            return SpringDataRepositoryMethodParametersInspection.isNotQueryParameter(psiMethod, parameterType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection$MyPartTreeParametersChecker", "isNotQueryParameter"));
        }
    }
}

