/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.diagnostic.Log4jBasedLogger;
import com.intellij.testFramework.LoggedErrorProcessor;
import com.intellij.testFramework.TestLoggerFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TestLogger
extends Log4jBasedLogger {
    TestLogger(@NotNull Logger logger) {
        if (logger == null) {
            TestLogger.$$$reportNull$$$0(0);
        }
        super(logger);
    }

    public void warn(String message, @Nullable Throwable t) {
        t = TestLogger.checkException((Throwable)t);
        LoggedErrorProcessor.getInstance().processWarn(message, t, this.myLogger);
    }

    public void error(String message, @Nullable Throwable t, String ... details) {
        if (details == null) {
            TestLogger.$$$reportNull$$$0(1);
        }
        t = TestLogger.checkException((Throwable)t);
        LoggedErrorProcessor.getInstance().processError(message, t, details, this.myLogger);
    }

    public void debug(@NonNls String message) {
        if (this.isDebugEnabled()) {
            super.debug(message);
            TestLoggerFactory.log(this.myLogger, Level.DEBUG, message, null);
        }
    }

    public void debug(@Nullable Throwable t) {
        if (this.isDebugEnabled()) {
            super.debug(t);
            TestLoggerFactory.log(this.myLogger, Level.DEBUG, null, t);
        }
    }

    public void debug(@NonNls String message, @Nullable Throwable t) {
        if (this.isDebugEnabled()) {
            super.debug(message, t);
            TestLoggerFactory.log(this.myLogger, Level.DEBUG, message, t);
        }
    }

    public void info(@NonNls String message) {
        super.info(message);
        TestLoggerFactory.log(this.myLogger, Level.INFO, message, null);
    }

    public void info(@NonNls String message, @Nullable Throwable t) {
        super.info(message, t);
        TestLoggerFactory.log(this.myLogger, Level.INFO, message, t);
    }

    public void trace(String message) {
        if (this.isTraceEnabled()) {
            super.trace(message);
            TestLoggerFactory.log(this.myLogger, Level.TRACE, message, null);
        }
    }

    public void trace(@Nullable Throwable t) {
        if (this.isTraceEnabled()) {
            super.trace(t);
            TestLoggerFactory.log(this.myLogger, Level.TRACE, null, t);
        }
    }

    public boolean isDebugEnabled() {
        if (ApplicationInfoImpl.INSTANCE.isInStressTest()) {
            return super.isDebugEnabled();
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
        }
        objectArray2[1] = "com/intellij/testFramework/TestLogger";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "error";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ApplicationInfoImpl {
        static final ApplicationInfoImpl INSTANCE = new ApplicationInfoImpl();
        private final Method isInStressTestMethod;

        private ApplicationInfoImpl() {
            Method method;
            try {
                Class<?> applicationInfoImplClass = Class.forName("com.intellij.openapi.application.impl.ApplicationInfoImpl");
                method = applicationInfoImplClass.getMethod("isInStressTest", new Class[0]);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                e.printStackTrace();
                method = null;
            }
            this.isInStressTestMethod = method;
        }

        boolean isInStressTest() {
            if (this.isInStressTestMethod == null) {
                return false;
            }
            try {
                return (Boolean)this.isInStressTestMethod.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
                return false;
            }
        }
    }
}

