/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.recommenders.java.util;

import com.intellij.lang.jvm.types.JvmPrimitiveTypeKind;
import com.intellij.lang.jvm.types.JvmReferenceType;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.recommenders.java.resolver.ModuleRevisionIdService;
import com.intellij.recommenders.java.util.ModuleRevisionId;
import com.intellij.recommenders.java.util.ResolvedTypeName;
import com.jetbrains.recommenders.java.commons.names.IFieldName;
import com.jetbrains.recommenders.java.commons.names.IMethodName;
import com.jetbrains.recommenders.java.commons.names.IName;
import com.jetbrains.recommenders.java.commons.names.ITypeName;
import com.jetbrains.recommenders.java.commons.names.QualifiedName;
import com.jetbrains.recommenders.java.commons.names.VmFieldName;
import com.jetbrains.recommenders.java.commons.names.VmMethodName;
import com.jetbrains.recommenders.java.commons.names.VmTypeName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u0005J\u0011\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\b\u00a2\u0006\u0002\u0010\tJ\f\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\fJ\f\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u000fJ\f\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u0010J\f\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u0013J\f\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u0014J\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u0004\u0018\u00010\u0017J\n\u0010\u0018\u001a\u00020\u0019*\u00020\u0013J\f\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u00020\u0010J\f\u0010\u001c\u001a\u0004\u0018\u00010\u001d*\u00020\u0013J\f\u0010\u001c\u001a\u0004\u0018\u00010\u001d*\u00020\u0014J\f\u0010\u001e\u001a\u0004\u0018\u00010\u001f*\u00020 J\u000e\u0010\u001e\u001a\u0004\u0018\u00010\u001f*\u0004\u0018\u00010\u0013J\f\u0010\u001e\u001a\u0004\u0018\u00010\u001f*\u00020\u0019J\n\u0010\u001e\u001a\u00020\u001f*\u00020!J\u000e\u0010\u001e\u001a\u0004\u0018\u00010\u001f*\u0004\u0018\u00010\u0014J\u000e\u0010\u001e\u001a\u0004\u0018\u00010\u001f*\u0004\u0018\u00010\"\u00a8\u0006#"}, d2={"Lcom/intellij/recommenders/java/util/PsiUtils;", "", "()V", "getCodeBlock", "Lcom/intellij/psi/PsiCodeBlock;", "Lcom/intellij/psi/PsiVariable;", "getParameterIndex", "", "Lcom/intellij/psi/PsiParameter;", "(Lcom/intellij/psi/PsiParameter;)Ljava/lang/Integer;", "toFieldName", "Lcom/jetbrains/recommenders/java/commons/names/IFieldName;", "Lcom/intellij/psi/PsiField;", "toMethodName", "Lcom/jetbrains/recommenders/java/commons/names/IMethodName;", "Lcom/intellij/psi/PsiMethod;", "Lcom/intellij/psi/PsiMethodCallExpression;", "toModuleRevisionId", "Lcom/intellij/recommenders/java/util/ModuleRevisionId;", "Lcom/intellij/psi/PsiClass;", "Lcom/intellij/psi/PsiType;", "toName", "Lcom/jetbrains/recommenders/java/commons/names/IName;", "Lcom/intellij/psi/PsiElement;", "toPsiType", "Lcom/intellij/psi/PsiClassType;", "toQualifiedName", "Lcom/jetbrains/recommenders/java/commons/names/QualifiedName;", "toResolvedType", "Lcom/intellij/recommenders/java/util/ResolvedTypeName;", "toTypeName", "Lcom/jetbrains/recommenders/java/commons/names/ITypeName;", "Lcom/intellij/psi/PsiArrayType;", "Lcom/intellij/psi/PsiPrimitiveType;", "Lcom/intellij/psi/PsiTypeParameter;", "intellij.recommenders.java"})
public final class PsiUtils {
    public static final PsiUtils INSTANCE;

    @Nullable
    public final Integer getParameterIndex(@NotNull PsiParameter $this$getParameterIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$getParameterIndex, (String)"$this$getParameterIndex");
        PsiElement psiElement = $this$getParameterIndex.getParent();
        if (!(psiElement instanceof PsiParameterList)) {
            psiElement = null;
        }
        PsiParameterList psiParameterList = (PsiParameterList)psiElement;
        return psiParameterList != null ? Integer.valueOf(psiParameterList.getParameterIndex($this$getParameterIndex)) : null;
    }

    @Nullable
    public final PsiCodeBlock getCodeBlock(@NotNull PsiVariable $this$getCodeBlock) {
        PsiCodeBlock psiCodeBlock;
        Intrinsics.checkNotNullParameter((Object)$this$getCodeBlock, (String)"$this$getCodeBlock");
        PsiElement element = PsiUtil.getVariableCodeBlock((PsiVariable)$this$getCodeBlock, null);
        PsiElement psiElement = element;
        if (!(psiElement instanceof PsiCodeBlock)) {
            psiElement = null;
        }
        if ((psiCodeBlock = (PsiCodeBlock)psiElement) == null) {
            psiCodeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)element, PsiCodeBlock.class);
        }
        return psiCodeBlock;
    }

    @Nullable
    public final QualifiedName toQualifiedName(@NotNull PsiMethodCallExpression $this$toQualifiedName) {
        QualifiedName qualifiedName;
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)$this$toQualifiedName, (String)"$this$toQualifiedName");
        PsiReferenceExpression psiReferenceExpression = $this$toQualifiedName.getMethodExpression();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceExpression, (String)"methodExpression");
        if (psiReferenceExpression.isQualified()) {
            PsiReferenceExpression psiReferenceExpression2 = $this$toQualifiedName.getMethodExpression();
            Intrinsics.checkNotNullExpressionValue((Object)psiReferenceExpression2, (String)"methodExpression");
            PsiExpression psiExpression = psiReferenceExpression2.getQualifierExpression();
            psiElement = psiExpression != null && (psiExpression = psiExpression.getReference()) != null ? psiExpression.resolve() : null;
        } else {
            PsiReferenceExpression psiReferenceExpression3 = $this$toQualifiedName.getMethodExpression();
            Intrinsics.checkNotNullExpressionValue((Object)psiReferenceExpression3, (String)"methodExpression");
            PsiElement $this$parentOfType$iv = (PsiElement)psiReferenceExpression3;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            psiElement = PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, PsiClass.class, (boolean)true);
        }
        PsiElement parent2 = psiElement;
        PsiReferenceExpression psiReferenceExpression4 = $this$toQualifiedName.getMethodExpression();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceExpression4, (String)"methodExpression");
        String name = psiReferenceExpression4.getReferenceName();
        if (parent2 == null || name == null) {
            return null;
        }
        PsiElement psiElement2 = parent2;
        if (psiElement2 instanceof PsiType) {
            ITypeName iTypeName = this.toTypeName((PsiType)parent2);
            if (iTypeName != null) {
                ITypeName iTypeName2 = iTypeName;
                boolean bl = false;
                boolean bl2 = false;
                ITypeName it = iTypeName2;
                boolean bl3 = false;
                qualifiedName = new QualifiedName(name, it);
            } else {
                qualifiedName = null;
            }
        } else if (psiElement2 instanceof PsiClass) {
            ITypeName iTypeName = this.toTypeName((PsiClass)parent2);
            if (iTypeName != null) {
                ITypeName iTypeName3 = iTypeName;
                boolean bl = false;
                boolean bl4 = false;
                ITypeName it = iTypeName3;
                boolean bl5 = false;
                qualifiedName = new QualifiedName(name, it);
            } else {
                qualifiedName = null;
            }
        } else if (psiElement2 instanceof PsiVariable) {
            ITypeName iTypeName = this.toTypeName(((PsiVariable)parent2).getType());
            if (iTypeName != null) {
                ITypeName iTypeName4 = iTypeName;
                boolean bl = false;
                boolean bl6 = false;
                ITypeName it = iTypeName4;
                boolean bl7 = false;
                qualifiedName = new QualifiedName(name, it);
            } else {
                qualifiedName = null;
            }
        } else if (psiElement2 instanceof PsiMethod) {
            ITypeName iTypeName = this.toTypeName(((PsiMethod)parent2).getReturnType());
            if (iTypeName != null) {
                ITypeName iTypeName5 = iTypeName;
                boolean bl = false;
                boolean bl8 = false;
                ITypeName it = iTypeName5;
                boolean bl9 = false;
                qualifiedName = new QualifiedName(name, it);
            } else {
                qualifiedName = null;
            }
        } else {
            qualifiedName = null;
        }
        return qualifiedName;
    }

    @Nullable
    public final IMethodName toMethodName(@NotNull PsiMethodCallExpression $this$toMethodName) {
        Intrinsics.checkNotNullParameter((Object)$this$toMethodName, (String)"$this$toMethodName");
        PsiMethod psiMethod = $this$toMethodName.resolveMethod();
        return psiMethod != null ? this.toMethodName(psiMethod) : null;
    }

    @Nullable
    public final IName toName(@Nullable PsiElement $this$toName) {
        PsiElement psiElement = $this$toName;
        if (psiElement instanceof PsiMethod) {
            return (IName)this.toMethodName((PsiMethod)$this$toName);
        }
        if (psiElement instanceof PsiType) {
            return (IName)this.toTypeName((PsiType)$this$toName);
        }
        if (psiElement instanceof PsiClass) {
            return (IName)this.toTypeName((PsiClass)$this$toName);
        }
        if (psiElement instanceof PsiField) {
            return (IName)this.toFieldName((PsiField)$this$toName);
        }
        return null;
    }

    @Nullable
    public final ITypeName toTypeName(@Nullable PsiTypeParameter $this$toTypeName) {
        if ($this$toTypeName == null) {
            return null;
        }
        JvmReferenceType[] jvmReferenceTypeArray = $this$toTypeName.getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)jvmReferenceTypeArray, (String)"this.bounds");
        JvmReferenceType[] jvmReferenceTypeArray2 = jvmReferenceTypeArray;
        boolean bl = false;
        if (jvmReferenceTypeArray2.length == 0) {
            return (ITypeName)VmTypeName.OBJECT;
        }
        return this.toTypeName($this$toTypeName.getSuperClass());
    }

    @Nullable
    public final ITypeName toTypeName(@Nullable PsiClass $this$toTypeName) {
        ITypeName iTypeName;
        if ($this$toTypeName == null) {
            return null;
        }
        String string2 = $this$toTypeName.getQualifiedName();
        if (string2 != null && (string2 = StringsKt.replace$default((String)string2, (char)'.', (char)'/', (boolean)false, (int)4, null)) != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            iTypeName = ITypeName.Companion.of('L' + it);
        } else {
            iTypeName = null;
        }
        return iTypeName;
    }

    @Nullable
    public final ITypeName toTypeName(@NotNull PsiClassType $this$toTypeName) {
        Intrinsics.checkNotNullParameter((Object)$this$toTypeName, (String)"$this$toTypeName");
        PsiClass clazz = $this$toTypeName.resolve();
        if (clazz instanceof PsiTypeParameter) {
            return this.toTypeName((PsiTypeParameter)clazz);
        }
        if (clazz instanceof PsiClass) {
            return this.toTypeName(clazz);
        }
        return null;
    }

    @NotNull
    public final ITypeName toTypeName(@NotNull PsiPrimitiveType $this$toTypeName) {
        ITypeName iTypeName;
        Intrinsics.checkNotNullParameter((Object)$this$toTypeName, (String)"$this$toTypeName");
        if (Intrinsics.areEqual((Object)PsiType.NULL, (Object)$this$toTypeName)) {
            iTypeName = (ITypeName)ITypeName.Companion.getNULL();
        } else {
            JvmPrimitiveTypeKind jvmPrimitiveTypeKind = $this$toTypeName.getKind();
            Intrinsics.checkNotNullExpressionValue((Object)jvmPrimitiveTypeKind, (String)"kind");
            String string2 = jvmPrimitiveTypeKind.getBinaryName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"kind.binaryName");
            iTypeName = ITypeName.Companion.of(string2);
        }
        return iTypeName;
    }

    @Nullable
    public final ITypeName toTypeName(@NotNull PsiArrayType $this$toTypeName) {
        VmTypeName vmTypeName;
        Intrinsics.checkNotNullParameter((Object)$this$toTypeName, (String)"$this$toTypeName");
        String arrayDimensions = StringsKt.repeat((CharSequence)"[", (int)$this$toTypeName.getArrayDimensions());
        ITypeName iTypeName = this.toTypeName($this$toTypeName.getDeepComponentType());
        if (iTypeName != null) {
            ITypeName iTypeName2 = iTypeName;
            boolean bl = false;
            boolean bl2 = false;
            ITypeName it = iTypeName2;
            boolean bl3 = false;
            vmTypeName = VmTypeName.Companion.of(arrayDimensions + it);
        } else {
            vmTypeName = null;
        }
        return (ITypeName)vmTypeName;
    }

    @Nullable
    public final ITypeName toTypeName(@Nullable PsiType $this$toTypeName) {
        PsiType psiType = $this$toTypeName;
        return psiType instanceof PsiPrimitiveType ? this.toTypeName((PsiPrimitiveType)$this$toTypeName) : (psiType instanceof PsiArrayType ? this.toTypeName((PsiArrayType)$this$toTypeName) : (psiType instanceof PsiClassType ? this.toTypeName((PsiClassType)$this$toTypeName) : null));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final IMethodName toMethodName(@NotNull PsiMethod $this$toMethodName) {
        IMethodName iMethodName;
        void $this$mapTo$iv$iv;
        Object object;
        ITypeName declaringType;
        Intrinsics.checkNotNullParameter((Object)$this$toMethodName, (String)"$this$toMethodName");
        PsiElement psiElement = $this$toMethodName.getParent();
        if (!(psiElement instanceof PsiClass)) {
            psiElement = null;
        }
        PsiClass psiClass = (PsiClass)psiElement;
        ITypeName iTypeName = declaringType = psiClass != null ? this.toTypeName(psiClass) : null;
        if ($this$toMethodName.getReturnType() == null) {
            object = (ITypeName)VmTypeName.VOID;
        } else {
            PsiType psiType = $this$toMethodName.getReturnType();
            object = psiType != null ? this.toTypeName(psiType) : null;
        }
        ITypeName returnType = object;
        PsiParameterList psiParameterList = $this$toMethodName.getParameterList();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"this.parameterList");
        PsiParameter[] psiParameterArray = psiParameterList.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"this.parameterList.parameters");
        PsiParameter[] $this$map$iv = psiParameterArray;
        boolean $i$f$map = false;
        PsiParameter[] psiParameterArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var10_9 = $this$mapTo$iv$iv;
        int n = ((void)var10_9).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var14_13 = item$iv$iv = var10_9[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v7 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"it");
            ITypeName iTypeName2 = INSTANCE.toTypeName(v7.getType());
            collection.add(iTypeName2);
        }
        List parameterTypes = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
        if (declaringType != null && returnType != null && parameterTypes.size() == $this$toMethodName.getParameters().length) {
            String string2 = $this$toMethodName.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this.name");
            iMethodName = VmMethodName.Companion.of(string2, declaringType, parameterTypes, returnType);
        } else {
            iMethodName = null;
        }
        return iMethodName;
    }

    @Nullable
    public final IFieldName toFieldName(@NotNull PsiField $this$toFieldName) {
        IFieldName iFieldName;
        ITypeName declaringType;
        Intrinsics.checkNotNullParameter((Object)$this$toFieldName, (String)"$this$toFieldName");
        ITypeName fieldType = this.toTypeName($this$toFieldName.getType());
        PsiElement psiElement = $this$toFieldName.getParent();
        if (!(psiElement instanceof PsiClass)) {
            psiElement = null;
        }
        PsiClass psiClass = (PsiClass)psiElement;
        ITypeName iTypeName = declaringType = psiClass != null ? this.toTypeName(psiClass) : null;
        if (fieldType != null && declaringType != null) {
            String string2 = $this$toFieldName.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this.name");
            iFieldName = (IFieldName)VmFieldName.Companion.of(declaringType, string2, fieldType);
        } else {
            iFieldName = null;
        }
        return iFieldName;
    }

    @Nullable
    public final ModuleRevisionId toModuleRevisionId(@NotNull PsiClass $this$toModuleRevisionId) {
        Intrinsics.checkNotNullParameter((Object)$this$toModuleRevisionId, (String)"$this$toModuleRevisionId");
        return ModuleRevisionIdService.Companion.getInstance().resolveModuleRevisionId((PsiElement)$this$toModuleRevisionId);
    }

    @Nullable
    public final ResolvedTypeName toResolvedType(@NotNull PsiType $this$toResolvedType) {
        Intrinsics.checkNotNullParameter((Object)$this$toResolvedType, (String)"$this$toResolvedType");
        ITypeName typeName = this.toTypeName($this$toResolvedType);
        ModuleRevisionId mrid = ModuleRevisionIdService.Companion.getInstance().resolveModuleRevisionId($this$toResolvedType);
        return mrid != null && typeName != null ? new ResolvedTypeName(typeName, mrid.getGroup(), mrid.getModule(), mrid.getRevision()) : null;
    }

    @Nullable
    public final ResolvedTypeName toResolvedType(@NotNull PsiClass $this$toResolvedType) {
        Intrinsics.checkNotNullParameter((Object)$this$toResolvedType, (String)"$this$toResolvedType");
        ITypeName typeName = this.toTypeName($this$toResolvedType);
        ModuleRevisionId mrid = ModuleRevisionIdService.Companion.getInstance().resolveModuleRevisionId((PsiElement)$this$toResolvedType);
        return mrid != null && typeName != null ? new ResolvedTypeName(typeName, mrid.getGroup(), mrid.getModule(), mrid.getRevision()) : null;
    }

    @Nullable
    public final ModuleRevisionId toModuleRevisionId(@NotNull PsiType $this$toModuleRevisionId) {
        Intrinsics.checkNotNullParameter((Object)$this$toModuleRevisionId, (String)"$this$toModuleRevisionId");
        return ModuleRevisionIdService.Companion.getInstance().resolveModuleRevisionId($this$toModuleRevisionId);
    }

    @NotNull
    public final PsiClassType toPsiType(@NotNull PsiClass $this$toPsiType) {
        Intrinsics.checkNotNullParameter((Object)$this$toPsiType, (String)"$this$toPsiType");
        PsiClassType psiClassType = PsiTypesUtil.getClassType((PsiClass)$this$toPsiType);
        Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"PsiTypesUtil.getClassType(this)");
        return psiClassType;
    }

    private PsiUtils() {
    }

    static {
        PsiUtils psiUtils;
        INSTANCE = psiUtils = new PsiUtils();
    }
}

