/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.recommenders.java.util;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.impl.LookupCellRenderer;
import com.intellij.openapi.util.Key;
import com.intellij.recommenders.decorating.StarDecoratedIcon;
import java.text.DecimalFormat;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0016J\f\u0010\b\u001a\u00020\t*\u00020\nH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/recommenders/java/util/MyLookupElementCustomizer;", "Lcom/intellij/codeInsight/lookup/impl/LookupCellRenderer$ItemPresentationCustomizer;", "()V", "customizePresentation", "Lcom/intellij/codeInsight/lookup/LookupElementPresentation;", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "presentation", "formatProbability", "", "", "Companion", "intellij.recommenders.java"})
public final class MyLookupElementCustomizer
implements LookupCellRenderer.ItemPresentationCustomizer {
    private static final DecimalFormat SMALL_NUMBERS;
    private static final DecimalFormat LARGE_NUMBERS;
    private static final Key<Double> PROBABILITY;
    private static final Key<Integer> POSITION;
    private static final Key<Integer> SCALED_PROBABILITY;
    private static final Key<String> TEXT;
    public static final Companion Companion;

    @NotNull
    public LookupElementPresentation customizePresentation(@NotNull LookupElement item, @NotNull LookupElementPresentation presentation) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Double probability = Companion.getProbability(item);
        String text = Companion.getText(item);
        if (probability == null && text == null) {
            return presentation;
        }
        LookupElementPresentation decoratedPresentation = new LookupElementPresentation();
        decoratedPresentation.copyFrom(presentation);
        decoratedPresentation.setIcon((Icon)StarDecoratedIcon.Companion.create(presentation.getIcon()));
        if (probability != null) {
            Integer n = Companion.getScaledProbability(item);
            Integer n2 = Companion.getPosition(item);
            decoratedPresentation.appendTailText(" - " + this.formatProbability(probability) + "% (" + (n != null ? n : 0) + "%) - " + (n2 != null ? n2 : 0), true);
        }
        if (text != null) {
            decoratedPresentation.appendTailText(' ' + (probability != null ? "-" : "") + ' ' + text, true);
        }
        return decoratedPresentation;
    }

    private final String formatProbability(double $this$formatProbability) {
        double d = $this$formatProbability * (double)100;
        boolean bl = false;
        boolean bl2 = false;
        double it = d;
        boolean bl3 = false;
        String string2 = (it < 5.0 ? SMALL_NUMBERS : LARGE_NUMBERS).format(it);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this * 100).let {\n     \u2026NUMBERS).format(it)\n    }");
        return string2;
    }

    static {
        Companion = new Companion(null);
        SMALL_NUMBERS = new DecimalFormat("#.##");
        LARGE_NUMBERS = new DecimalFormat("#");
        Key key = Key.create((String)"probability");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create(\"probability\")");
        PROBABILITY = key;
        Key key2 = Key.create((String)"position");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"Key.create(\"position\")");
        POSITION = key2;
        Key key3 = Key.create((String)"scaled-probability");
        Intrinsics.checkNotNullExpressionValue((Object)key3, (String)"Key.create(\"scaled-probability\")");
        SCALED_PROBABILITY = key3;
        Key key4 = Key.create((String)"text");
        Intrinsics.checkNotNullExpressionValue((Object)key4, (String)"Key.create(\"text\")");
        TEXT = key4;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u000f\u001a\u0004\u0018\u00010\u0007*\u00020\u00102\b\u0010\u000e\u001a\u0004\u0018\u00010\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R,\u0010\u0015\u001a\u0004\u0018\u00010\t*\u00020\u00102\b\u0010\u000e\u001a\u0004\u0018\u00010\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R,\u0010\u001a\u001a\u0004\u0018\u00010\u0007*\u00020\u00102\b\u0010\u000e\u001a\u0004\u0018\u00010\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u0012\"\u0004\b\u001c\u0010\u0014R,\u0010\u001d\u001a\u0004\u0018\u00010\r*\u00020\u00102\b\u0010\u000e\u001a\u0004\u0018\u00010\r8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lcom/intellij/recommenders/java/util/MyLookupElementCustomizer$Companion;", "", "()V", "LARGE_NUMBERS", "Ljava/text/DecimalFormat;", "POSITION", "Lcom/intellij/openapi/util/Key;", "", "PROBABILITY", "", "SCALED_PROBABILITY", "SMALL_NUMBERS", "TEXT", "", "value", "position", "Lcom/intellij/codeInsight/lookup/LookupElement;", "getPosition", "(Lcom/intellij/codeInsight/lookup/LookupElement;)Ljava/lang/Integer;", "setPosition", "(Lcom/intellij/codeInsight/lookup/LookupElement;Ljava/lang/Integer;)V", "probability", "getProbability", "(Lcom/intellij/codeInsight/lookup/LookupElement;)Ljava/lang/Double;", "setProbability", "(Lcom/intellij/codeInsight/lookup/LookupElement;Ljava/lang/Double;)V", "scaledProbability", "getScaledProbability", "setScaledProbability", "text", "getText", "(Lcom/intellij/codeInsight/lookup/LookupElement;)Ljava/lang/String;", "setText", "(Lcom/intellij/codeInsight/lookup/LookupElement;Ljava/lang/String;)V", "intellij.recommenders.java"})
    public static final class Companion {
        @Nullable
        public final Double getProbability(@NotNull LookupElement $this$probability) {
            Intrinsics.checkNotNullParameter((Object)$this$probability, (String)"$this$probability");
            return (Double)$this$probability.getUserData(PROBABILITY);
        }

        public final void setProbability(@NotNull LookupElement $this$probability, @Nullable Double value) {
            Intrinsics.checkNotNullParameter((Object)$this$probability, (String)"$this$probability");
            $this$probability.putUserData(PROBABILITY, (Object)value);
        }

        @Nullable
        public final String getText(@NotNull LookupElement $this$text) {
            Intrinsics.checkNotNullParameter((Object)$this$text, (String)"$this$text");
            return (String)$this$text.getUserData(TEXT);
        }

        public final void setText(@NotNull LookupElement $this$text, @Nullable String value) {
            Intrinsics.checkNotNullParameter((Object)$this$text, (String)"$this$text");
            $this$text.putUserData(TEXT, (Object)value);
        }

        @Nullable
        public final Integer getPosition(@NotNull LookupElement $this$position) {
            Integer n;
            Intrinsics.checkNotNullParameter((Object)$this$position, (String)"$this$position");
            Integer n2 = (Integer)$this$position.getUserData(POSITION);
            if (n2 != null) {
                int n3 = n2;
                boolean bl = false;
                n = Math.abs(n3);
            } else {
                n = null;
            }
            return n;
        }

        public final void setPosition(@NotNull LookupElement $this$position, @Nullable Integer value) {
            Intrinsics.checkNotNullParameter((Object)$this$position, (String)"$this$position");
            $this$position.putUserData(POSITION, (Object)value);
        }

        @Nullable
        public final Integer getScaledProbability(@NotNull LookupElement $this$scaledProbability) {
            Integer n;
            Intrinsics.checkNotNullParameter((Object)$this$scaledProbability, (String)"$this$scaledProbability");
            Integer n2 = (Integer)$this$scaledProbability.getUserData(SCALED_PROBABILITY);
            if (n2 != null) {
                int n3 = n2;
                boolean bl = false;
                n = Math.abs(n3);
            } else {
                n = null;
            }
            return n;
        }

        public final void setScaledProbability(@NotNull LookupElement $this$scaledProbability, @Nullable Integer value) {
            Intrinsics.checkNotNullParameter((Object)$this$scaledProbability, (String)"$this$scaledProbability");
            $this$scaledProbability.putUserData(SCALED_PROBABILITY, (Object)value);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

