/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.recommenders.java.resolver;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.recommenders.java.resolver.OrderEntryPath;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001b\u0010\u0005\u001a\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/intellij/recommenders/java/resolver/ModuleSourceOrderEntryPath;", "Lcom/intellij/recommenders/java/resolver/OrderEntryPath;", "entry", "Lcom/intellij/openapi/roots/ModuleSourceOrderEntry;", "(Lcom/intellij/openapi/roots/ModuleSourceOrderEntry;)V", "moduleName", "", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "getModuleName", "()Ljava/lang/String;", "projectName", "getProjectName", "Companion", "intellij.recommenders.java"})
public final class ModuleSourceOrderEntryPath
extends OrderEntryPath {
    @NotNull
    private final String moduleName;
    @NotNull
    private final String projectName;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getModuleName() {
        return this.moduleName;
    }

    @NotNull
    public final String getProjectName() {
        return this.projectName;
    }

    public ModuleSourceOrderEntryPath(@NotNull ModuleSourceOrderEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        super(Companion.computeDelegatePath(entry));
        ModuleRootModel moduleRootModel = entry.getRootModel();
        Intrinsics.checkNotNullExpressionValue((Object)moduleRootModel, (String)"entry.rootModel");
        Module module = moduleRootModel.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"entry.rootModel.module");
        String string2 = module.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"entry.rootModel.module.name");
        this.moduleName = string2;
        ModuleRootModel moduleRootModel2 = entry.getRootModel();
        Intrinsics.checkNotNullExpressionValue((Object)moduleRootModel2, (String)"entry.rootModel");
        Module module2 = moduleRootModel2.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"entry.rootModel.module");
        Project project = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"entry.rootModel.module.project");
        String string3 = project.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"entry.rootModel.module.project.name");
        this.projectName = string3;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/recommenders/java/resolver/ModuleSourceOrderEntryPath$Companion;", "", "()V", "computeDelegatePath", "Ljava/nio/file/Path;", "entry", "Lcom/intellij/openapi/roots/ModuleSourceOrderEntry;", "intellij.recommenders.java"})
    public static final class Companion {
        @NotNull
        public final Path computeDelegatePath(@NotNull ModuleSourceOrderEntry entry) {
            Path path;
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            ModuleRootModel moduleRootModel = entry.getRootModel();
            Intrinsics.checkNotNullExpressionValue((Object)moduleRootModel, (String)"entry.rootModel");
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)moduleRootModel.getModule());
            Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager\n      \u2026e(entry.rootModel.module)");
            Object[] objectArray = moduleRootManager.getContentRoots();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"ModuleRootManager\n      \u2026le)\n        .contentRoots");
            Object object = (VirtualFile)ArraysKt.firstOrNull((Object[])objectArray);
            if (object != null && (object = object.getCanonicalPath()) != null) {
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                path = Paths.get((String)it, new String[0]);
            } else {
                path = null;
            }
            Intrinsics.checkNotNull(path);
            return path;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

