/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.recommenders.java.resolver;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.recommenders.java.resolver.ByJreReleaseFileResolver;
import com.intellij.recommenders.java.resolver.ByLibraryOrderEntryResolver;
import com.intellij.recommenders.java.resolver.ByMavenPomPropertiesResolver;
import com.intellij.recommenders.java.resolver.ByModuleSourceOrderEntryResolver;
import com.intellij.recommenders.java.resolver.ByOsgiManifestResolver;
import com.intellij.recommenders.java.resolver.JdkOrderEntryPath;
import com.intellij.recommenders.java.resolver.LibraryOrderEntryPath;
import com.intellij.recommenders.java.resolver.ModuleRevisionIdResolver;
import com.intellij.recommenders.java.resolver.ModuleSourceOrderEntryPath;
import com.intellij.recommenders.java.util.ModuleRevisionId;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0015\u001a\u00020\u0017J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/intellij/recommenders/java/resolver/ModuleRevisionIdService;", "", "()V", "registry", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "Ljava/nio/file/Path;", "Lcom/intellij/recommenders/java/util/ModuleRevisionId;", "resolvers", "", "Lcom/intellij/recommenders/java/resolver/ModuleRevisionIdResolver;", "getResolvers", "()Ljava/util/List;", "setResolvers", "(Ljava/util/List;)V", "isJarLibrary", "Lcom/intellij/openapi/roots/LibraryOrderEntry;", "it", "Lcom/intellij/openapi/roots/OrderEntry;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "resolveModuleRevisionId", "element", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/psi/PsiType;", "toModulePath", "Companion", "intellij.recommenders.java"})
public final class ModuleRevisionIdService {
    @NotNull
    private List<? extends ModuleRevisionIdResolver> resolvers = CollectionsKt.listOf((Object[])new ModuleRevisionIdResolver[]{new ByModuleSourceOrderEntryResolver(), new ByLibraryOrderEntryResolver(), new ByJreReleaseFileResolver(), new ByMavenPomPropertiesResolver(), new ByMavenPomPropertiesResolver(), new ByOsgiManifestResolver()});
    private final LoadingCache<Path, ModuleRevisionId> registry;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final List<ModuleRevisionIdResolver> getResolvers() {
        return this.resolvers;
    }

    public final void setResolvers(@NotNull List<? extends ModuleRevisionIdResolver> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.resolvers = list;
    }

    @Nullable
    public final ModuleRevisionId resolveModuleRevisionId(@NotNull PsiType element) {
        ModuleRevisionId moduleRevisionId;
        PsiClassType psiClassType;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiType psiType = element;
        if (!(psiType instanceof PsiClassType)) {
            psiType = null;
        }
        if ((psiClassType = (PsiClassType)psiType) != null && (psiClassType = psiClassType.resolve()) != null) {
            PsiClassType psiClassType2 = psiClassType;
            boolean bl = false;
            boolean bl2 = false;
            PsiClassType it = psiClassType2;
            boolean bl3 = false;
            PsiClassType psiClassType3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)psiClassType3, (String)"it");
            moduleRevisionId = this.resolveModuleRevisionId((PsiElement)psiClassType3);
        } else {
            moduleRevisionId = null;
        }
        return moduleRevisionId;
    }

    @Nullable
    public final ModuleRevisionId resolveModuleRevisionId(@NotNull PsiElement element) {
        ModuleRevisionId moduleRevisionId;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Path path = this.toModulePath(element);
        if (path != null) {
            Path path2 = path;
            boolean bl = false;
            boolean bl2 = false;
            Path it = path2;
            boolean bl3 = false;
            moduleRevisionId = (ModuleRevisionId)this.registry.get((Object)it);
        } else {
            moduleRevisionId = null;
        }
        return moduleRevisionId;
    }

    private final Path toModulePath(PsiElement element) {
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (virtualFile != null) {
            VirtualFile virtualFile2 = virtualFile;
            boolean bl = false;
            boolean bl2 = false;
            VirtualFile file = virtualFile2;
            boolean bl3 = false;
            List list = ProjectFileIndex.getInstance((Project)element.getProject()).getOrderEntriesForFile(file);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ProjectFileIndex.getInst\u2026OrderEntriesForFile(file)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OrderEntry it = (OrderEntry)element$iv;
                boolean bl4 = false;
                OrderEntry orderEntry = it;
                if (orderEntry instanceof ModuleOrderEntry) continue;
                if (orderEntry instanceof ModuleSourceOrderEntry) {
                    return new ModuleSourceOrderEntryPath((ModuleSourceOrderEntry)it);
                }
                if (orderEntry instanceof JdkOrderEntry) {
                    return new JdkOrderEntryPath((JdkOrderEntry)it);
                }
                OrderEntry orderEntry2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)orderEntry2, (String)"it");
                VirtualFile virtualFile3 = file;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"file");
                if (!Intrinsics.areEqual((Object)orderEntry, (Object)this.isJarLibrary(orderEntry2, virtualFile3))) continue;
                return new LibraryOrderEntryPath((LibraryOrderEntry)it, file);
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final LibraryOrderEntry isJarLibrary(OrderEntry it, VirtualFile file) {
        if (!(it instanceof LibraryOrderEntry)) return null;
        VirtualFile virtualFile = VfsUtil.getLocalFile((VirtualFile)file);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"VfsUtil.getLocalFile(file)");
        if (!Intrinsics.areEqual((Object)"jar", (Object)virtualFile.getExtension())) return null;
        LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)it;
        return libraryOrderEntry;
    }

    public ModuleRevisionIdService() {
        LoadingCache loadingCache = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).maximumSize(100L).build((CacheLoader)new CacheLoader<Path, ModuleRevisionId>(this){
            final /* synthetic */ ModuleRevisionIdService this$0;

            @Nullable
            public final ModuleRevisionId load(@NotNull Path path) {
                ModuleRevisionId moduleRevisionId;
                Object v0;
                block2: {
                    Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                    Sequence $this$firstOrNull$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.this$0.getResolvers()), (Function1)((Function1)new Function1<ModuleRevisionIdResolver, ModuleRevisionId>(path){
                        final /* synthetic */ Path $path;

                        @Nullable
                        public final ModuleRevisionId invoke(@NotNull ModuleRevisionIdResolver it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return it.suggest(this.$path);
                        }
                        {
                            this.$path = path;
                            super(1);
                        }
                    }));
                    boolean $i$f$firstOrNull = false;
                    for (E element$iv : $this$firstOrNull$iv) {
                        ModuleRevisionId it = (ModuleRevisionId)element$iv;
                        boolean bl = false;
                        if (!(it != null)) continue;
                        v0 = element$iv;
                        break block2;
                    }
                    v0 = null;
                }
                if ((moduleRevisionId = (ModuleRevisionId)v0) == null) {
                    moduleRevisionId = ModuleRevisionId.Companion.of("unknown", "unknown", "0.0.0");
                }
                return moduleRevisionId;
            }
            {
                this.this$0 = moduleRevisionIdService;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"Caffeine.newBuilder()\n  \u2026\"unknown\", \"0.0.0\")\n    }");
        this.registry = loadingCache;
    }

    @JvmStatic
    @NotNull
    public static final ModuleRevisionIdService getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/intellij/recommenders/java/resolver/ModuleRevisionIdService$Companion;", "", "()V", "getInstance", "Lcom/intellij/recommenders/java/resolver/ModuleRevisionIdService;", "intellij.recommenders.java"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ModuleRevisionIdService getInstance() {
            Object object = ApplicationManager.getApplication().getService(ModuleRevisionIdService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026ionIdService::class.java)");
            return (ModuleRevisionIdService)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

