/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.recommenders.java.resolver;

import com.google.common.net.InternetDomainName;
import com.intellij.recommenders.java.resolver.ModuleRevisionIdResolver;
import com.intellij.recommenders.java.util.ModuleRevisionId;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/recommenders/java/resolver/ByOsgiManifestResolver;", "Lcom/intellij/recommenders/java/resolver/ModuleRevisionIdResolver;", "()V", "locations", "", "", "computeModuleRevisionIdFromManifest", "Lcom/intellij/recommenders/java/util/ModuleRevisionId;", "manifest", "Ljava/util/jar/Manifest;", "guessOrganisation", "reverseDomainName", "suggest", "root", "Ljava/nio/file/Path;", "intellij.recommenders.java"})
public final class ByOsgiManifestResolver
implements ModuleRevisionIdResolver {
    private final List<String> locations = CollectionsKt.listOf((Object[])new String[]{"META-INF/MANIFEST.MF", "src/main/resources/META-INF/MANIFEST.MF"});

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public ModuleRevisionId suggest(@NotNull Path root) {
        ModuleRevisionId moduleRevisionId;
        Object v1;
        block4: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Iterable $this$map$iv = this.locations;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Path path = root.resolve((String)it);
                collection.add(path);
            }
            Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Path it = (Path)element$iv;
                boolean bl = false;
                Path path = it;
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it");
                if (!PathKt.exists((Path)path)) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        Path path = v1;
        if (path != null) {
            Object object = path;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            object = new Manifest(PathKt.inputStream((Path)it));
            bl = false;
            bl2 = false;
            it = object;
            boolean bl4 = false;
            moduleRevisionId = this.computeModuleRevisionIdFromManifest((Manifest)it);
        } else {
            moduleRevisionId = null;
        }
        return moduleRevisionId;
    }

    private final ModuleRevisionId computeModuleRevisionIdFromManifest(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        String bundleName = attributes.getValue("Bundle-SymbolicName");
        String version = attributes.getValue("Bundle-Version");
        if (bundleName == null || version == null) {
            return null;
        }
        String module = StringsKt.substringBefore((String)bundleName, (String)";", (String)bundleName);
        String organisation = this.guessOrganisation(module);
        return ModuleRevisionId.Companion.of(organisation, module, version);
    }

    private final String guessOrganisation(String reverseDomainName) {
        List parts = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)reverseDomainName, (String)"/", (String)"", (boolean)false, (int)4, null), (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null);
        try {
            InternetDomainName name;
            String domainName = CollectionsKt.joinToString$default((Iterable)CollectionsKt.asReversed((List)parts), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
            InternetDomainName internetDomainName = name = InternetDomainName.from((String)domainName);
            Intrinsics.checkNotNullExpressionValue((Object)internetDomainName, (String)"name");
            if (!internetDomainName.isUnderPublicSuffix()) {
                return (String)parts.get(0);
            }
            InternetDomainName topPrivateDomain = name.topPrivateDomain();
            int size = topPrivateDomain.parts().size();
            int n = parts.size();
            int n2 = size + 1;
            boolean bl = false;
            int end = Math.min(n, n2);
            return CollectionsKt.joinToString$default((Iterable)parts.subList(0, end), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
        }
        catch (IllegalArgumentException e) {
            return reverseDomainName;
        }
    }
}

