/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.recommenders.java.resolver;

import com.intellij.recommenders.java.resolver.ModuleRevisionIdResolver;
import com.intellij.recommenders.java.util.ModuleRevisionId;
import com.intellij.util.io.PathKt;
import java.io.InputStream;
import java.nio.file.Path;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00060\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\fH\u0016J\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/recommenders/java/resolver/ByMavenPomXmlResolver;", "Lcom/intellij/recommenders/java/resolver/ModuleRevisionIdResolver;", "()V", "extractModuleRevisionId", "Lcom/intellij/recommenders/java/util/ModuleRevisionId;", "it", "Lorg/w3c/dom/Document;", "parsePomXml", "kotlin.jvm.PlatformType", "Ljava/io/InputStream;", "readPomFile", "pomFile", "Ljava/nio/file/Path;", "suggest", "root", "containsPropertyReference", "", "", "intellij.recommenders.java"})
public final class ByMavenPomXmlResolver
implements ModuleRevisionIdResolver {
    @Override
    @Nullable
    public ModuleRevisionId suggest(@NotNull Path root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Path path = root.resolve("pom.xml");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"root.resolve(\"pom.xml\")");
        return this.readPomFile(path);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ModuleRevisionId readPomFile(Path pomFile) {
        InputStream inputStream = PathKt.inputStreamIfExists((Path)pomFile);
        Object object = inputStream;
        if (inputStream == null) return null;
        Object object2 = object;
        boolean bl = false;
        boolean bl2 = false;
        Object it = object2;
        boolean bl3 = false;
        Document document = this.parsePomXml((InputStream)it);
        object = document;
        if (document == null) return null;
        object2 = object;
        bl = false;
        bl2 = false;
        it = object2;
        boolean bl4 = false;
        ModuleRevisionId moduleRevisionId = this.extractModuleRevisionId((Document)it);
        return moduleRevisionId;
    }

    private final ModuleRevisionId extractModuleRevisionId(Document it) {
        String version;
        String artifactId;
        String groupId;
        block7: {
            block6: {
                XPathFactory factory = XPathFactory.newInstance();
                groupId = factory.newXPath().evaluate("/project/groupId/text()", it);
                artifactId = factory.newXPath().evaluate("/project/artifactId/text()", it);
                version = factory.newXPath().evaluate("/project/version/text()", it);
                CharSequence charSequence = groupId;
                boolean bl = false;
                boolean bl2 = false;
                if (charSequence == null || charSequence.length() == 0) {
                    groupId = factory.newXPath().evaluate("/project/parent/groupId/text()", it);
                }
                charSequence = version;
                bl = false;
                bl2 = false;
                if (charSequence == null || charSequence.length() == 0) {
                    version = factory.newXPath().evaluate("/project/parent/version/text()", it);
                }
                charSequence = groupId;
                bl = false;
                bl2 = false;
                if (charSequence == null || charSequence.length() == 0) break block6;
                charSequence = artifactId;
                bl = false;
                bl2 = false;
                if (charSequence == null || charSequence.length() == 0) break block6;
                charSequence = version;
                bl = false;
                bl2 = false;
                if (!(charSequence == null || charSequence.length() == 0)) break block7;
            }
            return null;
        }
        if (this.containsPropertyReference(groupId) || this.containsPropertyReference(artifactId) || this.containsPropertyReference(version)) {
            return null;
        }
        return ModuleRevisionId.Companion.of(groupId, artifactId, version);
    }

    private final Document parsePomXml(InputStream it) {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(it);
    }

    private final boolean containsPropertyReference(String $this$containsPropertyReference) {
        return StringsKt.contains$default((CharSequence)$this$containsPropertyReference, (CharSequence)"$", (boolean)false, (int)2, null);
    }
}

