/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.recommenders.java.engines;

import com.intellij.psi.PsiType;
import com.intellij.recommenders.java.util.IModuleRevisionId;
import com.intellij.recommenders.java.util.PsiUtils;
import com.intellij.recommenders.java.util.ResolvedTypeName;
import com.intellij.recommenders.models.ModelsIndex;
import com.intellij.recommenders.models.ModelsRepository;
import com.intellij.recommenders.models.PoolingModelProvider;
import com.intellij.util.io.PathKt;
import com.jetbrains.recommenders.java.commons.IInstanceModel;
import com.jetbrains.recommenders.java.models.BayesInstanceModel;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\nR\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/recommenders/java/engines/InstanceModelProvider;", "Ljava/io/Closeable;", "modelsRepository", "Lcom/intellij/recommenders/models/ModelsRepository;", "modelsIndex", "Lcom/intellij/recommenders/models/ModelsIndex;", "(Lcom/intellij/recommenders/models/ModelsRepository;Lcom/intellij/recommenders/models/ModelsIndex;)V", "delegate", "Lcom/intellij/recommenders/models/PoolingModelProvider;", "Lcom/intellij/recommenders/java/util/ResolvedTypeName;", "Lcom/jetbrains/recommenders/java/commons/IInstanceModel;", "acquireModel", "key", "Lcom/intellij/psi/PsiType;", "close", "", "releaseModel", "model", "PoolingInstancesModelProvider", "intellij.recommenders.java"})
public final class InstanceModelProvider
implements Closeable {
    private final PoolingModelProvider<ResolvedTypeName, IInstanceModel> delegate;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final IInstanceModel acquireModel(@NotNull PsiType key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ResolvedTypeName resolvedTypeName = PsiUtils.INSTANCE.toResolvedType(key);
        ResolvedTypeName resolvedTypeName2 = resolvedTypeName;
        if (resolvedTypeName == null) return null;
        ResolvedTypeName resolvedTypeName3 = resolvedTypeName2;
        boolean bl = false;
        boolean bl2 = false;
        ResolvedTypeName it = resolvedTypeName3;
        boolean bl3 = false;
        ResolvedTypeName resolvedTypeName4 = ResolvedTypeName.copy$default(it, null, null, null, it.getVersion(), 7, null);
        resolvedTypeName2 = resolvedTypeName4;
        if (resolvedTypeName4 == null) return null;
        resolvedTypeName3 = resolvedTypeName2;
        bl = false;
        bl2 = false;
        it = resolvedTypeName3;
        boolean bl4 = false;
        IInstanceModel iInstanceModel = (IInstanceModel)this.delegate.acquireModel((IModuleRevisionId)it);
        return iInstanceModel;
    }

    public final void releaseModel(@Nullable IInstanceModel model) {
        this.delegate.releaseModel((Object)model);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    public InstanceModelProvider(@NotNull ModelsRepository modelsRepository, @NotNull ModelsIndex modelsIndex) {
        Intrinsics.checkNotNullParameter((Object)modelsRepository, (String)"modelsRepository");
        Intrinsics.checkNotNullParameter((Object)modelsIndex, (String)"modelsIndex");
        this.delegate = new PoolingInstancesModelProvider(modelsRepository, modelsIndex);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\r"}, d2={"Lcom/intellij/recommenders/java/engines/InstanceModelProvider$PoolingInstancesModelProvider;", "Lcom/intellij/recommenders/models/PoolingModelProvider;", "Lcom/intellij/recommenders/java/util/ResolvedTypeName;", "Lcom/jetbrains/recommenders/java/commons/IInstanceModel;", "repository", "Lcom/intellij/recommenders/models/ModelsRepository;", "index", "Lcom/intellij/recommenders/models/ModelsIndex;", "(Lcom/intellij/recommenders/models/ModelsRepository;Lcom/intellij/recommenders/models/ModelsIndex;)V", "loadModel", "key", "fileSystem", "Ljava/nio/file/FileSystem;", "intellij.recommenders.java"})
    public static final class PoolingInstancesModelProvider
    extends PoolingModelProvider<ResolvedTypeName, IInstanceModel> {
        @NotNull
        protected IInstanceModel loadModel(@NotNull ResolvedTypeName key, @NotNull FileSystem fileSystem) {
            IInstanceModel iInstanceModel;
            Path path;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
            Path path2 = path = fileSystem.getPath(key.getType().getPackage() + '/' + key.getType().getClassName() + ".jbif", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
            InputStream inputStream = PathKt.inputStreamIfExists((Path)path2);
            if (inputStream != null) {
                InputStream inputStream2 = inputStream;
                boolean bl = false;
                boolean bl2 = false;
                InputStream it = inputStream2;
                boolean bl3 = false;
                iInstanceModel = BayesInstanceModel.Companion.load(path, key.getType());
            } else {
                iInstanceModel = null;
            }
            IInstanceModel $this$orElse$iv = iInstanceModel;
            boolean $i$f$orElse = false;
            IInstanceModel iInstanceModel2 = $this$orElse$iv;
            if (iInstanceModel2 == null) {
                boolean bl = false;
                iInstanceModel2 = BayesInstanceModel.Companion.empty(key.getType());
            }
            return iInstanceModel2;
        }

        public PoolingInstancesModelProvider(@NotNull ModelsRepository repository, @NotNull ModelsIndex index) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            super(repository, index, "java-instances-v2", 0, 0, 24, null);
        }
    }
}

