/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.recommenders.java.engines;

import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.completion.ml.ContextFeatures;
import com.intellij.codeInsight.completion.ml.ElementFeatureProvider;
import com.intellij.codeInsight.completion.ml.MLFeatureValue;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.recommenders.java.engines.ClassDefinitionLocation;
import com.intellij.recommenders.java.engines.LookupUtils;
import com.intellij.recommenders.java.util.CompletionOnAny;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0005H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/recommenders/java/engines/GenericElementFeatureProvider;", "Lcom/intellij/codeInsight/completion/ml/ElementFeatureProvider;", "()V", "calculateFeatures", "", "", "Lcom/intellij/codeInsight/completion/ml/MLFeatureValue;", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "location", "Lcom/intellij/codeInsight/completion/CompletionLocation;", "contextFeatures", "Lcom/intellij/codeInsight/completion/ml/ContextFeatures;", "getElementOrigin", "Lcom/intellij/recommenders/java/engines/ClassDefinitionLocation;", "member", "Lcom/intellij/psi/PsiMember;", "project", "Lcom/intellij/openapi/project/Project;", "getName", "intellij.recommenders.java"})
public final class GenericElementFeatureProvider
implements ElementFeatureProvider {
    @NotNull
    public String getName() {
        return "rec-gf";
    }

    @NotNull
    public Map<String, MLFeatureValue> calculateFeatures(@NotNull LookupElement element, @NotNull CompletionLocation location2, @NotNull ContextFeatures contextFeatures) {
        Map features;
        block22: {
            PsiElement psiElement;
            block23: {
                Object expectedTypes2;
                block21: {
                    JavaMethodCallElement javaMethodCallElement;
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
                    Intrinsics.checkNotNullParameter((Object)contextFeatures, (String)"contextFeatures");
                    boolean bl = false;
                    features = new LinkedHashMap();
                    Object object = (CompletionOnAny)contextFeatures.getUserData(LookupUtils.INSTANCE.getCTX$intellij_recommenders_java());
                    if (object == null || (object = ((CompletionOnAny)object).getExpectedTypes()) == null || (object = CollectionsKt.toSet((Iterable)((Iterable)object))) == null) {
                        boolean bl2 = false;
                        object = SetsKt.emptySet();
                    }
                    expectedTypes2 = object;
                    psiElement = element.getPsiElement();
                    if (!(psiElement instanceof PsiMethod)) break block21;
                    PsiElement psiElement2 = element.getPsiElement();
                    if (psiElement2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiMethod");
                    }
                    PsiMethod method = (PsiMethod)psiElement2;
                    PsiMember psiMember = (PsiMember)method;
                    Project project = location2.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"location.project");
                    features.put("class-definition-location", MLFeatureValue.Companion.categorical((Enum)this.getElementOrigin(psiMember, project)));
                    Collection collection = (Collection)expectedTypes2;
                    boolean bl3 = false;
                    if (!collection.isEmpty() && (javaMethodCallElement = (JavaMethodCallElement)element.as(JavaMethodCallElement.CLASS_CONDITION_KEY)) != null && (javaMethodCallElement = javaMethodCallElement.getInferenceSubstitutor()) != null && (javaMethodCallElement = javaMethodCallElement.substitute(method.getReturnType())) != null) {
                        boolean bl4;
                        boolean exactMatch;
                        block18: {
                            boolean bl5;
                            Collection returnType;
                            block17: {
                                collection = javaMethodCallElement;
                                bl3 = false;
                                boolean bl6 = false;
                                returnType = collection;
                                boolean bl7 = false;
                                Iterable $this$any$iv = (Iterable)expectedTypes2;
                                boolean $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    bl5 = false;
                                } else {
                                    for (Object element$iv : $this$any$iv) {
                                        PsiType it = (PsiType)element$iv;
                                        boolean bl8 = false;
                                        if (!Intrinsics.areEqual((Object)it, (Object)returnType)) continue;
                                        bl5 = true;
                                        break block17;
                                    }
                                    bl5 = false;
                                }
                            }
                            exactMatch = bl5;
                            Iterable $this$any$iv = (Iterable)expectedTypes2;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl4 = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    PsiType it = (PsiType)element$iv;
                                    boolean bl9 = false;
                                    if (!it.isAssignableFrom((PsiType)returnType)) continue;
                                    bl4 = true;
                                    break block18;
                                }
                                bl4 = false;
                            }
                        }
                        boolean assignableMatch = bl4;
                        features.put("is-exact-or-assignable-expected-type-match", MLFeatureValue.Companion.binary(assignableMatch));
                        features.put("is-exact-expected-type-match", MLFeatureValue.Companion.binary(exactMatch));
                        features.put("is-assignable-expected-type-match", MLFeatureValue.Companion.binary(assignableMatch && !exactMatch));
                    }
                    features.put("element-type", MLFeatureValue.Companion.className$default((MLFeatureValue.Companion)MLFeatureValue.Companion, PsiMethod.class, (boolean)false, (int)2, null));
                    break block22;
                }
                if (!(psiElement instanceof PsiField)) break block23;
                PsiElement psiElement3 = element.getPsiElement();
                if (psiElement3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiField");
                }
                PsiField field = (PsiField)psiElement3;
                PsiMember psiMember = (PsiMember)field;
                Project project = location2.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"location.project");
                features.put("class-definition-location", MLFeatureValue.Companion.categorical((Enum)this.getElementOrigin(psiMember, project)));
                Collection collection = (Collection)expectedTypes2;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    boolean bl10;
                    boolean exactMatch;
                    block20: {
                        boolean bl11;
                        block19: {
                            Iterable $this$any$iv = (Iterable)expectedTypes2;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl11 = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    PsiType it = (PsiType)element$iv;
                                    boolean bl12 = false;
                                    if (!Intrinsics.areEqual((Object)it, (Object)field.getType())) continue;
                                    bl11 = true;
                                    break block19;
                                }
                                bl11 = false;
                            }
                        }
                        exactMatch = bl11;
                        Iterable $this$any$iv = (Iterable)expectedTypes2;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl10 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                PsiType it = (PsiType)element$iv;
                                boolean bl13 = false;
                                if (!it.isAssignableFrom(field.getType())) continue;
                                bl10 = true;
                                break block20;
                            }
                            bl10 = false;
                        }
                    }
                    boolean assignableMatch = bl10;
                    features.put("is-exact-or-assignable-expected-type-match", MLFeatureValue.Companion.binary(assignableMatch));
                    features.put("is-exact-expected-type-match", MLFeatureValue.Companion.binary(exactMatch));
                    features.put("is-assignable-expected-type-match", MLFeatureValue.Companion.binary(assignableMatch && !exactMatch));
                }
                features.put("element-type", MLFeatureValue.Companion.className$default((MLFeatureValue.Companion)MLFeatureValue.Companion, PsiField.class, (boolean)false, (int)2, null));
                break block22;
            }
            if (!(psiElement instanceof PsiType)) break block22;
            features.put("element-type", MLFeatureValue.Companion.className$default((MLFeatureValue.Companion)MLFeatureValue.Companion, PsiType.class, (boolean)false, (int)2, null));
        }
        return features;
    }

    private final ClassDefinitionLocation getElementOrigin(PsiMember member, Project project) {
        Object object;
        block4: {
            block3: {
                FileIndexFacade indexFacade = FileIndexFacade.getInstance((Project)project);
                object = member.getContainingFile();
                if (object == null || (object = object.getOriginalFile()) == null || (object = object.getVirtualFile()) == null) break block3;
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                ClassDefinitionLocation classDefinitionLocation = indexFacade.isInLibraryClasses((VirtualFile)it) ? ClassDefinitionLocation.IN_LIBRARY_CLASSES : (indexFacade.isInLibrarySource((VirtualFile)it) ? ClassDefinitionLocation.IN_LIBRARY_SOURCES : (indexFacade.isInSource((VirtualFile)it) ? ClassDefinitionLocation.IN_MODULE_SOURCES : ClassDefinitionLocation.IN_ELSEWHERE));
                object = classDefinitionLocation;
                if (classDefinitionLocation != null) break block4;
            }
            object = ClassDefinitionLocation.ERROR_NO_FILE;
        }
        return object;
    }
}

