/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutlib;

import com.android.ide.common.rendering.api.Bridge;
import com.android.io.IAbstractFile;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.tools.idea.io.BufferingFileWrapper;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.layoutlib.LayoutLogWrapper;
import com.android.tools.idea.layoutlib.LayoutlibBundle;
import com.android.tools.idea.layoutlib.LayoutlibClassLoader;
import com.android.tools.idea.layoutlib.LogWrapper;
import com.android.tools.idea.layoutlib.RenderingException;
import com.android.tools.idea.layoutlib.UnsupportedJavaRuntimeException;
import com.android.utils.ILogger;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class LayoutLibraryLoader {
    protected static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.uipreview.LayoutLibraryLoader");
    private static final Map<IAndroidTarget, LayoutLibrary> ourLibraryCache = ContainerUtil.createWeakKeySoftValueMap();

    private LayoutLibraryLoader() {
    }

    @NotNull
    private static LayoutLibrary loadImpl(@NotNull IAndroidTarget target, @NotNull Map<String, Map<String, Integer>> enumMap) throws RenderingException {
        if (target == null) {
            LayoutLibraryLoader.$$$reportNull$$$0(0);
        }
        if (enumMap == null) {
            LayoutLibraryLoader.$$$reportNull$$$0(1);
        }
        String fontFolderPath = FileUtil.toSystemIndependentName((String)target.getPath(12));
        VirtualFile fontFolder = LocalFileSystem.getInstance().findFileByPath(fontFolderPath);
        if (fontFolder == null || !fontFolder.isDirectory()) {
            throw new RenderingException(LayoutlibBundle.message("android.directory.cannot.be.found.error", FileUtil.toSystemDependentName((String)fontFolderPath)), new Throwable[0]);
        }
        String platformFolderPath = target.isPlatform() ? target.getLocation() : target.getParent().getLocation();
        File platformFolder = new File(platformFolderPath);
        if (!platformFolder.isDirectory()) {
            throw new RenderingException(LayoutlibBundle.message("android.directory.cannot.be.found.error", FileUtil.toSystemDependentName((String)platformFolderPath)), new Throwable[0]);
        }
        File buildProp = new File(platformFolder, "build.prop");
        if (!buildProp.isFile()) {
            throw new RenderingException(LayoutlibBundle.message("android.file.not.exist.error", FileUtil.toSystemDependentName((String)buildProp.getPath())), new Throwable[0]);
        }
        if (!SystemInfo.isJavaVersionAtLeast((int)8, (int)0, (int)0) && target.getVersion().getFeatureLevel() >= 24) {
            throw new UnsupportedJavaRuntimeException(LayoutlibBundle.message("android.layout.preview.unsupported.jdk", SdkVersionInfo.getCodeName((int)target.getVersion().getFeatureLevel())));
        }
        LogWrapper logger = new LogWrapper(LOG);
        Map buildPropMap = ProjectProperties.parsePropertyFile((IAbstractFile)new BufferingFileWrapper(buildProp), (ILogger)logger);
        LayoutLogWrapper layoutLog = new LayoutLogWrapper(LOG);
        String dataPath = FileUtil.toSystemIndependentName((String)target.getPath(7));
        LayoutLibrary library = LayoutLibrary.load((Bridge)new com.android.layoutlib.bridge.Bridge(), new LayoutlibClassLoader(LayoutLibraryLoader.class.getClassLoader()));
        if (!library.init(buildPropMap, new File(fontFolder.getPath()), LayoutLibraryLoader.getNativeLibraryPath(dataPath), dataPath + "icu/", enumMap, layoutLog)) {
            throw new RenderingException(LayoutlibBundle.message("layoutlib.init.failed", new Object[0]), new Throwable[0]);
        }
        LayoutLibrary layoutLibrary = library;
        if (layoutLibrary == null) {
            LayoutLibraryLoader.$$$reportNull$$$0(2);
        }
        return layoutLibrary;
    }

    @NotNull
    private static String getNativeLibraryPath(@NotNull String dataPath) {
        if (dataPath == null) {
            LayoutLibraryLoader.$$$reportNull$$$0(3);
        }
        String string = dataPath + LayoutLibraryLoader.getPlatformName() + (SystemInfo.is64Bit ? "/lib64/" : "/lib/");
        if (string == null) {
            LayoutLibraryLoader.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private static String getPlatformName() {
        if (SystemInfo.isWindows) {
            return "win";
        }
        if (SystemInfo.isMac) {
            return "mac";
        }
        if (SystemInfo.isLinux) {
            return "linux";
        }
        return "";
    }

    @NotNull
    public static synchronized LayoutLibrary load(@NotNull IAndroidTarget target, @NotNull Map<String, Map<String, Integer>> enumMap) throws RenderingException {
        LayoutLibrary library;
        if (target == null) {
            LayoutLibraryLoader.$$$reportNull$$$0(5);
        }
        if (enumMap == null) {
            LayoutLibraryLoader.$$$reportNull$$$0(6);
        }
        if ((library = ourLibraryCache.get(target)) == null || library.isDisposed()) {
            library = LayoutLibraryLoader.loadImpl(target, enumMap);
            ourLibraryCache.put(target, library);
        }
        LayoutLibrary layoutLibrary = library;
        if (layoutLibrary == null) {
            LayoutLibraryLoader.$$$reportNull$$$0(7);
        }
        return layoutLibrary;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumMap";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/layoutlib/LayoutLibraryLoader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/layoutlib/LayoutLibraryLoader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNativeLibraryPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadImpl";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNativeLibraryPath";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

