/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java.run;

import gherkin.pickles.Pickle;
import gherkin.pickles.PickleLocation;
import io.cucumber.plugin.event.HookTestStep;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.TestCase;
import io.cucumber.plugin.event.TestStep;
import io.cucumber.plugin.event.TestStepFinished;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jetbrains.plugins.cucumber.java.run.CucumberJvmTestStepFinishedEvent;

public class CucumberJvm5Adapter {
    private static Pickle getPickleEvent(TestCase testCase) {
        try {
            Field cucumberPickleField = testCase.getClass().getDeclaredField("pickle");
            cucumberPickleField.setAccessible(true);
            Object cucumberPickle = cucumberPickleField.get(testCase);
            Field pickleField = cucumberPickle.getClass().getDeclaredField("pickle");
            pickleField.setAccessible(true);
            return (Pickle)pickleField.get(cucumberPickle);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static class CucumberJvmTestStep
    implements org.jetbrains.plugins.cucumber.java.run.CucumberJvmTestStep {
        private final TestStep myRealStep;

        public CucumberJvmTestStep(TestStep realStep) {
            this.myRealStep = realStep;
        }

        public String getLocation() {
            if (this.myRealStep instanceof HookTestStep) {
                try {
                    Field definitionMatchField = this.myRealStep.getClass().getSuperclass().getDeclaredField("stepDefinitionMatch");
                    definitionMatchField.setAccessible(true);
                    Object definitionMatchFieldValue = definitionMatchField.get(this.myRealStep);
                    Field hookDefinitionField = definitionMatchFieldValue.getClass().getDeclaredField("hookDefinition");
                    hookDefinitionField.setAccessible(true);
                    Object hookDefinitionFieldValue = hookDefinitionField.get(definitionMatchFieldValue);
                    Field methodField = hookDefinitionFieldValue.getClass().getDeclaredField("method");
                    methodField.setAccessible(true);
                    Object methodFieldValue = methodField.get(hookDefinitionFieldValue);
                    if (methodFieldValue instanceof Method) {
                        Method method = (Method)methodFieldValue;
                        return String.format("java:test://%s/%s", method.getDeclaringClass().getName(), method.getName());
                    }
                }
                catch (Exception definitionMatchField) {
                    // empty catch block
                }
                return "";
            }
            PickleStepTestStep pickleStepTestStep = (PickleStepTestStep)this.myRealStep;
            return "file://" + pickleStepTestStep.getCodeLocation() + ":" + pickleStepTestStep.getStepLine();
        }

        public String getStepName() {
            String stepName;
            if (this.myRealStep instanceof HookTestStep) {
                stepName = "Hook: " + ((HookTestStep)this.myRealStep).getHookType().toString();
            } else {
                PickleStepTestStep pickleStep = (PickleStepTestStep)this.myRealStep;
                stepName = pickleStep.getStep().getKeyWord() + pickleStep.getStepText();
            }
            return stepName;
        }
    }

    public static class CucumberJvmTestCase
    implements org.jetbrains.plugins.cucumber.java.run.CucumberJvmTestCase {
        private final TestCase myRealTestCase;

        CucumberJvmTestCase(TestCase realTestCase) {
            this.myRealTestCase = realTestCase;
        }

        public boolean isScenarioOutline() {
            Pickle pickle = CucumberJvm5Adapter.getPickleEvent(this.myRealTestCase);
            return pickle != null && pickle.getLocations().size() > 1;
        }

        public String getUri() {
            return this.myRealTestCase.getUri().getPath();
        }

        public int getScenarioOutlineLine() {
            Pickle pickle = CucumberJvm5Adapter.getPickleEvent(this.myRealTestCase);
            if (pickle != null) {
                return ((PickleLocation)pickle.getLocations().get(pickle.getLocations().size() - 1)).getLine();
            }
            return 0;
        }

        public int getLine() {
            return this.myRealTestCase.getLine();
        }

        public String getScenarioName() {
            return this.myRealTestCase.getName();
        }
    }

    public static class CucumberJvmTestStepFinishedEvent
    implements org.jetbrains.plugins.cucumber.java.run.CucumberJvmTestStepFinishedEvent {
        private final CucumberJvmTestStep myTestStep;
        private final TestStepFinished myRealEvent;

        public CucumberJvmTestStepFinishedEvent(TestStepFinished testStepFinished) {
            this.myTestStep = new CucumberJvmTestStep(testStepFinished.getTestStep());
            this.myRealEvent = testStepFinished;
        }

        public org.jetbrains.plugins.cucumber.java.run.CucumberJvmTestStep getTestStep() {
            return this.myTestStep;
        }

        public CucumberJvmTestStepFinishedEvent.Status getResult() {
            switch (this.myRealEvent.getResult().getStatus()) {
                case PASSED: {
                    return CucumberJvmTestStepFinishedEvent.Status.PASSED;
                }
                case PENDING: {
                    return CucumberJvmTestStepFinishedEvent.Status.PENDING;
                }
                case SKIPPED: {
                    return CucumberJvmTestStepFinishedEvent.Status.SKIPPED;
                }
            }
            return CucumberJvmTestStepFinishedEvent.Status.FAILED;
        }

        public Long getDuration() {
            return this.myRealEvent.getResult().getDuration() != null ? this.myRealEvent.getResult().getDuration().toMillis() : 0L;
        }

        public String getErrorMessage() {
            Throwable error = this.myRealEvent.getResult().getError();
            String result = error != null ? error.getMessage() : null;
            return result != null ? result : "";
        }
    }
}

