/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.naming;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.psi.PsiElement;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.naming.ConventionInspection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LocalVariableNamingConventionJSInspection
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 1;
    private static final int DEFAULT_MAX_LENGTH = 32;

    @Override
    protected InspectionJSFix buildFix(PsiElement location) {
        return JSFixFactory.getInstance().renameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @InspectionMessage
    @NotNull
    public String buildErrorString(Object ... args) {
        JSVariable variable = (JSVariable)((PsiElement)args[0]).getParent();
        assert (variable != null);
        String variableName = variable.getName();
        if (variableName.length() < this.getMinLength()) {
            String string = InspectionJSBundle.message("variable.name.is.too.short.error.string", new Object[0]);
            if (string == null) {
                LocalVariableNamingConventionJSInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (variableName.length() > this.getMaxLength()) {
            String string = InspectionJSBundle.message("variable.name.is.too.long.error.string", new Object[0]);
            if (string == null) {
                LocalVariableNamingConventionJSInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionJSBundle.message("variable.name.doesnt.match.regex.error.string", this.getRegex());
        if (string == null) {
            LocalVariableNamingConventionJSInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NonNls
    protected String getDefaultRegex() {
        return "[a-z][A-Za-z]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 1;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 32;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/naming/LocalVariableNamingConventionJSInspection", "buildErrorString"));
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSVarStatement(JSVarStatement jsVarStatement) {
            JSVariable[] variables;
            super.visitJSVarStatement(jsVarStatement);
            if (jsVarStatement.getParent() instanceof JSFile) {
                return;
            }
            for (JSVariable variable : variables = jsVarStatement.getVariables()) {
                String name;
                JSAttributeList attributeList;
                if (variable instanceof TypeScriptEnumField || (attributeList = variable.getAttributeList()) != null && attributeList.hasModifier(JSAttributeList.ModifierType.STATIC) && variable.isConst() || (name = variable.getName()) == null || LocalVariableNamingConventionJSInspection.this.isValid(name)) continue;
                this.registerVariableError(variable);
            }
        }
    }
}

