/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.functionmetrics;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import com.sixrr.inspectjs.functionmetrics.LoopCountVisitor;
import org.jetbrains.annotations.NotNull;

public class FunctionWithMultipleLoopsJSInspection
extends JavaScriptInspection {
    @Override
    @InspectionMessage
    @NotNull
    public String buildErrorString(Object ... args) {
        JSFunction function2 = (JSFunction)((PsiElement)args[0]).getParent();
        assert (function2 != null);
        LoopCountVisitor visitor = new LoopCountVisitor();
        PsiElement lastChild = function2.getLastChild();
        assert (lastChild != null);
        lastChild.accept((PsiElementVisitor)visitor);
        int loopCount = visitor.getCount();
        if (FunctionWithMultipleLoopsJSInspection.functionHasIdentifier(function2)) {
            String string = InspectionJSBundle.message("function.contains.multiple.loops.error.string", loopCount);
            if (string == null) {
                FunctionWithMultipleLoopsJSInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionJSBundle.message("anonymous.function.contains.multiple.loops.error.string", loopCount);
        if (string == null) {
            FunctionWithMultipleLoopsJSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/functionmetrics/FunctionWithMultipleLoopsJSInspection", "buildErrorString"));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSFunctionDeclaration(@NotNull JSFunction function2) {
            PsiElement lastChild;
            if (function2 == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if (!((lastChild = function2.getLastChild()) instanceof JSBlockStatement)) {
                return;
            }
            LoopCountVisitor visitor = new LoopCountVisitor();
            lastChild.accept((PsiElementVisitor)visitor);
            int negationCount = visitor.getCount();
            if (negationCount <= 1) {
                return;
            }
            this.registerFunctionError(function2);
        }

        public void visitJSFunctionExpression(JSFunctionExpression node) {
            this.visitJSFunctionDeclaration((JSFunction)node);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/sixrr/inspectjs/functionmetrics/FunctionWithMultipleLoopsJSInspection$Visitor", "visitJSFunctionDeclaration"));
        }
    }
}

