/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.psi.JSLabeledStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSStatementWithLabelReference;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryLabelJSInspection
extends JavaScriptInspection
implements CleanupLocalInspectionTool {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnusedLabelVisitor();
    }

    @Override
    @NotNull
    @InspectionMessage
    protected String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("unnecessary.label.error.string", new Object[0]);
        if (string == null) {
            UnnecessaryLabelJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public InspectionJSFix buildFix(PsiElement location) {
        return new UnusedLabelFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/UnnecessaryLabelJSInspection", "buildErrorString"));
    }

    private static class UnusedLabelVisitor
    extends BaseInspectionVisitor {
        private UnusedLabelVisitor() {
        }

        private static boolean containsBreakOrContinueForLabel(JSLabeledStatement statement) {
            String label = statement.getLabel();
            if (label == null) {
                return false;
            }
            return SyntaxTraverser.psiTraverser((PsiElement)statement).filter(JSStatementWithLabelReference.class).filter(s -> label.equals(s.getLabel())).isNotEmpty();
        }

        public void visitJSLabeledStatement(JSLabeledStatement statement) {
            if (UnusedLabelVisitor.containsBreakOrContinueForLabel(statement)) {
                return;
            }
            PsiElement labelIdentifier = statement.getLabelIdentifier();
            this.registerError(labelIdentifier);
        }
    }

    private static class UnusedLabelFix
    extends InspectionJSFix {
        private UnusedLabelFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionJSBundle.message("remove.label.fix", new Object[0]);
            if (string == null) {
                UnusedLabelFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement label = descriptor2.getPsiElement();
            JSLabeledStatement labeledStatement = (JSLabeledStatement)label.getParent();
            assert (labeledStatement != null);
            JSStatement innerStatement = labeledStatement.getStatement();
            if (innerStatement == null) {
                return;
            }
            labeledStatement.replace(innerStatement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/UnnecessaryLabelJSInspection$UnusedLabelFix", "getFamilyName"));
        }
    }
}

